/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.DeprecatedAttributes;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.apache.maven.api.cli.Options;
import org.apache.maven.api.cli.ParserRequest;
import org.apache.maven.api.services.Interpolator;
import org.apache.maven.api.services.InterpolatorException;
import org.apache.maven.cling.invoker.CleanArgument;
import org.apache.maven.cling.invoker.CliUtils;
import org.apache.maven.jline.MessageUtils;

public class CommonsCliOptions
implements Options {
    protected final String source;
    protected final CLIManager cliManager;
    protected final CommandLine commandLine;

    public static CommonsCliOptions parse(String source, String[] args) throws ParseException {
        CLIManager cliManager = new CLIManager();
        return new CommonsCliOptions(source, cliManager, cliManager.parse(args));
    }

    protected CommonsCliOptions(String source, CLIManager cliManager, CommandLine commandLine) {
        this.source = Objects.requireNonNull(source);
        this.cliManager = Objects.requireNonNull(cliManager);
        this.commandLine = Objects.requireNonNull(commandLine);
    }

    public String source() {
        return this.source;
    }

    public Optional<Map<String, String>> userProperties() {
        if (this.commandLine.hasOption("D")) {
            return Optional.of(CliUtils.toMap(this.commandLine.getOptionProperties("D")));
        }
        return Optional.empty();
    }

    public Optional<Boolean> showVersionAndExit() {
        if (this.commandLine.hasOption("v")) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    public Optional<Boolean> showVersion() {
        if (this.commandLine.hasOption("V")) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    public Optional<Boolean> quiet() {
        if (this.commandLine.hasOption("q")) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    public Optional<Boolean> verbose() {
        if (this.commandLine.hasOption("X")) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    public Optional<Boolean> showErrors() {
        if (this.commandLine.hasOption("e") || this.verbose().orElse(false).booleanValue()) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    public Optional<String> failOnSeverity() {
        if (this.commandLine.hasOption("fos")) {
            return Optional.of(this.commandLine.getOptionValue("fos"));
        }
        return Optional.empty();
    }

    public Optional<Boolean> nonInteractive() {
        if (this.commandLine.hasOption("non-interactive") || this.commandLine.hasOption("B")) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    public Optional<Boolean> forceInteractive() {
        if (this.commandLine.hasOption("force-interactive")) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    public Optional<String> altUserSettings() {
        if (this.commandLine.hasOption("s")) {
            return Optional.of(this.commandLine.getOptionValue("s"));
        }
        return Optional.empty();
    }

    public Optional<String> altProjectSettings() {
        if (this.commandLine.hasOption("ps")) {
            return Optional.of(this.commandLine.getOptionValue("ps"));
        }
        return Optional.empty();
    }

    public Optional<String> altInstallationSettings() {
        if (this.commandLine.hasOption("is")) {
            return Optional.of(this.commandLine.getOptionValue("is"));
        }
        if (this.commandLine.hasOption("gs")) {
            return Optional.of(this.commandLine.getOptionValue("gs"));
        }
        return Optional.empty();
    }

    public Optional<String> altUserToolchains() {
        if (this.commandLine.hasOption("t")) {
            return Optional.of(this.commandLine.getOptionValue("t"));
        }
        return Optional.empty();
    }

    public Optional<String> altInstallationToolchains() {
        if (this.commandLine.hasOption("it")) {
            return Optional.of(this.commandLine.getOptionValue("it"));
        }
        if (this.commandLine.hasOption("gt")) {
            return Optional.of(this.commandLine.getOptionValue("gt"));
        }
        return Optional.empty();
    }

    public Optional<String> logFile() {
        if (this.commandLine.hasOption("l")) {
            return Optional.of(this.commandLine.getOptionValue("l"));
        }
        return Optional.empty();
    }

    public Optional<Boolean> rawStreams() {
        if (this.commandLine.hasOption("raw-streams")) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    public Optional<String> color() {
        if (this.commandLine.hasOption("color")) {
            if (this.commandLine.getOptionValue("color") != null) {
                return Optional.of(this.commandLine.getOptionValue("color"));
            }
            return Optional.of("auto");
        }
        return Optional.empty();
    }

    public Optional<Boolean> offline() {
        if (this.commandLine.hasOption("o")) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    public Optional<Boolean> help() {
        if (this.commandLine.hasOption("h")) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    public void warnAboutDeprecatedOptions(ParserRequest request, Consumer<String> printWriter) {
        if (this.cliManager.getUsedDeprecatedOptions().isEmpty()) {
            return;
        }
        printWriter.accept("Detected deprecated option use in " + this.source);
        for (Option option : this.cliManager.getUsedDeprecatedOptions()) {
            StringBuilder sb = new StringBuilder();
            sb.append("The option ");
            if (option.getOpt() != null) {
                sb.append("-").append(option.getOpt());
            }
            if (option.getLongOpt() != null) {
                if (option.getOpt() != null) {
                    sb.append(",");
                }
                sb.append("--").append(option.getLongOpt());
            }
            sb.append(" is deprecated ");
            if (option.getDeprecated().isForRemoval()) {
                sb.append("and will be removed in a future version");
            }
            if (option.getDeprecated().getSince() != null) {
                sb.append(" since ").append(request.commandName()).append(" ").append(option.getDeprecated().getSince());
            }
            printWriter.accept(sb.toString());
        }
    }

    public final Options interpolate(UnaryOperator<String> callback) {
        try {
            Interpolator interpolator = CliUtils.createInterpolator();
            CommandLine.Builder commandLineBuilder = CommandLine.builder();
            commandLineBuilder.setDeprecatedHandler(o -> {});
            for (Option option : this.commandLine.getOptions()) {
                if (!"D".equals(option.getOpt())) {
                    List values = option.getValuesList();
                    ListIterator<String> it = values.listIterator();
                    while (it.hasNext()) {
                        it.set(interpolator.interpolate((String)it.next(), callback));
                    }
                }
                commandLineBuilder.addOption(option);
            }
            for (String arg : this.commandLine.getArgList()) {
                commandLineBuilder.addArg(interpolator.interpolate(arg, callback));
            }
            return this.copy(this.source, this.cliManager, commandLineBuilder.get());
        }
        catch (InterpolatorException e) {
            throw new IllegalArgumentException("Could not interpolate CommonsCliOptions", e);
        }
    }

    protected CommonsCliOptions copy(String source, CLIManager cliManager, CommandLine commandLine) {
        return new CommonsCliOptions(source, cliManager, commandLine);
    }

    public void displayHelp(ParserRequest request, Consumer<String> printStream) {
        this.cliManager.displayHelp(request.command(), printStream);
    }

    protected static class CLIManager {
        public static final String USER_PROPERTY = "D";
        public static final String SHOW_VERSION_AND_EXIT = "v";
        public static final String SHOW_VERSION = "V";
        public static final String QUIET = "q";
        public static final String VERBOSE = "X";
        public static final String SHOW_ERRORS = "e";
        public static final String FAIL_ON_SEVERITY = "fos";
        public static final String NON_INTERACTIVE = "non-interactive";
        public static final String BATCH_MODE = "B";
        public static final String FORCE_INTERACTIVE = "force-interactive";
        public static final String ALTERNATE_USER_SETTINGS = "s";
        public static final String ALTERNATE_PROJECT_SETTINGS = "ps";
        public static final String ALTERNATE_INSTALLATION_SETTINGS = "is";
        public static final String ALTERNATE_USER_TOOLCHAINS = "t";
        public static final String ALTERNATE_INSTALLATION_TOOLCHAINS = "it";
        public static final String LOG_FILE = "l";
        public static final String RAW_STREAMS = "raw-streams";
        public static final String COLOR = "color";
        public static final String OFFLINE = "o";
        public static final String HELP = "h";
        public static final String SHOW_ERRORS_CLI_ARG = "-e";
        public static final String DEBUG = "debug";
        public static final String ENC = "enc";
        public static final String UPGRADE = "up";
        public static final String SHELL = "shell";
        public static final String YJP = "yjp";
        @Deprecated
        public static final String ALTERNATE_GLOBAL_SETTINGS = "gs";
        @Deprecated
        public static final String ALTERNATE_GLOBAL_TOOLCHAINS = "gt";
        protected org.apache.commons.cli.Options options;
        protected final LinkedHashSet<Option> usedDeprecatedOptions = new LinkedHashSet();

        protected CLIManager() {
            this.options = new org.apache.commons.cli.Options();
            this.prepareOptions(this.options);
        }

        protected void prepareOptions(org.apache.commons.cli.Options options) {
            options.addOption(Option.builder((String)HELP).longOpt("help").desc("Display help information").get());
            options.addOption(Option.builder((String)USER_PROPERTY).numberOfArgs(2).valueSeparator('=').desc("Define a user property").get());
            options.addOption(Option.builder((String)SHOW_VERSION_AND_EXIT).longOpt("version").desc("Display version information").get());
            options.addOption(Option.builder((String)QUIET).longOpt("quiet").desc("Quiet output - only show errors").get());
            options.addOption(Option.builder((String)VERBOSE).longOpt("verbose").desc("Produce execution verbose output").get());
            options.addOption(Option.builder((String)SHOW_ERRORS).longOpt("errors").desc("Produce execution error messages").get());
            options.addOption(Option.builder((String)BATCH_MODE).longOpt("batch-mode").desc("Run in non-interactive mode. Alias for --non-interactive (kept for backwards compatability)").get());
            options.addOption(Option.builder().longOpt(NON_INTERACTIVE).desc("Run in non-interactive mode. Alias for --batch-mode").get());
            options.addOption(Option.builder().longOpt(FORCE_INTERACTIVE).desc("Run in interactive mode. Overrides, if applicable, the CI environment variable and --non-interactive/--batch-mode options").get());
            options.addOption(Option.builder((String)ALTERNATE_USER_SETTINGS).longOpt("settings").desc("Alternate path for the user settings file").hasArg().get());
            options.addOption(Option.builder((String)ALTERNATE_PROJECT_SETTINGS).longOpt("project-settings").desc("Alternate path for the project settings file").hasArg().get());
            options.addOption(Option.builder((String)ALTERNATE_INSTALLATION_SETTINGS).longOpt("install-settings").desc("Alternate path for the installation settings file").hasArg().get());
            options.addOption(Option.builder((String)ALTERNATE_USER_TOOLCHAINS).longOpt("toolchains").desc("Alternate path for the user toolchains file").hasArg().get());
            options.addOption(Option.builder((String)ALTERNATE_INSTALLATION_TOOLCHAINS).longOpt("install-toolchains").desc("Alternate path for the installation toolchains file").hasArg().get());
            options.addOption(Option.builder((String)FAIL_ON_SEVERITY).longOpt("fail-on-severity").desc("Configure which severity of logging should cause the build to fail").hasArg().get());
            options.addOption(Option.builder((String)LOG_FILE).longOpt("log-file").hasArg().desc("Log file where all build output will go (disables output color)").get());
            options.addOption(Option.builder().longOpt(RAW_STREAMS).desc("Do not decorate standard output and error streams").get());
            options.addOption(Option.builder((String)SHOW_VERSION).longOpt("show-version").desc("Display version information WITHOUT stopping build").get());
            options.addOption(Option.builder().longOpt(COLOR).hasArg().optionalArg(true).desc("Defines the color mode of the output. Supported are 'auto', 'always', 'never'.").get());
            options.addOption(Option.builder((String)OFFLINE).longOpt("offline").desc("Work offline").get());
            options.addOption(Option.builder().longOpt(DEBUG).desc("Launch the JVM in debug mode (script option).").get());
            options.addOption(Option.builder().longOpt(ENC).desc("Launch the Maven Encryption tool (script option).").get());
            options.addOption(Option.builder().longOpt(UPGRADE).desc("Launch the Maven Upgrade tool (script option).").get());
            options.addOption(Option.builder().longOpt(SHELL).desc("Launch the Maven Shell tool (script option).").get());
            options.addOption(Option.builder().longOpt(YJP).desc("Launch the JVM with Yourkit profiler (script option).").get());
            options.addOption(Option.builder((String)ALTERNATE_GLOBAL_SETTINGS).longOpt("global-settings").desc("<deprecated> Alternate path for the global settings file.").hasArg().deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("4.0.0").setDescription("Use -is,--install-settings instead.").get()).get());
            options.addOption(Option.builder((String)ALTERNATE_GLOBAL_TOOLCHAINS).longOpt("global-toolchains").desc("<deprecated> Alternate path for the global toolchains file.").hasArg().deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("4.0.0").setDescription("Use -it,--install-toolchains instead.").get()).get());
        }

        public CommandLine parse(String[] args) throws ParseException {
            String[] cleanArgs = CleanArgument.cleanArgs(args);
            DefaultParser parser = DefaultParser.builder().setDeprecatedHandler(this::addDeprecatedOption).get();
            CommandLine commandLine = parser.parse(this.options, cleanArgs);
            this.options.getOptions().forEach(arg_0 -> ((CommandLine)commandLine).hasOption(arg_0));
            return commandLine;
        }

        protected void addDeprecatedOption(Option option) {
            this.usedDeprecatedOptions.add(option);
        }

        public org.apache.commons.cli.Options getOptions() {
            return this.options;
        }

        public Set<Option> getUsedDeprecatedOptions() {
            return this.usedDeprecatedOptions;
        }

        public void displayHelp(String command, Consumer<String> pw) {
            HelpFormatter formatter = new HelpFormatter();
            int width = MessageUtils.getTerminalWidth();
            if (width <= 0) {
                width = 74;
            }
            pw.accept("");
            StringWriter sw = new StringWriter();
            PrintWriter pw2 = new PrintWriter(sw);
            formatter.printHelp(pw2, width, this.commandLineSyntax(command), System.lineSeparator() + "Options:", this.options, 1, 3, System.lineSeparator(), false);
            pw2.flush();
            for (String s : sw.toString().split(System.lineSeparator())) {
                pw.accept(s);
            }
        }

        protected String commandLineSyntax(String command) {
            return command + " [options] [<goal|phase> ...]";
        }
    }
}

