/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.internal.referencing.CoordinateOperations;
import org.apache.sis.internal.referencing.provider.MapProjection;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform2D;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.referencing.operation.transform.MathTransformProvider;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public abstract class NormalizedProjection
extends AbstractMathTransform2D
implements Serializable {
    private static final long serialVersionUID = -4010883312927645853L;
    static final int DIMENSION = 2;
    static final double ANGULAR_TOLERANCE = 1.5706706731410455E-9;
    static final double ITERATION_TOLERANCE = 3.926676682852614E-10;
    static final int MAXIMUM_ITERATIONS = 18;
    static final byte STANDARD_VARIANT = 0;
    private static final Map<Class<?>, ParameterDescriptorGroup> DESCRIPTORS = new HashMap();
    final ContextualParameters context;
    protected final double eccentricity;
    protected final double eccentricitySquared;
    private final MathTransform2D inverse;

    protected NormalizedProjection(OperationMethod operationMethod, Parameters parameters, Map<ParameterRole, ? extends ParameterDescriptor<? extends Number>> map) {
        this(new Initializer(operationMethod, parameters, map, 0));
    }

    NormalizedProjection(Initializer initializer) {
        this.context = initializer.context;
        this.eccentricitySquared = initializer.eccentricitySquared.doubleValue();
        this.eccentricity = Math.sqrt(this.eccentricitySquared);
        this.inverse = new Inverse(this);
    }

    NormalizedProjection(NormalizedProjection normalizedProjection) {
        this.context = normalizedProjection.context;
        this.eccentricity = normalizedProjection.eccentricity;
        this.eccentricitySquared = normalizedProjection.eccentricitySquared;
        this.inverse = new Inverse(this);
    }

    static boolean identMatch(OperationMethod operationMethod, String string, String string2) {
        if (string2 != null) {
            for (ReferenceIdentifier referenceIdentifier : operationMethod.getIdentifiers()) {
                if (!"EPSG".equals(referenceIdentifier.getCodeSpace())) continue;
                return string2.equals(referenceIdentifier.getCode());
            }
        }
        return operationMethod.getName().getCode().replace('_', ' ').matches(string);
    }

    public MathTransform createMapProjection(MathTransformFactory mathTransformFactory) throws FactoryException {
        return this.context.completeTransform(mathTransformFactory, this);
    }

    final MathTransform delegate(MathTransformFactory mathTransformFactory, String string) throws FactoryException {
        OperationMethod operationMethod = mathTransformFactory instanceof DefaultMathTransformFactory ? ((DefaultMathTransformFactory)mathTransformFactory).getOperationMethod(string) : CoordinateOperations.getOperationMethod(mathTransformFactory.getAvailableMethods(SingleOperation.class), string);
        if (operationMethod instanceof MathTransformProvider) {
            return ((MathTransformProvider)operationMethod).createMathTransform(mathTransformFactory, this.context);
        }
        throw new FactoryException(Errors.format((short)160, (operationMethod != null ? operationMethod : mathTransformFactory).getClass()));
    }

    @Override
    protected final ContextualParameters getContextualParameters() {
        return this.context;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        ParameterValueGroup parameterValueGroup = this.getParameterDescriptors().createValue();
        parameterValueGroup.parameter("eccentricity").setValue(this.eccentricity);
        String[] stringArray = this.getInternalParameterNames();
        double[] dArray = this.getInternalParameterValues();
        for (int i = 0; i < stringArray.length; ++i) {
            parameterValueGroup.parameter(stringArray[i]).setValue(dArray[i]);
        }
        return parameterValueGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        ParameterDescriptorGroup parameterDescriptorGroup;
        Class<?> clazz = this.getClass();
        while (!Modifier.isPublic(clazz.getModifiers())) {
            clazz = clazz.getSuperclass();
        }
        Map<Class<?>, ParameterDescriptorGroup> map = DESCRIPTORS;
        synchronized (map) {
            parameterDescriptorGroup = DESCRIPTORS.get(clazz);
            if (parameterDescriptorGroup == null) {
                ParameterBuilder parameterBuilder = new ParameterBuilder().setRequired(true);
                if (clazz.getName().startsWith("org.apache.sis.")) {
                    parameterBuilder.setCodeSpace(Citations.SIS, "SIS");
                }
                String[] stringArray = this.getInternalParameterNames();
                ParameterDescriptor[] parameterDescriptorArray = new ParameterDescriptor[stringArray.length + 1];
                parameterDescriptorArray[0] = MapProjection.ECCENTRICITY;
                for (int i = 1; i < parameterDescriptorArray.length; ++i) {
                    parameterDescriptorArray[i] = ((ParameterBuilder)parameterBuilder.addName(stringArray[i - 1])).create(Double.class, null);
                }
                parameterDescriptorGroup = ((ParameterBuilder)parameterBuilder.addName(CharSequences.camelCaseToSentence(clazz.getSimpleName()) + " (radians domain)")).createGroup(1, 1, (GeneralParameterDescriptor[])parameterDescriptorArray);
                DESCRIPTORS.put(clazz, parameterDescriptorGroup);
            }
        }
        return parameterDescriptorGroup;
    }

    String[] getInternalParameterNames() {
        return CharSequences.EMPTY_ARRAY;
    }

    double[] getInternalParameterValues() {
        return null;
    }

    static double wraparoundScaledLongitude(double d, double d2) {
        if (d2 < 0.0 ? d < d2 : d > d2) {
            d -= 2.0 * d2;
        }
        return d;
    }

    static double fastHypot(double d, double d2) {
        return Math.sqrt(d * d + d2 * d2);
    }

    @Override
    public abstract Matrix transform(double[] var1, int var2, double[] var3, int var4, boolean var5) throws ProjectionException;

    protected abstract void inverseTransform(double[] var1, int var2, double[] var3, int var4) throws ProjectionException;

    @Override
    public MathTransform2D inverse() {
        return this.inverse;
    }

    @Override
    protected MathTransform tryConcatenate(boolean bl, MathTransform mathTransform, MathTransformFactory mathTransformFactory) throws FactoryException {
        Matrix matrix = NormalizedProjection.getMiddleMatrix(this, mathTransform, bl);
        if (matrix != null) {
            return this.tryConcatenate(!bl, matrix, mathTransformFactory);
        }
        return super.tryConcatenate(bl, mathTransform, mathTransformFactory);
    }

    MathTransform tryConcatenate(boolean bl, Matrix matrix, MathTransformFactory mathTransformFactory) throws FactoryException {
        return null;
    }

    private static Matrix getMiddleMatrix(AbstractMathTransform abstractMathTransform, MathTransform mathTransform, boolean bl) {
        int n;
        MathTransform mathTransform2;
        List<MathTransform> list = MathTransforms.getSteps(mathTransform);
        if (list.size() == 2 && ((mathTransform2 = list.get(n = bl ? 0 : 1)) instanceof Inverse || mathTransform2 instanceof NormalizedProjection)) {
            try {
                Matrix matrix;
                if (abstractMathTransform.equals(mathTransform2.inverse(), ComparisonMode.IGNORE_METADATA) && Matrices.isAffine(matrix = MathTransforms.getMatrix(list.get(n ^ 1))) && matrix.getNumRow() == 3 && matrix.getNumCol() == 3) {
                    return matrix;
                }
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                Logging.recoverableException(Logging.getLogger("org.apache.sis.referencing.operation"), abstractMathTransform instanceof NormalizedProjection ? NormalizedProjection.class : abstractMathTransform.getClass(), "tryConcatenate", noninvertibleTransformException);
            }
        }
        return null;
    }

    @Override
    protected int computeHashCode() {
        long l = Double.doubleToLongBits(this.eccentricity);
        double[] dArray = this.getInternalParameterValues();
        if (dArray != null) {
            for (int i = 0; i < dArray.length; ++i) {
                l = l * 31L + Double.doubleToLongBits(dArray[i]);
            }
        }
        return super.computeHashCode() ^ Long.hashCode(l);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        Object[] objectArray;
        if (object == this) {
            return true;
        }
        if (!super.equals(object, comparisonMode)) {
            return false;
        }
        NormalizedProjection normalizedProjection = (NormalizedProjection)object;
        switch (comparisonMode) {
            case STRICT: 
            case BY_CONTRACT: {
                if (!Objects.equals(this.context, normalizedProjection.context)) {
                    return false;
                }
            }
            case IGNORE_METADATA: {
                if (Numerics.equals(this.eccentricitySquared, normalizedProjection.eccentricitySquared)) break;
                return false;
            }
            default: {
                double d = Math.max(this.eccentricity, normalizedProjection.eccentricity);
                if (Numerics.epsilonEqual(this.eccentricity, normalizedProjection.eccentricity, 1.5706706731410455E-9 * (1.0 / d - d))) break;
                assert (comparisonMode != ComparisonMode.DEBUG) : Numerics.messageForDifference("eccentricity", this.eccentricity, normalizedProjection.eccentricity);
                return false;
            }
        }
        double[] dArray = this.getInternalParameterValues();
        double[] dArray2 = normalizedProjection.getInternalParameterValues();
        if (dArray == null) {
            return dArray2 == null;
        }
        if (dArray2 != null && dArray.length == dArray2.length && Arrays.equals(objectArray = this.getInternalParameterNames(), normalizedProjection.getInternalParameterNames())) {
            for (int i = 0; i < dArray.length; ++i) {
                if (Numerics.epsilonEqual(dArray[i], dArray2[i], comparisonMode)) continue;
                assert (comparisonMode != ComparisonMode.DEBUG) : Numerics.messageForDifference((String)objectArray[i], dArray[i], dArray2[i]);
                return false;
            }
            return true;
        }
        return false;
    }

    private static final class Inverse
    extends AbstractMathTransform2D.Inverse
    implements Serializable {
        private static final long serialVersionUID = 6014176098150309651L;
        private final NormalizedProjection forward;

        Inverse(NormalizedProjection normalizedProjection) {
            this.forward = normalizedProjection;
        }

        @Override
        public MathTransform2D inverse() {
            return this.forward;
        }

        @Override
        public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
            if (!bl) {
                this.forward.inverseTransform(dArray, n, dArray2, n2);
                return null;
            }
            if (dArray2 == null) {
                dArray2 = new double[2];
                n2 = 0;
            }
            this.forward.inverseTransform(dArray, n, dArray2, n2);
            return Matrices.inverse(this.forward.transform(dArray2, n2, null, 0, true));
        }

        @Override
        public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
            if (dArray == dArray2 && n < n2) {
                super.transform(dArray, n, dArray2, n2, n3);
            } else {
                while (--n3 >= 0) {
                    this.forward.inverseTransform(dArray, n, dArray2, n2);
                    n += 2;
                    n2 += 2;
                }
            }
        }

        @Override
        protected MathTransform tryConcatenate(boolean bl, MathTransform mathTransform, MathTransformFactory mathTransformFactory) throws FactoryException {
            Matrix matrix = NormalizedProjection.getMiddleMatrix(this, mathTransform, bl);
            if (matrix != null) {
                return this.forward.tryConcatenate(bl, matrix, mathTransformFactory);
            }
            return super.tryConcatenate(bl, mathTransform, mathTransformFactory);
        }
    }

    protected static enum ParameterRole {
        SEMI_MAJOR,
        SEMI_MINOR,
        LATITUDE_OF_CONFORMAL_SPHERE_RADIUS,
        CENTRAL_MERIDIAN,
        SCALE_FACTOR,
        FALSE_EASTING,
        FALSE_WESTING,
        FALSE_NORTHING,
        FALSE_SOUTHING;

    }
}

