/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.algorithms;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Element;

public class JCEMapper {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$algorithms$JCEMapper == null ? (class$org$apache$xml$security$algorithms$JCEMapper = JCEMapper.class$("org.apache.xml.security.algorithms.JCEMapper")) : class$org$apache$xml$security$algorithms$JCEMapper).getName());
    private static Map uriToJCEName;
    private static Map algorithmsMap;
    private static String providerName;
    static /* synthetic */ Class class$org$apache$xml$security$algorithms$JCEMapper;

    public static void init(Element element) throws Exception {
        JCEMapper.loadAlgorithms((Element)element.getElementsByTagName("Algorithms").item(0));
    }

    static void loadAlgorithms(Element element) {
        Element[] elementArray = XMLUtils.selectNodes(element.getFirstChild(), "http://www.xmlsecurity.org/NS/#configuration", "Algorithm");
        uriToJCEName = new HashMap(elementArray.length * 2);
        algorithmsMap = new HashMap(elementArray.length * 2);
        for (int i = 0; i < elementArray.length; ++i) {
            Element element2 = elementArray[i];
            String string = element2.getAttribute("URI");
            String string2 = element2.getAttribute("JCEName");
            uriToJCEName.put(string, string2);
            algorithmsMap.put(string, new Algorithm(element2));
        }
    }

    static Algorithm getAlgorithmMapping(String string) {
        return (Algorithm)algorithmsMap.get(string);
    }

    public static String translateURItoJCEID(String string) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Request for URI " + string));
        }
        String string2 = (String)uriToJCEName.get(string);
        return string2;
    }

    public static String getAlgorithmClassFromURI(String string) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Request for URI " + string));
        }
        return ((Algorithm)JCEMapper.algorithmsMap.get((Object)string)).algorithmClass;
    }

    public static int getKeyLengthFromURI(String string) {
        return Integer.parseInt(((Algorithm)JCEMapper.algorithmsMap.get((Object)string)).keyLength);
    }

    public static String getJCEKeyAlgorithmFromURI(String string) {
        return ((Algorithm)JCEMapper.algorithmsMap.get((Object)string)).requiredKey;
    }

    public static String getProviderId() {
        return providerName;
    }

    public static void setProviderId(String string) {
        providerName = string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        providerName = null;
    }

    public static class Algorithm {
        String algorithmClass;
        String keyLength;
        String requiredKey;

        public Algorithm(Element element) {
            this.algorithmClass = element.getAttribute("AlgorithmClass");
            this.keyLength = element.getAttribute("KeyLength");
            this.requiredKey = element.getAttribute("RequiredKey");
        }
    }
}

