/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.meridio;

import com.meridio.www.MeridioDMWS.DmLogicalOp;
import com.meridio.www.MeridioDMWS.DmPermission;
import com.meridio.www.MeridioDMWS.DmSearchScope;
import com.meridio.www.MeridioDMWS.DmVersionInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.connectorcommon.common.CommonsHTTPSender;
import org.apache.manifoldcf.connectorcommon.interfaces.IKeystoreManager;
import org.apache.manifoldcf.connectorcommon.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.Configuration;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IDFactory;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.crawler.connectors.BaseRepositoryConnector;
import org.apache.manifoldcf.crawler.connectors.meridio.DMDataSet.ACCESSCONTROL;
import org.apache.manifoldcf.crawler.connectors.meridio.DMDataSet.CATEGORIES;
import org.apache.manifoldcf.crawler.connectors.meridio.DMDataSet.DMDataSet;
import org.apache.manifoldcf.crawler.connectors.meridio.DMDataSet.DOCUMENTS;
import org.apache.manifoldcf.crawler.connectors.meridio.DMDataSet.PROPERTYDEFS;
import org.apache.manifoldcf.crawler.connectors.meridio.DMDataSet.PROPERTY_OPS;
import org.apache.manifoldcf.crawler.connectors.meridio.DMDataSet.PROPERTY_TERMS;
import org.apache.manifoldcf.crawler.connectors.meridio.DMDataSet.RESULTDEFS;
import org.apache.manifoldcf.crawler.connectors.meridio.DMDataSet.SEARCHRESULTS_DOCUMENTS;
import org.apache.manifoldcf.crawler.connectors.meridio.DMDataSet.SEARCH_CONTAINERS;
import org.apache.manifoldcf.crawler.connectors.meridio.MatchMap;
import org.apache.manifoldcf.crawler.connectors.meridio.MeridioClassContents;
import org.apache.manifoldcf.crawler.connectors.meridio.Messages;
import org.apache.manifoldcf.crawler.connectors.meridio.RMDataSet.RMDataSet;
import org.apache.manifoldcf.crawler.connectors.meridio.RMDataSet.Rm2vClass;
import org.apache.manifoldcf.crawler.connectors.meridio.RMDataSet.Rm2vFolder;
import org.apache.manifoldcf.crawler.connectors.meridio.RMDataSet.Rm2vRecord;
import org.apache.manifoldcf.crawler.interfaces.IExistingVersions;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.interfaces.ISeedingActivity;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;
import org.apache.manifoldcf.meridio.DMSearchResults;
import org.apache.manifoldcf.meridio.MeridioDataSetException;
import org.apache.manifoldcf.meridio.MeridioWrapper;
import org.apache.manifoldcf.ui.util.Encoder;
import org.w3c.dom.Element;

public class MeridioConnector
extends BaseRepositoryConnector {
    public static final String _rcsid = "@(#)$Id: MeridioConnector.java 996524 2010-09-13 13:38:01Z kwright $";
    protected String urlBase = null;
    protected String urlVersionBase = null;
    private static final int maxHitsToReturn = 100;
    private static final String defaultAuthorityDenyToken = "DEAD_AUTHORITY";
    private static final long interruptionRetryTime = 60000L;
    protected URL DmwsURL = null;
    protected URL RmwsURL = null;
    protected SSLSocketFactory mySSLFactory = null;
    protected MeridioWrapper meridio_ = null;
    private static String[] allowedMimeTypes = new String[]{"application/excel", "application/powerpoint", "application/ppt", "application/rtf", "application/xls", "text/html", "text/rtf", "text/pdf", "application/x-excel", "application/x-msexcel", "application/x-mspowerpoint", "application/x-msword-doc", "application/x-msword", "application/x-word", "Application/pdf", "text/xml", "no-type", "text/plain", "application/pdf", "application/x-rtf", "application/vnd.ms-excel", "application/vnd.ms-pps", "application/vnd.ms-powerpoint", "application/vnd.ms-word", "application/msword", "application/msexcel", "application/mspowerpoint", "application/ms-powerpoint", "application/ms-word", "application/ms-excel", "Adobe", "application/Vnd.Ms-Excel", "vnd.ms-powerpoint", "application/x-pdf", "winword", "text/richtext", "Text", "Text/html", "application/MSWORD", "application/PDF", "application/MSEXCEL", "application/MSPOWERPOINT"};

    public int getConnectorModel() {
        return 2;
    }

    protected void getSession() throws ManifoldCFException, ServiceInterruption {
        if (this.meridio_ == null) {
            try {
                String DMWSProtocol = this.params.getParameter("DMWSServerProtocol");
                String DMWSPort = this.params.getParameter("DMWSServerPort");
                DMWSPort = DMWSPort == null || DMWSPort.length() == 0 ? "" : ":" + DMWSPort;
                String Url = DMWSProtocol + "://" + this.params.getParameter("DMWSServerName") + DMWSPort + this.params.getParameter("DMWSLocation");
                Logging.connectors.debug((Object)("Meridio: Document Management Web Service (DMWS) URL is [" + Url + "]"));
                this.DmwsURL = new URL(Url);
                String RMWSProtocol = this.params.getParameter("RMWSServerProtocol");
                String RMWSPort = this.params.getParameter("RMWSServerPort");
                RMWSPort = RMWSPort == null || RMWSPort.length() == 0 ? "" : ":" + RMWSPort;
                Url = RMWSProtocol + "://" + this.params.getParameter("RMWSServerName") + RMWSPort + this.params.getParameter("RMWSLocation");
                Logging.connectors.debug((Object)("Meridio: Record Management Web Service (RMWS) URL is [" + Url + "]"));
                this.RmwsURL = new URL(Url);
                String keystoreData = this.params.getParameter("MeridioKeystore");
                this.mySSLFactory = keystoreData != null ? KeystoreManagerFactory.make((String)"", (String)keystoreData).getSecureSocketFactory() : null;
                String clientProtocol = this.params.getParameter("MeridioWebClientProtocol");
                String clientPort = this.params.getParameter("MeridioWebClientServerPort");
                clientPort = clientPort == null || clientPort.length() == 0 ? "" : ":" + clientPort;
                this.urlVersionBase = clientProtocol + "://" + this.params.getParameter("MeridioWebClientServerName") + clientPort + this.params.getParameter("MeridioWebClientDocDownloadLocation");
                this.urlBase = this.urlVersionBase + "?launchMode=1&launchAs=0&documentId=";
            }
            catch (MalformedURLException malformedURLException) {
                throw new ManifoldCFException("Meridio: Could not construct the URL for either the DM or RM Meridio Web Service", (Throwable)malformedURLException, 5);
            }
            try {
                this.meridio_ = new MeridioWrapper(Logging.connectors, this.DmwsURL, this.RmwsURL, null, this.params.getParameter("DMWSProxyHost"), this.params.getParameter("DMWSProxyPort"), this.params.getParameter("RMWSProxyHost"), this.params.getParameter("RMWSProxyPort"), null, null, this.params.getParameter("UserName"), this.params.getObfuscatedParameter("Password"), InetAddress.getLocalHost().getHostName(), this.mySSLFactory, CommonsHTTPSender.class, "client-config.wsdd");
            }
            catch (NumberFormatException e) {
                throw new ManifoldCFException("Meridio: bad number: " + e.getMessage(), (Throwable)e);
            }
            catch (UnknownHostException unknownHostException) {
                throw new ManifoldCFException("Meridio: A Unknown Host Exception occurred while connecting - is a network software and hardware configuration: " + unknownHostException.getMessage(), (Throwable)unknownHostException);
            }
            catch (AxisFault e) {
                String exceptionName;
                long currentTime = System.currentTimeMillis();
                if (e.getFaultCode().equals(new QName("http://xml.apache.org/axis/", "HTTP"))) {
                    Element elem = e.lookupFaultDetail(new QName("http://xml.apache.org/axis/", "HttpErrorCode"));
                    if (elem != null) {
                        elem.normalize();
                        String httpErrorCode = elem.getFirstChild().getNodeValue().trim();
                        throw new ManifoldCFException("Unexpected http error code " + httpErrorCode + " accessing Meridio: " + e.getMessage(), (Throwable)e);
                    }
                    throw new ManifoldCFException("Unknown http error occurred while connecting: " + e.getMessage(), (Throwable)e);
                }
                if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server.userException")) && (exceptionName = e.getFaultString()).equals("java.lang.InterruptedException")) {
                    throw new ManifoldCFException("Interrupted", 2);
                }
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Meridio: Got an unknown remote exception connecting - axis fault = " + e.getFaultCode().getLocalPart() + ", detail = " + e.getFaultString() + " - retrying"), (Throwable)e);
                }
                throw new ServiceInterruption("Remote procedure exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
            }
            catch (RemoteException remoteException) {
                throw new ManifoldCFException("Meridio: An unknown remote exception occurred while connecting: " + remoteException.getMessage(), (Throwable)remoteException);
            }
        }
    }

    public String[] getBinNames(String documentIdentifier) {
        String dmwshost = this.params.getParameter("DMWSServerName");
        String rmwshost = this.params.getParameter("RMWSServerName");
        return new String[]{dmwshost, rmwshost};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String check() throws ManifoldCFException {
        String string;
        Logging.connectors.debug((Object)"Meridio: Entering 'check' method");
        try {
            this.meridio_ = null;
            this.getSession();
        }
        catch (ServiceInterruption e) {
            return "Meridio temporarily unavailable: " + e.getMessage();
        }
        catch (ManifoldCFException e) {
            return e.getMessage();
        }
        try {
            RMDataSet rmws;
            DMDataSet ds = this.meridio_.getStaticData();
            if (null == ds) {
                Logging.connectors.debug((Object)"Meridio: DM DataSet returned was null in 'check' method");
                String string2 = "Connection failed - null DM DataSet";
                return string2;
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("Meridio System Name is [" + ds.getSYSTEMINFO().getSystemName() + "] and the comment is [" + ds.getSYSTEMINFO().getComment() + "]"));
            }
            if (null == (rmws = this.meridio_.getConfiguration())) {
                Logging.connectors.warn((Object)"Meridio: RM DataSet returned was null in 'check' method");
                String string3 = "Connection failed - null RM DataSet returned";
                return string3;
            }
            String string4 = super.check();
            return string4;
        }
        catch (AxisFault e) {
            String exceptionName;
            long currentTime = System.currentTimeMillis();
            if (e.getFaultCode().equals(new QName("http://xml.apache.org/axis/", "HTTP"))) {
                Element elem = e.lookupFaultDetail(new QName("http://xml.apache.org/axis/", "HttpErrorCode"));
                if (elem != null) {
                    elem.normalize();
                    String httpErrorCode = elem.getFirstChild().getNodeValue().trim();
                    String string5 = "Unexpected http error code " + httpErrorCode + " accessing Meridio: " + e.getMessage();
                    return string5;
                }
                String string6 = "Unknown http error occurred while checking: " + e.getMessage();
                return string6;
            }
            if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server.userException")) && (exceptionName = e.getFaultString()).equals("java.lang.InterruptedException")) {
                throw new ManifoldCFException("Interrupted", 2);
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("Meridio: Got an unknown remote exception checking - axis fault = " + e.getFaultCode().getLocalPart() + ", detail = " + e.getFaultString() + " - retrying"), (Throwable)e);
            }
            String string7 = "Axis fault: " + e.getMessage();
            return string7;
        }
        catch (RemoteException remoteException) {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("Meridio: Unknown remote exception occurred during 'check' method: " + remoteException.getMessage()), (Throwable)remoteException);
            }
            string = "Connection failed - Remote exception: " + remoteException.getMessage();
            return string;
        }
        catch (MeridioDataSetException meridioDataSetException) {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("Meridio: DataSet exception occurred during 'check' method: " + meridioDataSetException.getMessage()), (Throwable)meridioDataSetException);
            }
            string = "Connection failed - DataSet exception: " + meridioDataSetException.getMessage();
            return string;
        }
        finally {
            Logging.connectors.debug((Object)"Meridio: Exiting 'check' method");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws ManifoldCFException {
        Logging.connectors.debug((Object)"Meridio: Entering 'disconnect' method");
        try {
            if (this.meridio_ != null) {
                this.meridio_.logout();
            }
        }
        catch (AxisFault e) {
            String exceptionName;
            long currentTime = System.currentTimeMillis();
            if (e.getFaultCode().equals(new QName("http://xml.apache.org/axis/", "HTTP"))) {
                Element elem = e.lookupFaultDetail(new QName("http://xml.apache.org/axis/", "HttpErrorCode"));
                if (elem != null) {
                    elem.normalize();
                    String httpErrorCode = elem.getFirstChild().getNodeValue().trim();
                    Logging.connectors.warn((Object)("Unexpected http error code " + httpErrorCode + " logging out: " + e.getMessage()));
                    return;
                }
                Logging.connectors.warn((Object)("Unknown http error occurred while logging out: " + e.getMessage()));
                return;
            }
            if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server.userException")) && (exceptionName = e.getFaultString()).equals("java.lang.InterruptedException")) {
                throw new ManifoldCFException("Interrupted", 2);
            }
            if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server")) && e.getFaultString().indexOf(" 23031#") != -1) {
                this.meridio_ = null;
                return;
            }
            Logging.connectors.warn((Object)("Meridio: Got an unknown remote exception logging out - axis fault = " + e.getFaultCode().getLocalPart() + ", detail = " + e.getFaultString()), (Throwable)e);
            return;
        }
        catch (RemoteException remoteException) {
            Logging.connectors.warn((Object)("Meridio: A remote exception occurred while logging out: " + remoteException.getMessage()), (Throwable)remoteException);
        }
        finally {
            super.disconnect();
            this.meridio_ = null;
            this.urlBase = null;
            this.urlVersionBase = null;
            this.DmwsURL = null;
            this.RmwsURL = null;
            this.mySSLFactory = null;
            Logging.connectors.debug((Object)"Meridio: Exiting 'disconnect' method");
        }
    }

    public int getMaxDocumentRequest() {
        return 10;
    }

    public boolean requestInfo(Configuration output, String command) throws ManifoldCFException {
        if (command.equals("categories")) {
            try {
                String[] categories = this.getMeridioCategories();
                int i = 0;
                while (i < categories.length) {
                    String category = categories[i++];
                    ConfigurationNode node = new ConfigurationNode("category");
                    node.setValue(category);
                    output.addChild(output.getChildCount(), node);
                }
            }
            catch (ServiceInterruption e) {
                ManifoldCF.createServiceInterruptionNode((Configuration)output, (ServiceInterruption)e);
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            }
        } else if (command.equals("documentproperties")) {
            try {
                String[] properties = this.getMeridioDocumentProperties();
                int i = 0;
                while (i < properties.length) {
                    String property = properties[i++];
                    ConfigurationNode node = new ConfigurationNode("document_property");
                    node.setValue(property);
                    output.addChild(output.getChildCount(), node);
                }
            }
            catch (ServiceInterruption e) {
                ManifoldCF.createServiceInterruptionNode((Configuration)output, (ServiceInterruption)e);
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            }
        } else if (command.startsWith("classorfolder/")) {
            int classOrFolderId;
            String classOrFolderIdString = command.substring("classorfolder/".length());
            try {
                classOrFolderId = Integer.parseInt(classOrFolderIdString);
            }
            catch (NumberFormatException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)new ManifoldCFException(e.getMessage(), (Throwable)e));
                return false;
            }
            try {
                MeridioClassContents[] contents = this.getClassOrFolderContents(classOrFolderId);
                int i = 0;
                while (i < contents.length) {
                    MeridioClassContents content = contents[i++];
                    ConfigurationNode node = new ConfigurationNode("content");
                    ConfigurationNode child = new ConfigurationNode("id");
                    child.setValue(Integer.toString(content.classOrFolderId));
                    node.addChild(node.getChildCount(), child);
                    child = new ConfigurationNode("name");
                    child.setValue(content.classOrFolderName);
                    node.addChild(node.getChildCount(), child);
                    child = new ConfigurationNode("type");
                    String typeString = content.containerType == 1 ? "class" : (content.containerType == 0 ? "folder" : "unknown");
                    child.setValue(typeString);
                    node.addChild(node.getChildCount(), child);
                    output.addChild(output.getChildCount(), node);
                }
            }
            catch (ServiceInterruption e) {
                ManifoldCF.createServiceInterruptionNode((Configuration)output, (ServiceInterruption)e);
            }
            catch (ManifoldCFException e) {
                ManifoldCF.createErrorNode((Configuration)output, (ManifoldCFException)e);
            }
        } else {
            return super.requestInfo(output, command);
        }
        return true;
    }

    /*
     * Loose catch block
     */
    public String addSeedDocuments(ISeedingActivity activities, Specification spec, String lastSeedVersion, long seedTime, int jobMode) throws ManifoldCFException, ServiceInterruption {
        Logging.connectors.debug((Object)"Meridio: Entering 'addSeedDocuments' method");
        long startTime = lastSeedVersion == null ? 0L : new Long(lastSeedVersion);
        long timeAdjust = 900000L;
        startTime = startTime > timeAdjust ? (startTime -= timeAdjust) : 0L;
        while (true) {
            this.getSession();
            try {
                DMSearchResults searchResults;
                int numResultsReturnedByStream = 0;
                do {
                    searchResults = this.documentSpecificationSearch(spec, startTime, seedTime, numResultsReturnedByStream + 1, 100);
                    for (int i = 0; i < searchResults.returnedHitsCount; ++i) {
                        long documentId = searchResults.dsDM.getSEARCHRESULTS_DOCUMENTS()[i].getDocId();
                        String strDocumentId = new Long(documentId).toString();
                        activities.addSeedDocument(strDocumentId);
                    }
                } while ((numResultsReturnedByStream += searchResults.returnedHitsCount) != searchResults.totalHitsCount);
                return new Long(seedTime).toString();
            }
            catch (AxisFault e) {
                String exceptionName;
                long currentTime = System.currentTimeMillis();
                if (e.getFaultCode().equals(new QName("http://xml.apache.org/axis/", "HTTP"))) {
                    Element elem = e.lookupFaultDetail(new QName("http://xml.apache.org/axis/", "HttpErrorCode"));
                    if (elem != null) {
                        elem.normalize();
                        String httpErrorCode = elem.getFirstChild().getNodeValue().trim();
                        throw new ManifoldCFException("Unexpected http error code " + httpErrorCode + " accessing Meridio: " + e.getMessage(), (Throwable)e);
                    }
                    throw new ManifoldCFException("Unknown http error occurred while performing search: " + e.getMessage(), (Throwable)e);
                }
                if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server.userException")) && (exceptionName = e.getFaultString()).equals("java.lang.InterruptedException")) {
                    throw new ManifoldCFException("Interrupted", 2);
                }
                if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server")) && e.getFaultString().indexOf(" 23031#") != -1) {
                    this.meridio_ = null;
                    continue;
                }
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Meridio: Got an unknown remote exception while performing search - axis fault = " + e.getFaultCode().getLocalPart() + ", detail = " + e.getFaultString() + " - retrying"), (Throwable)e);
                }
                throw new ServiceInterruption("Remote procedure exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
            }
            catch (RemoteException remoteException) {
                throw new ManifoldCFException("Meridio: A Remote Exception occurred while performing a search: " + remoteException.getMessage(), (Throwable)remoteException);
            }
            break;
        }
        catch (MeridioDataSetException meridioDataSetException) {
            throw new ManifoldCFException("Meridio: A problem occurred manipulating the Web Service XML: " + meridioDataSetException.getMessage(), (Throwable)meridioDataSetException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    public void processDocuments(String[] documentIdentifiers, IExistingVersions statuses, Specification spec, IProcessActivity activities, int jobMode, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        Object[] acls = MeridioConnector.getAcls(spec);
        if (acls != null) {
            Arrays.sort(acls);
        }
        HashSet<Object[]> holder = new HashSet<Object[]>();
        String pathAttributeName = null;
        MatchMap matchMap = new MatchMap();
        boolean allMetadata = false;
        int i = 0;
        while (i < spec.getChildCount()) {
            SpecificationNode n;
            if ((n = spec.getChild(i++)).getType().equals("ReturnedMetadata")) {
                String category = n.getAttributeValue("category");
                String attributeName = n.getAttributeValue("property");
                Object metadataName = category == null || category.length() == 0 ? attributeName : category + "." + attributeName;
                holder.add((Object[])metadataName);
                continue;
            }
            if (n.getType().equals("AllMetadata")) {
                String value = n.getAttributeValue("value");
                if (value == null || !value.equals("true")) continue;
                allMetadata = true;
                continue;
            }
            if (n.getType().equals("pathnameattribute")) {
                pathAttributeName = n.getAttributeValue("value");
                continue;
            }
            if (!n.getType().equals("pathmap")) continue;
            String pathMatch = n.getAttributeValue("match");
            String pathReplace = n.getAttributeValue("replace");
            matchMap.appendMatchPair(pathMatch, pathReplace);
        }
        while (true) {
            this.getSession();
            try {
                Object[] categoryPropertyStringValues;
                if (allMetadata) {
                    categoryPropertyStringValues = this.getMeridioDocumentProperties();
                } else {
                    categoryPropertyStringValues = new String[holder.size()];
                    i = 0;
                    for (String value : holder) {
                        categoryPropertyStringValues[i++] = value;
                    }
                }
                Arrays.sort(categoryPropertyStringValues);
                ReturnMetadata[] categoryPropertyValues = new ReturnMetadata[categoryPropertyStringValues.length];
                i = 0;
                for (Object value : categoryPropertyStringValues) {
                    Object propertyName;
                    int dotIndex = ((String)value).indexOf(".");
                    String categoryName = null;
                    if (dotIndex == -1) {
                        propertyName = value;
                    } else {
                        categoryName = ((String)value).substring(0, dotIndex);
                        propertyName = ((String)value).substring(dotIndex + 1);
                    }
                    categoryPropertyValues[i++] = new ReturnMetadata(categoryName, (String)propertyName);
                }
                StringBuilder decodeableString = new StringBuilder();
                MeridioConnector.packList((StringBuilder)decodeableString, (String[])categoryPropertyStringValues, (char)'+');
                if (acls == null) {
                    decodeableString.append('-');
                } else {
                    decodeableString.append('+');
                    MeridioConnector.packList((StringBuilder)decodeableString, (String[])acls, (char)'+');
                    decodeableString.append('+');
                    MeridioConnector.pack((StringBuilder)decodeableString, (String)defaultAuthorityDenyToken, (char)'+');
                }
                if (pathAttributeName != null) {
                    decodeableString.append("+");
                    MeridioConnector.pack((StringBuilder)decodeableString, (String)pathAttributeName, (char)'+');
                    MeridioConnector.pack((StringBuilder)decodeableString, (String)matchMap.toString(), (char)'+');
                } else {
                    decodeableString.append("-");
                }
                long[] docIds = new long[documentIdentifiers.length];
                for (i = 0; i < documentIdentifiers.length; ++i) {
                    docIds[i] = new Long(documentIdentifiers[i]);
                }
                DMSearchResults searchResults = this.documentSpecificationSearch(spec, 0L, 0L, 1, this.getMaxDocumentRequest(), docIds, null);
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Found a total of <" + searchResults.totalHitsCount + "> hit(s) and <" + searchResults.returnedHitsCount + "> were returned by the method call"));
                }
                HashMap<Long, SEARCHRESULTS_DOCUMENTS> documentMap = new HashMap<Long, SEARCHRESULTS_DOCUMENTS>();
                if (searchResults.dsDM != null) {
                    SEARCHRESULTS_DOCUMENTS[] srd = searchResults.dsDM.getSEARCHRESULTS_DOCUMENTS();
                    for (i = 0; i < srd.length; ++i) {
                        documentMap.put(new Long(srd[i].getDocId()), srd[i]);
                    }
                }
                HashMap<SEARCHRESULTS_DOCUMENTS[], String> versionStrings = new HashMap<SEARCHRESULTS_DOCUMENTS[], String>();
                for (int j = 0; j < docIds.length; ++j) {
                    String documentIdentifier = documentIdentifiers[j];
                    long docId = docIds[j];
                    SEARCHRESULTS_DOCUMENTS[] docKey = new Long(docId);
                    SEARCHRESULTS_DOCUMENTS doc = (SEARCHRESULTS_DOCUMENTS)documentMap.get(docKey);
                    if (doc != null) {
                        String version = doc.getStr_value();
                        StringBuilder composedVersion = new StringBuilder();
                        composedVersion.append((CharSequence)decodeableString);
                        composedVersion.append(version);
                        composedVersion.append("_").append(this.urlVersionBase);
                        String versionString = composedVersion.toString();
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("Meridio: Document " + docKey + " has version " + versionString));
                        }
                        if (!activities.checkDocumentNeedsReindexing(documentIdentifier, versionString)) continue;
                        versionStrings.put(docKey, versionString);
                        continue;
                    }
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("Meridio: Document " + docKey + " is no longer in the search set, or has been deleted - removing."));
                    }
                    activities.deleteDocument(documentIdentifier);
                }
                HashMap documentPropertyMap = new HashMap();
                if (versionStrings.size() > 0 && categoryPropertyValues.length > 0) {
                    long[] fetchIds = new long[versionStrings.size()];
                    i = 0;
                    for (Long docKey : versionStrings.keySet()) {
                        fetchIds[i++] = docKey;
                    }
                    searchResults = this.documentSpecificationSearch(spec, 0L, 0L, 1, fetchIds.length, fetchIds, categoryPropertyValues);
                    HashMap<Long, Object> counterMap = new HashMap<Long, Object>();
                    if (searchResults.dsDM != null) {
                        SEARCHRESULTS_DOCUMENTS[] searchResultsDocuments;
                        for (SEARCHRESULTS_DOCUMENTS searchResultsDocument : searchResultsDocuments = searchResults.dsDM.getSEARCHRESULTS_DOCUMENTS()) {
                            long docId = searchResultsDocument.getDocId();
                            Long docKey = new Long(docId);
                            Object counterMapItem = (MutableInteger)counterMap.get(docKey);
                            if (counterMapItem == null) {
                                counterMapItem = new MutableInteger();
                                counterMap.put(docKey, counterMapItem);
                            }
                            Object propertyName = categoryPropertyStringValues[((MutableInteger)counterMapItem).getValue()];
                            ((MutableInteger)counterMapItem).increment();
                            String propertyValue = searchResultsDocuments[i].getStr_value();
                            HashMap<Object, String> propertyMap = (HashMap<Object, String>)documentPropertyMap.get(docKey);
                            if (propertyMap == null) {
                                propertyMap = new HashMap<Object, String>();
                                documentPropertyMap.put(docKey, propertyMap);
                            }
                            if (propertyValue == null || propertyValue.length() <= 0) continue;
                            propertyMap.put(propertyName, propertyValue);
                        }
                    }
                }
                for (String documentIdentifier : documentIdentifiers) {
                    String[] denyAcls;
                    Object[] allowAcls;
                    Long docKey = new Long(documentIdentifier);
                    long docId = docKey;
                    String docVersion = (String)versionStrings.get(docKey);
                    if (docVersion == null) continue;
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("Processing document identifier '" + documentIdentifier + "' with version string '" + docVersion + "'"));
                    }
                    activities.checkJobStillActive();
                    RepositoryDocument repositoryDocument = new RepositoryDocument();
                    Map docMetadataMap = (Map)documentPropertyMap.get(docKey);
                    if (docMetadataMap != null) {
                        for (Object categoryPropertyName : categoryPropertyStringValues) {
                            String propertyValue = (String)docMetadataMap.get(categoryPropertyName);
                            if (propertyValue == null || propertyValue.length() <= 0) continue;
                            repositoryDocument.addField((String)categoryPropertyName, propertyValue);
                        }
                    }
                    String fileURL = this.urlBase + new Long(docId).toString();
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("URL for document '" + new Long(docId).toString() + "' is '" + fileURL + "'"));
                    }
                    DMDataSet documentData = null;
                    documentData = this.meridio_.getDocumentData((int)docId, true, true, false, false, DmVersionInfo.LATEST, false, false, false);
                    if (null == documentData) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("Meridio: Could not retrieve document data for document id '" + new Long(docId).toString() + "' in processDocuments method - deleting document."));
                        }
                        activities.noDocument(documentIdentifier, docVersion);
                        continue;
                    }
                    if (null == documentData.getDOCUMENTS() || documentData.getDOCUMENTS().length != 1) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("Meridio: Could not retrieve document owner for document id '" + new Long(docId).toString() + "' in processDocuments method. No information or incorrect amount of information was returned"));
                        }
                        activities.noDocument(documentIdentifier, docVersion);
                        continue;
                    }
                    if (pathAttributeName != null && pathAttributeName.length() > 0) {
                        short recordType;
                        RMDataSet partList;
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("Meridio: Path attribute name is " + pathAttributeName));
                        }
                        if ((partList = (recordType = documentData.getDOCUMENTS()[0].getPROP_recordType()) == 0 || recordType == 4 || recordType == 19 ? this.meridio_.getRecordPartList((int)docId, false, false) : this.meridio_.getDocumentPartList((int)docId)) != null) {
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("Meridio: Document '" + new Long(docId).toString() + "' has a part list with " + Integer.toString(partList.getRm2vPart().length) + " values"));
                            }
                            for (int k = 0; k < partList.getRm2vPart().length; ++k) {
                                repositoryDocument.addField(pathAttributeName, matchMap.translate(partList.getRm2vPart()[k].getParentTitlePath()));
                            }
                        } else if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("Meridio: Document '" + new Long(docId).toString() + "' has no part list, so no path attribute"));
                        }
                    }
                    if (acls != null && acls.length == 0) {
                        int j;
                        ACCESSCONTROL[] documentAcls = documentData.getACCESSCONTROL();
                        ArrayList<String> allowAclsArrayList = new ArrayList<String>();
                        ArrayList<String> denyAclsArrayList = new ArrayList<String>();
                        denyAclsArrayList.add(defaultAuthorityDenyToken);
                        if (documentAcls != null) {
                            for (int j2 = 0; j2 < documentAcls.length; ++j2) {
                                if (Logging.connectors.isDebugEnabled()) {
                                    Logging.connectors.debug((Object)("Object Id '" + documentAcls[j2].getObjectId() + "' Object Type '" + documentAcls[j2].getObjectType() + "' Permission '" + documentAcls[j2].getPermission() + "' User Id '" + documentAcls[j2].getUserId() + "' Group Id '" + documentAcls[j2].getGroupId() + "'"));
                                }
                                if (documentAcls[j2].getPermission() == 0) {
                                    if (documentAcls[j2].getGroupId() > 0L) {
                                        denyAclsArrayList.add("G" + documentAcls[j2].getGroupId());
                                        continue;
                                    }
                                    if (documentAcls[j2].getUserId() <= 0L) continue;
                                    denyAclsArrayList.add("U" + documentAcls[j2].getUserId());
                                    continue;
                                }
                                if (documentAcls[j2].getGroupId() > 0L) {
                                    allowAclsArrayList.add("G" + documentAcls[j2].getGroupId());
                                    continue;
                                }
                                if (documentAcls[j2].getUserId() <= 0L) continue;
                                allowAclsArrayList.add("U" + documentAcls[j2].getUserId());
                            }
                        }
                        DOCUMENTS document = documentData.getDOCUMENTS()[0];
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("Document id '" + new Long(docId).toString() + "' is owned by owner id '" + document.getPROP_ownerId() + "' having the owner name '" + document.getPROP_ownerName() + "' Record Type is '" + document.getPROP_recordType() + "'"));
                        }
                        if (document.getPROP_recordType() == 4 || document.getPROP_recordType() == 19) {
                            RMDataSet rmds = this.meridio_.getRecord((int)docId, false, false, false);
                            Rm2vRecord record = rmds.getRm2vRecord()[0];
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("Record User Id Owner is '" + record.getOwnerID() + "' Record Group Owner Id is '" + record.getGroupOwnerID() + "'"));
                            }
                            if (record.getGroupOwnerID() > 0) {
                                allowAclsArrayList.add("G" + record.getGroupOwnerID());
                            } else if (record.getOwnerID() > 0) {
                                allowAclsArrayList.add("U" + record.getOwnerID());
                            }
                        } else {
                            allowAclsArrayList.add("U" + document.getPROP_ownerId());
                        }
                        allowAcls = new String[allowAclsArrayList.size()];
                        for (j = 0; j < allowAclsArrayList.size(); ++j) {
                            allowAcls[j] = (String)allowAclsArrayList.get(j);
                            if (!Logging.connectors.isDebugEnabled()) continue;
                            Logging.connectors.debug((Object)("Meridio: Adding '" + (String)allowAcls[j] + "' to allow ACLs"));
                        }
                        denyAcls = new String[denyAclsArrayList.size()];
                        for (j = 0; j < denyAclsArrayList.size(); ++j) {
                            denyAcls[j] = (String)denyAclsArrayList.get(j);
                            if (!Logging.connectors.isDebugEnabled()) continue;
                            Logging.connectors.debug((Object)("Meridio: Adding '" + denyAcls[j] + "' to deny ACLs"));
                        }
                    } else {
                        allowAcls = acls;
                        denyAcls = allowAcls == null ? null : new String[]{defaultAuthorityDenyToken};
                    }
                    repositoryDocument.setSecurity("document", (String[])allowAcls, denyAcls);
                    try {
                        AttachmentPart ap = this.meridio_.getLatestVersionFile((int)docId);
                        if (null == ap) {
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("Meridio: Failed to get content for document '" + new Long(docId).toString() + "'"));
                            }
                            activities.noDocument(documentIdentifier, docVersion);
                            continue;
                        }
                        try {
                            File theTempFile;
                            String fileName = ap.getDataHandler().getName();
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("Meridio: File data is supposedly in " + fileName));
                            }
                            if ((theTempFile = new File(fileName)).isFile()) {
                                long fileSize = theTempFile.length();
                                if (activities.checkLengthIndexable(fileSize)) {
                                    try (FileInputStream is = new FileInputStream(theTempFile);){
                                        repositoryDocument.setBinary((InputStream)is, fileSize);
                                        if (null == activities) continue;
                                        activities.ingestDocumentWithException(documentIdentifier, docVersion, fileURL, repositoryDocument);
                                        continue;
                                    }
                                }
                                activities.noDocument(documentIdentifier, docVersion);
                                continue;
                            }
                            if (Logging.connectors.isDebugEnabled()) {
                                Logging.connectors.debug((Object)("Meridio: Expected temporary file was not present - skipping document '" + new Long(docId).toString() + "'"));
                            }
                            activities.deleteDocument(documentIdentifier);
                        }
                        finally {
                            ap.dispose();
                        }
                    }
                    catch (SocketTimeoutException ioex) {
                        throw new ManifoldCFException("Socket timeout exception: " + ioex.getMessage(), (Throwable)ioex);
                    }
                    catch (ConnectTimeoutException ioex) {
                        throw new ManifoldCFException("Connect timeout exception: " + ioex.getMessage(), (Throwable)ioex);
                    }
                    catch (InterruptedIOException e) {
                        throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                    }
                    catch (AxisFault e) {
                        throw e;
                    }
                    catch (RemoteException e) {
                        throw e;
                    }
                    catch (SOAPException soapEx) {
                        throw new ManifoldCFException("SOAP Exception encountered while retrieving document content: " + soapEx.getMessage(), (Throwable)soapEx);
                    }
                    catch (IOException ioex) {
                        throw new ManifoldCFException("Input stream failure: " + ioex.getMessage(), (Throwable)ioex);
                    }
                }
                Logging.connectors.debug((Object)"Meridio: Exiting 'processDocuments' method");
                return;
            }
            catch (AxisFault e) {
                String exceptionName;
                long currentTime = System.currentTimeMillis();
                if (e.getFaultCode().equals(new QName("http://xml.apache.org/axis/", "HTTP"))) {
                    Element elem = e.lookupFaultDetail(new QName("http://xml.apache.org/axis/", "HttpErrorCode"));
                    if (elem != null) {
                        elem.normalize();
                        String httpErrorCode = elem.getFirstChild().getNodeValue().trim();
                        throw new ManifoldCFException("Unexpected http error code " + httpErrorCode + " accessing Meridio: " + e.getMessage(), (Throwable)e);
                    }
                    throw new ManifoldCFException("Unknown http error occurred while getting doc versions: " + e.getMessage(), (Throwable)e);
                }
                if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server.userException")) && (exceptionName = e.getFaultString()).equals("java.lang.InterruptedException")) {
                    throw new ManifoldCFException("Interrupted", 2);
                }
                if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server")) && e.getFaultString().indexOf(" 23031#") != -1) {
                    this.meridio_ = null;
                    continue;
                }
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("Meridio: Got an unknown remote exception getting doc versions - axis fault = " + e.getFaultCode().getLocalPart() + ", detail = " + e.getFaultString() + " - retrying"), (Throwable)e);
                }
                throw new ServiceInterruption("Remote procedure exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
            }
            catch (RemoteException remoteException) {
                throw new ManifoldCFException("Meridio: A remote exception occurred while getting doc versions: " + remoteException.getMessage(), (Throwable)remoteException);
            }
            break;
        }
        catch (MeridioDataSetException meridioDataSetException) {
            throw new ManifoldCFException("Meridio: A problem occurred manipulating the Web Service XML: " + meridioDataSetException.getMessage(), (Throwable)meridioDataSetException);
        }
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "MeridioConnector.DocumentServer"));
        tabsArray.add(Messages.getString(locale, "MeridioConnector.RecordsServer"));
        tabsArray.add(Messages.getString(locale, "MeridioConnector.Credentials"));
        tabsArray.add(Messages.getString(locale, "MeridioConnector.WebClient"));
        out.print("<script type=\"text/javascript\">\n<!--\n\nfunction checkConfig()\n{\n  if (editconnection.dmwsServerPort.value != \"\" && !isInteger(editconnection.dmwsServerPort.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.PleaseSupplyAValidNumber") + "\");\n    editconnection.dmwsServerPort.focus();\n    return false;\n  }\n  if (editconnection.rmwsServerPort.value != \"\" && !isInteger(editconnection.rmwsServerPort.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.PleaseSupplyAValidNumber") + "\");\n    editconnection.dmwsServerPort.focus();\n    return false;\n  }\n  if (editconnection.dmwsProxyPort.value != \"\" && !isInteger(editconnection.dmwsProxyPort.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.PleaseSupplyAValidNumber") + "\");\n    editconnection.dmwsProxyPort.focus();\n    return false;\n  }\n  if (editconnection.rmwsProxyPort.value != \"\" && !isInteger(editconnection.rmwsProxyPort.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.PleaseSupplyAValidNumber") + "\");\n    editconnection.dmwsProxyPort.focus();\n    return false;\n  }\n\n  if (editconnection.webClientServerPort.value != \"\" && !isInteger(editconnection.webClientServerPort.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.PleaseSupplyAValidNumber") + "\");\n    editconnection.webClientServerPort.focus();\n    return false;\n  }\n  if (editconnection.userName.value != \"\" && editconnection.userName.value.indexOf(\"\\\\\") <= 0)\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.AValidMeridioUserNameHasTheForm") + "\");\n    editconnection.userName.focus();\n    return false;\n  }\n  return true;\n}\n\nfunction checkConfigForSave()\n{\n  if (editconnection.dmwsServerName.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.PleaseFillInAMeridioDocumentManagementServerName") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.DocumentServer") + "\");\n    editconnection.dmwsServerName.focus();\n    return false;\n  }\n  if (editconnection.rmwsServerName.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.PleaseFillInAMeridioRecordsManagementServerName") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.RecordsServer") + "\");\n    editconnection.rmwsServerName.focus();\n    return false;\n  }\n  if (editconnection.webClientServerName.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.PleaseFillInAMeridioWebClientServerName") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.WebClient") + "\");\n    editconnection.webClientServerName.focus();\n    return false;\n  }\n  if (editconnection.dmwsServerPort.value != \"\" && !isInteger(editconnection.dmwsServerPort.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.PleaseSupplyAMeridioDocumentManagementPortNumber") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.DocumentServer") + "\");\n    editconnection.dmwsServerPort.focus();\n    return false;\n  }\n  if (editconnection.rmwsServerPort.value != \"\" && !isInteger(editconnection.rmwsServerPort.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.PleaseSupplyAMeridioDocumentManagementPortNumber") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.RecordsServer") + "\");\n    editconnection.rmwsServerPort.focus();\n    return false;\n  }\n  if (editconnection.webClientServerPort.value != \"\" && !isInteger(editconnection.webClientServerPort.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.PleaseSupplyAMeridioWebClientPortNumberOrNoneForDefault") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.WebClient") + "\");\n    editconnection.webClientServerPort.focus();\n    return false;\n  }\n  if (editconnection.userName.value == \"\" || editconnection.userName.value.indexOf(\"\\\\\") <= 0)\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.TheConnectionRequiresAValidMeridioUserNameOfTheForm") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.Credentials") + "\");\n    editconnection.userName.focus();\n    return false;\n  }\n\n  return true;\n}\n\nfunction DeleteCertificate(aliasName)\n{\n  editconnection.keystorealias.value = aliasName;\n  editconnection.configop.value = \"Delete\";\n  postForm();\n}\n\nfunction AddCertificate()\n{\n  if (editconnection.certificate.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.ChooseACertificateFile") + "\");\n    editconnection.certificate.focus();\n  }\n  else\n  {\n    editconnection.configop.value = \"Add\";\n    postForm();\n  }\n}\n\n//-->\n</script>\n");
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        String meridioKeystore;
        String webClientDocDownloadLocation;
        String webClientServerPort;
        String webClientServerName;
        String password;
        String userName;
        String rmwsProxyPort;
        String dmwsProxyPort;
        String rmwsProxyHost;
        String dmwsProxyHost;
        String rmwsLocation;
        String dmwsLocation;
        String rmwsServerPort;
        String dmwsServerPort;
        String rmwsServerName;
        String dmwsServerName;
        String rmwsServerProtocol;
        String dmwsServerProtocol = parameters.getParameter("DMWSServerProtocol");
        if (dmwsServerProtocol == null) {
            dmwsServerProtocol = "http";
        }
        if ((rmwsServerProtocol = parameters.getParameter("RMWSServerProtocol")) == null) {
            rmwsServerProtocol = "http";
        }
        if ((dmwsServerName = parameters.getParameter("DMWSServerName")) == null) {
            dmwsServerName = "";
        }
        if ((rmwsServerName = parameters.getParameter("RMWSServerName")) == null) {
            rmwsServerName = "";
        }
        if ((dmwsServerPort = parameters.getParameter("DMWSServerPort")) == null) {
            dmwsServerPort = "";
        }
        if ((rmwsServerPort = parameters.getParameter("RMWSServerPort")) == null) {
            rmwsServerPort = "";
        }
        if ((dmwsLocation = parameters.getParameter("DMWSLocation")) == null) {
            dmwsLocation = "/DMWS/MeridioDMWS.asmx";
        }
        if ((rmwsLocation = parameters.getParameter("RMWSLocation")) == null) {
            rmwsLocation = "/RMWS/MeridioRMWS.asmx";
        }
        if ((dmwsProxyHost = parameters.getParameter("DMWSProxyHost")) == null) {
            dmwsProxyHost = "";
        }
        if ((rmwsProxyHost = parameters.getParameter("RMWSProxyHost")) == null) {
            rmwsProxyHost = "";
        }
        if ((dmwsProxyPort = parameters.getParameter("DMWSProxyPort")) == null) {
            dmwsProxyPort = "";
        }
        if ((rmwsProxyPort = parameters.getParameter("RMWSProxyPort")) == null) {
            rmwsProxyPort = "";
        }
        if ((userName = parameters.getParameter("UserName")) == null) {
            userName = "";
        }
        password = (password = parameters.getObfuscatedParameter("Password")) == null ? "" : out.mapPasswordToKey(password);
        String webClientProtocol = parameters.getParameter("MeridioWebClientProtocol");
        if (webClientProtocol == null) {
            webClientProtocol = "http";
        }
        if ((webClientServerName = parameters.getParameter("MeridioWebClientServerName")) == null) {
            webClientServerName = "";
        }
        if ((webClientServerPort = parameters.getParameter("MeridioWebClientServerPort")) == null) {
            webClientServerPort = "";
        }
        if ((webClientDocDownloadLocation = parameters.getParameter("MeridioWebClientDocDownloadLocation")) == null) {
            webClientDocDownloadLocation = "/meridio/browse/downloadcontent.aspx";
        }
        IKeystoreManager localKeystore = (meridioKeystore = parameters.getParameter("MeridioKeystore")) == null ? KeystoreManagerFactory.make((String)"") : KeystoreManagerFactory.make((String)"", (String)meridioKeystore);
        out.print("<input name=\"configop\" type=\"hidden\" value=\"Continue\"/>\n");
        if (tabName.equals(Messages.getString(locale, "MeridioConnector.DocumentServer"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.DocumentWebserviceServerProtocol") + "</nobr></td>\n    <td class=\"value\">\n      <select name=\"dmwsServerProtocol\">\n        <option value=\"http\" " + (dmwsServerProtocol.equals("http") ? "selected=\"true\"" : "") + ">http</option>\n        <option value=\"https\" " + (dmwsServerProtocol.equals("https") ? "selected=\"true\"" : "") + ">https</option>\n      </select>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.DocumentWebserviceServerName") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"64\" name=\"dmwsServerName\" value=\"" + Encoder.attributeEscape((String)dmwsServerName) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.DocumentWebserviceServerPort") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"5\" name=\"dmwsServerPort\" value=\"" + dmwsServerPort + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.DocumentWebserviceLocation") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"64\" name=\"dmwsLocation\" value=\"" + Encoder.attributeEscape((String)dmwsLocation) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"separator\" colspan=\"2\"><hr/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.DocumentWebserviceServerProxyHost") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"64\" name=\"dmwsProxyHost\" value=\"" + Encoder.attributeEscape((String)dmwsProxyHost) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.DocumentWebserviceServerProxyPort") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"5\" name=\"dmwsProxyPort\" value=\"" + dmwsProxyPort + "\"/></td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"dmwsServerProtocol\" value=\"" + dmwsServerProtocol + "\"/>\n<input type=\"hidden\" name=\"dmwsServerName\" value=\"" + Encoder.attributeEscape((String)dmwsServerName) + "\"/>\n<input type=\"hidden\" name=\"dmwsServerPort\" value=\"" + dmwsServerPort + "\"/>\n<input type=\"hidden\" name=\"dmwsLocation\" value=\"" + Encoder.attributeEscape((String)dmwsLocation) + "\"/>\n<input type=\"hidden\" name=\"dmwsProxyHost\" value=\"" + Encoder.attributeEscape((String)dmwsProxyHost) + "\"/>\n<input type=\"hidden\" name=\"dmwsProxyPort\" value=\"" + dmwsProxyPort + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "MeridioConnector.RecordsServer"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.RecordWebserviceServerProtocol") + "</nobr></td>\n    <td class=\"value\">\n      <select name=\"rmwsServerProtocol\">\n        <option value=\"http\" " + (rmwsServerProtocol.equals("http") ? "selected=\"true\"" : "") + ">http</option>\n        <option value=\"https\" " + (rmwsServerProtocol.equals("https") ? "selected=\"true\"" : "") + ">https</option>\n      </select>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.RecordWebserviceServerName") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"64\" name=\"rmwsServerName\" value=\"" + Encoder.attributeEscape((String)rmwsServerName) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.RecordWebserviceServerPort") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"5\" name=\"rmwsServerPort\" value=\"" + rmwsServerPort + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.RecordWebserviceLocation") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"64\" name=\"rmwsLocation\" value=\"" + Encoder.attributeEscape((String)rmwsLocation) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"separator\" colspan=\"2\"><hr/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.RecordWebserviceServerProxyHost") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"64\" name=\"rmwsProxyHost\" value=\"" + Encoder.attributeEscape((String)rmwsProxyHost) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.RecordWebserviceServerProxyPort") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"5\" name=\"rmwsProxyPort\" value=\"" + rmwsProxyPort + "\"/></td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"rmwsServerProtocol\" value=\"" + rmwsServerProtocol + "\"/>\n<input type=\"hidden\" name=\"rmwsServerName\" value=\"" + Encoder.attributeEscape((String)rmwsServerName) + "\"/>\n<input type=\"hidden\" name=\"rmwsServerPort\" value=\"" + rmwsServerPort + "\"/>\n<input type=\"hidden\" name=\"rmwsLocation\" value=\"" + Encoder.attributeEscape((String)rmwsLocation) + "\"/>\n<input type=\"hidden\" name=\"rmwsProxyHost\" value=\"" + Encoder.attributeEscape((String)rmwsProxyHost) + "\"/>\n<input type=\"hidden\" name=\"rmwsProxyPort\" value=\"" + rmwsProxyPort + "\"/>\n");
        }
        if (meridioKeystore != null) {
            out.print("<input type=\"hidden\" name=\"keystoredata\" value=\"" + Encoder.attributeEscape((String)meridioKeystore) + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "MeridioConnector.Credentials"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.UserName") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"32\" name=\"userName\" value=\"" + Encoder.attributeEscape((String)userName) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.Password") + "</nobr></td>\n    <td class=\"value\"><input type=\"password\" size=\"32\" name=\"password\" value=\"" + Encoder.attributeEscape((String)password) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.SSLCertificateList") + "</nobr></td>\n    <td class=\"value\">\n      <input type=\"hidden\" name=\"keystorealias\" value=\"\"/>\n      <table class=\"displaytable\">\n");
            String[] contents = localKeystore.getContents();
            if (contents.length == 0) {
                out.print("        <tr><td class=\"message\" colspan=\"2\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.NoCertificatesPresent") + "</nobr></td></tr>\n");
            } else {
                for (int i = 0; i < contents.length; ++i) {
                    String alias = contents[i];
                    String description = localKeystore.getDescription(alias);
                    if (description.length() > 128) {
                        description = description.substring(0, 125) + "...";
                    }
                    out.print("        <tr>\n          <td class=\"value\"><input type=\"button\" onclick='Javascript:DeleteCertificate(\"" + Encoder.attributeJavascriptEscape((String)alias) + "\")' alt=\"" + Messages.getAttributeString(locale, "MeridioConnector.DeleteCert") + Encoder.attributeEscape((String)alias) + "\" value=\"Delete\"/></td>\n          <td>" + Encoder.bodyEscape((String)description) + "</td>\n        </tr>\n");
                }
            }
            out.print("      </table>\n      <input type=\"button\" onclick='Javascript:AddCertificate()' alt=\"" + Messages.getAttributeString(locale, "MeridioConnector.AddCert") + "\" value=\"Add\"/>&nbsp;\n      Certificate:&nbsp;<input name=\"certificate\" size=\"50\" type=\"file\"/>\n    </td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"userName\" value=\"" + Encoder.attributeEscape((String)userName) + "\"/>\n<input type=\"hidden\" name=\"password\" value=\"" + Encoder.attributeEscape((String)password) + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "MeridioConnector.WebClient"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.WebClientProtocol") + "</nobr></td>\n    <td class=\"value\">\n      <select name=\"webClientProtocol\">\n        <option value=\"http\" " + (webClientProtocol.equals("http") ? "selected=\"true\"" : "") + ">http</option>\n        <option value=\"https\" " + (webClientProtocol.equals("https") ? "selected=\"true\"" : "") + ">https</option>\n      </select>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.WebClientServerName") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"64\" name=\"webClientServerName\" value=\"" + Encoder.attributeEscape((String)webClientServerName) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.WebClientServerPort") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"5\" name=\"webClientServerPort\" value=\"" + webClientServerPort + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.WebClientServerDocLocation") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"64\" name=\"webClientDocDownloadLocation\" value=\"" + Encoder.attributeEscape((String)webClientDocDownloadLocation) + "\"/></td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"webClientProtocol\" value=\"" + webClientProtocol + "\"/>\n<input type=\"hidden\" name=\"webClientServerName\" value=\"" + Encoder.attributeEscape((String)webClientServerName) + "\"/>\n<input type=\"hidden\" name=\"webClientServerPort\" value=\"" + webClientServerPort + "\"/>\n<input type=\"hidden\" name=\"webClientDocDownloadLocation\" value=\"" + Encoder.attributeEscape((String)webClientDocDownloadLocation) + "\"/>\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        String configOp;
        String webClientDocDownloadLocation;
        String webClientServerPort;
        String webClientServerName;
        String webClientProtocol;
        String password;
        String userName;
        String rmwsProxyPort;
        String dmwsProxyPort;
        String rmwsProxyHost;
        String dmwsProxyHost;
        String rmwsLocation;
        String dmwsLocation;
        String rmwsServerPort;
        String dmwsServerPort;
        String rmwsServerName;
        String dmwsServerName;
        String rmwsServerProtocol;
        String dmwsServerProtocol = variableContext.getParameter("dmwsServerProtocol");
        if (dmwsServerProtocol != null) {
            parameters.setParameter("DMWSServerProtocol", dmwsServerProtocol);
        }
        if ((rmwsServerProtocol = variableContext.getParameter("rmwsServerProtocol")) != null) {
            parameters.setParameter("RMWSServerProtocol", rmwsServerProtocol);
        }
        if ((dmwsServerName = variableContext.getParameter("dmwsServerName")) != null) {
            parameters.setParameter("DMWSServerName", dmwsServerName);
        }
        if ((rmwsServerName = variableContext.getParameter("rmwsServerName")) != null) {
            parameters.setParameter("RMWSServerName", rmwsServerName);
        }
        if ((dmwsServerPort = variableContext.getParameter("dmwsServerPort")) != null) {
            if (dmwsServerPort.length() > 0) {
                parameters.setParameter("DMWSServerPort", dmwsServerPort);
            } else {
                parameters.setParameter("DMWSServerPort", null);
            }
        }
        if ((rmwsServerPort = variableContext.getParameter("rmwsServerPort")) != null) {
            if (rmwsServerPort.length() > 0) {
                parameters.setParameter("RMWSServerPort", rmwsServerPort);
            } else {
                parameters.setParameter("RMWSServerPort", null);
            }
        }
        if ((dmwsLocation = variableContext.getParameter("dmwsLocation")) != null) {
            parameters.setParameter("DMWSLocation", dmwsLocation);
        }
        if ((rmwsLocation = variableContext.getParameter("rmwsLocation")) != null) {
            parameters.setParameter("RMWSLocation", rmwsLocation);
        }
        if ((dmwsProxyHost = variableContext.getParameter("dmwsProxyHost")) != null) {
            parameters.setParameter("DMWSProxyHost", dmwsProxyHost);
        }
        if ((rmwsProxyHost = variableContext.getParameter("rmwsProxyHost")) != null) {
            parameters.setParameter("RMWSProxyHost", rmwsProxyHost);
        }
        if ((dmwsProxyPort = variableContext.getParameter("dmwsProxyPort")) != null && dmwsProxyPort.length() > 0) {
            parameters.setParameter("DMWSProxyPort", dmwsProxyPort);
        }
        if ((rmwsProxyPort = variableContext.getParameter("rmwsProxyPort")) != null && rmwsProxyPort.length() > 0) {
            parameters.setParameter("RMWSProxyPort", rmwsProxyPort);
        }
        if ((userName = variableContext.getParameter("userName")) != null) {
            parameters.setParameter("UserName", userName);
        }
        if ((password = variableContext.getParameter("password")) != null) {
            parameters.setObfuscatedParameter("Password", variableContext.mapKeyToPassword(password));
        }
        if ((webClientProtocol = variableContext.getParameter("webClientProtocol")) != null) {
            parameters.setParameter("MeridioWebClientProtocol", webClientProtocol);
        }
        if ((webClientServerName = variableContext.getParameter("webClientServerName")) != null) {
            parameters.setParameter("MeridioWebClientServerName", webClientServerName);
        }
        if ((webClientServerPort = variableContext.getParameter("webClientServerPort")) != null) {
            if (webClientServerPort.length() > 0) {
                parameters.setParameter("MeridioWebClientServerPort", webClientServerPort);
            } else {
                parameters.setParameter("MeridioWebClientServerPort", null);
            }
        }
        if ((webClientDocDownloadLocation = variableContext.getParameter("webClientDocDownloadLocation")) != null) {
            parameters.setParameter("MeridioWebClientDocDownloadLocation", webClientDocDownloadLocation);
        }
        if ((configOp = variableContext.getParameter("configop")) != null) {
            if (configOp.equals("Delete")) {
                String alias = variableContext.getParameter("keystorealias");
                String keystoreValue = parameters.getParameter("MeridioKeystore");
                IKeystoreManager mgr = keystoreValue != null ? KeystoreManagerFactory.make((String)"", (String)keystoreValue) : KeystoreManagerFactory.make((String)"");
                mgr.remove(alias);
                parameters.setParameter("MeridioKeystore", mgr.getString());
            } else if (configOp.equals("Add")) {
                String alias = IDFactory.make((IThreadContext)threadContext);
                byte[] certificateValue = variableContext.getBinaryBytes("certificate");
                String keystoreValue = parameters.getParameter("MeridioKeystore");
                IKeystoreManager mgr = keystoreValue != null ? KeystoreManagerFactory.make((String)"", (String)keystoreValue) : KeystoreManagerFactory.make((String)"");
                ByteArrayInputStream is = new ByteArrayInputStream(certificateValue);
                String certError = null;
                try {
                    mgr.importCertificate(alias, (InputStream)is);
                }
                catch (Throwable e) {
                    certError = e.getMessage();
                }
                finally {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException iOException) {}
                }
                if (certError != null) {
                    return "Illegal certificate: " + certError;
                }
                parameters.setParameter("MeridioKeystore", mgr.getString());
            }
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        out.print("<table class=\"displaytable\">\n  <tr>\n    <td class=\"description\" colspan=\"1\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.Parameters") + "</nobr></td>\n    <td class=\"value\" colspan=\"3\">\n");
        Iterator iter = parameters.listParameters();
        while (iter.hasNext()) {
            String param = (String)iter.next();
            String value = parameters.getParameter(param);
            if (param.length() >= "password".length() && param.substring(param.length() - "password".length()).equalsIgnoreCase("password")) {
                out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=********</nobr><br/>\n");
                continue;
            }
            if (param.length() >= "keystore".length() && param.substring(param.length() - "keystore".length()).equalsIgnoreCase("keystore")) {
                IKeystoreManager kmanager = KeystoreManagerFactory.make((String)"", (String)value);
                out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=&lt;" + Integer.toString(kmanager.getContents().length) + " certificate(s)&gt;</nobr><br/>\n");
                continue;
            }
            out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=" + Encoder.bodyEscape((String)value) + "</nobr><br/>\n");
        }
        out.print("    </td>\n  </tr>\n</table>\n");
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "MeridioConnector.SearchPaths"));
        tabsArray.add(Messages.getString(locale, "MeridioConnector.ContentTypes"));
        tabsArray.add(Messages.getString(locale, "MeridioConnector.Categories"));
        tabsArray.add(Messages.getString(locale, "MeridioConnector.DataTypes"));
        tabsArray.add(Messages.getString(locale, "MeridioConnector.Security"));
        tabsArray.add(Messages.getString(locale, "MeridioConnector.Metadata"));
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        out.print("<script type=\"text/javascript\">\n<!--\n\nfunction " + seqPrefix + "SpecDeletePath(n)\n{\n  var anchor;\n  if (n == 0)\n    anchor = \"" + seqPrefix + "SpecPathAdd\";\n  else\n    anchor = \"" + seqPrefix + "SpecPath_\"+(n-1);\n  " + seqPrefix + "SpecOp(\"" + seqPrefix + "specpathop_\"+n,\"Delete\",anchor);\n}\n\nfunction " + seqPrefix + "SpecAddPath()\n{\n  " + seqPrefix + "SpecOp(\"" + seqPrefix + "specpathop\",\"Add\",\"" + seqPrefix + "SpecPathAdd\");\n}\n\nfunction " + seqPrefix + "SpecDeleteFromPath()\n{\n  " + seqPrefix + "SpecOp(\"" + seqPrefix + "specpathop\",\"DeleteFromPath\",\"" + seqPrefix + "SpecPathAdd\");\n}\n\nfunction " + seqPrefix + "SpecAddToPath()\n{\n  if (editjob." + seqPrefix + "specpath.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.SelectAFolderOrClassFirst") + "\");\n    editjob." + seqPrefix + "specpath.focus();\n  }\n  else\n    " + seqPrefix + "SpecOp(\"" + seqPrefix + "specpathop\",\"AddToPath\",\"" + seqPrefix + "SpecPathAdd\");\n}\n\nfunction " + seqPrefix + "SpecAddAccessToken(anchorvalue)\n{\n  if (editjob." + seqPrefix + "spectoken.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.AccessTokenCannotBeNull") + "\");\n    editjob." + seqPrefix + "spectoken.focus();\n  }\n  else\n    " + seqPrefix + "SpecOp(\"" + seqPrefix + "accessop\",\"Add\",anchorvalue);\n}\n\nfunction " + seqPrefix + "SpecDeleteMapping(item, anchorvalue)\n{\n  " + seqPrefix + "SpecOp(\"" + seqPrefix + "specmappingop_\"+item,\"Delete\",anchorvalue);\n}\n\nfunction " + seqPrefix + "SpecAddMapping(anchorvalue)\n{\n  if (editjob." + seqPrefix + "specmatch.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "MeridioConnector.MatchStringCannotBeEmpty") + "\");\n    editjob." + seqPrefix + "specmatch.focus();\n    return;\n  }\n  " + seqPrefix + "SpecOp(\"" + seqPrefix + "specmappingop\",\"Add\",anchorvalue);\n}\n\nfunction " + seqPrefix + "SpecOp(n, opValue, anchorvalue)\n{\n  eval(\"editjob.\"+n+\".value = \\\"\"+opValue+\"\\\"\");\n  postFormSetAnchor(anchorvalue);\n}\n//-->\n</script>\n");
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        SpecificationNode sn;
        String pathString;
        SpecificationNode sn2;
        int k;
        int i;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        if (tabName.equals(Messages.getString(locale, "MeridioConnector.SearchPaths")) && connectionSequenceNumber == actualSequenceNumber) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
            i = 0;
            k = 0;
            while (i < ds.getChildCount()) {
                if (!(sn2 = ds.getChild(i++)).getType().equals("SearchPath")) continue;
                pathString = sn2.getAttributeValue("path");
                out.print("  <tr>\n    <td class=\"description\">\n      <input type=\"hidden\" name=\"" + seqPrefix + "specpathop_" + Integer.toString(k) + "\" value=\"Continue\"/>\n      <input type=\"hidden\" name=\"" + seqPrefix + "specpath_" + Integer.toString(k) + "\" value=\"" + Encoder.attributeEscape((String)pathString) + "\"/>\n      <a name=\"" + seqPrefix + "SpecPath_" + Integer.toString(k) + "\">\n        <input type=\"button\" value=\"Delete\" onclick='javascript:" + seqPrefix + "SpecDeletePath(" + Integer.toString(k) + ");' alt=\"" + Messages.getAttributeString(locale, "MeridioConnector.DeletePath") + Integer.toString(k) + "\"/>\n      </a>\n    </td>\n    <td class=\"value\"><nobr>" + Encoder.bodyEscape((String)pathString) + "</nobr></td>\n  </tr>\n");
                ++k;
            }
            if (k == 0) {
                out.print("  <tr><td class=\"message\" colspan=\"2\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.NoPathsSpecified") + "</nobr></td></tr>\n");
            }
            out.print("  <tr>\n    <td class=\"lightseparator\" colspan=\"2\"><input type=\"hidden\" name=\"" + seqPrefix + "specpath_total\" value=\"" + Integer.toString(k) + "\"/><hr/></td>\n  </tr>\n  <tr>\n");
            String pathSoFar = (String)this.currentContext.get((Object)(seqPrefix + "specpath"));
            String idsSoFar = (String)this.currentContext.get((Object)(seqPrefix + "specpathids"));
            Integer containerType = (Integer)this.currentContext.get((Object)(seqPrefix + "specpathtype"));
            if (pathSoFar == null) {
                pathSoFar = "/";
            }
            if (idsSoFar == null) {
                idsSoFar = "0";
            }
            if (containerType == null) {
                containerType = new Integer(1);
            }
            int currentInt = 0;
            if (idsSoFar.length() > 0) {
                String[] ids = idsSoFar.split(",");
                currentInt = Integer.parseInt(ids[ids.length - 1]);
            }
            try {
                MeridioClassContents[] childList = containerType == 1 ? this.getClassOrFolderContents(currentInt) : new MeridioClassContents[]{};
                out.print("    <td class=\"description\">\n      <input type=\"hidden\" name=\"" + seqPrefix + "specpathop\" value=\"Continue\"/>\n      <input type=\"hidden\" name=\"" + seqPrefix + "specpathbase\" value=\"" + Encoder.attributeEscape((String)pathSoFar) + "\"/>\n      <input type=\"hidden\" name=\"" + seqPrefix + "specidsbase\" value=\"" + idsSoFar + "\"/>\n      <input type=\"hidden\" name=\"" + seqPrefix + "spectype\" value=\"" + containerType.toString() + "\"/>\n      <a name=\"" + seqPrefix + "SpecPathAdd\"><input type=\"button\" value=\"Add\" onclick=\"javascript:" + seqPrefix + "SpecAddPath();\" alt=\"" + Messages.getAttributeString(locale, "MeridioConnector.AddPath") + "\"/></a>\n    </td>\n    <td class=\"value\">\n      <nobr>\n        " + Encoder.bodyEscape((String)pathSoFar) + "\n");
                if (pathSoFar.length() > 1) {
                    out.print("        <input type=\"button\" value=\"-\" onclick=\"javascript:" + seqPrefix + "SpecDeleteFromPath();\" alt=\"" + Messages.getAttributeString(locale, "MeridioConnector.DeleteFromPath") + "\"/>\n");
                }
                if (childList.length > 0) {
                    out.print("        <input type=\"button\" value=\"+\" onclick=\"javascript:" + seqPrefix + "SpecAddToPath();\" alt=\"" + Messages.getAttributeString(locale, "MeridioConnector.AddToPath") + "\"/>\n        <select name=\"" + seqPrefix + "specpath\" size=\"10\">\n          <option value=\"\" selected=\"\">" + Messages.getBodyString(locale, "MeridioConnector.PickAFolder") + "</option>\n");
                    for (int j = 0; j < childList.length; ++j) {
                        out.print("          <option value=\"" + Integer.toString(childList[j].classOrFolderId) + ";" + Integer.toString(childList[j].containerType) + ";" + Encoder.attributeEscape((String)childList[j].classOrFolderName) + "\">\n            " + Encoder.bodyEscape((String)childList[j].classOrFolderName) + "\n          </option>\n");
                    }
                    out.print("        </select>\n");
                }
                out.print("      </nobr>\n    </td>\n");
            }
            catch (ServiceInterruption e) {
                e.printStackTrace();
                out.print("    <td class=\"message\" colspan=\"2\">" + Messages.getBodyString(locale, "MeridioConnector.ServiceInterruption") + Encoder.bodyEscape((String)e.getMessage()) + "</td>\n");
            }
            catch (ManifoldCFException e) {
                e.printStackTrace();
                out.print("    <td class=\"message\" colspan=\"2\">" + Encoder.bodyEscape((String)e.getMessage()) + "</td>\n");
            }
            out.print("  </tr>\n</table>\n");
        } else {
            i = 0;
            k = 0;
            while (i < ds.getChildCount()) {
                if (!(sn2 = ds.getChild(i++)).getType().equals("SearchPath")) continue;
                pathString = sn2.getAttributeValue("path");
                out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specpath_" + Integer.toString(k) + "\" value=\"" + Encoder.attributeEscape((String)pathString) + "\"/>\n");
                ++k;
            }
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specpath_total\" value=\"" + Integer.toString(k) + "\"/>\n");
        }
        HashSet<String> mimeTypeMap = new HashSet<String>();
        for (i = 0; i < ds.getChildCount(); ++i) {
            String[] sn3 = ds.getChild(i);
            if (!sn3.getType().equals("MIMEType")) continue;
            String type = sn3.getAttributeValue("type");
            mimeTypeMap.add(type);
        }
        if (mimeTypeMap.size() == 0) {
            for (String allowedMimeType : allowedMimeTypes) {
                mimeTypeMap.add(allowedMimeType);
            }
        }
        if (tabName.equals(Messages.getString(locale, "MeridioConnector.ContentTypes")) && connectionSequenceNumber == actualSequenceNumber) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.MimeTypes") + "</nobr></td>\n    <td class=\"value\">\n");
            i = 0;
            while (i < allowedMimeTypes.length) {
                String mimeType = allowedMimeTypes[i++];
                out.print("      <nobr>\n        <input type=\"checkbox\" name=\"" + seqPrefix + "specmimetypes\" value=\"" + Encoder.attributeEscape((String)mimeType) + "\" " + (mimeTypeMap.contains(mimeType) ? "checked=\"true\"" : "") + ">\n          " + Encoder.bodyEscape((String)mimeType) + "\n        </input>\n      </nobr>\n      <br/>\n");
            }
            out.print("    </td>\n  </tr>\n</table>\n");
        } else {
            for (String mimeType : mimeTypeMap) {
                out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specmimetypes\" value=\"" + Encoder.attributeEscape((String)mimeType) + "\"/>\n");
            }
        }
        HashSet<String> categoriesMap = new HashSet<String>();
        for (i = 0; i < ds.getChildCount(); ++i) {
            SpecificationNode sn4 = ds.getChild(i);
            if (!sn4.getType().equals("SearchCategory")) continue;
            String category = sn4.getAttributeValue("category");
            categoriesMap.add(category);
        }
        if (tabName.equals(Messages.getString(locale, "MeridioConnector.Categories")) && connectionSequenceNumber == actualSequenceNumber) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n");
            try {
                String[] categoryList = this.getMeridioCategories();
                out.print("    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.Categories") + "</nobr></td>\n    <td class=\"value\">\n");
                k = 0;
                while (k < categoryList.length) {
                    String category = categoryList[k++];
                    out.print("      <nobr>\n        <input type=\"checkbox\" name=\"" + seqPrefix + "speccategories\" value=\"" + Encoder.attributeEscape((String)category) + "\" " + (categoriesMap.contains(category) ? "checked=\"true\"" : "") + ">\n        " + Encoder.bodyEscape((String)category) + "\n        </input>\n      </nobr>\n      <br/>\n");
                }
                out.print("    </td>\n");
            }
            catch (ServiceInterruption e) {
                e.printStackTrace();
                out.print("    <td class=\"message\" colspan=\"2\">" + Messages.getBodyString(locale, "MeridioConnector.ServiceInterruption") + Encoder.bodyEscape((String)e.getMessage()) + "</td>\n");
            }
            catch (ManifoldCFException e) {
                e.printStackTrace();
                out.print("    <td class=\"message\" colspan=\"2\">" + Encoder.bodyEscape((String)e.getMessage()) + "</td>\n");
            }
            out.print("  </tr>\n</table>\n");
        } else {
            for (String category : categoriesMap) {
                out.print("<input type=\"hidden\" name=\"" + seqPrefix + "speccategories\" value=\"" + Encoder.attributeEscape((String)category) + "\"/>\n");
            }
        }
        String mode = "DOCUMENTS_AND_RECORDS";
        i = 0;
        while (i < ds.getChildCount()) {
            SpecificationNode sn5;
            if (!(sn5 = ds.getChild(i++)).getType().equals("SearchOn")) continue;
            mode = sn5.getAttributeValue("value");
        }
        if (tabName.equals(Messages.getString(locale, "MeridioConnector.DataTypes")) && connectionSequenceNumber == actualSequenceNumber) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.DataTypesToIngest") + "</nobr></td>\n    <td class=\"value\">\n      <nobr><input type=\"radio\" name=\"" + seqPrefix + "specsearchon\" value=\"DOCUMENTS\" " + (mode.equals("DOCUMENTS") ? "checked=\"true\"" : "") + "/>" + Messages.getBodyString(locale, "MeridioConnector.Documents") + "</nobr><br/>\n      <nobr><input type=\"radio\" name=\"" + seqPrefix + "specsearchon\" value=\"RECORDS\" " + (mode.equals("RECORDS") ? "checked=\"true\"" : "") + "/>" + Messages.getBodyString(locale, "MeridioConnector.Records") + "</nobr><br/>\n      <nobr><input type=\"radio\" name=\"" + seqPrefix + "specsearchon\" value=\"DOCUMENTS_AND_RECORDS\" " + (mode.equals("DOCUMENTS_AND_RECORDS") ? "checked=\"true\"" : "") + "/>" + Messages.getBodyString(locale, "MeridioConnector.DocumentsAndRecords") + "</nobr><br/>\n    </td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specsearchon\" value=\"" + mode + "\"/>\n");
        }
        i = 0;
        boolean securityOn = true;
        while (i < ds.getChildCount()) {
            if (!(sn = ds.getChild(i++)).getType().equals("security")) continue;
            String securityValue = sn.getAttributeValue("value");
            if (securityValue.equals("off")) {
                securityOn = false;
                continue;
            }
            if (!securityValue.equals("on")) continue;
            securityOn = true;
        }
        if (tabName.equals(Messages.getString(locale, "MeridioConnector.Security")) && connectionSequenceNumber == actualSequenceNumber) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.Security2") + "</nobr></td>\n    <td class=\"value\">\n      <input type=\"radio\" name=\"" + seqPrefix + "specsecurity\" value=\"on\" " + (securityOn ? "checked=\"true\"" : "") + " />" + Messages.getBodyString(locale, "MeridioConnector.Enabled") + "&nbsp;\n      <input type=\"radio\" name=\"" + seqPrefix + "specsecurity\" value=\"off\" " + (!securityOn ? "checked=\"true\"" : "") + " />" + Messages.getBodyString(locale, "MeridioConnector.Disabled") + "\n    </td>\n  </tr>\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
            i = 0;
            k = 0;
            while (i < ds.getChildCount()) {
                if (!(sn = ds.getChild(i++)).getType().equals("access")) continue;
                String accessDescription = "_" + Integer.toString(k);
                String accessOpName = seqPrefix + "accessop" + accessDescription;
                String token = sn.getAttributeValue("token");
                out.print("  <tr>\n    <td class=\"description\">\n      <input type=\"hidden\" name=\"" + accessOpName + "\" value=\"\"/>\n      <input type=\"hidden\" name=\"" + seqPrefix + "spectoken" + accessDescription + "\" value=\"" + Encoder.attributeEscape((String)token) + "\"/>\n      <a name=\"" + seqPrefix + "token_" + Integer.toString(k) + "\">\n        <input type=\"button\" value=\"Delete\" onClick='Javascript:" + seqPrefix + "SpecOp(\"" + accessOpName + "\",\"Delete\",\"" + seqPrefix + "token_" + Integer.toString(k) + "\")' alt=\"" + Messages.getAttributeString(locale, "MeridioConnector.DeleteToken") + Integer.toString(k) + "\"/>\n      </a>&nbsp;\n    </td>\n    <td class=\"value\">\n      " + Encoder.bodyEscape((String)token) + "\n    </td>\n  </tr>\n");
                ++k;
            }
            if (k == 0) {
                out.print("  <tr>\n    <td class=\"message\" colspan=\"2\">" + Messages.getBodyString(locale, "MeridioConnector.NoAccessTokensPresent") + "</td>\n  </tr>\n");
            }
            out.print("  <tr><td class=\"lightseparator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\">\n      <input type=\"hidden\" name=\"" + seqPrefix + "tokencount\" value=\"" + Integer.toString(k) + "\"/>\n      <input type=\"hidden\" name=\"" + seqPrefix + "accessop\" value=\"\"/>\n      <a name=\"" + seqPrefix + "token_" + Integer.toString(k) + "\">\n        <input type=\"button\" value=\"Add\" onClick='Javascript:" + seqPrefix + "SpecAddAccessToken(\"" + seqPrefix + "token_" + Integer.toString(k + 1) + "\")' alt=\"" + Messages.getAttributeString(locale, "MeridioConnector.AddAccessToken") + "\"/>\n      </a>&nbsp;\n    </td>\n    <td class=\"value\">\n      <input type=\"text\" size=\"30\" name=\"" + seqPrefix + "spectoken\" value=\"\"/>\n    </td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specsecurity\" value=\"" + (securityOn ? "on" : "off") + "\"/>\n");
            i = 0;
            k = 0;
            while (i < ds.getChildCount()) {
                if (!(sn = ds.getChild(i++)).getType().equals("access")) continue;
                String accessDescription = "_" + Integer.toString(k);
                String token = sn.getAttributeValue("token");
                out.print("<input type=\"hidden\" name=\"" + seqPrefix + "spectoken" + accessDescription + "\" value=\"" + Encoder.attributeEscape((String)token) + "\"/>\n");
                ++k;
            }
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "tokencount\" value=\"" + Integer.toString(k) + "\"/>\n");
        }
        i = 0;
        String pathNameAttribute = "";
        while (i < ds.getChildCount()) {
            SpecificationNode sn6;
            if (!(sn6 = ds.getChild(i++)).getType().equals("pathnameattribute")) continue;
            pathNameAttribute = sn6.getAttributeValue("value");
        }
        i = 0;
        MatchMap matchMap = new MatchMap();
        while (i < ds.getChildCount()) {
            SpecificationNode sn7;
            if (!(sn7 = ds.getChild(i++)).getType().equals("pathmap")) continue;
            String pathMatch = sn7.getAttributeValue("match");
            String pathReplace = sn7.getAttributeValue("replace");
            matchMap.appendMatchPair(pathMatch, pathReplace);
        }
        boolean allMetadata = false;
        HashMap<String, String> metadataSelected = new HashMap<String, String>();
        i = 0;
        while (i < ds.getChildCount()) {
            SpecificationNode sn8;
            if ((sn8 = ds.getChild(i++)).getType().equals("ReturnedMetadata")) {
                String category = sn8.getAttributeValue("category");
                String property = sn8.getAttributeValue("property");
                String descriptor = category == null || category.length() == 0 ? property : category + "." + property;
                metadataSelected.put(descriptor, descriptor);
                continue;
            }
            if (!sn8.getType().equals("AllMetadata")) continue;
            String value = sn8.getAttributeValue("value");
            if (value != null && value.equals("true")) {
                allMetadata = true;
                continue;
            }
            allMetadata = false;
        }
        if (tabName.equals(Messages.getString(locale, "MeridioConnector.Metadata")) && connectionSequenceNumber == actualSequenceNumber) {
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specmappingcount\" value=\"" + Integer.toString(matchMap.getMatchCount()) + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "specmappingop\" value=\"\"/>\n\n<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"4\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\" colspan=\"1\">\n      <nobr>" + Messages.getBodyString(locale, "MeridioConnector.IncludeAllMetadata") + "</nobr>\n    </td>\n    <td class=\"value\" colspan=\"3\">\n      <nobr>\n        <input type=\"radio\" name=\"" + seqPrefix + "allmetadata\" value=\"false\" " + (!allMetadata ? "checked=\"true\"" : "") + ">" + Messages.getBodyString(locale, "MeridioConnector.IncludeSpecified") + "</input>\n        <input type=\"radio\" name=\"" + seqPrefix + "allmetadata\" value=\"true\" " + (allMetadata ? "checked=\"true\"" : "") + ">" + Messages.getBodyString(locale, "MeridioConnector.IncludeAll") + "</input>\n      </nobr>\n    </td>\n  </tr>\n  <tr><td class=\"separator\" colspan=\"4\"><hr/></td></tr>\n  <tr>\n");
            try {
                String[] propertyList = this.getMeridioDocumentProperties();
                out.print("    <td class=\"description\" colspan=\"1\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.Metadata") + "</nobr></td>\n    <td class=\"value\" colspan=\"3\">\n      <input type=\"hidden\" name=\"" + seqPrefix + "specproperties_edit\" value=\"true\"/>\n");
                k = 0;
                while (k < propertyList.length) {
                    String descriptor = propertyList[k++];
                    out.print("      <nobr>\n        <input type=\"checkbox\" name=\"" + seqPrefix + "specproperties\" value=\"" + Encoder.attributeEscape((String)descriptor) + "\" " + (metadataSelected.get(descriptor) != null ? "checked=\"true\"" : "") + ">\n          " + Encoder.bodyEscape((String)descriptor) + "\n        </input>\n      </nobr>\n      <br/>\n");
                }
                out.print("    </td>\n");
            }
            catch (ServiceInterruption e) {
                e.printStackTrace();
                out.print("    <td class=\"message\" colspan=\"4\">" + Messages.getBodyString(locale, "MeridioConnector.ServiceInterruption") + Encoder.bodyEscape((String)e.getMessage()) + "</td>\n");
            }
            catch (ManifoldCFException e) {
                e.printStackTrace();
                out.print("    <td class=\"message\" colspan=\"4\">" + Encoder.bodyEscape((String)e.getMessage()) + "</td>\n");
            }
            out.print("  </tr>\n  <tr><td class=\"separator\" colspan=\"4\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.PathAttributeMetadataName") + "</nobr></td>\n    <td class=\"value\" colspan=\"3\"><nobr>\n      <input type=\"text\" size=\"16\" name=\"" + seqPrefix + "specpathnameattribute\" value=\"" + Encoder.attributeEscape((String)pathNameAttribute) + "\"/></nobr>\n    </td>\n  </tr>\n  <tr><td class=\"separator\" colspan=\"4\"><hr/></td></tr>\n");
            for (i = 0; i < matchMap.getMatchCount(); ++i) {
                String matchString = matchMap.getMatchString(i);
                String replaceString = matchMap.getReplaceString(i);
                out.print("  <tr>\n    <td class=\"description\"><input type=\"hidden\" name=\"" + seqPrefix + "specmappingop_" + Integer.toString(i) + "\" value=\"\"/>\n      <a name=\"" + seqPrefix + "mapping_" + Integer.toString(i) + "\">\n        <input type=\"button\" onClick='Javascript:" + seqPrefix + "SpecDeleteMapping(Integer.toString(i),\"" + seqPrefix + "mapping_" + Integer.toString(i) + "\")' alt=\"" + Messages.getAttributeString(locale, "MeridioConnector.DeleteMapping") + Integer.toString(i) + "\" value=\"Delete\"/>\n      </a>\n    </td>\n    <td class=\"value\"><input type=\"hidden\" name=\"" + seqPrefix + "specmatch_" + Integer.toString(i) + "\" value=\"" + Encoder.attributeEscape((String)matchString) + "\"/>" + Encoder.bodyEscape((String)matchString) + "</td>\n    <td class=\"value\">==></td>\n    <td class=\"value\"><input type=\"hidden\" name=\"" + seqPrefix + "specreplace_" + Integer.toString(i) + "\" value=\"" + Encoder.attributeEscape((String)replaceString) + "\"/>" + Encoder.bodyEscape((String)replaceString) + "</td>\n  </tr>\n");
            }
            if (i == 0) {
                out.print("  <tr><td colspan=\"4\" class=\"message\">" + Messages.getBodyString(locale, "MeridioConnector.NoMappingsSpecified") + "</td></tr>\n");
            }
            out.print("  <tr><td class=\"lightseparator\" colspan=\"4\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\">\n      <a name=\"" + seqPrefix + "mapping_" + Integer.toString(i) + "\">\n        <input type=\"button\" onClick='Javascript:" + seqPrefix + "SpecAddMapping(\"" + seqPrefix + "mapping_" + Integer.toString(i + 1) + "\")' alt=\"" + Messages.getAttributeString(locale, "MeridioConnector.AddToMappings") + "\" value=\"Add\"/>\n      </a>\n    </td>\n    <td class=\"value\">" + Messages.getBodyString(locale, "MeridioConnector.MatchRegexp") + "&nbsp;<input type=\"text\" name=\"" + seqPrefix + "specmatch\" size=\"32\" value=\"\"/></td>\n    <td class=\"value\">==></td>\n    <td class=\"value\">" + Messages.getBodyString(locale, "MeridioConnector.ReplaceString") + "&nbsp;<input type=\"text\" name=\"" + seqPrefix + "specreplace\" size=\"32\" value=\"\"/></td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specproperties_edit\" value=\"true\"/>\n");
            for (String descriptor : metadataSelected.keySet()) {
                out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specproperties\" value=\"" + Encoder.attributeEscape((String)descriptor) + "\"/>\n");
            }
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "allmetadata\" value=\"" + (allMetadata ? "true" : "false") + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "specpathnameattribute\" value=\"" + Encoder.attributeEscape((String)pathNameAttribute) + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "specmappingcount\" value=\"" + Integer.toString(matchMap.getMatchCount()) + "\"/>\n");
            for (i = 0; i < matchMap.getMatchCount(); ++i) {
                String matchString = matchMap.getMatchString(i);
                String replaceString = matchMap.getReplaceString(i);
                out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specmatch_" + Integer.toString(i) + "\" value=\"" + Encoder.attributeEscape((String)matchString) + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "specreplace_" + Integer.toString(i) + "\" value=\"" + Encoder.attributeEscape((String)replaceString) + "\"/>\n");
            }
        }
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException {
        SpecificationNode node;
        SpecificationNode newNode;
        String category;
        SpecificationNode sn;
        String[] y;
        int i;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String x = variableContext.getParameter(seqPrefix + "specpath_total");
        if (x != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn2 = ds.getChild(i);
                if (sn2.getType().equals("SearchPath")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            int count = Integer.parseInt(x);
            for (i = 0; i < count; ++i) {
                String path = variableContext.getParameter(seqPrefix + "specpath_" + Integer.toString(i));
                String pathOp = variableContext.getParameter(seqPrefix + "specpathop_" + Integer.toString(i));
                if (pathOp != null && pathOp.equals("Delete")) continue;
                SpecificationNode sn3 = new SpecificationNode("SearchPath");
                sn3.setAttribute("path", path);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)sn3);
            }
            x = variableContext.getParameter(seqPrefix + "specpathop");
            if (x != null) {
                String pathSoFar = variableContext.getParameter(seqPrefix + "specpathbase");
                String idsSoFar = variableContext.getParameter(seqPrefix + "specidsbase");
                Integer containerType = new Integer(variableContext.getParameter(seqPrefix + "spectype"));
                if (x.equals("Add")) {
                    SpecificationNode sn4 = new SpecificationNode("SearchPath");
                    sn4.setAttribute("path", pathSoFar);
                    ds.addChild(ds.getChildCount(), (ConfigurationNode)sn4);
                    pathSoFar = null;
                    idsSoFar = null;
                    containerType = null;
                } else if (x.equals("AddToPath")) {
                    String pathField = variableContext.getParameter(seqPrefix + "specpath");
                    int index = pathField.indexOf(";");
                    int secondIndex = pathField.indexOf(";", index + 1);
                    pathSoFar = pathSoFar + pathField.substring(secondIndex + 1) + "/";
                    idsSoFar = idsSoFar + "," + pathField.substring(0, index);
                    containerType = new Integer(pathField.substring(index + 1, secondIndex));
                } else if (x.equals("DeleteFromPath")) {
                    pathSoFar = pathSoFar.substring(0, pathSoFar.lastIndexOf("/"));
                    pathSoFar = pathSoFar.substring(0, pathSoFar.lastIndexOf("/") + 1);
                    idsSoFar = idsSoFar.substring(0, idsSoFar.lastIndexOf(",") - 1);
                    containerType = new Integer(1);
                }
                this.currentContext.save((Object)(seqPrefix + "specpath"), (Object)pathSoFar);
                this.currentContext.save((Object)(seqPrefix + "specpathids"), (Object)idsSoFar);
                this.currentContext.save((Object)(seqPrefix + "specpathtype"), (Object)containerType);
            }
        }
        if ((x = variableContext.getParameter(seqPrefix + "specsearchon")) != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn5 = ds.getChild(i);
                if (sn5.getType().equals("SearchOn")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            SpecificationNode newNode2 = new SpecificationNode("SearchOn");
            newNode2.setAttribute("value", x);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)newNode2);
        }
        if ((y = variableContext.getParameterValues(seqPrefix + "speccategories")) != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                sn = ds.getChild(i);
                if (sn.getType().equals("SearchCategory")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            i = 0;
            while (i < y.length) {
                category = y[i++];
                newNode = new SpecificationNode("SearchCategory");
                newNode.setAttribute("category", category);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)newNode);
            }
        }
        if ((x = variableContext.getParameter(seqPrefix + "specproperties_edit")) != null && x.length() > 0) {
            i = 0;
            while (i < ds.getChildCount()) {
                sn = ds.getChild(i);
                if (sn.getType().equals("ReturnedMetadata")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            y = variableContext.getParameterValues(seqPrefix + "specproperties");
            if (y != null) {
                i = 0;
                while (i < y.length) {
                    String property;
                    String category2;
                    String descriptor = y[i++];
                    newNode = new SpecificationNode("ReturnedMetadata");
                    int index = descriptor.indexOf(".");
                    if (index == -1) {
                        category2 = null;
                        property = descriptor;
                    } else {
                        category2 = descriptor.substring(0, index);
                        property = descriptor.substring(index + 1);
                    }
                    if (category2 != null) {
                        newNode.setAttribute("category", category2);
                    }
                    newNode.setAttribute("property", property);
                    ds.addChild(ds.getChildCount(), (ConfigurationNode)newNode);
                }
            }
        }
        if ((y = variableContext.getParameterValues(seqPrefix + "specmimetypes")) != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                sn = ds.getChild(i);
                if (sn.getType().equals("MIMEType")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            i = 0;
            while (i < y.length) {
                category = y[i++];
                newNode = new SpecificationNode("MIMEType");
                newNode.setAttribute("type", category);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)newNode);
            }
        }
        if ((x = variableContext.getParameter(seqPrefix + "specsecurity")) != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                sn = ds.getChild(i);
                if (sn.getType().equals("security")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            SpecificationNode node2 = new SpecificationNode("security");
            node2.setAttribute("value", x);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)node2);
        }
        if ((x = variableContext.getParameter(seqPrefix + "tokencount")) != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                sn = ds.getChild(i);
                if (sn.getType().equals("access")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            int accessCount = Integer.parseInt(x);
            i = 0;
            while (i < accessCount) {
                String accessDescription = "_" + Integer.toString(i);
                String accessOpName = seqPrefix + "accessop" + accessDescription;
                String xc = variableContext.getParameter(accessOpName);
                if (xc != null && xc.equals("Delete")) {
                    ++i;
                    continue;
                }
                String accessSpec = variableContext.getParameter(seqPrefix + "spectoken" + accessDescription);
                SpecificationNode node3 = new SpecificationNode("access");
                node3.setAttribute("token", accessSpec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node3);
                ++i;
            }
            String op = variableContext.getParameter(seqPrefix + "accessop");
            if (op != null && op.equals("Add")) {
                String accessspec = variableContext.getParameter(seqPrefix + "spectoken");
                node = new SpecificationNode("access");
                node.setAttribute("token", accessspec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
            }
        }
        if ((x = variableContext.getParameter(seqPrefix + "specpathnameattribute")) != null && x.length() > 0) {
            i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn6 = ds.getChild(i);
                if (sn6.getType().equals("pathnameattribute")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            SpecificationNode node4 = new SpecificationNode("pathnameattribute");
            node4.setAttribute("value", x);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)node4);
        }
        if ((x = variableContext.getParameter(seqPrefix + "specmappingcount")) != null && x.length() > 0) {
            i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn7 = ds.getChild(i);
                if (sn7.getType().equals("pathmap")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            int mappingCount = Integer.parseInt(x);
            i = 0;
            while (i < mappingCount) {
                String pathDescription = "_" + Integer.toString(i);
                String pathOpName = seqPrefix + "specmappingop" + pathDescription;
                x = variableContext.getParameter(pathOpName);
                if (x != null && x.equals("Delete")) {
                    ++i;
                    continue;
                }
                String match = variableContext.getParameter(seqPrefix + "specmatch" + pathDescription);
                String replace = variableContext.getParameter(seqPrefix + "specreplace" + pathDescription);
                SpecificationNode node5 = new SpecificationNode("pathmap");
                node5.setAttribute("match", match);
                node5.setAttribute("replace", replace);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node5);
                ++i;
            }
            x = variableContext.getParameter(seqPrefix + "specmappingop");
            if (x != null && x.equals("Add")) {
                String match = variableContext.getParameter(seqPrefix + "specmatch");
                String replace = variableContext.getParameter(seqPrefix + "specreplace");
                node = new SpecificationNode("pathmap");
                node.setAttribute("match", match);
                node.setAttribute("replace", replace);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
            }
        }
        if ((x = variableContext.getParameter(seqPrefix + "allmetadata")) != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn8 = ds.getChild(i);
                if (sn8.getType().equals("AllMetadata")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            SpecificationNode node6 = new SpecificationNode("AllMetadata");
            node6.setAttribute("value", x);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)node6);
        }
        return null;
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        SpecificationNode sn;
        SpecificationNode sn2;
        SpecificationNode sn3;
        out.print("<table class=\"displaytable\">\n  <tr>\n");
        int i = 0;
        boolean seenAny = false;
        while (i < ds.getChildCount()) {
            SpecificationNode sn4;
            if (!(sn4 = ds.getChild(i++)).getType().equals("SearchPath")) continue;
            if (!seenAny) {
                out.print("    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.Paths") + "</nobr></td>\n    <td class=\"value\">\n");
                seenAny = true;
            }
            out.print("      " + Encoder.bodyEscape((String)sn4.getAttributeValue("path")) + "<br/>\n");
        }
        if (seenAny) {
            out.print("    </td>\n  </tr>\n");
        } else {
            out.print("  <tr><td class=\"message\" colspan=\"2\">" + Messages.getBodyString(locale, "MeridioConnector.NoPathsSpecified") + "</td></tr>\n");
        }
        out.print("  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.DataType") + "</nobr>\n    </td>\n    <td class=\"value\">\n      <nobr>\n");
        i = 0;
        String mode = "DOCUMENTS_AND_RECORDS";
        while (i < ds.getChildCount()) {
            SpecificationNode sn5;
            if (!(sn5 = ds.getChild(i++)).getType().equals("SearchOn")) continue;
            mode = sn5.getAttributeValue("value");
        }
        String displayMode = mode.equals("DOCUMENTS") ? "Documents only" : (mode.equals("RECORDS") ? "Records only" : "Documents and Records");
        out.print("        " + displayMode + "\n      </nobr>\n    </td>\n  </tr>\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.Categories") + "</nobr>\n    </td>\n    <td class=\"value\">\n");
        int count = 0;
        i = 0;
        while (i < ds.getChildCount()) {
            SpecificationNode sn6;
            if (!(sn6 = ds.getChild(i++)).getType().equals("SearchCategory")) continue;
            ++count;
        }
        Object[] sortArray = new String[count];
        count = 0;
        i = 0;
        while (i < ds.getChildCount()) {
            if (!(sn3 = ds.getChild(i++)).getType().equals("SearchCategory")) continue;
            sortArray[count++] = sn3.getAttributeValue("category");
        }
        Arrays.sort(sortArray);
        i = 0;
        while (i < sortArray.length) {
            Object category = sortArray[i++];
            out.print("      <nobr>" + Encoder.bodyEscape((String)category) + "</nobr><br/>\n");
        }
        out.print("    </td>\n  </tr>\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.MimeTypes") + "</nobr>\n    </td>\n    <td class=\"value\">\n");
        count = 0;
        i = 0;
        while (i < ds.getChildCount()) {
            if (!(sn3 = ds.getChild(i++)).getType().equals("MIMEType")) continue;
            ++count;
        }
        sortArray = new String[count];
        count = 0;
        i = 0;
        while (i < ds.getChildCount()) {
            if (!(sn3 = ds.getChild(i++)).getType().equals("MIMEType")) continue;
            sortArray[count++] = sn3.getAttributeValue("type");
        }
        Arrays.sort(sortArray);
        i = 0;
        while (i < sortArray.length) {
            Object mimeType = sortArray[i++];
            out.print("      <nobr>" + Encoder.bodyEscape((String)mimeType) + "</nobr><br/>\n");
        }
        out.print("    </td>\n  </tr>\n\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n\n");
        i = 0;
        boolean securityOn = true;
        while (i < ds.getChildCount()) {
            if (!(sn2 = ds.getChild(i++)).getType().equals("security")) continue;
            String securityValue = sn2.getAttributeValue("value");
            if (securityValue.equals("off")) {
                securityOn = false;
                continue;
            }
            if (!securityValue.equals("on")) continue;
            securityOn = true;
        }
        out.print("  <tr>\n    <td class=\"description\">" + Messages.getBodyString(locale, "MeridioConnector.Security2") + "</td>\n    <td class=\"value\">" + (securityOn ? Messages.getBodyString(locale, "MeridioConnector.Enabled") : Messages.getBodyString(locale, "MeridioConnector.Disabled")) + "</td>\n  </tr>\n\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
        seenAny = false;
        i = 0;
        while (i < ds.getChildCount()) {
            if (!(sn2 = ds.getChild(i++)).getType().equals("access")) continue;
            if (!seenAny) {
                out.print("  <tr>\n    <td class=\"description\">" + Messages.getBodyString(locale, "MeridioConnector.AccessTokens") + "</td>\n    <td class=\"value\">\n");
                seenAny = true;
            }
            String token = sn2.getAttributeValue("token");
            out.print("      " + Encoder.bodyEscape((String)token) + "<br/>\n");
        }
        if (seenAny) {
            out.print("    </td>\n  </tr>\n");
        } else {
            out.print("  <tr><td class=\"message\" colspan=\"2\">" + Messages.getBodyString(locale, "MeridioConnector.NoAccessTokensSpecified") + "</td></tr>\n");
        }
        out.print("  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n");
        count = 0;
        i = 0;
        boolean allMetadata = false;
        while (i < ds.getChildCount()) {
            String value;
            if ((sn = ds.getChild(i++)).getType().equals("ReturnedMetadata")) {
                ++count;
                continue;
            }
            if (!sn.getType().equals("AllMetadata") || (value = sn.getAttributeValue("value")) == null || !value.equals("true")) continue;
            allMetadata = true;
        }
        if (allMetadata) {
            out.print("    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.MetadataPropertiesToIngest") + "</nobr>\n    </td>\n    <td class=\"value\"><nobr><b>" + Messages.getBodyString(locale, "MeridioConnector.AllMetadata") + "</b></nobr></td>\n");
        } else if (count > 0) {
            out.print("    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.MetadataPropertiesToIngest") + "</nobr>\n    </td>\n    <td class=\"value\">\n");
            sortArray = new String[count];
            i = 0;
            count = 0;
            while (i < ds.getChildCount()) {
                if (!(sn = ds.getChild(i++)).getType().equals("ReturnedMetadata")) continue;
                String category = sn.getAttributeValue("category");
                String property = sn.getAttributeValue("property");
                String descriptor = category == null || category.length() == 0 ? property : category + "." + property;
                sortArray[count++] = descriptor;
            }
            Arrays.sort(sortArray);
            i = 0;
            while (i < sortArray.length) {
                Object descriptor = sortArray[i++];
                out.print("      <nobr>" + Encoder.bodyEscape((String)descriptor) + "</nobr><br/>\n");
            }
            out.print("    </td>\n");
        } else {
            out.print("    <td class=\"message\" colspan=\"2\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.NoMetadataPropertiesToIngest") + "</nobr></td> \n");
        }
        out.print("  </tr>\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
        String pathNameAttribute = "";
        i = 0;
        while (i < ds.getChildCount()) {
            SpecificationNode sn7;
            if (!(sn7 = ds.getChild(i++)).getType().equals("pathnameattribute")) continue;
            pathNameAttribute = sn7.getAttributeValue("value");
        }
        out.print("  <tr>\n");
        if (pathNameAttribute.length() > 0) {
            out.print("    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.PathNameMetadataAttribute") + "</nobr></td>\n    <td class=\"value\"><nobr>" + Encoder.bodyEscape((String)pathNameAttribute) + "</nobr></td>\n");
        } else {
            out.print("    <td class=\"message\" colspan=\"2\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.NoPathNameMetadataAttributeSpecified") + "</nobr></td>\n");
        }
        out.print("  </tr>\n\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n\n  <tr>\n");
        i = 0;
        MatchMap matchMap = new MatchMap();
        while (i < ds.getChildCount()) {
            SpecificationNode sn8;
            if (!(sn8 = ds.getChild(i++)).getType().equals("pathmap")) continue;
            String pathMatch = sn8.getAttributeValue("match");
            String pathReplace = sn8.getAttributeValue("replace");
            matchMap.appendMatchPair(pathMatch, pathReplace);
        }
        if (matchMap.getMatchCount() > 0) {
            out.print("    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.PathValueMapping") + "</nobr></td>\n    <td class=\"value\">\n      <table class=\"displaytable\">\n");
            for (i = 0; i < matchMap.getMatchCount(); ++i) {
                String matchString = matchMap.getMatchString(i);
                String replaceString = matchMap.getReplaceString(i);
                out.print("        <tr>\n          <td class=\"value\">" + Encoder.bodyEscape((String)matchString) + "</td>\n          <td class=\"value\">--></td><td class=\"value\">" + Encoder.bodyEscape((String)replaceString) + "</td>\n        </tr>\n");
            }
            out.print("      </table>\n    </td>\n");
        } else {
            out.print("    <td class=\"message\" colspan=\"2\"><nobr>" + Messages.getBodyString(locale, "MeridioConnector.NoMappingsSpecified") + "</nobr></td>\n");
        }
        out.print("  </tr>\n</table>\n");
    }

    protected static String[] getAcls(Specification spec) {
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        boolean securityOn = true;
        while (i < spec.getChildCount()) {
            SpecificationNode sn;
            if ((sn = spec.getChild(i++)).getType().equals("access")) {
                String token = sn.getAttributeValue("token");
                map.put(token, token);
                continue;
            }
            if (!sn.getType().equals("security")) continue;
            String value = sn.getAttributeValue("value");
            if (value.equals("on")) {
                securityOn = true;
                continue;
            }
            if (!value.equals("off")) continue;
            securityOn = false;
        }
        if (!securityOn) {
            return null;
        }
        String[] rval = new String[map.size()];
        Iterator iter = map.keySet().iterator();
        i = 0;
        while (iter.hasNext()) {
            rval[i++] = (String)iter.next();
        }
        return rval;
    }

    private static String[] getMIMETypes(Specification spec) {
        ArrayList<String> al = new ArrayList<String>();
        for (int i = 0; i < spec.getChildCount(); ++i) {
            SpecificationNode sn = spec.getChild(i);
            if (!sn.getType().equals("MIMEType")) continue;
            al.add(sn.getAttributeValue("type"));
        }
        String[] mimeTypes = new String[al.size()];
        Iterator it = al.iterator();
        int i = 0;
        while (it.hasNext()) {
            mimeTypes[i] = (String)it.next();
            ++i;
        }
        return mimeTypes;
    }

    private DMSearchResults documentSpecificationSearch(Specification docSpec, long startTime, long endTime, int startPositionOfHits, int maxHitsToReturn) throws RemoteException, MeridioDataSetException {
        return this.documentSpecificationSearch(docSpec, startTime, endTime, startPositionOfHits, maxHitsToReturn, null, null);
    }

    private DMSearchResults documentSpecificationSearch(Specification docSpec, long startTime, long endTime, int startPositionOfHits, int maxHitsToReturn, long restrictDocumentId) throws RemoteException, MeridioDataSetException {
        if (restrictDocumentId > 0L) {
            return this.documentSpecificationSearch(docSpec, startTime, endTime, startPositionOfHits, maxHitsToReturn, new long[]{restrictDocumentId}, null);
        }
        return this.documentSpecificationSearch(docSpec, startTime, endTime, startPositionOfHits, maxHitsToReturn, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DMSearchResults documentSpecificationSearch(Specification docSpec, long startTime, long endTime, int startPositionOfHits, int maxHitsToReturn, long[] restrictDocumentId, ReturnMetadata[] returnMetadata) throws RemoteException, MeridioDataSetException {
        try {
            DMSearchResults searchResults;
            int i;
            SpecificationNode sn;
            int i2;
            Logging.connectors.debug((Object)"Entering documentSpecificationSearch");
            int currentSearchTerm = 1;
            DMDataSet dsSearchCriteria = new DMDataSet();
            PROPERTY_TERMS drDeleteSearch = new PROPERTY_TERMS();
            drDeleteSearch.setId(currentSearchTerm++);
            drDeleteSearch.setTermType(new Short("1"));
            drDeleteSearch.setPropertyName("PROP_markedForDelete");
            drDeleteSearch.setCategoryId(4L);
            drDeleteSearch.setNum_relation(new Short("0"));
            drDeleteSearch.setNum_value(0L);
            drDeleteSearch.setParentId(1L);
            drDeleteSearch.setIsVersionProperty(false);
            dsSearchCriteria.addPROPERTY_TERMS(drDeleteSearch);
            if (startTime > 0L) {
                Logging.connectors.debug((Object)("Start Date/time is <" + new Date(startTime) + "> in ms <" + startTime + "> End Date/time is <" + new Date(endTime) + "> in ms <" + endTime + ">"));
                PROPERTY_TERMS drDateStart = new PROPERTY_TERMS();
                drDateStart.setId(currentSearchTerm++);
                drDateStart.setTermType(new Short("2"));
                drDateStart.setPropertyName("PROP_lastModifiedDate");
                drDateStart.setCategoryId(4L);
                drDateStart.setDate_relation(new Short("11"));
                drDateStart.setDate_value(new Date(startTime));
                drDateStart.setParentId(1L);
                drDateStart.setIsVersionProperty(false);
                dsSearchCriteria.addPROPERTY_TERMS(drDateStart);
                PROPERTY_TERMS drDateEnd = new PROPERTY_TERMS();
                drDateEnd.setId(currentSearchTerm++);
                drDateEnd.setTermType(new Short("2"));
                drDateEnd.setPropertyName("PROP_lastModifiedDate");
                drDateEnd.setCategoryId(4L);
                drDateEnd.setDate_relation(new Short("8"));
                drDateEnd.setDate_value(new Date(endTime));
                drDateEnd.setParentId(1L);
                drDateEnd.setIsVersionProperty(false);
                dsSearchCriteria.addPROPERTY_TERMS(drDateEnd);
            }
            PROPERTY_TERMS drDocIdSearch = new PROPERTY_TERMS();
            drDocIdSearch.setId(currentSearchTerm++);
            drDocIdSearch.setTermType(new Short("1"));
            drDocIdSearch.setPropertyName("PROP_documentId");
            drDocIdSearch.setCategoryId(4L);
            drDocIdSearch.setNum_relation(new Short("3"));
            drDocIdSearch.setNum_value(0L);
            drDocIdSearch.setParentId(1L);
            drDocIdSearch.setIsVersionProperty(false);
            dsSearchCriteria.addPROPERTY_TERMS(drDocIdSearch);
            if (restrictDocumentId != null && restrictDocumentId.length == 1) {
                PROPERTY_TERMS drDocIdSearchRestricted = new PROPERTY_TERMS();
                drDocIdSearchRestricted.setId(currentSearchTerm++);
                drDocIdSearchRestricted.setTermType(new Short("1"));
                drDocIdSearchRestricted.setPropertyName("PROP_documentId");
                drDocIdSearchRestricted.setCategoryId(4L);
                drDocIdSearchRestricted.setNum_relation(new Short("0"));
                drDocIdSearchRestricted.setNum_value(restrictDocumentId[0]);
                drDocIdSearchRestricted.setParentId(1L);
                drDocIdSearchRestricted.setIsVersionProperty(false);
                dsSearchCriteria.addPROPERTY_TERMS(drDocIdSearchRestricted);
            } else if (restrictDocumentId != null && restrictDocumentId.length > 1) {
                for (int i3 = 0; i3 < restrictDocumentId.length; ++i3) {
                    PROPERTY_TERMS drDocIdSearchRestricted = new PROPERTY_TERMS();
                    drDocIdSearchRestricted.setId(currentSearchTerm++);
                    drDocIdSearchRestricted.setTermType(new Short("1"));
                    drDocIdSearchRestricted.setPropertyName("PROP_documentId");
                    drDocIdSearchRestricted.setCategoryId(4L);
                    drDocIdSearchRestricted.setNum_relation(new Short("0"));
                    drDocIdSearchRestricted.setNum_value(restrictDocumentId[i3]);
                    drDocIdSearchRestricted.setParentId(4L);
                    drDocIdSearchRestricted.setIsVersionProperty(false);
                    dsSearchCriteria.addPROPERTY_TERMS(drDocIdSearchRestricted);
                }
                PROPERTY_OPS drMIMETypeOps = new PROPERTY_OPS();
                drMIMETypeOps.setId(4L);
                drMIMETypeOps.setParentId(1L);
                drMIMETypeOps.setOperator(new Short("1"));
                dsSearchCriteria.addPROPERTY_OPS(drMIMETypeOps);
            }
            PROPERTY_OPS drPropertyOps = new PROPERTY_OPS();
            drPropertyOps.setId(1L);
            drPropertyOps.setOperator(new Short("0"));
            dsSearchCriteria.addPROPERTY_OPS(drPropertyOps);
            String searchOn = null;
            for (i2 = 0; i2 < docSpec.getChildCount(); ++i2) {
                sn = docSpec.getChild(i2);
                if (!sn.getType().equals("SearchOn")) continue;
                searchOn = sn.getAttributeValue("value");
            }
            if (searchOn != null && searchOn.equals("DOCUMENTS_ONLY")) {
                PROPERTY_TERMS drDocsOrRecsSearch = new PROPERTY_TERMS();
                drDocsOrRecsSearch.setId(currentSearchTerm++);
                drDocsOrRecsSearch.setTermType(new Short("1"));
                drDocsOrRecsSearch.setPropertyName("PROP_recordType");
                drDocsOrRecsSearch.setCategoryId(4L);
                drDocsOrRecsSearch.setNum_relation(new Short("1"));
                drDocsOrRecsSearch.setNum_value(0L);
                drDocsOrRecsSearch.setParentId(1L);
                drDocsOrRecsSearch.setIsVersionProperty(false);
                dsSearchCriteria.addPROPERTY_TERMS(drDocsOrRecsSearch);
                PROPERTY_TERMS drDocsOrRecsSearch2 = new PROPERTY_TERMS();
                drDocsOrRecsSearch2.setId(currentSearchTerm++);
                drDocsOrRecsSearch2.setTermType(new Short("1"));
                drDocsOrRecsSearch2.setPropertyName("PROP_recordType");
                drDocsOrRecsSearch2.setCategoryId(4L);
                drDocsOrRecsSearch2.setNum_relation(new Short("1"));
                drDocsOrRecsSearch2.setNum_value(4L);
                drDocsOrRecsSearch2.setParentId(1L);
                drDocsOrRecsSearch2.setIsVersionProperty(false);
                dsSearchCriteria.addPROPERTY_TERMS(drDocsOrRecsSearch2);
                PROPERTY_TERMS drDocsOrRecsSearch3 = new PROPERTY_TERMS();
                drDocsOrRecsSearch3.setId(currentSearchTerm++);
                drDocsOrRecsSearch3.setTermType(new Short("1"));
                drDocsOrRecsSearch3.setPropertyName("PROP_recordType");
                drDocsOrRecsSearch3.setCategoryId(4L);
                drDocsOrRecsSearch3.setNum_relation(new Short("1"));
                drDocsOrRecsSearch3.setNum_value(19L);
                drDocsOrRecsSearch3.setParentId(1L);
                drDocsOrRecsSearch3.setIsVersionProperty(false);
                dsSearchCriteria.addPROPERTY_TERMS(drDocsOrRecsSearch3);
            }
            if (searchOn != null && searchOn.equals("RECORDS_ONLY")) {
                PROPERTY_TERMS drDocsOrRecsSearch = new PROPERTY_TERMS();
                drDocsOrRecsSearch.setId(currentSearchTerm++);
                drDocsOrRecsSearch.setTermType(new Short("1"));
                drDocsOrRecsSearch.setPropertyName("PROP_recordType");
                drDocsOrRecsSearch.setCategoryId(4L);
                drDocsOrRecsSearch.setNum_relation(new Short("5"));
                drDocsOrRecsSearch.setNum_value(4L);
                drDocsOrRecsSearch.setParentId(1L);
                drDocsOrRecsSearch.setIsVersionProperty(false);
                dsSearchCriteria.addPROPERTY_TERMS(drDocsOrRecsSearch);
            }
            for (i2 = 0; i2 < docSpec.getChildCount(); ++i2) {
                sn = docSpec.getChild(i2);
                if (!sn.getType().equals("SearchPath")) continue;
                String searchPath = sn.getAttributeValue("path");
                int searchContainer = this.meridio_.findClassOrFolder(searchPath);
                if (searchContainer > 0) {
                    SEARCH_CONTAINERS drSearchContainers = new SEARCH_CONTAINERS();
                    drSearchContainers.setContainerId(searchContainer);
                    dsSearchCriteria.addSEARCH_CONTAINERS(drSearchContainers);
                    Logging.connectors.debug((Object)("Found path [" + searchPath + "] id: [" + searchContainer + "]"));
                    continue;
                }
                if (searchContainer == 0) {
                    Logging.connectors.debug((Object)"Meridio: Found FilePlan root, so not including in search criteria!");
                    continue;
                }
                Logging.connectors.warn((Object)("Meridio: Did not find FilePlan path [" + searchPath + "]. The path is therefore *not* being used to restrict the search scope"));
            }
            CATEGORIES[] meridioCategories = this.meridio_.getCategories().getCATEGORIES();
            HashMap<String, Long> categoryMap = new HashMap<String, Long>();
            for (i = 0; i < meridioCategories.length; ++i) {
                String title = meridioCategories[i].getPROP_title();
                long categoryID = meridioCategories[i].getPROP_categoryId();
                categoryMap.put(title, new Long(categoryID));
            }
            ArrayList<Long> categoriesToAdd = new ArrayList<Long>();
            for (i = 0; i < docSpec.getChildCount(); ++i) {
                SpecificationNode sn2 = docSpec.getChild(i);
                if (!sn2.getType().equals("SearchCategory")) continue;
                String searchCategory = sn2.getAttributeValue("category");
                Long categoryIDObject = (Long)categoryMap.get(searchCategory);
                if (categoryIDObject != null) {
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("Meridio: Category [" + searchCategory + "] match, ID=[" + categoryIDObject + "]"));
                    }
                    categoriesToAdd.add(categoryIDObject);
                    continue;
                }
                if (!Logging.connectors.isDebugEnabled()) continue;
                Logging.connectors.debug((Object)("Meridio: No match found for Category [" + searchCategory + "]"));
            }
            for (i = 0; i < categoriesToAdd.size(); ++i) {
                PROPERTY_TERMS drDocsOrRecsSearch = new PROPERTY_TERMS();
                drDocsOrRecsSearch.setId(currentSearchTerm++);
                drDocsOrRecsSearch.setTermType(new Short("1"));
                drDocsOrRecsSearch.setPropertyName("PROP_categoryId");
                drDocsOrRecsSearch.setCategoryId(4L);
                drDocsOrRecsSearch.setNum_relation(new Short("0"));
                drDocsOrRecsSearch.setNum_value((Long)categoriesToAdd.get(i));
                if (categoriesToAdd.size() == 1) {
                    drDocsOrRecsSearch.setParentId(1L);
                } else {
                    drDocsOrRecsSearch.setParentId(2L);
                }
                drDocsOrRecsSearch.setIsVersionProperty(false);
                dsSearchCriteria.addPROPERTY_TERMS(drDocsOrRecsSearch);
            }
            String[] mimeTypes = MeridioConnector.getMIMETypes(docSpec);
            for (i = 0; i < mimeTypes.length; ++i) {
                PROPERTY_TERMS drMIMETypesSearch = new PROPERTY_TERMS();
                drMIMETypesSearch.setId(currentSearchTerm++);
                drMIMETypesSearch.setTermType(new Short("0"));
                drMIMETypesSearch.setPropertyName("PROP_W_mimeType");
                drMIMETypesSearch.setCategoryId(4L);
                drMIMETypesSearch.setStr_relation(new Short("0"));
                drMIMETypesSearch.setStr_value(mimeTypes[i]);
                if (mimeTypes.length == 1) {
                    drMIMETypesSearch.setParentId(1L);
                } else {
                    drMIMETypesSearch.setParentId(3L);
                }
                drMIMETypesSearch.setIsVersionProperty(true);
                dsSearchCriteria.addPROPERTY_TERMS(drMIMETypesSearch);
            }
            if (categoriesToAdd.size() > 1) {
                PROPERTY_OPS drCategoryOps = new PROPERTY_OPS();
                drCategoryOps.setId(2L);
                drCategoryOps.setParentId(1L);
                drCategoryOps.setOperator(new Short("1"));
                dsSearchCriteria.addPROPERTY_OPS(drCategoryOps);
            }
            if (mimeTypes.length > 1) {
                PROPERTY_OPS drMIMETypeOps = new PROPERTY_OPS();
                drMIMETypeOps.setId(3L);
                drMIMETypeOps.setParentId(1L);
                drMIMETypeOps.setOperator(new Short("1"));
                dsSearchCriteria.addPROPERTY_OPS(drMIMETypeOps);
            }
            int returnResultsAdded = 0;
            if (returnMetadata != null && returnMetadata.length > 0) {
                PROPERTYDEFS[] propertyDefs = this.meridio_.getStaticData().getPROPERTYDEFS();
                HashMap<String, String> propertyMap = new HashMap<String, String>();
                HashMap<Long, HashMap<String, String>> customMap = new HashMap<Long, HashMap<String, String>>();
                i = 0;
                while (i < propertyDefs.length) {
                    PROPERTYDEFS def;
                    if ((def = propertyDefs[i++]).getTableName().equals("DOCUMENTS")) {
                        propertyMap.put(def.getDisplayName(), def.getColumnName());
                        continue;
                    }
                    if (!def.getTableName().equals("DOCUMENT_CUSTOMPROPS")) continue;
                    Long categoryID = new Long(def.getCategoryId());
                    HashMap<String, String> dataMap = (HashMap<String, String>)customMap.get(categoryID);
                    if (dataMap == null) {
                        dataMap = new HashMap<String, String>();
                        customMap.put(categoryID, dataMap);
                    }
                    dataMap.put(def.getDisplayName(), def.getColumnName());
                }
                for (i = 0; i < returnMetadata.length; ++i) {
                    HashMap categoryMatchMap;
                    long categoryMatch = 0L;
                    boolean isCategoryMatch = false;
                    RESULTDEFS drResultDefs = new RESULTDEFS();
                    drResultDefs.setIsVersionProperty(false);
                    if (returnMetadata[i].getCategoryName() == null || returnMetadata[i].getCategoryName().length() == 0) {
                        isCategoryMatch = true;
                        categoryMatch = 4L;
                    } else {
                        Long categoryIDObject = (Long)categoryMap.get(returnMetadata[i].getCategoryName());
                        if (categoryIDObject != null) {
                            isCategoryMatch = true;
                            categoryMatch = categoryIDObject;
                        }
                    }
                    if (!isCategoryMatch) {
                        if (!Logging.connectors.isDebugEnabled()) continue;
                        Logging.connectors.debug((Object)("Meridio: Category '" + returnMetadata[i].getCategoryName() + "' no match found for search results criteria!"));
                        continue;
                    }
                    String columnName = (String)propertyMap.get(returnMetadata[i].getPropertyName());
                    if (columnName == null && (categoryMatchMap = (HashMap)customMap.get(new Long(categoryMatch))) != null) {
                        columnName = (String)categoryMatchMap.get(returnMetadata[i].getPropertyName());
                    }
                    if (columnName == null) {
                        if (!Logging.connectors.isDebugEnabled()) continue;
                        Logging.connectors.debug((Object)("Meridio: No property match found for '" + returnMetadata[i].getPropertyName() + "'"));
                        continue;
                    }
                    drResultDefs.setPropertyName(columnName);
                    drResultDefs.setCategoryId(categoryMatch);
                    dsSearchCriteria.addRESULTDEFS(drResultDefs);
                    ++returnResultsAdded;
                }
            }
            if (returnResultsAdded == 0) {
                RESULTDEFS drResultDefs = new RESULTDEFS();
                drResultDefs.setPropertyName("PROP_lastModifiedDate");
                drResultDefs.setIsVersionProperty(false);
                drResultDefs.setCategoryId(4L);
                dsSearchCriteria.addRESULTDEFS(drResultDefs);
            }
            DMSearchResults dMSearchResults = searchResults = this.meridio_.searchDocuments(dsSearchCriteria, maxHitsToReturn, startPositionOfHits, DmPermission.READ, false, DmSearchScope.BOTH, false, true, false, DmLogicalOp.AND);
            return dMSearchResults;
        }
        finally {
            Logging.connectors.debug((Object)"Exiting documentSpecificationSearch method.");
        }
    }

    /*
     * Loose catch block
     */
    public String[] getMeridioCategories() throws ManifoldCFException, ServiceInterruption {
        Logging.connectors.debug((Object)"Entering 'getMeridioCategories' method");
        while (true) {
            this.getSession();
            ArrayList<String> returnCategories = new ArrayList<String>();
            try {
                CATEGORIES[] categories = this.meridio_.getCategories().getCATEGORIES();
                for (int i = 0; i < categories.length; ++i) {
                    if (categories[i].getPROP_categoryId() != 4L && categories[i].getPROP_categoryId() != 5L && categories[i].getPROP_categoryId() <= 100L || categories[i].getPROP_title().equals("<None>")) continue;
                    Logging.connectors.debug((Object)("Adding category <" + categories[i].getPROP_title() + ">"));
                    returnCategories.add(categories[i].getPROP_title());
                }
                Object[] returnStringArray = new String[returnCategories.size()];
                Iterator it = returnCategories.iterator();
                int i = 0;
                while (it.hasNext()) {
                    returnStringArray[i] = (String)it.next();
                    ++i;
                }
                Arrays.sort(returnStringArray);
                Logging.connectors.debug((Object)"Exiting 'getMeridioCategories' method");
                return returnStringArray;
            }
            catch (AxisFault e) {
                String exceptionName;
                long currentTime = System.currentTimeMillis();
                if (e.getFaultCode().equals(new QName("http://xml.apache.org/axis/", "HTTP"))) {
                    Element elem = e.lookupFaultDetail(new QName("http://xml.apache.org/axis/", "HttpErrorCode"));
                    if (elem != null) {
                        elem.normalize();
                        String httpErrorCode = elem.getFirstChild().getNodeValue().trim();
                        throw new ManifoldCFException("Unexpected http error code " + httpErrorCode + " getting categories: " + e.getMessage());
                    }
                    throw new ManifoldCFException("Unknown http error occurred while getting categories: " + e.getMessage(), (Throwable)e);
                }
                if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server.userException")) && (exceptionName = e.getFaultString()).equals("java.lang.InterruptedException")) {
                    throw new ManifoldCFException("Interrupted", 2);
                }
                if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server")) && e.getFaultString().indexOf(" 23031#") != -1) {
                    this.meridio_ = null;
                    continue;
                }
                throw new ManifoldCFException("Meridio: Got an unknown remote exception getting categories - axis fault = " + e.getFaultCode().getLocalPart() + ", detail = " + e.getFaultString(), (Throwable)e);
            }
            catch (RemoteException remoteException) {
                throw new ManifoldCFException("Meridio: A Remote Exception occurred while retrieving the Meridio categories: " + remoteException.getMessage(), (Throwable)remoteException);
            }
            break;
        }
        catch (MeridioDataSetException meridioDataSetException) {
            throw new ManifoldCFException("Meridio: DataSet Exception occurred retrieving the Meridio categories: " + meridioDataSetException.getMessage(), (Throwable)meridioDataSetException);
        }
    }

    /*
     * Loose catch block
     */
    public String[] getMeridioDocumentProperties() throws ManifoldCFException, ServiceInterruption {
        Logging.connectors.debug((Object)"Entering 'getMeridioDocumentProperties' method");
        while (true) {
            this.getSession();
            ArrayList<String> meridioDocumentProperties = new ArrayList<String>();
            try {
                CATEGORIES[] categories = this.meridio_.getCategories().getCATEGORIES();
                PROPERTYDEFS[] propertyDefs = this.meridio_.getStaticData().getPROPERTYDEFS();
                block5: for (int i = 0; i < propertyDefs.length; ++i) {
                    if (propertyDefs[i].getTableName() == null) continue;
                    if (propertyDefs[i].getTableName().compareTo("DOCUMENTS") == 0) {
                        meridioDocumentProperties.add(propertyDefs[i].getDisplayName());
                    }
                    if (propertyDefs[i].getCategoryId() != 4L && propertyDefs[i].getCategoryId() != 5L && propertyDefs[i].getCategoryId() <= 100L || propertyDefs[i].getTableName().compareTo("DOCUMENT_CUSTOMPROPS") != 0) continue;
                    for (int j = 0; j < categories.length; ++j) {
                        if (categories[j].getPROP_categoryId() != propertyDefs[i].getCategoryId()) continue;
                        meridioDocumentProperties.add(categories[j].getPROP_title() + "." + propertyDefs[i].getDisplayName());
                        Logging.connectors.debug((Object)("Prop: <" + categories[j].getPROP_title() + "." + propertyDefs[i].getDisplayName() + "> Column <" + propertyDefs[i].getColumnName() + ">"));
                        continue block5;
                    }
                }
                Object[] returnStringArray = new String[meridioDocumentProperties.size()];
                Iterator it = meridioDocumentProperties.iterator();
                int i2 = 0;
                while (it.hasNext()) {
                    returnStringArray[i2] = (String)it.next();
                    ++i2;
                }
                Arrays.sort(returnStringArray);
                Logging.connectors.debug((Object)"Exiting 'getMeridioDocumentProperties' method");
                return returnStringArray;
            }
            catch (AxisFault e) {
                String exceptionName;
                long currentTime = System.currentTimeMillis();
                if (e.getFaultCode().equals(new QName("http://xml.apache.org/axis/", "HTTP"))) {
                    Element elem = e.lookupFaultDetail(new QName("http://xml.apache.org/axis/", "HttpErrorCode"));
                    if (elem != null) {
                        elem.normalize();
                        String httpErrorCode = elem.getFirstChild().getNodeValue().trim();
                        throw new ManifoldCFException("Unexpected http error code " + httpErrorCode + " getting document properties: " + e.getMessage());
                    }
                    throw new ManifoldCFException("Unknown http error occurred while getting document properties: " + e.getMessage(), (Throwable)e);
                }
                if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server.userException")) && (exceptionName = e.getFaultString()).equals("java.lang.InterruptedException")) {
                    throw new ManifoldCFException("Interrupted", 2);
                }
                if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server")) && e.getFaultString().indexOf(" 23031#") != -1) {
                    this.meridio_ = null;
                    continue;
                }
                throw new ManifoldCFException("Meridio: Got an unknown remote exception getting document properties - axis fault = " + e.getFaultCode().getLocalPart() + ", detail = " + e.getFaultString(), (Throwable)e);
            }
            catch (RemoteException remoteException) {
                throw new ManifoldCFException("Meridio: A Remote Exception occurred while retrieving the Meridio document properties: " + remoteException.getMessage(), (Throwable)remoteException);
            }
            break;
        }
        catch (MeridioDataSetException meridioDataSetException) {
            throw new ManifoldCFException("Meridio: DataSet Exception occurred retrieving the Meridio document properties: " + meridioDataSetException.getMessage(), (Throwable)meridioDataSetException);
        }
    }

    /*
     * Loose catch block
     */
    public MeridioClassContents[] getClassOrFolderContents(int classOrFolderId) throws ManifoldCFException, ServiceInterruption {
        Logging.connectors.debug((Object)"Entering 'getClassOrFolderContents' method");
        while (true) {
            this.getSession();
            ArrayList<MeridioClassContents> meridioContainers = new ArrayList<MeridioClassContents>();
            try {
                MeridioClassContents classContents;
                int i;
                RMDataSet ds = this.meridio_.getClassContents(classOrFolderId, false, false, false);
                if (ds == null) {
                    Logging.connectors.debug((Object)"No classes or folders in returned DataSet");
                    return new MeridioClassContents[0];
                }
                Rm2vClass[] classes = ds.getRm2vClass();
                Rm2vFolder[] folders = ds.getRm2vFolder();
                for (i = 0; i < classes.length; ++i) {
                    if (classes[i].getHomePage() != null && classes[i].getHomePage().length() != 0) continue;
                    classContents = new MeridioClassContents();
                    classContents.containerType = 1;
                    classContents.classOrFolderId = classes[i].getId();
                    classContents.classOrFolderName = classes[i].getName();
                    meridioContainers.add(classContents);
                }
                for (i = 0; i < folders.length; ++i) {
                    classContents = new MeridioClassContents();
                    classContents.containerType = 0;
                    classContents.classOrFolderId = folders[i].getId();
                    classContents.classOrFolderName = folders[i].getName();
                    meridioContainers.add(classContents);
                }
                MeridioClassContents[] classArray = new MeridioClassContents[meridioContainers.size()];
                Iterator it = meridioContainers.iterator();
                int i2 = 0;
                while (it.hasNext()) {
                    classArray[i2] = (MeridioClassContents)it.next();
                    ++i2;
                }
                Logging.connectors.debug((Object)"Exiting 'getClassOrFolderContents' method");
                return classArray;
            }
            catch (AxisFault e) {
                String exceptionName;
                long currentTime = System.currentTimeMillis();
                if (e.getFaultCode().equals(new QName("http://xml.apache.org/axis/", "HTTP"))) {
                    Element elem = e.lookupFaultDetail(new QName("http://xml.apache.org/axis/", "HttpErrorCode"));
                    if (elem != null) {
                        elem.normalize();
                        String httpErrorCode = elem.getFirstChild().getNodeValue().trim();
                        throw new ManifoldCFException("Unexpected http error code " + httpErrorCode + " getting class or folder contents: " + e.getMessage());
                    }
                    throw new ManifoldCFException("Unknown http error occurred while getting class or folder contents: " + e.getMessage(), (Throwable)e);
                }
                if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server.userException")) && (exceptionName = e.getFaultString()).equals("java.lang.InterruptedException")) {
                    throw new ManifoldCFException("Interrupted", 2);
                }
                if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server")) && e.getFaultString().indexOf(" 23031#") != -1) {
                    this.meridio_ = null;
                    continue;
                }
                throw new ManifoldCFException("Meridio: Got an unknown remote exception getting class or folder contents - axis fault = " + e.getFaultCode().getLocalPart() + ", detail = " + e.getFaultString(), (Throwable)e);
            }
            catch (RemoteException remoteException) {
                throw new ManifoldCFException("Meridio: A Remote Exception occurred while retrieving class or folder contents: " + remoteException.getMessage(), (Throwable)remoteException);
            }
            break;
        }
        catch (MeridioDataSetException meridioDataSetException) {
            throw new ManifoldCFException("Meridio: A problem occurred manipulating the Web Service XML: " + meridioDataSetException.getMessage(), (Throwable)meridioDataSetException);
        }
    }

    static {
        Arrays.sort(allowedMimeTypes);
    }

    protected static class MutableInteger {
        int value = 0;

        public int getValue() {
            return this.value;
        }

        public void increment() {
            ++this.value;
        }
    }

    private static class ReturnMetadata {
        protected String categoryName_;
        protected String propertyName_;

        public ReturnMetadata(String categoryName, String propertyName) {
            this.categoryName_ = categoryName;
            this.propertyName_ = propertyName;
        }

        public String getCategoryName() {
            return this.categoryName_;
        }

        public String getPropertyName() {
            return this.propertyName_;
        }
    }
}

