/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.spi.auth;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.nuxeo.client.spi.NuxeoClientException;
import org.nuxeo.client.util.Base64;

public class BasicAuthInterceptor
implements Interceptor {
    protected String token;

    public BasicAuthInterceptor(String username, String password) {
        if (username == null || password == null) {
            throw new NuxeoClientException("'username' and 'password' must be set");
        }
        String info = username + ":" + password;
        this.token = "Basic " + Base64.encode(info, 8);
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request original = chain.request();
        Request request = chain.request().newBuilder().addHeader("Authorization", this.token).addHeader("Content-Type", "application/json; charset=UTF-8").method(original.method(), original.body()).build();
        return chain.proceed(request);
    }
}

