/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.cas;

import org.apache.uima.cas.ByteArrayFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JCasRegistry;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.cas.TOP_Type;

public final class ByteArray
extends TOP
implements ByteArrayFS {
    public static final int typeIndexID;
    public static final int type;

    @Override
    public int getTypeIndexID() {
        return typeIndexID;
    }

    private ByteArray() {
    }

    public ByteArray(int addr, TOP_Type type) {
        super(addr, type);
    }

    public ByteArray(JCas jcas, int length) {
        this(jcas.getLowLevelCas().ll_createByteArray(length), jcas.getType(typeIndexID));
    }

    @Override
    public byte get(int i) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, i);
        return this.jcasType.ll_cas.ll_getByteArrayValue(this.addr, i);
    }

    @Override
    public void set(int i, byte v) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, i);
        this.jcasType.ll_cas.ll_setByteArrayValue(this.addr, i, v);
    }

    @Override
    public void copyFromArray(byte[] src, int srcOffset, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, destOffset, length);
        for (int i = 0; i < length; ++i) {
            this.jcasType.ll_cas.ll_setByteArrayValue(this.addr, i + destOffset, src[i + srcOffset]);
        }
    }

    @Override
    public void copyToArray(int srcOffset, byte[] dest, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, srcOffset, length);
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = this.jcasType.ll_cas.ll_getByteArrayValue(this.addr, i + srcOffset);
        }
    }

    @Override
    public byte[] toArray() {
        int size = this.size();
        byte[] outArray = new byte[size];
        this.copyToArray(0, outArray, 0, size);
        return outArray;
    }

    @Override
    public int size() {
        return this.jcasType.casImpl.ll_getArraySize(this.addr);
    }

    @Override
    public void copyToArray(int srcOffset, String[] dest, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, srcOffset, length);
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = Byte.toString(this.jcasType.ll_cas.ll_getByteArrayValue(this.addr, i + srcOffset));
        }
    }

    @Override
    public void copyFromArray(String[] src, int srcOffset, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, destOffset, length);
        for (int i = 0; i < length; ++i) {
            this.jcasType.ll_cas.ll_setByteArrayValue(this.addr, i + destOffset, Byte.parseByte(src[i + srcOffset]));
        }
    }

    @Override
    public String[] toStringArray() {
        int size = this.size();
        String[] strArray = new String[size];
        this.copyToArray(0, strArray, 0, size);
        return strArray;
    }

    static {
        type = typeIndexID = JCasRegistry.register(ByteArray.class);
    }
}

