/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.webcrawler;

import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.connectorcommon.interfaces.BreakException;
import org.apache.manifoldcf.connectorcommon.interfaces.IBreakCheck;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.interfaces.IAbortActivity;

public class AbortChecker
implements IBreakCheck {
    protected final IAbortActivity activities;
    protected ServiceInterruption serviceInterruption = null;
    protected ManifoldCFException mcfException = null;

    public AbortChecker(IAbortActivity activities) {
        this.activities = activities;
    }

    public long abortCheck() throws BreakException, InterruptedException {
        try {
            this.activities.checkJobStillActive();
            return 1000L;
        }
        catch (ServiceInterruption e) {
            this.serviceInterruption = e;
            throw new BreakException("Break requested: " + e.getMessage(), (Throwable)e);
        }
        catch (ManifoldCFException e) {
            if (e.getErrorCode() == 2) {
                throw new InterruptedException("Interrupted: " + e.getMessage());
            }
            this.mcfException = e;
            throw new BreakException("Error during break check: " + e.getMessage(), (Throwable)e);
        }
    }

    public void rethrowExceptions() throws ManifoldCFException, ServiceInterruption {
        if (this.serviceInterruption != null) {
            throw this.serviceInterruption;
        }
        if (this.mcfException != null) {
            throw this.mcfException;
        }
    }
}

