/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko.util;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.lucene.analysis.ko.POS;
import org.apache.lucene.analysis.ko.dict.BinaryDictionary;
import org.apache.lucene.analysis.ko.dict.Dictionary;
import org.apache.lucene.analysis.ko.util.CSVUtil;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.OutputStreamDataOutput;
import org.apache.lucene.util.ArrayUtil;

abstract class BinaryDictionaryWriter {
    private static final int ID_LIMIT = 8192;
    private final Class<? extends BinaryDictionary> implClazz;
    protected ByteBuffer buffer;
    private int targetMapEndOffset = 0;
    private int lastWordId = -1;
    private int lastSourceId = -1;
    private int[] targetMap = new int[8192];
    private int[] targetMapOffsets = new int[8192];
    private final ArrayList<String> posDict = new ArrayList();

    BinaryDictionaryWriter(Class<? extends BinaryDictionary> implClazz, int size) {
        this.implClazz = implClazz;
        this.buffer = ByteBuffer.allocate(size);
    }

    public int put(String[] entry) {
        boolean hasSinglePOS;
        POS.Tag rightPOS;
        POS.Tag leftPOS;
        short leftId = Short.parseShort(entry[1]);
        short rightId = Short.parseShort(entry[2]);
        short wordCost = Short.parseShort(entry[3]);
        POS.Type posType = POS.resolveType(entry[8]);
        if (posType == POS.Type.MORPHEME || posType == POS.Type.COMPOUND || entry[9].equals("*")) {
            leftPOS = POS.resolveTag(entry[4]);
            assert (entry[9].equals("*") && entry[10].equals("*"));
            rightPOS = leftPOS;
        } else {
            leftPOS = POS.resolveTag(entry[9]);
            rightPOS = POS.resolveTag(entry[10]);
        }
        String reading = entry[7].equals("*") ? "" : (entry[0].equals(entry[7]) ? "" : entry[7]);
        String expression = entry[11].equals("*") ? "" : entry[11];
        int left = this.buffer.remaining();
        int worstCase = 9 + 2 * (expression.length() + reading.length());
        if (worstCase > left) {
            ByteBuffer newBuffer = ByteBuffer.allocate(ArrayUtil.oversize((int)(this.buffer.limit() + worstCase - left), (int)1));
            this.buffer.flip();
            newBuffer.put(this.buffer);
            this.buffer = newBuffer;
        }
        int toFill = 1 + leftId - this.posDict.size();
        for (int i = 0; i < toFill; ++i) {
            this.posDict.add(null);
        }
        String fullPOSData = leftPOS.name() + "," + entry[5];
        String existing = this.posDict.get(leftId);
        assert (existing == null || existing.equals(fullPOSData));
        this.posDict.set(leftId, fullPOSData);
        ArrayList<Dictionary.Morpheme> morphemes = new ArrayList<Dictionary.Morpheme>();
        boolean bl = hasSinglePOS = leftPOS == rightPOS;
        if (posType != POS.Type.MORPHEME && expression.length() > 0) {
            String[] exprTokens;
            for (String exprToken : exprTokens = expression.split("\\+")) {
                String[] tokenSplit = exprToken.split("/");
                assert (tokenSplit.length == 3);
                String surfaceForm = tokenSplit[0].trim();
                if (surfaceForm.isEmpty()) continue;
                POS.Tag exprTag = POS.resolveTag(tokenSplit[1]);
                morphemes.add(new Dictionary.Morpheme(exprTag, tokenSplit[0]));
                if (leftPOS == exprTag) continue;
                hasSinglePOS = false;
            }
        }
        int flags = 0;
        if (hasSinglePOS) {
            flags |= 1;
        }
        if (posType == POS.Type.MORPHEME && reading.length() > 0) {
            flags |= 2;
        }
        if (leftId >= 8192) {
            throw new IllegalArgumentException("leftId >= 8192: " + leftId);
        }
        if (posType.ordinal() >= 4) {
            throw new IllegalArgumentException("posType.ordinal() >= 4: " + posType.name());
        }
        this.buffer.putShort((short)(leftId << 2 | posType.ordinal()));
        this.buffer.putShort((short)(rightId << 2 | flags));
        this.buffer.putShort(wordCost);
        if (posType == POS.Type.MORPHEME) {
            assert (leftPOS == rightPOS);
            if (reading.length() > 0) {
                this.writeString(reading);
            }
        } else {
            if (!hasSinglePOS) {
                this.buffer.put((byte)rightPOS.ordinal());
            }
            this.buffer.put((byte)morphemes.size());
            int compoundOffset = 0;
            for (Dictionary.Morpheme morpheme : morphemes) {
                if (!hasSinglePOS) {
                    this.buffer.put((byte)morpheme.posTag.ordinal());
                }
                if (posType != POS.Type.INFLECT) {
                    this.buffer.put((byte)morpheme.surfaceForm.length());
                    compoundOffset += morpheme.surfaceForm.length();
                } else {
                    this.writeString(morpheme.surfaceForm);
                }
                assert (compoundOffset <= entry[0].length()) : Arrays.toString(entry);
            }
        }
        return this.buffer.position();
    }

    private void writeString(String s) {
        this.buffer.put((byte)s.length());
        for (int i = 0; i < s.length(); ++i) {
            this.buffer.putChar(s.charAt(i));
        }
    }

    void addMapping(int sourceId, int wordId) {
        if (wordId <= this.lastWordId) {
            throw new IllegalStateException("words out of order: " + wordId + " vs lastID: " + this.lastWordId);
        }
        if (sourceId > this.lastSourceId) {
            this.targetMapOffsets = ArrayUtil.grow((int[])this.targetMapOffsets, (int)(sourceId + 1));
            for (int i = this.lastSourceId + 1; i <= sourceId; ++i) {
                this.targetMapOffsets[i] = this.targetMapEndOffset;
            }
        } else if (sourceId != this.lastSourceId) {
            throw new IllegalStateException("source ids not in increasing order: lastSourceId=" + this.lastSourceId + " vs sourceId=" + sourceId);
        }
        this.targetMap = ArrayUtil.grow((int[])this.targetMap, (int)(this.targetMapEndOffset + 1));
        this.targetMap[this.targetMapEndOffset] = wordId;
        ++this.targetMapEndOffset;
        this.lastSourceId = sourceId;
        this.lastWordId = wordId;
    }

    final String getBaseFileName() {
        return this.implClazz.getName().replace('.', '/');
    }

    public void write(Path baseDir) throws IOException {
        String baseName = this.getBaseFileName();
        this.writeDictionary(baseDir.resolve(baseName + "$buffer.dat"));
        this.writeTargetMap(baseDir.resolve(baseName + "$targetMap.dat"));
        this.writePosDict(baseDir.resolve(baseName + "$posDict.dat"));
    }

    private void writeTargetMap(Path path) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);
             BufferedOutputStream bos = new BufferedOutputStream(os);){
            OutputStreamDataOutput out = new OutputStreamDataOutput((OutputStream)bos);
            CodecUtil.writeHeader((DataOutput)out, (String)"ko_dict_map", (int)1);
            int numSourceIds = this.lastSourceId + 1;
            out.writeVInt(this.targetMapEndOffset);
            out.writeVInt(numSourceIds + 1);
            int prev = 0;
            int sourceId = 0;
            for (int ofs = 0; ofs < this.targetMapEndOffset; ++ofs) {
                int val = this.targetMap[ofs];
                int delta = val - prev;
                assert (delta >= 0);
                if (ofs == this.targetMapOffsets[sourceId]) {
                    out.writeVInt(delta << 1 | 1);
                    ++sourceId;
                } else {
                    out.writeVInt(delta << 1);
                }
                prev += delta;
            }
            if (sourceId != numSourceIds) {
                throw new IllegalStateException("sourceId:" + sourceId + " != numSourceIds:" + numSourceIds);
            }
        }
    }

    private void writePosDict(Path path) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);
             BufferedOutputStream bos = new BufferedOutputStream(os);){
            OutputStreamDataOutput out = new OutputStreamDataOutput((OutputStream)bos);
            CodecUtil.writeHeader((DataOutput)out, (String)"ko_dict_pos", (int)1);
            out.writeVInt(this.posDict.size());
            for (String s : this.posDict) {
                if (s == null) {
                    out.writeByte((byte)POS.Tag.UNKNOWN.ordinal());
                    continue;
                }
                String[] data = CSVUtil.parse(s);
                if (data.length != 2) {
                    throw new IllegalArgumentException("Malformed pos/inflection: " + s + "; expected 2 characters");
                }
                out.writeByte((byte)POS.Tag.valueOf(data[0]).ordinal());
            }
        }
    }

    private void writeDictionary(Path path) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);
             BufferedOutputStream bos = new BufferedOutputStream(os);){
            OutputStreamDataOutput out = new OutputStreamDataOutput((OutputStream)bos);
            CodecUtil.writeHeader((DataOutput)out, (String)"ko_dict", (int)1);
            out.writeVInt(this.buffer.position());
            WritableByteChannel channel = Channels.newChannel(bos);
            this.buffer.flip();
            channel.write(this.buffer);
            assert ((long)this.buffer.remaining() == 0L);
        }
    }
}

