/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplemagic.types;

import com.j256.simplemagic.types.NumberType;
import com.j256.simplemagic.types.TestOperator;

public class NumberComparison {
    private final NumberType numberType;
    private final TestOperator operator;
    private final Number value;

    public NumberComparison(NumberType numberType, String testStr) {
        String valueStr;
        this.numberType = numberType;
        TestOperator op = TestOperator.fromTest(testStr);
        if (op == null) {
            op = TestOperator.DEFAULT_OPERATOR;
            valueStr = testStr;
        } else {
            valueStr = testStr.substring(1).trim();
        }
        this.operator = op;
        try {
            this.value = numberType.decodeValueString(valueStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Could not parse number from: '" + valueStr + "'");
        }
    }

    public boolean isMatch(Long andValue, boolean unsignedType, Number extractedValue) {
        if (andValue != null) {
            extractedValue = extractedValue.longValue() & andValue;
        }
        return this.operator.doTest(unsignedType, extractedValue, this.value, this.numberType);
    }

    public Number getValue() {
        return this.value;
    }

    public String toString() {
        return (Object)((Object)this.operator) + ", value " + this.value;
    }
}

