/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplemagic;

import com.j256.simplemagic.ContentType;
import java.io.Serializable;

public class ContentInfo
implements Serializable {
    private static final long serialVersionUID = 1342819252130963539L;
    public static final ContentInfo EMPTY_INFO = new ContentInfo(ContentType.EMPTY);
    private final ContentType contentType;
    private final String name;
    private final String message;
    private final String mimeType;
    private final String[] fileExtensions;
    private final boolean partial;

    public ContentInfo(String name, String mimeType, String message, boolean partial) {
        this.contentType = ContentType.fromMimeType(mimeType);
        if (this.contentType == ContentType.OTHER) {
            this.name = name;
            this.fileExtensions = null;
        } else {
            this.name = this.contentType.getSimpleName();
            this.fileExtensions = this.contentType.getFileExtensions();
        }
        this.mimeType = mimeType;
        this.message = message;
        this.partial = partial;
    }

    public ContentInfo(ContentType contentType) {
        this.contentType = contentType;
        this.name = contentType.getSimpleName();
        this.mimeType = contentType.getMimeType();
        this.message = null;
        this.fileExtensions = contentType.getFileExtensions();
        this.partial = false;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public String getName() {
        return this.name;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getMessage() {
        return this.message;
    }

    public String[] getFileExtensions() {
        return this.fileExtensions;
    }

    public boolean isPartial() {
        return this.partial;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        if (this.contentType != null) {
            sb.append(", type ").append((Object)this.contentType);
        }
        if (this.mimeType != null) {
            sb.append(", mime '").append(this.mimeType).append('\'');
        }
        if (this.message != null) {
            sb.append(", msg '").append(this.message).append('\'');
        }
        return sb.toString();
    }
}

