/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.ProjectionException;
import org.locationtech.proj4j.proj.Projection;
import org.locationtech.proj4j.util.ProjectionMath;

public class LambertAzimuthalEqualAreaProjection
extends Projection {
    private static final int N_POLE = 0;
    private static final int S_POLE = 1;
    private static final int EQUIT = 2;
    private static final int OBLIQ = 3;
    private int mode = 0;
    private double phi0;
    private double sinb1;
    private double cosb1;
    private double xmf;
    private double ymf;
    private double mmf;
    private double qp;
    private double dd;
    private double rq;
    private double[] apa;
    private double sinph0;
    private double cosph0;

    public LambertAzimuthalEqualAreaProjection() {
        this(false);
    }

    public LambertAzimuthalEqualAreaProjection(boolean south) {
    }

    @Override
    public void initialize() {
        double d;
        super.initialize();
        this.phi0 = this.projectionLatitude;
        double t = Math.abs(this.phi0);
        this.mode = Math.abs(d - 1.5707963267948966) < 1.0E-10 ? (this.phi0 < 0.0 ? 1 : 0) : (Math.abs(t) < 1.0E-10 ? 2 : 3);
        if (!this.spherical) {
            this.e = Math.sqrt(this.es);
            this.qp = ProjectionMath.qsfn(1.0, this.e, this.one_es);
            this.mmf = 0.5 / (1.0 - this.es);
            this.apa = ProjectionMath.authset(this.es);
            switch (this.mode) {
                case 0: 
                case 1: {
                    this.dd = 1.0;
                    break;
                }
                case 2: {
                    this.rq = Math.sqrt(0.5 * this.qp);
                    this.dd = 1.0 / this.rq;
                    this.xmf = 1.0;
                    this.ymf = 0.5 * this.qp;
                    break;
                }
                case 3: {
                    this.rq = Math.sqrt(0.5 * this.qp);
                    double sinphi = Math.sin(this.phi0);
                    this.sinb1 = ProjectionMath.qsfn(sinphi, this.e, this.one_es) / this.qp;
                    this.cosb1 = Math.sqrt(1.0 - this.sinb1 * this.sinb1);
                    this.dd = Math.cos(this.phi0) / (Math.sqrt(1.0 - this.es * sinphi * sinphi) * this.rq * this.cosb1);
                    this.xmf = this.rq;
                    this.ymf = this.xmf / this.dd;
                    this.xmf *= this.dd;
                }
            }
        } else if (this.mode == 3) {
            this.sinph0 = Math.sin(this.phi0);
            this.cosph0 = Math.cos(this.phi0);
        }
    }

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        if (this.spherical) {
            this.project_s(lplam, lpphi, out);
        } else {
            this.project_e(lplam, lpphi, out);
        }
        return out;
    }

    public void project_s(double lplam, double lpphi, ProjCoordinate out) {
        double sinphi = Math.sin(lpphi);
        double cosphi = Math.cos(lpphi);
        double coslam = Math.cos(lplam);
        switch (this.mode) {
            case 2: 
            case 3: {
                out.y = this.mode == 2 ? 1.0 + cosphi * coslam : 1.0 + this.sinph0 * sinphi + this.cosph0 * cosphi * coslam;
                if (out.y <= 1.0E-10) {
                    throw new ProjectionException("F");
                }
                out.y = Math.sqrt(2.0 / out.y);
                out.x = out.y * cosphi * Math.sin(lplam);
                out.y = out.y * (this.mode == 2 ? sinphi : this.cosph0 * sinphi - this.sinph0 * cosphi * coslam);
                break;
            }
            case 0: {
                coslam = -coslam;
            }
            case 1: {
                if (Math.abs(lpphi + this.phi0) < 1.0E-10) {
                    throw new ProjectionException("F");
                }
                out.y = 0.7853981633974483 - lpphi * 0.5;
                out.y = 2.0 * (this.mode == 1 ? Math.cos(out.y) : Math.sin(out.y));
                out.x = out.y * Math.sin(lplam);
                out.y *= coslam;
            }
        }
    }

    public void project_e(double lplam, double lpphi, ProjCoordinate out) {
        double sinb = 0.0;
        double cosb = 0.0;
        double b = 0.0;
        double coslam = Math.cos(lplam);
        double sinlam = Math.sin(lplam);
        double sinphi = Math.sin(lpphi);
        double q = ProjectionMath.qsfn(sinphi, this.e, this.one_es);
        if (this.mode == 3 || this.mode == 2) {
            sinb = q / this.qp;
            cosb = Math.sqrt(1.0 - sinb * sinb);
        }
        switch (this.mode) {
            case 3: {
                b = 1.0 + this.sinb1 * sinb + this.cosb1 * cosb * coslam;
                break;
            }
            case 2: {
                b = 1.0 + cosb * coslam;
                break;
            }
            case 0: {
                b = 1.5707963267948966 + lpphi;
                q = this.qp - q;
                break;
            }
            case 1: {
                b = lpphi - 1.5707963267948966;
                q = this.qp + q;
            }
        }
        if (Math.abs(b) < 1.0E-10) {
            throw new ProjectionException("F");
        }
        switch (this.mode) {
            case 2: 
            case 3: {
                if (this.mode == 3) {
                    b = Math.sqrt(2.0 / b);
                    out.y = this.ymf * b * (this.cosb1 * sinb - this.sinb1 * cosb * coslam);
                } else {
                    b = Math.sqrt(2.0 / (1.0 + cosb * coslam));
                    out.y = b * sinb * this.ymf;
                }
                out.x = this.xmf * b * cosb * sinlam;
                break;
            }
            case 0: 
            case 1: {
                if (q >= 0.0) {
                    b = Math.sqrt(q);
                    out.x = b * sinlam;
                    out.y = coslam * (this.mode == 1 ? b : -b);
                    break;
                }
                out.y = 0.0;
                out.x = 0.0;
            }
        }
    }

    @Override
    public ProjCoordinate projectInverse(double xyx, double xyy, ProjCoordinate out) {
        if (this.spherical) {
            this.projectInverse_s(xyx, xyy, out);
        } else {
            this.projectInverse_e(xyx, xyy, out);
        }
        return out;
    }

    public void projectInverse_s(double xyx, double xyy, ProjCoordinate out) {
        double lplam;
        double d;
        double cosz = 0.0;
        double sinz = 0.0;
        double rh = Math.hypot(xyx, xyy);
        double lpphi = rh * 0.5;
        if (d > 1.0) {
            throw new ProjectionException("I_ERROR");
        }
        lpphi = 2.0 * Math.asin(lpphi);
        if (this.mode == 3 || this.mode == 2) {
            sinz = Math.sin(lpphi);
            cosz = Math.cos(lpphi);
        }
        switch (this.mode) {
            case 2: {
                lpphi = Math.abs(rh) <= 1.0E-10 ? 0.0 : Math.asin(xyy * sinz / rh);
                xyx *= sinz;
                xyy = cosz * rh;
                break;
            }
            case 3: {
                lpphi = Math.abs(rh) <= 1.0E-10 ? this.phi0 : Math.asin(cosz * this.sinph0 + xyy * sinz * this.cosph0 / rh);
                xyx *= sinz * this.cosph0;
                xyy = (cosz - Math.sin(lpphi) * this.sinph0) * rh;
                break;
            }
            case 0: {
                xyy = -xyy;
                lpphi = 1.5707963267948966 - lpphi;
                break;
            }
            case 1: {
                lpphi -= 1.5707963267948966;
            }
        }
        out.x = lplam = xyy == 0.0 && (this.mode == 2 || this.mode == 3) ? 0.0 : Math.atan2(xyx, xyy);
        out.y = lpphi;
    }

    public void projectInverse_e(double xyx, double xyy, ProjCoordinate out) {
        double ab = 0.0;
        switch (this.mode) {
            case 2: 
            case 3: {
                double d;
                double rho = Math.hypot(xyx /= this.dd, xyy *= this.dd);
                if (d < 1.0E-10) {
                    double lplam = 0.0;
                    double lpphi = this.phi0;
                    out.x = lplam;
                    out.y = lpphi;
                    return;
                }
                double sCe = 2.0 * Math.asin(0.5 * rho / this.rq);
                double cCe = Math.cos(sCe);
                sCe = Math.sin(sCe);
                xyx *= sCe;
                if (this.mode == 3) {
                    ab = cCe * this.sinb1 + xyy * sCe * this.cosb1 / rho;
                    double q = this.qp * ab;
                    xyy = rho * this.cosb1 * cCe - xyy * this.sinb1 * sCe;
                    break;
                }
                ab = xyy * sCe / rho;
                double q = this.qp * ab;
                xyy = rho * cCe;
                break;
            }
            case 0: {
                xyy = -xyy;
            }
            case 1: {
                double q = xyx * xyx + xyy * xyy;
                if (0.0 == q) {
                    double lplam = 0.0;
                    double lpphi = this.phi0;
                    out.x = lplam;
                    out.y = lpphi;
                    return;
                }
                ab = 1.0 - q / this.qp;
                if (this.mode != 1) break;
                ab = -ab;
            }
        }
        double lplam = Math.atan2(xyx, xyy);
        double lpphi = ProjectionMath.authlat(Math.asin(ab), this.apa);
        out.x = lplam;
        out.y = lpphi;
    }

    @Override
    public boolean isEqualArea() {
        return true;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Lambert Azimuthal Equal Area";
    }
}

