/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Attribute;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.DefaultType;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Element;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementArray;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementList;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementListUnion;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementMapUnion;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementUnion;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Text;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Transient;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Version;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Contact;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ContactList;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Detail;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.MethodContact;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.MethodDetail;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.MethodException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.MethodPart;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.MethodPartFactory;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.MethodScanner$PartMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.MethodType;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Support;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;

class MethodScanner
extends ContactList {
    private final MethodPartFactory factory;
    private final Support support;
    private final MethodScanner$PartMap write;
    private final MethodScanner$PartMap read;
    private final Detail detail;

    public MethodScanner(Detail detail, Support support) {
        this.factory = new MethodPartFactory(detail, support);
        this.write = new MethodScanner$PartMap(null);
        this.read = new MethodScanner$PartMap(null);
        this.support = support;
        this.detail = detail;
        this.scan(detail);
    }

    private void scan(Detail detail) {
        DefaultType defaultType = detail.getOverride();
        DefaultType defaultType2 = detail.getAccess();
        Class clazz = detail.getSuper();
        if (clazz != null) {
            this.extend(clazz, defaultType);
        }
        this.extract(detail, defaultType2);
        this.extract(detail);
        this.build();
        this.validate();
    }

    private void extend(Class clazz, DefaultType defaultType) {
        ContactList contactList = this.support.getMethods(clazz, defaultType);
        for (Contact contact : contactList) {
            this.process((MethodContact)contact);
        }
    }

    private void extract(Detail detail) {
        List list = detail.getMethods();
        for (MethodDetail methodDetail : list) {
            Annotation[] annotationArray = methodDetail.getAnnotations();
            Method method = methodDetail.getMethod();
            for (Annotation annotation : annotationArray) {
                this.scan(method, annotation, annotationArray);
            }
        }
    }

    private void extract(Detail detail, DefaultType defaultType) {
        List list = detail.getMethods();
        if (defaultType == DefaultType.PROPERTY) {
            for (MethodDetail methodDetail : list) {
                Annotation[] annotationArray = methodDetail.getAnnotations();
                Method method = methodDetail.getMethod();
                Class clazz = this.factory.getType(method);
                if (clazz == null) continue;
                this.process(method, annotationArray);
            }
        }
    }

    private void scan(Method method, Annotation annotation, Annotation[] annotationArray) {
        if (annotation instanceof Attribute) {
            this.process(method, annotation, annotationArray);
        }
        if (annotation instanceof ElementUnion) {
            this.process(method, annotation, annotationArray);
        }
        if (annotation instanceof ElementListUnion) {
            this.process(method, annotation, annotationArray);
        }
        if (annotation instanceof ElementMapUnion) {
            this.process(method, annotation, annotationArray);
        }
        if (annotation instanceof ElementList) {
            this.process(method, annotation, annotationArray);
        }
        if (annotation instanceof ElementArray) {
            this.process(method, annotation, annotationArray);
        }
        if (annotation instanceof ElementMap) {
            this.process(method, annotation, annotationArray);
        }
        if (annotation instanceof Element) {
            this.process(method, annotation, annotationArray);
        }
        if (annotation instanceof Version) {
            this.process(method, annotation, annotationArray);
        }
        if (annotation instanceof Text) {
            this.process(method, annotation, annotationArray);
        }
        if (annotation instanceof Transient) {
            this.remove(method, annotation, annotationArray);
        }
    }

    private void process(Method method, Annotation annotation, Annotation[] annotationArray) {
        MethodPart methodPart = this.factory.getInstance(method, annotation, annotationArray);
        MethodType methodType = methodPart.getMethodType();
        if (methodType == MethodType.GET) {
            this.process(methodPart, this.read);
        }
        if (methodType == MethodType.IS) {
            this.process(methodPart, this.read);
        }
        if (methodType == MethodType.SET) {
            this.process(methodPart, this.write);
        }
    }

    private void process(Method method, Annotation[] annotationArray) {
        MethodPart methodPart = this.factory.getInstance(method, annotationArray);
        MethodType methodType = methodPart.getMethodType();
        if (methodType == MethodType.GET) {
            this.process(methodPart, this.read);
        }
        if (methodType == MethodType.IS) {
            this.process(methodPart, this.read);
        }
        if (methodType == MethodType.SET) {
            this.process(methodPart, this.write);
        }
    }

    private void process(MethodPart methodPart, MethodScanner$PartMap methodScanner$PartMap) {
        String string = methodPart.getName();
        if (string != null) {
            methodScanner$PartMap.put(string, methodPart);
        }
    }

    private void process(MethodContact methodContact) {
        MethodPart methodPart = methodContact.getRead();
        MethodPart methodPart2 = methodContact.getWrite();
        if (methodPart2 != null) {
            this.insert(methodPart2, this.write);
        }
        this.insert(methodPart, this.read);
    }

    private void insert(MethodPart methodPart, MethodScanner$PartMap methodScanner$PartMap) {
        String string = methodPart.getName();
        MethodPart methodPart2 = (MethodPart)methodScanner$PartMap.remove(string);
        if (methodPart2 != null && this.isText(methodPart)) {
            methodPart = methodPart2;
        }
        methodScanner$PartMap.put(string, methodPart);
    }

    private boolean isText(MethodPart methodPart) {
        Annotation annotation = methodPart.getAnnotation();
        return annotation instanceof Text;
    }

    private void remove(Method method, Annotation annotation, Annotation[] annotationArray) {
        MethodPart methodPart = this.factory.getInstance(method, annotation, annotationArray);
        MethodType methodType = methodPart.getMethodType();
        if (methodType == MethodType.GET) {
            this.remove(methodPart, this.read);
        }
        if (methodType == MethodType.IS) {
            this.remove(methodPart, this.read);
        }
        if (methodType == MethodType.SET) {
            this.remove(methodPart, this.write);
        }
    }

    private void remove(MethodPart methodPart, MethodScanner$PartMap methodScanner$PartMap) {
        String string = methodPart.getName();
        if (string != null) {
            methodScanner$PartMap.remove(string);
        }
    }

    private void build() {
        for (String string : this.read) {
            MethodPart methodPart = (MethodPart)this.read.get(string);
            if (methodPart == null) continue;
            this.build(methodPart, string);
        }
    }

    private void build(MethodPart methodPart, String string) {
        MethodPart methodPart2 = this.write.take(string);
        if (methodPart2 != null) {
            this.build(methodPart, methodPart2);
        } else {
            this.build(methodPart);
        }
    }

    private void build(MethodPart methodPart) {
        this.add(new MethodContact(methodPart));
    }

    private void build(MethodPart methodPart, MethodPart methodPart2) {
        Annotation annotation = methodPart.getAnnotation();
        String string = methodPart.getName();
        if (!methodPart2.getAnnotation().equals(annotation)) {
            throw new MethodException("Annotations do not match for '%s' in %s", string, this.detail);
        }
        Class clazz = methodPart.getType();
        if (clazz != methodPart2.getType()) {
            throw new MethodException("Method types do not match for %s in %s", string, clazz);
        }
        this.add(new MethodContact(methodPart, methodPart2));
    }

    private void validate() {
        for (String string : this.write) {
            MethodPart methodPart = (MethodPart)this.write.get(string);
            if (methodPart == null) continue;
            this.validate(methodPart, string);
        }
    }

    private void validate(MethodPart methodPart, String string) {
        MethodPart methodPart2 = this.read.take(string);
        Method method = methodPart.getMethod();
        if (methodPart2 == null) {
            throw new MethodException("No matching get method for %s in %s", method, this.detail);
        }
    }
}

