/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SpecProvider;
import org.apache.solr.common.util.CommandOperation;
import org.apache.solr.common.util.ValidatingJsonMap;
import org.apache.solr.security.AuthenticationPlugin;
import org.apache.solr.security.ConfigEditablePlugin;
import org.apache.solr.security.Sha256AuthenticationProvider;
import org.eclipse.jetty.client.api.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthPlugin
extends AuthenticationPlugin
implements ConfigEditablePlugin,
SpecProvider {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private AuthenticationProvider authenticationProvider;
    private static final ThreadLocal<Header> authHeader = new ThreadLocal();
    private static final String X_REQUESTED_WITH_HEADER = "X-Requested-With";
    private boolean blockUnknown = false;
    private boolean forwardCredentials = false;
    public static final String PROPERTY_BLOCK_UNKNOWN = "blockUnknown";
    public static final String PROPERTY_REALM = "realm";
    public static final String FORWARD_CREDENTIALS = "forwardCredentials";
    private static final Set<String> PROPS = ImmutableSet.of((Object)"blockUnknown", (Object)"realm", (Object)"forwardCredentials");

    public boolean authenticate(String username, String pwd) {
        return this.authenticationProvider.authenticate(username, pwd);
    }

    @Override
    public void init(Map<String, Object> pluginConfig) {
        Object o = pluginConfig.get(PROPERTY_BLOCK_UNKNOWN);
        if (o != null) {
            try {
                this.blockUnknown = Boolean.parseBoolean(o.toString());
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid value for parameter blockUnknown");
            }
        }
        if ((o = pluginConfig.get(FORWARD_CREDENTIALS)) != null) {
            try {
                this.forwardCredentials = Boolean.parseBoolean(o.toString());
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid value for parameter forwardCredentials");
            }
        }
        this.authenticationProvider = this.getAuthenticationProvider(pluginConfig);
    }

    @Override
    public Map<String, Object> edit(Map<String, Object> latestConf, List<CommandOperation> commands) {
        for (CommandOperation command : commands) {
            if (!command.name.equals("set-property")) continue;
            for (Map.Entry e : command.getDataMap().entrySet()) {
                if (PROPS.contains(e.getKey())) {
                    latestConf.put((String)e.getKey(), e.getValue());
                    return latestConf;
                }
                command.addError("Unknown property " + (String)e.getKey());
            }
        }
        if (!CommandOperation.captureErrors(commands).isEmpty()) {
            return null;
        }
        if (this.authenticationProvider instanceof ConfigEditablePlugin) {
            ConfigEditablePlugin editablePlugin = (ConfigEditablePlugin)((Object)this.authenticationProvider);
            return editablePlugin.edit(latestConf, commands);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "This cannot be edited");
    }

    protected AuthenticationProvider getAuthenticationProvider(Map<String, Object> pluginConfig) {
        Sha256AuthenticationProvider provider = new Sha256AuthenticationProvider();
        provider.init(pluginConfig);
        return provider;
    }

    private void authenticationFailure(HttpServletResponse response, boolean isAjaxRequest, String message) throws IOException {
        this.getPromptHeaders(isAjaxRequest).forEach((arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1));
        response.sendError(401, message);
    }

    @Override
    public boolean doAuthenticate(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws Exception {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String authHeader = request.getHeader("Authorization");
        boolean isAjaxRequest = BasicAuthPlugin.isAjaxRequest(request);
        if (authHeader != null) {
            String basic;
            BasicAuthPlugin.authHeader.set((Header)new BasicHeader("Authorization", authHeader));
            StringTokenizer st = new StringTokenizer(authHeader);
            if (st.hasMoreTokens() && (basic = st.nextToken()).equalsIgnoreCase("Basic")) {
                if (st.hasMoreTokens()) {
                    try {
                        String credentials = new String(Base64.decodeBase64((String)st.nextToken()), StandardCharsets.UTF_8);
                        int p = credentials.indexOf(":");
                        if (p != -1) {
                            String pwd;
                            final String username = credentials.substring(0, p).trim();
                            if (!this.authenticate(username, pwd = credentials.substring(p + 1).trim())) {
                                this.numWrongCredentials.inc();
                                log.debug("Bad auth credentials supplied in Authorization header");
                                this.authenticationFailure(response, isAjaxRequest, "Bad credentials");
                                return false;
                            }
                            HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper(request){

                                public Principal getUserPrincipal() {
                                    return new BasicAuthUserPrincipal(username, pwd);
                                }
                            };
                            this.numAuthenticated.inc();
                            filterChain.doFilter((ServletRequest)wrapper, (ServletResponse)response);
                            return true;
                        }
                        this.numErrors.mark();
                        this.authenticationFailure(response, isAjaxRequest, "Invalid authentication token");
                        return false;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new Error("Couldn't retrieve authentication", e);
                    }
                }
                this.numErrors.mark();
                this.authenticationFailure(response, isAjaxRequest, "Malformed Basic Auth header");
                return false;
            }
        }
        if (this.blockUnknown) {
            this.numMissingCredentials.inc();
            this.authenticationFailure(response, isAjaxRequest, "require authentication");
            return false;
        }
        this.numPassThrough.inc();
        request.setAttribute(AuthenticationPlugin.class.getName(), this.getPromptHeaders(isAjaxRequest));
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        return true;
    }

    private Map<String, String> getPromptHeaders(boolean isAjaxRequest) {
        HashMap<String, String> headers = new HashMap<String, String>(this.authenticationProvider.getPromptHeaders());
        if (isAjaxRequest && headers.containsKey("WWW-Authenticate") && ((String)headers.get("WWW-Authenticate")).startsWith("Basic ")) {
            headers.put("WWW-Authenticate", "x" + (String)headers.get("WWW-Authenticate"));
            log.debug("Prefixing {} header for Basic Auth with 'x' to prevent browser basic auth popup", (Object)"WWW-Authenticate");
        }
        return headers;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void closeRequest() {
        authHeader.remove();
    }

    @Override
    protected boolean interceptInternodeRequest(HttpRequest httpRequest, HttpContext httpContext) {
        HttpClientContext httpClientContext;
        if (this.forwardCredentials && httpContext instanceof HttpClientContext && (httpClientContext = (HttpClientContext)httpContext).getUserToken() instanceof BasicAuthUserPrincipal) {
            BasicAuthUserPrincipal principal = (BasicAuthUserPrincipal)httpClientContext.getUserToken();
            String userPassBase64 = Base64.encodeBase64String((byte[])(principal.getName() + ":" + principal.getPassword()).getBytes(StandardCharsets.UTF_8));
            httpRequest.setHeader("Authorization", "Basic " + userPassBase64);
            return true;
        }
        return false;
    }

    @Override
    protected boolean interceptInternodeRequest(Request request) {
        Object userToken;
        if (this.forwardCredentials && (userToken = request.getAttributes().get("solr-req-principal")) instanceof BasicAuthUserPrincipal) {
            BasicAuthUserPrincipal principal = (BasicAuthUserPrincipal)userToken;
            String userPassBase64 = Base64.encodeBase64String((byte[])(principal.getName() + ":" + principal.getPassword()).getBytes(StandardCharsets.UTF_8));
            request.header("Authorization", "Basic " + userPassBase64);
            return true;
        }
        return false;
    }

    public ValidatingJsonMap getSpec() {
        return this.authenticationProvider.getSpec();
    }

    public boolean getBlockUnknown() {
        return this.blockUnknown;
    }

    static boolean isAjaxRequest(HttpServletRequest request) {
        return "XMLHttpRequest".equalsIgnoreCase(request.getHeader(X_REQUESTED_WITH_HEADER));
    }

    @Contract(threading=ThreadingBehavior.IMMUTABLE)
    private class BasicAuthUserPrincipal
    implements Principal,
    Serializable {
        private String username;
        private final String password;

        public BasicAuthUserPrincipal(String username, String pwd) {
            this.username = username;
            this.password = pwd;
        }

        @Override
        public String getName() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        @Override
        public boolean implies(Subject subject) {
            return false;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BasicAuthUserPrincipal that = (BasicAuthUserPrincipal)o;
            return Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.username, this.password);
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this).append("username", (Object)this.username).append("pwd", (Object)"*****").toString();
        }
    }

    public static interface AuthenticationProvider
    extends SpecProvider {
        public void init(Map<String, Object> var1);

        public boolean authenticate(String var1, String var2);

        public Map<String, String> getPromptHeaders();
    }
}

