/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.solr.client.solrj.io.ModelCache;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.SolrDefaultStreamFactory;
import org.apache.solr.handler.StreamHandler;
import org.apache.solr.handler.component.SearchHandler;
import org.apache.solr.handler.export.ExportWriter;
import org.apache.solr.handler.export.ExportWriterStream;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricsContext;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportHandler
extends SearchHandler {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ModelCache modelCache = null;
    private ConcurrentMap objectCache = new ConcurrentHashMap();
    private SolrDefaultStreamFactory streamFactory = new ExportHandlerStreamFactory();
    private String coreName;
    private SolrClientCache solrClientCache;
    private StreamContext initialStreamContext;
    private String writerMetricsPath;

    @Override
    public void initializeMetrics(SolrMetricsContext parentContext, String scope) {
        super.initializeMetrics(parentContext, scope);
        this.writerMetricsPath = SolrMetricManager.mkName("writer", this.getCategory().toString(), scope);
    }

    @Override
    public void inform(SolrCore core) {
        super.inform(core);
        CoreContainer coreContainer = core.getCoreContainer();
        this.solrClientCache = coreContainer.getSolrClientCache();
        this.coreName = core.getName();
        if (coreContainer.isZooKeeperAware()) {
            String defaultCollection = core.getCoreDescriptor().getCollectionName();
            String defaultZkhost = core.getCoreContainer().getZkController().getZkServerAddress();
            this.streamFactory.withCollectionZkHost(defaultCollection, defaultZkhost);
            this.streamFactory.withDefaultZkHost(defaultZkhost);
            this.modelCache = new ModelCache(250, defaultZkhost, this.solrClientCache);
        }
        this.streamFactory.withSolrResourceLoader(core.getResourceLoader());
        StreamHandler.addExpressiblePlugins((StreamFactory)this.streamFactory, core);
        this.initialStreamContext = new StreamContext();
        this.initialStreamContext.setStreamFactory((StreamFactory)this.streamFactory);
        this.initialStreamContext.setSolrClientCache(this.solrClientCache);
        this.initialStreamContext.setModelCache(this.modelCache);
        this.initialStreamContext.setObjectCache(this.objectCache);
        this.initialStreamContext.put((Object)"core", (Object)this.coreName);
        this.initialStreamContext.put((Object)"solr-core", (Object)core);
        this.initialStreamContext.put((Object)"exportHandler", (Object)this);
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        try {
            super.handleRequestBody(req, rsp);
        }
        catch (Exception e) {
            rsp.setException(e);
        }
        String wt = req.getParams().get("wt", "json");
        if ("xsort".equals(wt)) {
            wt = "json";
        }
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("wt", "filestream");
        req.setParams(SolrParams.wrapDefaults((SolrParams)new MapSolrParams(map), (SolrParams)req.getParams()));
        rsp.add("filestream", new ExportWriter(req, rsp, wt, this.initialStreamContext, this.solrMetricsContext, this.writerMetricsPath, this));
    }

    public static class ExportHandlerStreamFactory
    extends SolrDefaultStreamFactory {
        static final String[] forbiddenStreams = new String[]{"search", "facet", "facet2D", "update", "delete", "jdbc", "topic", "commit", "random", "knnSearch", "parallel", "executor", "daemon"};

        public ExportHandlerStreamFactory() {
            for (String function : forbiddenStreams) {
                this.withoutFunctionName(function);
            }
            this.withFunctionName("input", ExportWriterStream.class);
        }
    }
}

