/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.util.function.BooleanConsumer;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValueStream;
import org.apache.solr.common.SolrException;

class BooleanStreamFillMissingFunction
extends BooleanValueStream.AbstractBooleanValueStream
implements BooleanConsumer {
    private final BooleanValueStream baseExpr;
    private final BooleanValueStream fillExpr;
    public static final String name = "fill_missing";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;
    boolean exists = false;
    BooleanConsumer cons;

    public BooleanStreamFillMissingFunction(BooleanValueStream baseExpr, BooleanValueStream fillExpr) throws SolrException {
        this.baseExpr = baseExpr;
        this.fillExpr = fillExpr;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, baseExpr, fillExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, fillExpr);
    }

    @Override
    public void streamBooleans(BooleanConsumer cons) {
        this.exists = false;
        this.cons = cons;
        this.baseExpr.streamBooleans(this);
        if (!this.exists) {
            this.fillExpr.streamBooleans(cons);
        }
    }

    @Override
    public void accept(boolean value) {
        this.exists = true;
        this.cons.accept(value);
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

