/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.security.access.hierarchicalroles.NullRoleHierarchy;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.acls.domain.GrantedAuthoritySid;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.Sid;
import org.springframework.security.acls.model.SidRetrievalStrategy;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;

public class SidRetrievalStrategyImpl
implements SidRetrievalStrategy {
    private RoleHierarchy roleHierarchy = new NullRoleHierarchy();

    public SidRetrievalStrategyImpl() {
    }

    public SidRetrievalStrategyImpl(RoleHierarchy roleHierarchy) {
        Assert.notNull((Object)roleHierarchy, "RoleHierarchy must not be null");
        this.roleHierarchy = roleHierarchy;
    }

    @Override
    public List<Sid> getSids(Authentication authentication) {
        Collection<? extends GrantedAuthority> authorities = this.roleHierarchy.getReachableGrantedAuthorities(authentication.getAuthorities());
        ArrayList<Sid> sids = new ArrayList<Sid>(authorities.size() + 1);
        sids.add(new PrincipalSid(authentication));
        for (GrantedAuthority grantedAuthority : authorities) {
            sids.add(new GrantedAuthoritySid(grantedAuthority));
        }
        return sids;
    }
}

