/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.common;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.TimeZone;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructField;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.BigDecimal;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class SparkQueryTest$ {
    public static SparkQueryTest$ MODULE$;

    static {
        new SparkQueryTest$();
    }

    public String checkAnswer(Dataset<Row> sparkDF, Dataset<Row> kylinAnswer, boolean checkOrder) {
        String string;
        Option<String> option = this.checkAnswerBySeq(this.castDataType(sparkDF, kylinAnswer), (Seq<Row>)Predef$.MODULE$.wrapRefArray((Object[])kylinAnswer.collect()), kylinAnswer, checkOrder, this.checkAnswerBySeq$default$5());
        if (option instanceof Some) {
            String errorMessage;
            Some some = (Some)option;
            string = errorMessage = (String)some.value();
        } else if (None$.MODULE$.equals(option)) {
            string = null;
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    public boolean checkAnswer$default$3() {
        return false;
    }

    public Option<String> checkAnswerBySeq(Dataset<Row> sparkDF, Seq<Row> kylinAnswer, Dataset<Row> kylinDF, boolean checkOrder, boolean checkToRDD) {
        Seq seq;
        Object object = checkToRDD ? BoxesRunTime.boxToLong((long)sparkDF.rdd().count()) : BoxedUnit.UNIT;
        try {
            seq = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkDF.collect())).toSeq();
        }
        catch (Exception e) {
            String errorMessage = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(190).append("\n                       |Exception thrown while executing query:\n                       |").append(kylinDF.queryExecution()).append("\n                       |== Exception ==\n                       |").append(e).append("\n                       |").append(org.apache.spark.sql.catalyst.util.package$.MODULE$.stackTraceToString((Throwable)e)).append("\n          ").toString())).stripMargin();
            return new Some((Object)errorMessage);
        }
        Seq sparkAnswer = seq;
        return this.sameRows((Seq<Row>)sparkAnswer, kylinAnswer, checkOrder).map((Function1 & Serializable & scala.Serializable)results -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(195).append("\n               |Results do not match for query:\n               |Timezone: ").append(TimeZone.getDefault()).append("\n               |Timezone Env: ").append(scala.sys.package$.MODULE$.env().getOrElse((Object)"TZ", (Function0 & Serializable & scala.Serializable)() -> "")).append("\n               |\n               |").append(kylinDF.queryExecution()).append("\n               |== Results ==\n               |").append((String)results).append("\n       ").toString())).stripMargin());
    }

    public boolean checkAnswerBySeq$default$4() {
        return false;
    }

    public boolean checkAnswerBySeq$default$5() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Row> prepareAnswer(Seq<Row> answer, boolean isSorted) {
        void var3_3;
        Seq converted = (Seq)answer.map((Function1 & Serializable & scala.Serializable)row -> MODULE$.prepareRow((Row)row), Seq$.MODULE$.canBuildFrom());
        return !isSorted ? (Seq)converted.sortBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString(), (Ordering)Ordering.String$.MODULE$) : var3_3;
    }

    public Row prepareRow(Row row) {
        return Row$.MODULE$.fromSeq((Seq)row.toSeq().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            void var1_11;
            boolean bl = false;
            double d = 0.0;
            Object object = x0$1;
            if (object == null) {
                return var1_11;
            }
            if (object instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)object;
                scala.math.BigDecimal bigDecimal2 = scala.package$.MODULE$.BigDecimal().apply(bigDecimal).setScale(2, BigDecimal.RoundingMode$.MODULE$.HALF_UP());
                return var1_11;
            }
            if (object instanceof Double) {
                bl = true;
                d = BoxesRunTime.unboxToDouble((Object)object);
                if (Double.isNaN(d) || Double.isInfinite(d)) {
                    None$ none$ = None$.MODULE$;
                    return var1_11;
                }
            }
            if (bl) {
                Double d2 = BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(scala.package$.MODULE$.BigDecimal().apply(d).setScale(2, BigDecimal.RoundingMode$.MODULE$.HALF_UP()).toString())).toDouble());
                return var1_11;
            }
            if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
                Object object2 = object;
                Seq seq = Predef$.MODULE$.genericArrayOps(object2).toSeq();
                return var1_11;
            }
            if (object instanceof Row) {
                Row row = (Row)object;
                Row row2 = MODULE$.prepareRow(row);
                return var1_11;
            }
            Object object3 = object;
            return var1_11;
        }, Seq$.MODULE$.canBuildFrom()));
    }

    public Option<String> sameRows(Seq<Row> sparkAnswer, Seq<Row> kylinAnswer, boolean isSorted) {
        Seq<Row> sparkResults = this.prepareAnswer(sparkAnswer, isSorted);
        Seq<Row> kylinResults = this.prepareAnswer(kylinAnswer, isSorted);
        Seq<Row> seq = sparkResults;
        Seq<Row> seq2 = kylinResults;
        if (seq == null ? seq2 != null : !seq.equals(seq2)) {
            String string = new StringBuilder(24).append("== Expected Answer - ").append(kylinAnswer.size()).append(" ==").toString();
            String string2 = new StringBuilder(21).append("== Kylin Answer - ").append(sparkAnswer.size()).append(" ==").toString();
            String errorMessage = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(72).append("\n                   |== Results ==\n                   |").append(org.apache.spark.sql.catalyst.util.package$.MODULE$.sideBySide((Seq)((SeqLike)kylinResults.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString(), Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom()), (Seq)((SeqLike)sparkResults.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toString(), Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)string2, Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n                ").toString())).stripMargin();
            return new Some((Object)errorMessage);
        }
        return None$.MODULE$;
    }

    public boolean sameRows$default$3() {
        return false;
    }

    public void checkAggregatesWithTol(Row actualAnswer, Row expectedAnswer, double absTol) {
        Predef$.MODULE$.require(actualAnswer.length() == expectedAnswer.length(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("actual answer length ").append(actualAnswer.length()).append(" != ").append("expected answer length ").append(expectedAnswer.length()).toString());
        ((IterableLike)actualAnswer.toSeq().zip((GenIterable)expectedAnswer.toSeq(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SparkQueryTest$.$anonfun$checkAggregatesWithTol$2(absTol, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public Dataset<Row> castDataType(Dataset<Row> sparkResult, Dataset<Row> cubeResult) {
        Seq newNames = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkResult.schema().names())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)name -> new StringBuilder(1).append(((String)name._1()).replaceAll("\\.", "_")).append("_").append(name._2$mcI$sp()).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSeq();
        Dataset newDf = sparkResult.toDF(newNames);
        Seq columns = (Seq)((TraversableLike)newDf.schema().zip((GenIterable)cubeResult.schema(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StructField sparkField = (StructField)tuple2._1();
            StructField kylinField = (StructField)tuple2._2();
            Column column = !sparkField.dataType().sameType(kylinField.dataType()) ? functions$.MODULE$.col(sparkField.name()).cast(kylinField.dataType()) : functions$.MODULE$.col(sparkField.name());
            return column;
        }, Seq$.MODULE$.canBuildFrom());
        return newDf.select(columns);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$checkAggregatesWithTol$2(double absTol$1, Tuple2 x0$1) {
        Object expected;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Object actual = tuple2._1();
            Object expected2 = tuple2._2();
            if (actual instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)actual);
                if (expected2 instanceof Double) {
                    double d2 = BoxesRunTime.unboxToDouble((Object)expected2);
                    Predef$.MODULE$.assert(package$.MODULE$.abs(d - d2) < absTol$1, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("actual answer ").append(d).append(" not within ").append(absTol$1).append(" of correct answer ").append(d2).toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Object actual = tuple2._1();
        Predef$.MODULE$.assert(BoxesRunTime.equals((Object)actual, (Object)(expected = tuple2._2())), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append(actual).append(" did not equal ").append(expected).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private SparkQueryTest$() {
        MODULE$ = this;
    }
}

