/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.kylin.common.BackwardCompatibilityConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.shaded.com.google.common.collect.Maps;

public class KylinConfigCLI {
    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: KylinConfigCLI conf_name");
            System.err.println("Example: KylinConfigCLI kylin.server.mode");
            System.exit(1);
        }
        Properties config = KylinConfig.getInstanceFromEnv().exportToProperties();
        BackwardCompatibilityConfig bcc = new BackwardCompatibilityConfig();
        String key = bcc.check(args[0].trim());
        if (!key.endsWith(".")) {
            String value = config.getProperty(key);
            if (value == null) {
                value = "";
            }
            System.out.println(value.trim());
        } else {
            Map<String, String> props = KylinConfigCLI.getPropertiesByPrefix(config, key);
            for (Map.Entry<String, String> prop : props.entrySet()) {
                System.out.println(prop.getKey() + "=" + prop.getValue().trim());
            }
        }
    }

    private static Map<String, String> getPropertiesByPrefix(Properties props, String prefix) {
        LinkedHashMap<String, String> result = Maps.newLinkedHashMap();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String entryKey = (String)entry.getKey();
            if (!entryKey.startsWith(prefix)) continue;
            result.put(entryKey.substring(prefix.length()), (String)entry.getValue());
        }
        return result;
    }
}

