/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security.cas;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.rest.security.KylinUserManager;
import org.apache.kylin.rest.security.ManagedUser;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.validation.Assertion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.cas.userdetails.AbstractCasAssertionUserDetailsService;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class CasUserDetailsService
extends AbstractCasAssertionUserDetailsService {
    private static final Logger logger = LoggerFactory.getLogger(CasUserDetailsService.class);
    private static final String NON_EXISTENT_PASSWORD_VALUE = "NO_PASSWORD";
    private String[] defaultAuthorities = new String[]{"ALL_USERS"};

    public void setDefaultAuthorities(String[] defaultAuthorities) {
        this.defaultAuthorities = defaultAuthorities;
    }

    protected UserDetails loadUserDetails(Assertion assertion) {
        if (assertion == null) {
            throw new CredentialsExpiredException("bad assertion");
        }
        ManagedUser user = this.parseUserDetails(assertion);
        KylinUserManager kylinUserManager = KylinUserManager.getInstance(KylinConfig.getInstanceFromEnv());
        ManagedUser existUser = kylinUserManager.get(user.getUsername());
        if (existUser == null) {
            kylinUserManager.update(user);
        }
        return kylinUserManager.get(user.getUsername());
    }

    protected ManagedUser parseUserDetails(Assertion assertion) {
        AttributePrincipal principal = assertion.getPrincipal();
        List grantedAuthorities = Stream.of(this.defaultAuthorities).map(SimpleGrantedAuthority::new).collect(Collectors.toList());
        return new ManagedUser(principal.getName(), NON_EXISTENT_PASSWORD_VALUE, (Boolean)true, grantedAuthorities);
    }
}

