/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QueryModelPriorities {
    private static final Pattern MODEL_PRIORITY_PATTERN = Pattern.compile("SELECT\\W+/\\*\\+\\W*(.+)\\*/");
    private static final String MODEL_PRIOPITY_INDEX = "model_priority(";

    private QueryModelPriorities() {
    }

    private static String getHint(String sql) {
        Matcher matcher = MODEL_PRIORITY_PATTERN.matcher(sql.toUpperCase(Locale.ROOT));
        if (matcher.find()) {
            return matcher.group(1).trim();
        }
        return "";
    }

    public static String[] getCubePrioritiesFromComment(String sql) {
        String hint = QueryModelPriorities.getHint(sql).toLowerCase(Locale.ROOT);
        if (hint.isEmpty() || hint.indexOf(MODEL_PRIOPITY_INDEX) != 0) {
            return new String[0];
        }
        String[] modelHints = hint.replace(MODEL_PRIOPITY_INDEX, "").replace(")", "").split(",");
        for (int i = 0; i < modelHints.length; ++i) {
            modelHints[i] = modelHints[i].trim();
        }
        return modelHints;
    }
}

