/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.execution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.lock.DistributedLockFactory;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ChainedExecutable;
import org.apache.kylin.job.execution.Executable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.execution.Output;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;

public class DefaultChainedExecutable
extends AbstractExecutable
implements ChainedExecutable {
    public static final Integer DEFAULT_PRIORITY = 10;
    private final List<AbstractExecutable> subTasks = Lists.newArrayList();

    @Override
    protected void initConfig(KylinConfig config) {
        super.initConfig(config);
        for (AbstractExecutable sub : this.subTasks) {
            sub.initConfig(config);
        }
    }

    @Override
    public void setProjectName(String name) {
        this.setParam("project", name);
    }

    @Override
    public String getProjectName() {
        return this.getParam("project");
    }

    public long getMapReduceWaitTime() {
        return this.getExtraInfoAsLong("mapReduceWaitTime", 0L);
    }

    public void setMapReduceWaitTime(long t) {
        this.addExtraInfo("mapReduceWaitTime", t + "");
    }

    public Set<String> getMetadataDumpList(KylinConfig config) {
        return Collections.emptySet();
    }

    @Override
    protected ExecuteResult doWork(ExecutableContext context) throws ExecuteException {
        Executable subTask;
        ExecutableState state;
        List<AbstractExecutable> executables = this.getTasks();
        int size = executables.size();
        for (int i = 0; i < size && (state = (subTask = (Executable)executables.get(i)).getStatus()) != ExecutableState.RUNNING && state != ExecutableState.STOPPED; ++i) {
            if (state == ExecutableState.ERROR) {
                throw new IllegalStateException("invalid subtask state, subtask:" + subTask.getName() + ", state:" + (Object)((Object)subTask.getStatus()));
            }
            if (!subTask.isRunnable()) continue;
            return subTask.execute(context);
        }
        return new ExecuteResult(ExecuteResult.State.SUCCEED);
    }

    @Override
    protected void onExecuteStart(ExecutableContext executableContext) {
        long startTime = this.getStartTime();
        if (startTime > 0L) {
            this.getManager().updateJobOutput(this.getParam("project"), this.getId(), ExecutableState.RUNNING, null, null, this.getLogPath());
        } else {
            HashMap<String, String> info = Maps.newHashMap();
            info.put("startTime", Long.toString(System.currentTimeMillis()));
            this.getManager().updateJobOutput(this.getParam("project"), this.getId(), ExecutableState.RUNNING, info, null, this.getLogPath());
        }
        this.getManager().addJobInfo(this.getId(), "buildInstance", DistributedLockFactory.processAndHost());
    }

    @Override
    protected void onExecuteError(Throwable exception, ExecutableContext executableContext) {
        super.onExecuteError(exception, executableContext);
        this.onStatusChange(executableContext, ExecuteResult.createError(exception), ExecutableState.ERROR);
    }

    @Override
    protected void onExecuteFinished(ExecuteResult result, ExecutableContext executableContext) {
        ExecutableManager mgr = this.getManager();
        if (this.isDiscarded()) {
            this.setEndTime(System.currentTimeMillis());
            this.onStatusChange(executableContext, result, ExecutableState.DISCARDED);
        } else if (this.isPaused()) {
            this.setEndTime(System.currentTimeMillis());
            this.onStatusChange(executableContext, result, ExecutableState.STOPPED);
        } else if (result.succeed()) {
            List<AbstractExecutable> jobs = this.getTasks();
            boolean allSucceed = true;
            boolean hasError = false;
            boolean hasDiscarded = false;
            for (Executable executable : jobs) {
                ExecutableState status;
                if (executable.getStatus() == ExecutableState.RUNNING) {
                    logger.error("There shouldn't be a running subtask[jobId: {}, jobName: {}], \nit might cause endless state, will retry to fetch subtask's state.", (Object)executable.getId(), (Object)executable.getName());
                    this.getManager().updateJobOutput(this.getParam("project"), executable.getId(), ExecutableState.ERROR, null, "killed due to inconsistent state", this.getLogPath());
                    hasError = true;
                }
                if ((status = executable.getStatus()) == ExecutableState.ERROR) {
                    hasError = true;
                }
                if (status != ExecutableState.SUCCEED) {
                    allSucceed = false;
                }
                if (status != ExecutableState.DISCARDED) continue;
                hasDiscarded = true;
            }
            if (allSucceed) {
                this.setEndTime(System.currentTimeMillis());
                mgr.updateJobOutput(this.getParam("project"), this.getId(), ExecutableState.SUCCEED, null, null, this.getLogPath());
                this.onStatusChange(executableContext, result, ExecutableState.SUCCEED);
            } else if (hasError) {
                this.setEndTime(System.currentTimeMillis());
                mgr.updateJobOutput(this.getParam("project"), this.getId(), ExecutableState.ERROR, null, null, this.getLogPath());
                this.onStatusChange(executableContext, result, ExecutableState.ERROR);
            } else if (hasDiscarded) {
                this.setEndTime(System.currentTimeMillis());
                mgr.updateJobOutput(this.getParam("project"), this.getId(), ExecutableState.DISCARDED, null, null, this.getLogPath());
            } else {
                mgr.updateJobOutput(this.getParam("project"), this.getId(), ExecutableState.READY, null, null, this.getLogPath());
            }
        } else {
            this.setEndTime(System.currentTimeMillis());
            mgr.updateJobOutput(this.getParam("project"), this.getId(), ExecutableState.ERROR, null, result.output(), this.getLogPath());
            this.onStatusChange(executableContext, result, ExecutableState.ERROR);
        }
    }

    protected void onStatusChange(ExecutableContext context, ExecuteResult result, ExecutableState state) {
        super.notifyUserStatusChange(context, state);
    }

    public List<AbstractExecutable> getTasks() {
        return this.subTasks;
    }

    public final AbstractExecutable getTaskByName(String name) {
        for (AbstractExecutable task : this.subTasks) {
            if (task.getName() == null || !task.getName().equalsIgnoreCase(name)) continue;
            return task;
        }
        return null;
    }

    @Override
    public void addTask(AbstractExecutable executable) {
        executable.setParentExecutable(this);
        executable.setParent(this);
        executable.setId(this.getId() + "-" + String.format(Locale.ROOT, "%02d", this.subTasks.size()));
        this.subTasks.add(executable);
    }

    @Override
    public int getDefaultPriority() {
        return DEFAULT_PRIORITY;
    }

    public String findExtraInfo(String key, String dft) {
        return this.findExtraInfo(key, dft, false);
    }

    public String findExtraInfoBackward(String key, String dft) {
        return this.findExtraInfo(key, dft, true);
    }

    private String findExtraInfo(String key, String dft, boolean backward) {
        ArrayList<AbstractExecutable> tasks = new ArrayList<AbstractExecutable>(this.getTasks());
        if (backward) {
            Collections.reverse(tasks);
        }
        for (AbstractExecutable child : tasks) {
            Output output = this.getManager().getOutput(child.getId());
            String value = output.getExtra().get(key);
            if (value == null) continue;
            return value;
        }
        return dft;
    }

    @Override
    public <T extends AbstractExecutable> T getTask(Class<T> clz) {
        List<AbstractExecutable> tasks = this.getTasks();
        for (AbstractExecutable task : tasks) {
            if (!task.getClass().equals(clz)) continue;
            return (T)task;
        }
        return null;
    }
}

