/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.persistence.WriteConflictException;
import org.apache.kylin.common.util.AutoReadWriteLock;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.CubeUpdate;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.SnapshotTableDesc;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.cachesync.Broadcaster;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.cachesync.CaseInsensitiveStringCache;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.project.RealizationEntry;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.IRealizationProvider;
import org.apache.kylin.metadata.realization.RealizationRegistry;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.source.SourcePartition;
import org.apache.kylin.tool.shaded.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeManager
implements IRealizationProvider {
    private static String ALPHA_NUM = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static int HBASE_TABLE_LENGTH = 10;
    private static int PARQUET_IDENTIFIER_LENGTH = 3;
    public static final Serializer<CubeInstance> CUBE_SERIALIZER = new JsonSerializer<CubeInstance>(CubeInstance.class);
    private static final Logger logger = LoggerFactory.getLogger(CubeManager.class);
    private KylinConfig config;
    private CaseInsensitiveStringCache<CubeInstance> cubeMap;
    private CachedCrudAssist<CubeInstance> crud;
    private AutoReadWriteLock cubeMapLock = new AutoReadWriteLock();
    private ConcurrentMap<String, String> usedStorageLocation = new ConcurrentHashMap<String, String>();
    private SegmentAssist segAssist = new SegmentAssist();
    private Random ran = new Random();

    public static CubeManager getInstance(KylinConfig config) {
        return config.getManager(CubeManager.class);
    }

    static CubeManager newInstance(KylinConfig config) throws IOException {
        return new CubeManager(config);
    }

    private CubeManager(KylinConfig cfg) throws IOException {
        logger.info("Initializing CubeManager with config {}", (Object)cfg);
        this.config = cfg;
        this.cubeMap = new CaseInsensitiveStringCache(this.config, "cube");
        this.crud = new CachedCrudAssist<CubeInstance>(this.getStore(), "/cube", CubeInstance.class, this.cubeMap){

            @Override
            protected CubeInstance initEntityAfterReload(CubeInstance cube, String resourceName) {
                cube.init(CubeManager.this.config);
                for (CubeSegment segment : cube.getSegments()) {
                    CubeManager.this.usedStorageLocation.put(segment.getUuid(), segment.getStorageLocationIdentifier());
                }
                return cube;
            }
        };
        this.crud.setCheckCopyOnWrite(true);
        this.crud.reloadAll();
        Broadcaster.getInstance(this.config).registerListener(new CubeSyncListener(), "cube");
    }

    public List<CubeInstance> listAllCubes() {
        try (AutoReadWriteLock.AutoLock lock = this.cubeMapLock.lockForRead();){
            ArrayList<CubeInstance> arrayList = new ArrayList<CubeInstance>(this.cubeMap.values());
            return arrayList;
        }
    }

    public List<CubeInstance> reloadAndListAllCubes() throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.cubeMapLock.lockForWrite();){
            this.crud.reloadAll();
        }
        return this.listAllCubes();
    }

    public CubeInstance getCube(String cubeName) {
        try (AutoReadWriteLock.AutoLock lock = this.cubeMapLock.lockForRead();){
            CubeInstance cubeInstance = (CubeInstance)this.cubeMap.get(cubeName);
            return cubeInstance;
        }
    }

    public CubeInstance getCubeByUuid(String uuid) {
        try (AutoReadWriteLock.AutoLock lock = this.cubeMapLock.lockForRead();){
            for (CubeInstance cube : this.cubeMap.values()) {
                if (!uuid.equals(cube.getUuid())) continue;
                CubeInstance cubeInstance = cube;
                return cubeInstance;
            }
            Iterator iterator = null;
            return iterator;
        }
    }

    public List<String> getErrorCubes() {
        return this.crud.getLoadFailedEntities();
    }

    public List<CubeInstance> getCubesByDesc(String descName) {
        try (AutoReadWriteLock.AutoLock lock = this.cubeMapLock.lockForRead();){
            List<CubeInstance> list = this.listAllCubes();
            ArrayList<CubeInstance> result = new ArrayList<CubeInstance>();
            for (CubeInstance ci : list) {
                if (!descName.equalsIgnoreCase(ci.getDescName())) continue;
                result.add(ci);
            }
            ArrayList<CubeInstance> arrayList = result;
            return arrayList;
        }
    }

    public CubeInstance createCube(String cubeName, String projectName, CubeDesc desc, String owner) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.cubeMapLock.lockForWrite();){
            logger.info("Creating cube '{}-->{}' from desc '{}'", projectName, cubeName, desc.getName());
            CubeInstance cube = CubeInstance.create(cubeName, desc);
            cube.setOwner(owner);
            this.updateCubeWithRetry(new CubeUpdate(cube), 0);
            ProjectManager.getInstance(this.config).moveRealizationToProject(RealizationType.CUBE, cubeName, projectName, owner);
            CubeInstance cubeInstance = cube;
            return cubeInstance;
        }
    }

    public CubeInstance createCube(CubeInstance cube, String projectName, String owner) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.cubeMapLock.lockForWrite();){
            logger.info("Creating cube '{}-->{}' from instance object. '", (Object)projectName, (Object)cube.getName());
            cube.setOwner(owner);
            this.updateCubeWithRetry(new CubeUpdate(cube), 0);
            ProjectManager.getInstance(this.config).moveRealizationToProject(RealizationType.CUBE, cube.getName(), projectName, owner);
            CubeInstance cubeInstance = cube;
            return cubeInstance;
        }
    }

    public CubeInstance clearSegments(CubeInstance cube) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.cubeMapLock.lockForWrite();){
            cube = cube.latestCopyForWrite();
            CubeUpdate update = new CubeUpdate(cube);
            update.setToRemoveSegs(cube.getSegments().toArray((CubeSegment[])new CubeSegment[cube.getSegments().size()]));
            update.setCuboids(Maps.newHashMap());
            update.setCuboidsRecommend(Sets.newHashSet());
            update.setUpdateTableSnapshotPath(Maps.newHashMap());
            update.setCreateTimeUTC(System.currentTimeMillis());
            update.setCuboidLastOptimized(0L);
            CubeInstance cubeInstance = this.updateCube(update);
            return cubeInstance;
        }
    }

    public CubeInstance updateCube(CubeUpdate update) throws IOException {
        return this.updateCube(update, false);
    }

    public CubeInstance updateCube(CubeUpdate update, boolean isLocal) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.cubeMapLock.lockForWrite();){
            CubeInstance cube;
            CubeInstance cubeInstance = cube = this.updateCubeWithRetry(update, 0, isLocal);
            return cubeInstance;
        }
    }

    public CubeInstance updateCubeStatus(CubeInstance cube, RealizationStatusEnum newStatus) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.cubeMapLock.lockForWrite();){
            cube = cube.latestCopyForWrite();
            CubeUpdate update = new CubeUpdate(cube);
            update.setStatus(newStatus);
            ProjectManager.getInstance(this.config).touchProject(cube.getProject());
            CubeInstance cubeInstance = this.updateCube(update);
            return cubeInstance;
        }
    }

    public CubeInstance updateCubeOwner(CubeInstance cube, String owner) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.cubeMapLock.lockForWrite();){
            cube = cube.latestCopyForWrite();
            CubeUpdate update = new CubeUpdate(cube);
            update.setOwner(owner);
            ProjectManager.getInstance(this.config).touchProject(cube.getProject());
            CubeInstance cubeInstance = this.updateCube(update);
            return cubeInstance;
        }
    }

    public CubeInstance updateCubeDropSegments(CubeInstance cube, Collection<CubeSegment> segsToDrop) throws IOException {
        CubeSegment[] arr = segsToDrop.toArray(new CubeSegment[segsToDrop.size()]);
        return this.updateCubeDropSegments(cube, arr);
    }

    public CubeInstance updateCubeDropSegments(CubeInstance cube, CubeSegment ... segsToDrop) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.cubeMapLock.lockForWrite();){
            cube = cube.latestCopyForWrite();
            CubeUpdate update = new CubeUpdate(cube);
            update.setToRemoveSegs(segsToDrop);
            CubeInstance cubeInstance = this.updateCube(update);
            return cubeInstance;
        }
    }

    public CubeInstance dropOptmizingSegments(CubeInstance cube, CubeSegment ... segsToDrop) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.cubeMapLock.lockForWrite();){
            cube = cube.latestCopyForWrite();
            CubeUpdate update = new CubeUpdate(cube);
            update.setToRemoveSegs(segsToDrop);
            update.setCuboidsRecommend(Sets.newHashSet());
            CubeInstance cubeInstance = this.updateCube(update);
            return cubeInstance;
        }
    }

    public CubeInstance updateCubeSegStatus(CubeSegment seg, SegmentStatusEnum status) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.cubeMapLock.lockForWrite();){
            CubeInstance cube = seg.getCubeInstance().latestCopyForWrite();
            seg = cube.getSegmentById(seg.getUuid());
            CubeUpdate update = new CubeUpdate(cube);
            seg.setStatus(status);
            update.setToUpdateSegs(seg);
            CubeInstance cubeInstance = this.updateCube(update);
            return cubeInstance;
        }
    }

    public CubeInstance updateCubeLookupSnapshot(CubeInstance cube, String lookupTableName, String newSnapshotResPath) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.cubeMapLock.lockForWrite();){
            cube = cube.latestCopyForWrite();
            CubeUpdate update = new CubeUpdate(cube);
            HashMap<String, String> map = Maps.newHashMap();
            map.put(lookupTableName, newSnapshotResPath);
            update.setUpdateTableSnapshotPath(map);
            CubeInstance cubeInstance = this.updateCube(update);
            return cubeInstance;
        }
    }

    private CubeInstance updateCubeWithRetry(CubeUpdate update, int retry) throws IOException {
        return this.updateCubeWithRetry(update, retry, false);
    }

    private CubeInstance updateCubeWithRetry(CubeUpdate update, int retry, boolean isLocal) throws IOException {
        if (update == null || update.getCubeInstance() == null) {
            throw new IllegalStateException();
        }
        CubeInstance cube = update.getCubeInstance();
        logger.info("Updating cube instance '{}'", (Object)cube.getName());
        Segments newSegs = (Segments)cube.getSegments().clone();
        if (update.getToAddSegs() != null) {
            newSegs.addAll(Arrays.asList(update.getToAddSegs()));
        }
        ArrayList<String> toRemoveResources = Lists.newArrayList();
        if (update.getToRemoveSegs() != null) {
            this.processToRemoveSegments(update, newSegs, toRemoveResources);
        }
        if (update.getToUpdateSegs() != null) {
            this.processToUpdateSegments(update, newSegs);
        }
        Collections.sort(newSegs);
        newSegs.validate();
        cube.setSegments(newSegs);
        this.setCubeMember(cube, update);
        try {
            cube = this.crud.save(cube, isLocal);
        }
        catch (WriteConflictException ise) {
            logger.warn("Write conflict to update cube {} at try {}, will retry...", (Object)cube.getName(), (Object)retry);
            if (retry >= 7) {
                logger.error("Retried 7 times till got error, abandoning...", ise);
                throw ise;
            }
            cube = this.crud.reload(cube.getName());
            update.setCubeInstance(cube.latestCopyForWrite());
            return this.updateCubeWithRetry(update, ++retry);
        }
        for (String resource : toRemoveResources) {
            try {
                this.getStore().deleteResource(resource);
            }
            catch (IOException ioe) {
                logger.error("Failed to delete resource {}", (Object)toRemoveResources);
            }
        }
        ProjectManager.getInstance(cube.getConfig()).clearL2Cache(cube.getProject());
        return cube;
    }

    private void setCubeMember(CubeInstance cube, CubeUpdate update) {
        if (update.getStatus() != null) {
            cube.setStatus(update.getStatus());
        }
        if (update.getOwner() != null) {
            cube.setOwner(update.getOwner());
        }
        if (update.getCost() > 0) {
            cube.setCost(update.getCost());
        }
        if (update.getCuboids() != null) {
            cube.setCuboids(update.getCuboids());
        }
        if (update.getCuboidsRecommend() != null) {
            cube.setCuboidsRecommend(update.getCuboidsRecommend());
        }
        if (update.getUpdateTableSnapshotPath() != null) {
            for (Map.Entry<String, String> lookupSnapshotPathEntry : update.getUpdateTableSnapshotPath().entrySet()) {
                cube.putSnapshotResPath(lookupSnapshotPathEntry.getKey(), lookupSnapshotPathEntry.getValue());
            }
        }
        if (update.getCreateTimeUTC() >= 0L) {
            cube.setCreateTimeUTC(update.getCreateTimeUTC());
        }
        if (update.getCuboidLastOptimized() >= 0L) {
            cube.setCuboidLastOptimized(update.getCuboidLastOptimized());
        }
    }

    private void processToUpdateSegments(CubeUpdate update, Segments<CubeSegment> newSegs) {
        block0: for (CubeSegment segment : update.getToUpdateSegs()) {
            for (int i = 0; i < newSegs.size(); ++i) {
                if (!((CubeSegment)newSegs.get(i)).getUuid().equals(segment.getUuid())) continue;
                newSegs.set(i, segment);
                continue block0;
            }
        }
    }

    private void processToRemoveSegments(CubeUpdate update, Segments<CubeSegment> newSegs, List<String> toRemoveResources) {
        Iterator iterator = newSegs.iterator();
        block0: while (iterator.hasNext()) {
            CubeSegment currentSeg = (CubeSegment)iterator.next();
            for (CubeSegment toRemoveSeg : update.getToRemoveSegs()) {
                if (!currentSeg.getUuid().equals(toRemoveSeg.getUuid())) continue;
                logger.info("Remove segment {}", (Object)currentSeg);
                toRemoveResources.add(currentSeg.getStatisticsResourcePath());
                iterator.remove();
                continue block0;
            }
        }
    }

    public CubeInstance reloadCube(String cubeName) {
        try (AutoReadWriteLock.AutoLock lock = this.cubeMapLock.lockForWrite();){
            CubeInstance cubeInstance = this.crud.reload(cubeName);
            return cubeInstance;
        }
    }

    public CubeInstance reloadCubeQuietly(String cubeName) {
        try (AutoReadWriteLock.AutoLock lock = this.cubeMapLock.lockForWrite();){
            CubeInstance cube = this.crud.reloadQuietly(cubeName);
            if (cube != null) {
                Cuboid.clearCache(cube);
            }
            CubeInstance cubeInstance = cube;
            return cubeInstance;
        }
    }

    public void removeCubeLocal(String cubeName) {
        try (AutoReadWriteLock.AutoLock lock = this.cubeMapLock.lockForWrite();){
            CubeInstance cube = (CubeInstance)this.cubeMap.get(cubeName);
            if (cube != null) {
                this.cubeMap.removeLocal(cubeName);
                for (CubeSegment segment : cube.getSegments()) {
                    this.usedStorageLocation.remove(segment.getUuid());
                }
                Cuboid.clearCache(cube);
            }
        }
    }

    public CubeInstance dropCube(String cubeName, boolean deleteDesc) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.cubeMapLock.lockForWrite();){
            logger.info("Dropping cube '{}'", (Object)cubeName);
            CubeInstance cube = this.getCube(cubeName);
            this.crud.delete(cube);
            Cuboid.clearCache(cube);
            if (deleteDesc && cube.getDescriptor() != null) {
                CubeDescManager.getInstance(this.config).removeCubeDesc(cube.getDescriptor());
            }
            ProjectManager.getInstance(this.config).removeRealizationsFromProjects(RealizationType.CUBE, cubeName);
            CubeInstance cubeInstance = cube;
            return cubeInstance;
        }
    }

    private String getSnapshotResPath(CubeSegment cubeSegment, String tableName, SnapshotTableDesc snapshotTableDesc) {
        String snapshotResPath = snapshotTableDesc == null || !snapshotTableDesc.isGlobal() ? cubeSegment.getSnapshotResPath(tableName) : cubeSegment.getCubeInstance().getSnapshotResPath(tableName);
        if (snapshotResPath == null) {
            throw new IllegalStateException("No snapshot for table '" + tableName + "' found on cube segment" + cubeSegment.getCubeInstance().getName() + "/" + cubeSegment);
        }
        return snapshotResPath;
    }

    @VisibleForTesting
    String generateStorageLocation(int engineType) {
        StringBuffer sb;
        String namePrefix = this.config.getHBaseTableNamePrefix();
        String namespace = this.config.getHBaseStorageNameSpace();
        String tableName = "";
        do {
            sb = new StringBuffer();
            int identifierLength = HBASE_TABLE_LENGTH;
            if (engineType != 6) {
                if (!(namespace.equals("default") || namespace.equals(""))) {
                    sb.append(namespace).append(":");
                }
                sb.append(namePrefix);
            } else {
                identifierLength = PARQUET_IDENTIFIER_LENGTH;
            }
            for (int i = 0; i < identifierLength; ++i) {
                sb.append(ALPHA_NUM.charAt(this.ran.nextInt(ALPHA_NUM.length())));
            }
        } while (this.usedStorageLocation.containsValue(tableName = sb.toString()));
        return tableName;
    }

    public CubeInstance copyForWrite(CubeInstance cube) {
        return this.crud.copyForWrite(cube);
    }

    private boolean isReady(CubeSegment seg) {
        return seg.getStatus() == SegmentStatusEnum.READY;
    }

    private TableMetadataManager getTableManager() {
        return TableMetadataManager.getInstance(this.config);
    }

    private ResourceStore getStore() {
        return ResourceStore.getStore(this.config);
    }

    @Override
    public RealizationType getRealizationType() {
        return RealizationType.CUBE;
    }

    @Override
    public IRealization getRealization(String name) {
        return this.getCube(name);
    }

    public CubeSegment appendSegment(CubeInstance cube) throws IOException {
        return this.appendSegment(cube, null, null, null, null);
    }

    public CubeSegment appendSegment(CubeInstance cube, SegmentRange.TSRange tsRange) throws IOException {
        return this.appendSegment(cube, tsRange, null, null, null);
    }

    public CubeSegment appendSegment(CubeInstance cube, SourcePartition src) throws IOException {
        return this.appendSegment(cube, src.getTSRange(), src.getSegRange(), src.getSourcePartitionOffsetStart(), src.getSourcePartitionOffsetEnd());
    }

    CubeSegment appendSegment(CubeInstance cube, SegmentRange.TSRange tsRange, SegmentRange segRange, Map<Integer, Long> sourcePartitionOffsetStart, Map<Integer, Long> sourcePartitionOffsetEnd) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.cubeMapLock.lockForWrite();){
            CubeSegment cubeSegment = this.segAssist.appendSegment(cube, tsRange, segRange, sourcePartitionOffsetStart, sourcePartitionOffsetEnd);
            return cubeSegment;
        }
    }

    public CubeSegment refreshSegment(CubeInstance cube, SegmentRange.TSRange tsRange, SegmentRange segRange) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.cubeMapLock.lockForWrite();){
            CubeSegment cubeSegment = this.segAssist.refreshSegment(cube, tsRange, segRange);
            return cubeSegment;
        }
    }

    public CubeSegment[] optimizeSegments(CubeInstance cube, Set<Long> cuboidsRecommend) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.cubeMapLock.lockForWrite();){
            CubeSegment[] cubeSegmentArray = this.segAssist.optimizeSegments(cube, cuboidsRecommend);
            return cubeSegmentArray;
        }
    }

    public CubeSegment mergeSegments(CubeInstance cube, SegmentRange.TSRange tsRange, SegmentRange segRange, boolean force) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.cubeMapLock.lockForWrite();){
            CubeSegment cubeSegment = this.segAssist.mergeSegments(cube, tsRange, segRange, force);
            return cubeSegment;
        }
    }

    public void promoteNewlyBuiltSegments(CubeInstance cube, CubeSegment newSegment) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.cubeMapLock.lockForWrite();){
            this.segAssist.promoteNewlyBuiltSegments(cube, newSegment);
        }
    }

    public void promoteNewlyOptimizeSegments(CubeInstance cube, CubeSegment ... optimizedSegments) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.cubeMapLock.lockForWrite();){
            this.segAssist.promoteNewlyOptimizeSegments(cube, optimizedSegments);
        }
    }

    public void promoteCheckpointOptimizeSegments(CubeInstance cube, Map<Long, Long> recommendCuboids, CubeSegment ... optimizedSegments) throws IOException {
        try (AutoReadWriteLock.AutoLock lock = this.cubeMapLock.lockForWrite();){
            this.segAssist.promoteCheckpointOptimizeSegments(cube, recommendCuboids, optimizedSegments);
        }
    }

    public List<CubeSegment> calculateHoles(String cubeName) {
        return this.segAssist.calculateHoles(cubeName);
    }

    public CubeInstance findLatestSnapshot(List<RealizationEntry> realizationEntries, String lookupTableName, CubeInstance cubeInstance) {
        CubeInstance cube = null;
        try {
            if (!realizationEntries.isEmpty()) {
                long maxBuildTime = Long.MIN_VALUE;
                RealizationRegistry registry = RealizationRegistry.getInstance(this.config);
                for (RealizationEntry entry : realizationEntries) {
                    long latestBuildTime;
                    CubeSegment segment;
                    CubeInstance current;
                    IRealization realization = registry.getRealization(entry.getType(), entry.getRealization());
                    if (realization == null || !realization.isReady() || !(realization instanceof CubeInstance) || (current = (CubeInstance)realization).getDescriptor().findDimensionByTable(lookupTableName) == null || (segment = current.getLatestReadySegment()) == null || (latestBuildTime = segment.getLastBuildTime()) <= maxBuildTime) continue;
                    maxBuildTime = latestBuildTime;
                    cube = current;
                }
            }
        }
        catch (Exception e) {
            logger.info("Unexpected error.", e);
            throw e;
        }
        if (!cubeInstance.equals(cube)) {
            logger.debug("Picked cube {} over {} as it provides a more recent snapshot of the lookup table {}", cube, cubeInstance, lookupTableName);
        }
        return cube == null ? cubeInstance : cube;
    }

    private class SegmentAssist {
        private SegmentAssist() {
        }

        CubeSegment appendSegment(CubeInstance cube, SegmentRange.TSRange tsRange, SegmentRange segRange, Map<Integer, Long> sourcePartitionOffsetStart, Map<Integer, Long> sourcePartitionOffsetEnd) throws IOException {
            CubeInstance cubeCopy = cube.latestCopyForWrite();
            this.checkInputRanges(tsRange, segRange);
            PartitionDesc partitionDesc = cubeCopy.getModel().getPartitionDesc();
            if (partitionDesc != null && partitionDesc.isPartitioned()) {
                if (tsRange != null && (Long)tsRange.start.v == 0L) {
                    CubeDesc cubeDesc = cubeCopy.getDescriptor();
                    CubeSegment last = cubeCopy.getLastSegment();
                    if (last == null) {
                        tsRange = new SegmentRange.TSRange(cubeDesc.getPartitionDateStart(), (Long)tsRange.end.v);
                    } else if (!last.isOffsetCube()) {
                        tsRange = new SegmentRange.TSRange((Long)last.getTSRange().end.v, (Long)tsRange.end.v);
                    }
                }
            } else {
                tsRange = null;
                segRange = null;
            }
            CubeSegment newSegment = this.newSegment(cubeCopy, tsRange, segRange);
            newSegment.setSourcePartitionOffsetStart(sourcePartitionOffsetStart);
            newSegment.setSourcePartitionOffsetEnd(sourcePartitionOffsetEnd);
            this.validateNewSegments(cubeCopy, newSegment);
            CubeUpdate update = new CubeUpdate(cubeCopy);
            update.setToAddSegs(newSegment);
            CubeManager.this.updateCube(update);
            return newSegment;
        }

        public CubeSegment refreshSegment(CubeInstance cube, SegmentRange.TSRange tsRange, SegmentRange segRange) throws IOException {
            CubeInstance cubeCopy = cube.latestCopyForWrite();
            this.checkInputRanges(tsRange, segRange);
            PartitionDesc partitionDesc = cubeCopy.getModel().getPartitionDesc();
            if (partitionDesc == null || !partitionDesc.isPartitioned()) {
                tsRange = null;
                segRange = null;
            }
            CubeSegment newSegment = this.newSegment(cubeCopy, tsRange, segRange);
            Pair<Boolean, Boolean> pair = cubeCopy.getSegments().fitInSegments(newSegment);
            if (!pair.getFirst().booleanValue() || !pair.getSecond().booleanValue()) {
                throw new IllegalArgumentException("The new refreshing segment " + newSegment + " does not match any existing segment in cube " + cubeCopy);
            }
            if (segRange != null) {
                CubeSegment toRefreshSeg = null;
                for (CubeSegment cubeSegment : cubeCopy.getSegments()) {
                    if (!cubeSegment.getSegRange().equals(segRange)) continue;
                    toRefreshSeg = cubeSegment;
                    break;
                }
                if (toRefreshSeg == null) {
                    throw new IllegalArgumentException("For streaming cube, only one segment can be refreshed at one time");
                }
                newSegment.setSourcePartitionOffsetStart(toRefreshSeg.getSourcePartitionOffsetStart());
                newSegment.setSourcePartitionOffsetEnd(toRefreshSeg.getSourcePartitionOffsetEnd());
            }
            CubeUpdate update = new CubeUpdate(cubeCopy);
            update.setToAddSegs(newSegment);
            CubeManager.this.updateCube(update);
            return newSegment;
        }

        public CubeSegment[] optimizeSegments(CubeInstance cube, Set<Long> cuboidsRecommend) throws IOException {
            CubeInstance cubeCopy = cube.latestCopyForWrite();
            Segments<CubeSegment> readySegments = cubeCopy.getSegments(SegmentStatusEnum.READY);
            CubeSegment[] optimizeSegments = new CubeSegment[readySegments.size()];
            int i = 0;
            for (CubeSegment segment : readySegments) {
                CubeSegment newSegment = this.newSegment(cubeCopy, segment.getTSRange(), null);
                this.validateNewSegments(cubeCopy, newSegment);
                optimizeSegments[i++] = newSegment;
            }
            CubeUpdate update = new CubeUpdate(cubeCopy);
            update.setCuboidsRecommend(cuboidsRecommend);
            update.setToAddSegs(optimizeSegments);
            CubeManager.this.updateCube(update);
            return optimizeSegments;
        }

        public CubeSegment mergeSegments(CubeInstance cube, SegmentRange.TSRange tsRange, SegmentRange segRange, boolean force) throws IOException {
            CubeInstance cubeCopy = cube.latestCopyForWrite();
            if (cubeCopy.getSegments().isEmpty()) {
                throw new IllegalArgumentException("Cube " + cubeCopy + " has no segments");
            }
            this.checkInputRanges(tsRange, segRange);
            this.checkCubeIsPartitioned(cubeCopy);
            if (cubeCopy.getSegments().getFirstSegment().isOffsetCube()) {
                segRange = this.getOffsetCubeSegRange(cubeCopy, tsRange, segRange);
                tsRange = null;
                Preconditions.checkArgument(segRange != null);
            } else {
                if (tsRange == null) {
                    tsRange = new SegmentRange.TSRange((Long)segRange.start.v, (Long)segRange.end.v);
                }
                segRange = null;
            }
            CubeSegment newSegment = this.newSegment(cubeCopy, tsRange, segRange);
            newSegment.setMerged(true);
            Segments<CubeSegment> mergingSegments = cubeCopy.getMergingSegments(newSegment);
            if (mergingSegments.size() <= 1) {
                throw new IllegalArgumentException("Range " + newSegment.getSegRange() + " must contain at least 2 segments, but there is " + mergingSegments.size());
            }
            CubeSegment first = (CubeSegment)mergingSegments.get(0);
            CubeSegment last = (CubeSegment)mergingSegments.get(mergingSegments.size() - 1);
            if (!force) {
                this.checkReadyForMerge(mergingSegments);
            }
            if (first.isOffsetCube()) {
                newSegment.setSegRange(new SegmentRange(first.getSegRange().start, last.getSegRange().end));
                newSegment.setSourcePartitionOffsetStart(first.getSourcePartitionOffsetStart());
                newSegment.setSourcePartitionOffsetEnd(last.getSourcePartitionOffsetEnd());
                newSegment.setTSRange(null);
            } else {
                newSegment.setTSRange(new SegmentRange.TSRange(mergingSegments.getTSStart(), mergingSegments.getTSEnd()));
                newSegment.setSegRange(null);
            }
            this.validateNewSegments(cubeCopy, newSegment);
            CubeUpdate update = new CubeUpdate(cubeCopy);
            update.setToAddSegs(newSegment);
            CubeManager.this.updateCube(update);
            return newSegment;
        }

        private void checkReadyForMerge(Segments<CubeSegment> mergingSegments) {
            for (int i = 0; i < mergingSegments.size() - 1; ++i) {
                if (((CubeSegment)mergingSegments.get(i)).getSegRange().connects(((CubeSegment)mergingSegments.get(i + 1)).getSegRange())) continue;
                throw new IllegalStateException("Merging segments must not have gaps between " + mergingSegments.get(i) + " and " + mergingSegments.get(i + 1));
            }
            ArrayList<String> emptySegment = Lists.newArrayList();
            for (CubeSegment seg : mergingSegments) {
                if (seg.getSizeKB() != 0L || seg.getInputRecords() != 0L) continue;
                emptySegment.add(seg.getName());
            }
            long maxSegMergeSpan = KylinConfig.getInstanceFromEnv().getMaxSegmentMergeSpan();
            for (CubeSegment seg : mergingSegments) {
                if (maxSegMergeSpan <= 0L || seg.getTSRange().duration() <= maxSegMergeSpan) continue;
                throw new IllegalArgumentException("Segment range is larger than the max segement merge span, couldn't merge unless 'forceMergeEmptySegment' set to true: " + seg);
            }
            if (emptySegment.size() > 0) {
                throw new IllegalArgumentException("Empty cube segment found, couldn't merge unless 'forceMergeEmptySegment' set to true: " + emptySegment);
            }
        }

        private SegmentRange getOffsetCubeSegRange(CubeInstance cubeCopy, SegmentRange.TSRange tsRange, SegmentRange segRange) {
            if (segRange == null && tsRange != null) {
                Pair<CubeSegment, CubeSegment> pair = cubeCopy.getSegments(SegmentStatusEnum.READY).findMergeOffsetsByDateRange(tsRange, Long.MAX_VALUE);
                if (pair == null) {
                    throw new IllegalArgumentException("Find no segments to merge by " + tsRange + " for cube " + cubeCopy);
                }
                segRange = new SegmentRange(pair.getFirst().getSegRange().start, pair.getSecond().getSegRange().end);
            }
            return segRange;
        }

        private void checkInputRanges(SegmentRange.TSRange tsRange, SegmentRange segRange) {
            if (tsRange != null && segRange != null) {
                throw new IllegalArgumentException("Build or refresh cube segment either by TSRange or by SegmentRange, not both.");
            }
        }

        private void checkCubeIsPartitioned(CubeInstance cube) {
            if (!cube.getDescriptor().getModel().getPartitionDesc().isPartitioned()) {
                throw new IllegalStateException("there is no partition date column specified, only full build is supported");
            }
        }

        private CubeSegment newSegment(CubeInstance cube, SegmentRange.TSRange tsRange, SegmentRange segRange) {
            DataModelDesc modelDesc = cube.getModel();
            CubeSegment segment = new CubeSegment();
            segment.setUuid(RandomUtil.randomUUID().toString());
            segment.setName(CubeSegment.makeSegmentName(tsRange, segRange, modelDesc));
            segment.setCreateTimeUTC(System.currentTimeMillis());
            segment.setCubeInstance(cube);
            if (tsRange == null && segRange == null) {
                tsRange = new SegmentRange.TSRange(0L, Long.MAX_VALUE);
            }
            segment.setTSRange(tsRange);
            segment.setSegRange(segRange);
            segment.setStatus(SegmentStatusEnum.NEW);
            segment.setStorageLocationIdentifier(CubeManager.this.generateStorageLocation(cube.getEngineType()));
            Map<String, String> additionalInfo = segment.getAdditionalInfo();
            additionalInfo.put("storageType", "" + cube.getStorageType());
            segment.setAdditionalInfo(additionalInfo);
            segment.setCubeInstance(cube);
            segment.validate();
            return segment;
        }

        public void promoteNewlyBuiltSegments(CubeInstance cube, CubeSegment newSegCopy) throws IOException {
            Segments tobe;
            if (newSegCopy.getCubeInstance().isCachedAndShared()) {
                throw new IllegalStateException();
            }
            CubeInstance cubeCopy = CubeManager.this.getCube(cube.getName()).latestCopyForWrite();
            if (StringUtils.isBlank(newSegCopy.getStorageLocationIdentifier())) {
                throw new IllegalStateException(String.format(Locale.ROOT, "For cube %s, segment %s missing StorageLocationIdentifier", cubeCopy.toString(), newSegCopy.toString()));
            }
            if (StringUtils.isBlank(newSegCopy.getLastBuildJobID())) {
                throw new IllegalStateException(String.format(Locale.ROOT, "For cube %s, segment %s missing LastBuildJobID", cubeCopy.toString(), newSegCopy.toString()));
            }
            if (CubeManager.this.isReady(newSegCopy)) {
                logger.warn("For cube {}, segment {} state should be NEW but is READY", (Object)cubeCopy, (Object)newSegCopy);
            }
            if (!(tobe = cubeCopy.calculateToBeSegments(newSegCopy)).contains(newSegCopy)) {
                throw new IllegalStateException(String.format(Locale.ROOT, "For cube %s, segment %s is expected but not in the tobe %s", cubeCopy.toString(), newSegCopy.toString(), ((Object)tobe).toString()));
            }
            newSegCopy.setStatus(SegmentStatusEnum.READY);
            ArrayList<CubeSegment> toRemoveSegs = Lists.newArrayList();
            for (CubeSegment segment : cubeCopy.getSegments()) {
                if (tobe.contains(segment)) continue;
                toRemoveSegs.add(segment);
            }
            logger.info("Promoting cube {}, new segment {}, to remove segments {}", cubeCopy, newSegCopy, toRemoveSegs);
            CubeUpdate update = new CubeUpdate(cubeCopy);
            update.setToRemoveSegs(toRemoveSegs.toArray(new CubeSegment[toRemoveSegs.size()])).setToUpdateSegs(newSegCopy);
            if (cube.getConfig().isJobAutoReadyCubeEnabled()) {
                update.setStatus(RealizationStatusEnum.READY);
            }
            CubeManager.this.updateCube(update);
        }

        public void promoteNewlyOptimizeSegments(CubeInstance cube, CubeSegment ... optimizedSegments) throws IOException {
            CubeSegment[] segCopy;
            CubeInstance cubeCopy = cube.latestCopyForWrite();
            for (CubeSegment seg : segCopy = cube.regetSegments(optimizedSegments)) {
                seg.setStatus(SegmentStatusEnum.READY_PENDING);
            }
            CubeUpdate update = new CubeUpdate(cubeCopy);
            update.setToUpdateSegs(segCopy);
            CubeManager.this.updateCube(update);
        }

        public void promoteCheckpointOptimizeSegments(CubeInstance cube, Map<Long, Long> recommendCuboids, CubeSegment ... optimizedSegments) throws IOException {
            CubeInstance cubeCopy = cube.latestCopyForWrite();
            Object[] optSegCopy = cubeCopy.regetSegments(optimizedSegments);
            if (cubeCopy.getSegments().size() != optSegCopy.length * 2) {
                throw new IllegalStateException(String.format(Locale.ROOT, "For cube %s, every READY segment should be optimized and all segments should be READY before optimizing", cubeCopy.toString()));
            }
            CubeSegment[] originalSegments = new CubeSegment[optSegCopy.length];
            int i = 0;
            for (CubeSegment cubeSegment : optSegCopy) {
                originalSegments[i++] = cubeCopy.getOriginalSegmentToOptimize(cubeSegment);
                if (StringUtils.isBlank(cubeSegment.getStorageLocationIdentifier())) {
                    throw new IllegalStateException(String.format(Locale.ROOT, "For cube %s, segment %s missing StorageLocationIdentifier", cubeCopy.toString(), cubeSegment.toString()));
                }
                if (StringUtils.isBlank(cubeSegment.getLastBuildJobID())) {
                    throw new IllegalStateException(String.format(Locale.ROOT, "For cube %s, segment %s missing LastBuildJobID", cubeCopy.toString(), cubeSegment.toString()));
                }
                cubeSegment.setStatus(SegmentStatusEnum.READY);
            }
            logger.info("Promoting cube {}, new segments {}, to remove segments {}", cubeCopy, Arrays.toString(optSegCopy), originalSegments);
            CubeUpdate update = new CubeUpdate(cubeCopy);
            update.setToRemoveSegs(originalSegments).setToUpdateSegs((CubeSegment[])optSegCopy).setCuboids(recommendCuboids).setCuboidsRecommend(Sets.newHashSet());
            if (cube.getConfig().isJobAutoReadyCubeEnabled()) {
                update.setStatus(RealizationStatusEnum.READY);
            }
            CubeManager.this.updateCube(update);
        }

        private void validateNewSegments(CubeInstance cube, CubeSegment newSegments) {
            Segments tobe = cube.calculateToBeSegments(newSegments);
            List<CubeSegment> newList = Arrays.asList(newSegments);
            if (!tobe.containsAll(newList)) {
                throw new IllegalStateException(String.format(Locale.ROOT, "For cube %s, the new segments %s do not fit in its current %s; the resulted tobe is %s", cube.toString(), newList.toString(), cube.getSegments().toString(), ((Object)tobe).toString()));
            }
        }

        public List<CubeSegment> calculateHoles(String cubeName) {
            ArrayList<CubeSegment> holes = Lists.newArrayList();
            CubeInstance cube = CubeManager.this.getCube(cubeName);
            DataModelDesc modelDesc = cube.getModel();
            Preconditions.checkNotNull(cube);
            Segments<CubeSegment> segments = cube.getSegments();
            logger.info("totally {} cubeSegments", (Object)segments.size());
            if (segments.size() == 0) {
                return holes;
            }
            Collections.sort(segments);
            for (int i = 0; i < segments.size() - 1; ++i) {
                CubeSegment first = (CubeSegment)segments.get(i);
                CubeSegment second = (CubeSegment)segments.get(i + 1);
                if (first.getSegRange().connects(second.getSegRange()) || !first.getSegRange().apartBefore(second.getSegRange())) continue;
                CubeSegment hole = new CubeSegment();
                hole.setCubeInstance(cube);
                if (first.isOffsetCube()) {
                    hole.setSegRange(new SegmentRange(first.getSegRange().end, second.getSegRange().start));
                    hole.setSourcePartitionOffsetStart(first.getSourcePartitionOffsetEnd());
                    hole.setSourcePartitionOffsetEnd(second.getSourcePartitionOffsetStart());
                    hole.setName(CubeSegment.makeSegmentName(null, hole.getSegRange(), modelDesc));
                } else {
                    hole.setTSRange(new SegmentRange.TSRange((Long)first.getTSRange().end.v, (Long)second.getTSRange().start.v));
                    hole.setName(CubeSegment.makeSegmentName(hole.getTSRange(), null, modelDesc));
                }
                holes.add(hole);
            }
            return holes;
        }
    }

    private class CubeSyncListener
    extends Broadcaster.Listener {
        private CubeSyncListener() {
        }

        @Override
        public void onProjectSchemaChange(Broadcaster broadcaster, String project) throws IOException {
            ProjectManager projectManager = ProjectManager.getInstance(CubeManager.this.config);
            for (IRealization real : projectManager.listAllRealizations(project)) {
                if (!(real instanceof CubeInstance)) continue;
                CubeManager.this.reloadCubeQuietly(real.getName());
            }
            projectManager.reloadProjectL2Cache(project);
        }

        @Override
        public void onEntityChange(Broadcaster broadcaster, String entity, Broadcaster.Event event, String cacheKey) throws IOException {
            String cubeName = cacheKey;
            if (event == Broadcaster.Event.DROP) {
                CubeManager.this.removeCubeLocal(cubeName);
            } else {
                CubeManager.this.reloadCubeQuietly(cubeName);
            }
            for (ProjectInstance prj : ProjectManager.getInstance(CubeManager.this.config).findProjects(RealizationType.CUBE, cubeName)) {
                broadcaster.notifyProjectDataUpdate(prj.getName());
            }
        }
    }
}

