/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.zookeeper;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.x.discovery.ServiceCache;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceDiscoveryBuilder;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.details.InstanceSerializer;
import org.apache.curator.x.discovery.details.ServiceCacheListener;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.common.util.ZKUtil;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.JavaType;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.kylin.tool.shaded.org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KylinServerDiscovery
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(KylinServerDiscovery.class);
    public static final String SERVICE_PATH = "/service";
    public static final String SERVICE_NAME = "cluster_servers";
    public static final String SERVICE_PAYLOAD_DESCRIPTION = "description";
    private final KylinConfig kylinConfig;
    private final CuratorFramework curator;
    private final ServiceDiscovery<LinkedHashMap> serviceDiscovery;
    private final ServiceCache<LinkedHashMap> serviceCache;

    public static KylinServerDiscovery getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private KylinServerDiscovery() {
        this(KylinConfig.getInstanceFromEnv());
    }

    @VisibleForTesting
    protected KylinServerDiscovery(KylinConfig kylinConfig) {
        this.kylinConfig = kylinConfig;
        this.curator = ZKUtil.getZookeeperClient(kylinConfig);
        try {
            JsonInstanceSerializer<LinkedHashMap> serializer = new JsonInstanceSerializer<LinkedHashMap>(LinkedHashMap.class);
            this.serviceDiscovery = ServiceDiscoveryBuilder.builder(LinkedHashMap.class).client(this.curator).basePath(SERVICE_PATH).serializer(serializer).build();
            this.serviceDiscovery.start();
            this.serviceCache = this.serviceDiscovery.serviceCacheBuilder().name(SERVICE_NAME).threadFactory(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("KylinServerTracker-%d").build()).build();
            final AtomicBoolean isFinishInit = new AtomicBoolean(false);
            this.serviceCache.addListener((Object)new ServiceCacheListener(){

                public void stateChanged(CuratorFramework curatorFramework, ConnectionState connectionState) {
                }

                public void cacheChanged() {
                    logger.info("Service discovery get cacheChanged notification");
                    List instances = KylinServerDiscovery.this.serviceCache.getInstances();
                    HashMap instanceNodes = Maps.newHashMapWithExpectedSize((int)instances.size());
                    for (ServiceInstance entry : instances) {
                        instanceNodes.put(entry.getAddress() + ":" + entry.getPort(), (String)((LinkedHashMap)entry.getPayload()).get(KylinServerDiscovery.SERVICE_PAYLOAD_DESCRIPTION));
                    }
                    logger.info("kylin.server.cluster-servers update to " + instanceNodes);
                    System.setProperty("kylin.server.cluster-servers", StringUtil.join(instanceNodes.keySet(), ","));
                    String restServersInClusterWithMode = StringUtil.join(instanceNodes.entrySet().stream().map(input -> (String)input.getKey() + ":" + (String)input.getValue()).collect(Collectors.toList()), ",");
                    logger.info("kylin.server.cluster-servers-with-mode update to " + restServersInClusterWithMode);
                    System.setProperty("kylin.server.cluster-servers-with-mode", restServersInClusterWithMode);
                    isFinishInit.set(true);
                }
            });
            this.serviceCache.start();
            this.registerSelf();
            int i = 1;
            long maxWaitingTime = 60000L;
            while (!isFinishInit.get()) {
                logger.info("Haven't registered, waiting ...");
                long waitingTime = 100L * (long)i * (long)i;
                if (waitingTime > maxWaitingTime) {
                    waitingTime = maxWaitingTime;
                } else {
                    ++i;
                }
                Thread.sleep(waitingTime);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to initialize due to ", e);
        }
    }

    private void registerSelf() throws Exception {
        String hostAddr = this.kylinConfig.getServerRestAddress();
        String[] hostAddrInfo = hostAddr.split(":");
        if (hostAddrInfo.length < 2) {
            logger.error("kylin.server.host-address {} is not qualified ", (Object)hostAddr);
            throw new RuntimeException("kylin.server.host-address " + hostAddr + " is not qualified");
        }
        String host = hostAddrInfo[0];
        int port = Integer.parseInt(hostAddrInfo[1]);
        String serverMode = this.kylinConfig.getServerMode();
        this.registerServer(host, port, serverMode);
    }

    private void registerServer(String host, int port, String mode) throws Exception {
        LinkedHashMap<String, String> instanceDetail = new LinkedHashMap<String, String>();
        instanceDetail.put(SERVICE_PAYLOAD_DESCRIPTION, mode);
        ServiceInstance thisInstance = ServiceInstance.builder().name(SERVICE_NAME).payload(instanceDetail).port(port).address(host).build();
        for (ServiceInstance instance : this.serviceCache.getInstances()) {
            if (!instance.getAddress().equals(thisInstance.getAddress()) || !instance.getPort().equals(thisInstance.getPort())) continue;
            this.serviceDiscovery.unregisterService(instance);
        }
        this.serviceDiscovery.registerService(thisInstance);
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeQuietly(this.serviceCache);
        IOUtils.closeQuietly(this.serviceDiscovery);
    }

    static class JsonInstanceSerializer<T>
    implements InstanceSerializer<T> {
        private final ObjectMapper mapper;
        private final Class<T> payloadClass;
        private final JavaType type;

        JsonInstanceSerializer(Class<T> payloadClass) {
            this.payloadClass = payloadClass;
            this.mapper = new ObjectMapper();
            this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.type = this.mapper.getTypeFactory().constructType((Type)((Object)ServiceInstance.class));
        }

        public ServiceInstance<T> deserialize(byte[] bytes) throws Exception {
            ServiceInstance rawServiceInstance = (ServiceInstance)this.mapper.readValue(bytes, this.type);
            this.payloadClass.cast(rawServiceInstance.getPayload());
            return rawServiceInstance;
        }

        public byte[] serialize(ServiceInstance<T> instance) throws Exception {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.mapper.convertValue(instance.getPayload(), this.payloadClass);
            this.mapper.writeValue(out, instance);
            return out.toByteArray();
        }
    }

    private static class SingletonHolder {
        private static final KylinServerDiscovery INSTANCE = new KylinServerDiscovery();

        private SingletonHolder() {
        }
    }
}

