/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

public class RingBuffer {
    private final byte[] bytes;
    private int writePos;
    private int size;

    private RingBuffer(int capacity) {
        this.bytes = new byte[capacity];
    }

    public static RingBuffer allocate(int capacity) {
        return new RingBuffer(capacity);
    }

    public RingBuffer put(byte[] src) {
        for (int i = 0; i < src.length; ++i) {
            if (this.writePos >= this.bytes.length) {
                this.writePos = 0;
            }
            this.bytes[this.writePos++] = src[i];
            this.size = this.size < this.bytes.length ? this.size + 1 : this.size;
        }
        return this;
    }

    public byte[] get() {
        byte[] res;
        if (this.size == this.bytes.length && this.writePos < this.size) {
            res = new byte[this.size];
            System.arraycopy(this.bytes, this.writePos, res, 0, this.size - this.writePos);
            System.arraycopy(this.bytes, 0, res, this.size - this.writePos, this.writePos);
        } else {
            res = new byte[this.writePos];
            System.arraycopy(this.bytes, 0, res, 0, this.writePos);
        }
        return res;
    }
}

