/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.metrics.perflog;

import java.util.HashMap;
import java.util.Map;
import org.apache.kylin.common.metrics.perflog.IPerfLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplePerfLogger
implements IPerfLogger {
    private static final Logger LOG = LoggerFactory.getLogger(SimplePerfLogger.class.getName());
    protected final Map<String, Long> startTimes = new HashMap<String, Long>();
    protected final Map<String, Long> endTimes = new HashMap<String, Long>();

    protected SimplePerfLogger() {
    }

    @Override
    public void perfLogBegin(String callerName, String method) {
        long startTime = System.currentTimeMillis();
        this.startTimes.put(method, new Long(startTime));
        if (LOG.isDebugEnabled()) {
            LOG.debug("<PERFLOG method=" + method + " from=" + callerName + ">");
        }
    }

    @Override
    public long perfLogEnd(String callerName, String method) {
        return this.perfLogEnd(callerName, method, null);
    }

    @Override
    public long perfLogEnd(String callerName, String method, String additionalInfo) {
        long duration;
        Long startTime = this.startTimes.get(method);
        long endTime = System.currentTimeMillis();
        this.endTimes.put(method, new Long(endTime));
        long l = duration = startTime == null ? -1L : endTime - startTime;
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("</PERFLOG method=").append(method);
            if (startTime != null) {
                sb.append(" start=").append(startTime);
            }
            sb.append(" end=").append(endTime);
            if (startTime != null) {
                sb.append(" duration=").append(duration);
            }
            sb.append(" from=").append(callerName);
            if (additionalInfo != null) {
                sb.append(" ").append(additionalInfo);
            }
            sb.append(">");
            LOG.debug(sb.toString());
        }
        return duration;
    }
}

