/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.commands;

import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.knox.gateway.shell.CredentialCollectionException;
import org.apache.knox.gateway.shell.CredentialCollector;
import org.apache.knox.gateway.shell.KnoxSession;
import org.apache.knox.gateway.shell.KnoxShellException;
import org.apache.knox.gateway.shell.commands.AbstractKnoxShellCommand;
import org.apache.knox.gateway.shell.hdfs.Get;
import org.apache.knox.gateway.shell.hdfs.Hdfs;
import org.apache.knox.gateway.shell.hdfs.Ls;
import org.apache.knox.gateway.shell.hdfs.Mkdir;
import org.apache.knox.gateway.shell.hdfs.Put;
import org.apache.knox.gateway.shell.hdfs.Rm;
import org.apache.knox.gateway.shell.hdfs.Status;
import org.apache.knox.gateway.shell.table.KnoxShellTable;
import org.apache.knox.gateway.util.JsonUtils;
import org.codehaus.groovy.tools.shell.Groovysh;

public class WebHDFSCommand
extends AbstractKnoxShellCommand {
    private static final String DESC = "POSIX style commands for Hadoop Filesystems";
    private static final String USAGE = "Usage: \n  :fs mounts \n  :fs mount target-topology-url mountpoint-name \n  :fs unmount mountpoint-name \n  :fs ls {target-path} \n  :fs cat {target-path} \n  :fs get {from-path} {to-path} \n  :fs put {from-path} {tp-path} \n  :fs rm {target-path} \n  :fs mkdir {dir-path} \n";
    private Map<String, KnoxSession> sessions = new HashMap<String, KnoxSession>();

    public WebHDFSCommand(Groovysh shell) {
        super(shell, ":filesystem", ":fs", DESC, USAGE, DESC);
    }

    public Object execute(List<String> args) {
        Map<String, String> mounts = this.getMountPoints();
        if (args.isEmpty()) {
            args.add("ls");
        }
        if (args.get(0).equalsIgnoreCase("mount")) {
            String url = args.get(1);
            String mountPoint = args.get(2);
            return this.mount(mounts, url, mountPoint);
        }
        if (args.get(0).equalsIgnoreCase("unmount")) {
            String mountPoint = args.get(1);
            this.unmount(mounts, mountPoint);
        } else {
            if (args.get(0).equalsIgnoreCase("mounts")) {
                return this.listMounts(mounts);
            }
            if (args.get(0).equalsIgnoreCase("ls")) {
                String path = args.get(1);
                return this.listStatus(mounts, path);
            }
            if (args.get(0).equalsIgnoreCase("put")) {
                String localFile = args.get(1);
                String path = args.get(2);
                int permission = 755;
                if (args.size() >= 4) {
                    permission = Integer.parseInt(args.get(3));
                }
                return this.put(mounts, localFile, path, permission);
            }
            if (args.get(0).equalsIgnoreCase("rm")) {
                String path = args.get(1);
                return this.remove(mounts, path);
            }
            if (args.get(0).equalsIgnoreCase("cat")) {
                String path = args.get(1);
                return this.cat(mounts, path);
            }
            if (args.get(0).equalsIgnoreCase("mkdir")) {
                String path = args.get(1);
                String perms = null;
                if (args.size() == 3) {
                    perms = args.get(2);
                }
                return this.mkdir(mounts, path, perms);
            }
            if (args.get(0).equalsIgnoreCase("get")) {
                String path = args.get(1);
                String mountPoint = this.determineMountPoint(path);
                KnoxSession session = this.getSessionForMountPoint(mounts, mountPoint);
                if (session != null) {
                    String from = this.determineTargetPath(path, mountPoint);
                    String to = null;
                    to = args.size() > 2 ? args.get(2) : System.getProperty("user.home") + File.separator + path.substring(path.lastIndexOf(File.separator));
                    return this.get(mountPoint, from, to);
                }
                return "No session established for mountPoint: " + mountPoint + " Use :fs mount {topology-url} {mountpoint-name}";
            }
            System.out.println("Unknown filesystem command");
            System.out.println(this.getUsage());
        }
        return "";
    }

    private String get(String mountPoint, String from, String to) {
        String result = null;
        try {
            ((Get.Response)Hdfs.get(this.sessions.get(mountPoint)).from(from).file(to).now()).getString();
            result = "Successfully copied: " + from + " to: " + to;
        }
        catch (IOException | KnoxShellException e) {
            e.printStackTrace();
            result = "Exception ocurred: " + e.getMessage();
        }
        return result;
    }

    private String mkdir(Map<String, String> mounts, String path, String perms) {
        String result = null;
        String mountPoint = this.determineMountPoint(path);
        KnoxSession session = this.getSessionForMountPoint(mounts, mountPoint);
        if (session != null) {
            String targetPath = this.determineTargetPath(path, mountPoint);
            if (!this.exists(session, targetPath)) {
                try {
                    if (perms != null) {
                        ((Mkdir.Response)Hdfs.mkdir(this.sessions.get(mountPoint)).dir(targetPath).now()).getString();
                    } else {
                        ((Mkdir.Response)Hdfs.mkdir(session).dir(targetPath).perm(perms).now()).getString();
                    }
                    result = "Successfully created directory: " + targetPath;
                }
                catch (IOException | KnoxShellException e) {
                    e.printStackTrace();
                    result = "Exception ocurred: " + e.getMessage();
                }
            } else {
                result = targetPath + " already exists";
            }
        } else {
            result = "No session established for mountPoint: " + mountPoint + " Use :fs mount {topology-url} {mountpoint-name}";
        }
        return result;
    }

    private String cat(Map<String, String> mounts, String path) {
        String response = null;
        String mountPoint = this.determineMountPoint(path);
        KnoxSession session = this.getSessionForMountPoint(mounts, mountPoint);
        if (session != null) {
            String targetPath = this.determineTargetPath(path, mountPoint);
            try {
                String contents;
                response = contents = ((Get.Response)Hdfs.get(session).from(targetPath).now()).getString();
            }
            catch (IOException | KnoxShellException e) {
                e.printStackTrace();
                response = "Exception ocurred: " + e.getMessage();
            }
        } else {
            response = "No session established for mountPoint: " + mountPoint + " Use :fs mount {topology-url} {mountpoint-name}";
        }
        return response;
    }

    private String remove(Map<String, String> mounts, String path) {
        String mountPoint = this.determineMountPoint(path);
        KnoxSession session = this.getSessionForMountPoint(mounts, mountPoint);
        if (session != null) {
            String targetPath = this.determineTargetPath(path, mountPoint);
            try {
                ((Rm.Response)Hdfs.rm(session).file(targetPath).now()).getString();
            }
            catch (IOException | KnoxShellException e) {
                e.printStackTrace();
            }
        } else {
            return "No session established for mountPoint: " + mountPoint + " Use :fs mount {topology-url} {mountpoint-name}";
        }
        return "Successfully removed: " + path;
    }

    private String put(Map<String, String> mounts, String localFile, String path, int permission) {
        String mountPoint = this.determineMountPoint(path);
        KnoxSession session = this.getSessionForMountPoint(mounts, mountPoint);
        if (session != null) {
            String targetPath = this.determineTargetPath(path, mountPoint);
            try {
                boolean overwrite = false;
                if (this.exists(session, targetPath) && this.collectClearInput(targetPath + " already exists would you like to overwrite (Y/n)").equalsIgnoreCase("y")) {
                    overwrite = true;
                }
                ((Put.Response)Hdfs.put(session).file(localFile).to(targetPath).overwrite(overwrite).permission(permission).now()).getString();
            }
            catch (IOException e) {
                e.printStackTrace();
                return "Exception ocurred: " + e.getMessage();
            }
        } else {
            return "No session established for mountPoint: " + mountPoint + " Use :fs mount {topology-url} {mountpoint-name}";
        }
        return "Successfully put: " + localFile + " to: " + path;
    }

    private boolean exists(KnoxSession session, String path) {
        boolean rc = false;
        try {
            Status.Response response = (Status.Response)Hdfs.status(session).file(path).now();
            rc = response.exists();
        }
        catch (KnoxShellException knoxShellException) {
            // empty catch block
        }
        return rc;
    }

    private Object listStatus(Map<String, String> mounts, String path) {
        Object response = null;
        try {
            String mountPoint = this.determineMountPoint(path);
            if (mountPoint != null) {
                KnoxSession session = this.getSessionForMountPoint(mounts, mountPoint);
                if (session != null) {
                    String directory = this.determineTargetPath(path, mountPoint);
                    String json = ((Ls.Response)Hdfs.ls(session).dir(directory).now()).getString();
                    Map map = JsonUtils.getFileStatusesAsMap((String)json);
                    if (map != null) {
                        ArrayList list = (ArrayList)((HashMap)map.get("FileStatuses")).get("FileStatus");
                        KnoxShellTable table = this.buildTableFromListStatus(directory, list);
                        response = table;
                    }
                } else {
                    response = "No session established for mountPoint: " + mountPoint + " Use :fs mount {topology-url} {mountpoint-name}";
                }
            } else {
                response = "No mountpoint found. Use ':fs mount {topologyURL} {mountpoint}'.";
            }
        }
        catch (IOException | KnoxShellException e) {
            response = "Exception ocurred: " + e.getMessage();
            e.printStackTrace();
        }
        return response;
    }

    private KnoxShellTable listMounts(Map<String, String> mounts) {
        KnoxShellTable table = new KnoxShellTable();
        table.header("Mount Point").header("Topology URL");
        for (String mountPoint : mounts.keySet()) {
            table.row().value((Comparable<? extends Object>)((Object)mountPoint)).value((Comparable)((Object)mounts.get(mountPoint)));
        }
        return table;
    }

    private void unmount(Map<String, String> mounts, String mountPoint) {
        this.sessions.remove(mountPoint);
        mounts.remove(mountPoint);
        KnoxSession.persistMountPoints(mounts);
    }

    private String mount(Map<String, String> mounts, String url, String mountPoint) {
        KnoxSession session = this.establishSession(mountPoint, url);
        if (session != null) {
            mounts.put(mountPoint, url);
            KnoxSession.persistMountPoints(mounts);
            return url + " mounted as " + mountPoint;
        }
        return "Failed to mount " + url + " as " + mountPoint;
    }

    private KnoxSession getSessionForMountPoint(Map<String, String> mounts, String mountPoint) {
        String url;
        KnoxSession session = this.sessions.get(mountPoint);
        if (session == null && (url = mounts.get(mountPoint)) != null) {
            session = this.establishSession(mountPoint, url);
        }
        return session;
    }

    private KnoxSession establishSession(String mountPoint, String url) {
        CredentialCollector dlg;
        try {
            dlg = this.login();
        }
        catch (CredentialCollectionException e) {
            e.printStackTrace();
            return null;
        }
        String username = dlg.name();
        String password = new String(dlg.chars());
        KnoxSession session = null;
        try {
            session = KnoxSession.login(url, username, password);
            this.sessions.put(mountPoint, session);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return session;
    }

    private String collectClearInput(String prompt) {
        Console c = System.console();
        if (c == null) {
            System.err.println("No console.");
            System.exit(1);
        }
        String value = c.readLine(prompt, new Object[0]);
        return value;
    }

    private String determineTargetPath(String path, String mountPoint) {
        String directory = null;
        if (path.startsWith("/")) {
            directory = this.stripMountPoint(path, mountPoint);
        }
        return directory;
    }

    private String stripMountPoint(String path, String mountPoint) {
        String newPath = path.replace("/" + mountPoint, "");
        return newPath;
    }

    private String determineMountPoint(String path) {
        String mountPoint = null;
        if (path.startsWith("/")) {
            String[] pathElements = path.split("/");
            mountPoint = pathElements[1];
        }
        return mountPoint;
    }

    private KnoxShellTable buildTableFromListStatus(String directory, List<HashMap<String, String>> list) {
        Calendar cal = Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault());
        KnoxShellTable table = new KnoxShellTable();
        table.title(directory);
        table.header("permission").header("owner").header("group").header("length").header("modtime").header("name");
        for (Map map : list) {
            cal.setTimeInMillis(Long.parseLong((String)map.get("modificationTime")));
            table.row().value((Comparable)map.get("permission")).value((Comparable)map.get("owner")).value((Comparable)map.get("group")).value((Comparable)map.get("length")).value(cal.getTime()).value((Comparable)map.get("pathSuffix"));
        }
        return table;
    }

    protected Map<String, String> getMountPoints() {
        Map<String, String> mounts = null;
        try {
            mounts = KnoxSession.loadMountPoints();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return mounts;
    }

    public static void main(String[] args) {
        WebHDFSCommand cmd = new WebHDFSCommand(new Groovysh());
        cmd.execute(new ArrayList<String>(Arrays.asList(args)));
    }
}

