/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.hbase;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;

class HBaseRequestUtil {
    HBaseRequestUtil() {
    }

    public static HttpUriRequest fixTrailingSlash(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest) {
        String[] split;
        if (inboundRequest.getPathInfo().endsWith("/") && !(split = outboundRequest.getURI().toString().split("\\?"))[0].endsWith("/")) {
            outboundRequest = RequestBuilder.copy((HttpRequest)outboundRequest).setUri(split[0] + "/" + (split.length == 2 ? "?" + split[1] : "")).build();
        }
        return outboundRequest;
    }

    public static URI decodeUrl(HttpServletRequest request) {
        String base = request.getRequestURI();
        StringBuilder str = new StringBuilder();
        try {
            str.append(URLDecoder.decode(base, StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            str.append(base);
        }
        String query = request.getQueryString();
        if (query != null) {
            str.append('?');
            str.append(query);
        }
        return URI.create(str.toString());
    }
}

