/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.pool;

import org.ldaptive.BindOperation;
import org.ldaptive.BindRequest;
import org.ldaptive.Connection;
import org.ldaptive.Response;
import org.ldaptive.ResultCode;
import org.ldaptive.pool.Passivator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindPassivator
implements Passivator<Connection> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private BindRequest bindRequest;

    public BindPassivator() {
        this.bindRequest = new BindRequest();
    }

    public BindPassivator(BindRequest br) {
        this.bindRequest = br;
    }

    public BindRequest getBindRequest() {
        return this.bindRequest;
    }

    public void setBindRequest(BindRequest br) {
        this.bindRequest = br;
    }

    @Override
    public boolean passivate(Connection c) {
        boolean success = false;
        if (c != null) {
            try {
                BindOperation bind = new BindOperation(c);
                Response response = bind.execute(this.bindRequest);
                success = ResultCode.SUCCESS == response.getResultCode();
            }
            catch (Exception e) {
                this.logger.debug("passivation failed for bind request {}", (Object)this.bindRequest, (Object)e);
            }
        }
        return success;
    }

    public String toString() {
        return String.format("[%s@%d::bindRequest=%s]", this.getClass().getName(), this.hashCode(), this.bindRequest);
    }
}

