/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.token.impl;

import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.security.token.TokenStateService;
import org.apache.knox.gateway.services.security.token.TokenUtils;
import org.apache.knox.gateway.services.security.token.UnknownTokenException;
import org.apache.knox.gateway.services.security.token.impl.JWT;
import org.apache.knox.gateway.services.security.token.impl.JWTToken;
import org.apache.knox.gateway.services.token.impl.TokenStateServiceMessages;

public class DefaultTokenStateService
implements TokenStateService {
    protected static final long DEFAULT_RENEWAL_INTERVAL = 86400000L;
    protected static final int MAX_RENEWALS = 7;
    protected static final long DEFAULT_MAX_LIFETIME = 604800000L;
    protected static final TokenStateServiceMessages log = (TokenStateServiceMessages)MessagesFactory.get(TokenStateServiceMessages.class);
    private final Map<String, Long> tokenExpirations = new HashMap<String, Long>();
    private final Map<String, Long> maxTokenLifetimes = new HashMap<String, Long>();
    private long tokenEvictionInterval;
    private long tokenEvictionGracePeriod;
    protected boolean permissiveValidationEnabled;
    private final ScheduledExecutorService evictionScheduler = Executors.newScheduledThreadPool(1);

    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        this.tokenEvictionInterval = config.getKnoxTokenEvictionInterval();
        this.tokenEvictionGracePeriod = config.getKnoxTokenEvictionGracePeriod();
        this.permissiveValidationEnabled = config.isKnoxTokenPermissiveValidationEnabled();
    }

    public void start() throws ServiceLifecycleException {
        if (this.tokenEvictionInterval > 0L) {
            this.evictionScheduler.scheduleAtFixedRate(() -> this.evictExpiredTokens(), this.tokenEvictionInterval, this.tokenEvictionInterval, TimeUnit.SECONDS);
        }
    }

    public void stop() throws ServiceLifecycleException {
        this.evictionScheduler.shutdown();
    }

    public long getDefaultRenewInterval() {
        return 86400000L;
    }

    public long getDefaultMaxLifetimeDuration() {
        return 604800000L;
    }

    public void addToken(JWTToken token, long issueTime) {
        if (token == null) {
            throw new IllegalArgumentException("Token cannot be null.");
        }
        this.addToken(TokenUtils.getTokenId((JWT)token), issueTime, token.getExpiresDate().getTime());
    }

    public void addToken(String tokenId, long issueTime, long expiration) {
        this.addToken(tokenId, issueTime, expiration, this.getDefaultMaxLifetimeDuration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToken(String tokenId, long issueTime, long expiration, long maxLifetimeDuration) {
        if (!this.isValidIdentifier(tokenId)) {
            throw new IllegalArgumentException("Token identifier cannot be null.");
        }
        Map<String, Long> map = this.tokenExpirations;
        synchronized (map) {
            this.tokenExpirations.put(tokenId, expiration);
        }
        this.setMaxLifetime(tokenId, issueTime, maxLifetimeDuration);
        log.addedToken(tokenId, this.getTimestampDisplay(expiration));
    }

    public long getTokenExpiration(JWT token) throws UnknownTokenException {
        long expiration;
        block3: {
            expiration = -1L;
            try {
                expiration = this.getTokenExpiration(TokenUtils.getTokenId((JWT)token));
            }
            catch (UnknownTokenException e) {
                String exp;
                if (this.permissiveValidationEnabled && (exp = token.getExpires()) != null) {
                    log.permissiveTokenHandling(TokenUtils.getTokenId((JWT)token), e.getMessage());
                    expiration = Long.parseLong(exp);
                }
                if (expiration != -1L) break block3;
                throw e;
            }
        }
        return expiration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTokenExpiration(String tokenId) throws UnknownTokenException {
        long expiration;
        this.validateToken(tokenId);
        Map<String, Long> map = this.tokenExpirations;
        synchronized (map) {
            expiration = this.tokenExpirations.get(tokenId);
        }
        return expiration;
    }

    public long renewToken(JWTToken token) throws UnknownTokenException {
        return this.renewToken(token, 86400000L);
    }

    public long renewToken(JWTToken token, long renewInterval) throws UnknownTokenException {
        if (token == null) {
            throw new IllegalArgumentException("Token cannot be null.");
        }
        return this.renewToken(TokenUtils.getTokenId((JWT)token), renewInterval);
    }

    public long renewToken(String tokenId) throws UnknownTokenException {
        return this.renewToken(tokenId, 86400000L);
    }

    public long renewToken(String tokenId, long renewInterval) throws UnknownTokenException {
        this.validateToken(tokenId);
        if (!this.hasRemainingRenewals(tokenId, renewInterval)) {
            log.renewalLimitExceeded(tokenId);
            throw new IllegalArgumentException("The renewal limit for the token has been exceeded");
        }
        long expiration = System.currentTimeMillis() + renewInterval;
        this.updateExpiration(tokenId, expiration);
        log.renewedToken(tokenId, this.getTimestampDisplay(expiration));
        return expiration;
    }

    public void revokeToken(JWTToken token) throws UnknownTokenException {
        if (token == null) {
            throw new IllegalArgumentException("Token cannot be null.");
        }
        this.revokeToken(TokenUtils.getTokenId((JWT)token));
    }

    public void revokeToken(String tokenId) throws UnknownTokenException {
        this.removeToken(tokenId);
        log.revokedToken(tokenId);
    }

    public boolean isExpired(JWTToken token) throws UnknownTokenException {
        return this.getTokenExpiration((JWT)token) <= System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMaxLifetime(String token, long issueTime, long maxLifetimeDuration) {
        Map<String, Long> map = this.maxTokenLifetimes;
        synchronized (map) {
            this.maxTokenLifetimes.put(token, issueTime + maxLifetimeDuration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isUnknown(String token) {
        boolean isUnknown;
        Map<String, Long> map = this.tokenExpirations;
        synchronized (map) {
            isUnknown = !this.tokenExpirations.containsKey(token);
        }
        return isUnknown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateExpiration(String tokenId, long expiration) {
        Map<String, Long> map = this.tokenExpirations;
        synchronized (map) {
            this.tokenExpirations.replace(tokenId, expiration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeToken(String tokenId) throws UnknownTokenException {
        this.validateToken(tokenId);
        Map<String, Long> map = this.tokenExpirations;
        synchronized (map) {
            this.tokenExpirations.remove(tokenId);
        }
        map = this.maxTokenLifetimes;
        synchronized (map) {
            this.maxTokenLifetimes.remove(tokenId);
        }
        log.removedTokenState(tokenId);
    }

    protected boolean hasRemainingRenewals(String tokenId, long renewInterval) {
        return System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(30L) + renewInterval < this.getMaxLifetime(tokenId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getMaxLifetime(String tokenId) {
        long result;
        Map<String, Long> map = this.maxTokenLifetimes;
        synchronized (map) {
            result = this.maxTokenLifetimes.getOrDefault(tokenId, 0L);
        }
        return result;
    }

    protected boolean isValidIdentifier(String tokenId) {
        return tokenId != null && !tokenId.isEmpty();
    }

    protected void validateToken(String tokenId) throws IllegalArgumentException, UnknownTokenException {
        if (!this.isValidIdentifier(tokenId)) {
            throw new IllegalArgumentException("Token identifier cannot be null.");
        }
        if (this.isUnknown(tokenId)) {
            log.unknownToken(tokenId);
            throw new UnknownTokenException(tokenId);
        }
    }

    protected String getTimestampDisplay(long timestamp) {
        return Instant.ofEpochMilli(timestamp).toString();
    }

    protected void evictExpiredTokens() {
        for (String tokenId : this.getTokens()) {
            try {
                if (!this.needsEviction(tokenId)) continue;
                log.evictToken(tokenId);
                this.removeToken(tokenId);
            }
            catch (Exception e) {
                log.failedExpiredTokenEviction(tokenId, e);
            }
        }
    }

    protected boolean needsEviction(String tokenId) throws UnknownTokenException {
        long maxLifetime = this.getMaxLifetime(tokenId);
        if (maxLifetime <= 0L) {
            throw new UnknownTokenException(tokenId);
        }
        return maxLifetime + TimeUnit.SECONDS.toMillis(this.tokenEvictionGracePeriod) <= System.currentTimeMillis();
    }

    protected List<String> getTokens() {
        return new ArrayList<String>(this.tokenExpirations.keySet());
    }
}

