/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiClusterRef;
import com.cloudera.api.swagger.model.ApiCommissionState;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiEntityStatus;
import com.cloudera.api.swagger.model.ApiEntityType;
import com.cloudera.api.swagger.model.ApiHealthCheck;
import com.cloudera.api.swagger.model.ApiHealthSummary;
import com.cloudera.api.swagger.model.ApiOsDistribution;
import com.cloudera.api.swagger.model.ApiRoleRef;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="This is the model for a host in the system.")
public class ApiHost {
    @SerializedName(value="hostId")
    private String hostId = null;
    @SerializedName(value="ipAddress")
    private String ipAddress = null;
    @SerializedName(value="hostname")
    private String hostname = null;
    @SerializedName(value="rackId")
    private String rackId = null;
    @SerializedName(value="lastHeartbeat")
    private String lastHeartbeat = null;
    @SerializedName(value="roleRefs")
    private List<ApiRoleRef> roleRefs = null;
    @SerializedName(value="healthSummary")
    private ApiHealthSummary healthSummary = null;
    @SerializedName(value="healthChecks")
    private List<ApiHealthCheck> healthChecks = null;
    @SerializedName(value="hostUrl")
    private String hostUrl = null;
    @SerializedName(value="maintenanceMode")
    private Boolean maintenanceMode = null;
    @SerializedName(value="commissionState")
    private ApiCommissionState commissionState = null;
    @SerializedName(value="maintenanceOwners")
    private List<ApiEntityType> maintenanceOwners = null;
    @SerializedName(value="config")
    private ApiConfigList config = null;
    @SerializedName(value="numCores")
    private BigDecimal numCores = null;
    @SerializedName(value="numPhysicalCores")
    private BigDecimal numPhysicalCores = null;
    @SerializedName(value="totalPhysMemBytes")
    private BigDecimal totalPhysMemBytes = null;
    @SerializedName(value="entityStatus")
    private ApiEntityStatus entityStatus = null;
    @SerializedName(value="clusterRef")
    private ApiClusterRef clusterRef = null;
    @SerializedName(value="distribution")
    private ApiOsDistribution distribution = null;

    public ApiHost hostId(String hostId) {
        this.hostId = hostId;
        return this;
    }

    @ApiModelProperty(value="A unique host identifier. This is not the same as the hostname (FQDN). It is a distinct value that remains the same even if the hostname changes.")
    public String getHostId() {
        return this.hostId;
    }

    public void setHostId(String hostId) {
        this.hostId = hostId;
    }

    public ApiHost ipAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    @ApiModelProperty(value="The host IP address. This field is not mutable after the initial creation.")
    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public ApiHost hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @ApiModelProperty(value="The hostname. This field is not mutable after the initial creation.")
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public ApiHost rackId(String rackId) {
        this.rackId = rackId;
        return this;
    }

    @ApiModelProperty(value="The rack ID for this host.")
    public String getRackId() {
        return this.rackId;
    }

    public void setRackId(String rackId) {
        this.rackId = rackId;
    }

    public ApiHost lastHeartbeat(String lastHeartbeat) {
        this.lastHeartbeat = lastHeartbeat;
        return this;
    }

    @ApiModelProperty(value="Readonly. Requires \"full\" view. When the host agent sent the last heartbeat.")
    public String getLastHeartbeat() {
        return this.lastHeartbeat;
    }

    public void setLastHeartbeat(String lastHeartbeat) {
        this.lastHeartbeat = lastHeartbeat;
    }

    public ApiHost roleRefs(List<ApiRoleRef> roleRefs) {
        this.roleRefs = roleRefs;
        return this;
    }

    public ApiHost addRoleRefsItem(ApiRoleRef roleRefsItem) {
        if (this.roleRefs == null) {
            this.roleRefs = new ArrayList<ApiRoleRef>();
        }
        this.roleRefs.add(roleRefsItem);
        return this;
    }

    @ApiModelProperty(value="Readonly. Requires \"full\" view. The list of roles assigned to this host.")
    public List<ApiRoleRef> getRoleRefs() {
        return this.roleRefs;
    }

    public void setRoleRefs(List<ApiRoleRef> roleRefs) {
        this.roleRefs = roleRefs;
    }

    public ApiHost healthSummary(ApiHealthSummary healthSummary) {
        this.healthSummary = healthSummary;
        return this;
    }

    @ApiModelProperty(value="Readonly. Requires \"full\" view. The high-level health status of this host.")
    public ApiHealthSummary getHealthSummary() {
        return this.healthSummary;
    }

    public void setHealthSummary(ApiHealthSummary healthSummary) {
        this.healthSummary = healthSummary;
    }

    public ApiHost healthChecks(List<ApiHealthCheck> healthChecks) {
        this.healthChecks = healthChecks;
        return this;
    }

    public ApiHost addHealthChecksItem(ApiHealthCheck healthChecksItem) {
        if (this.healthChecks == null) {
            this.healthChecks = new ArrayList<ApiHealthCheck>();
        }
        this.healthChecks.add(healthChecksItem);
        return this;
    }

    @ApiModelProperty(value="Readonly. Requires \"full\" view. The list of health checks performed on the host, with their results.")
    public List<ApiHealthCheck> getHealthChecks() {
        return this.healthChecks;
    }

    public void setHealthChecks(List<ApiHealthCheck> healthChecks) {
        this.healthChecks = healthChecks;
    }

    public ApiHost hostUrl(String hostUrl) {
        this.hostUrl = hostUrl;
        return this;
    }

    @ApiModelProperty(value="Readonly. A URL into the Cloudera Manager web UI for this specific host.")
    public String getHostUrl() {
        return this.hostUrl;
    }

    public void setHostUrl(String hostUrl) {
        this.hostUrl = hostUrl;
    }

    public ApiHost maintenanceMode(Boolean maintenanceMode) {
        this.maintenanceMode = maintenanceMode;
        return this;
    }

    @ApiModelProperty(value="Readonly. Whether the host is in maintenance mode. Available since API v2.")
    public Boolean getMaintenanceMode() {
        return this.maintenanceMode;
    }

    public void setMaintenanceMode(Boolean maintenanceMode) {
        this.maintenanceMode = maintenanceMode;
    }

    public ApiHost commissionState(ApiCommissionState commissionState) {
        this.commissionState = commissionState;
        return this;
    }

    @ApiModelProperty(value="Readonly. The commission state of this role. Available since API v2.")
    public ApiCommissionState getCommissionState() {
        return this.commissionState;
    }

    public void setCommissionState(ApiCommissionState commissionState) {
        this.commissionState = commissionState;
    }

    public ApiHost maintenanceOwners(List<ApiEntityType> maintenanceOwners) {
        this.maintenanceOwners = maintenanceOwners;
        return this;
    }

    public ApiHost addMaintenanceOwnersItem(ApiEntityType maintenanceOwnersItem) {
        if (this.maintenanceOwners == null) {
            this.maintenanceOwners = new ArrayList<ApiEntityType>();
        }
        this.maintenanceOwners.add(maintenanceOwnersItem);
        return this;
    }

    @ApiModelProperty(example="\"null\"", value="Readonly. The list of objects that trigger this host to be in maintenance mode. Available since API v2.")
    public List<ApiEntityType> getMaintenanceOwners() {
        return this.maintenanceOwners;
    }

    public void setMaintenanceOwners(List<ApiEntityType> maintenanceOwners) {
        this.maintenanceOwners = maintenanceOwners;
    }

    public ApiHost config(ApiConfigList config) {
        this.config = config;
        return this;
    }

    @ApiModelProperty(value="")
    public ApiConfigList getConfig() {
        return this.config;
    }

    public void setConfig(ApiConfigList config) {
        this.config = config;
    }

    public ApiHost numCores(BigDecimal numCores) {
        this.numCores = numCores;
        return this;
    }

    @ApiModelProperty(value="Readonly. The number of logical CPU cores on this host. Only populated after the host has heartbeated to the server. Available since API v4.")
    public BigDecimal getNumCores() {
        return this.numCores;
    }

    public void setNumCores(BigDecimal numCores) {
        this.numCores = numCores;
    }

    public ApiHost numPhysicalCores(BigDecimal numPhysicalCores) {
        this.numPhysicalCores = numPhysicalCores;
        return this;
    }

    @ApiModelProperty(value="Readonly. The number of physical CPU cores on this host. Only populated after the host has heartbeated to the server. Available since API v9.")
    public BigDecimal getNumPhysicalCores() {
        return this.numPhysicalCores;
    }

    public void setNumPhysicalCores(BigDecimal numPhysicalCores) {
        this.numPhysicalCores = numPhysicalCores;
    }

    public ApiHost totalPhysMemBytes(BigDecimal totalPhysMemBytes) {
        this.totalPhysMemBytes = totalPhysMemBytes;
        return this;
    }

    @ApiModelProperty(value="Readonly. The amount of physical RAM on this host, in bytes. Only populated after the host has heartbeated to the server. Available since API v4.")
    public BigDecimal getTotalPhysMemBytes() {
        return this.totalPhysMemBytes;
    }

    public void setTotalPhysMemBytes(BigDecimal totalPhysMemBytes) {
        this.totalPhysMemBytes = totalPhysMemBytes;
    }

    public ApiHost entityStatus(ApiEntityStatus entityStatus) {
        this.entityStatus = entityStatus;
        return this;
    }

    @ApiModelProperty(value="Readonly. The entity status for this host. Available since API v11.")
    public ApiEntityStatus getEntityStatus() {
        return this.entityStatus;
    }

    public void setEntityStatus(ApiEntityStatus entityStatus) {
        this.entityStatus = entityStatus;
    }

    public ApiHost clusterRef(ApiClusterRef clusterRef) {
        this.clusterRef = clusterRef;
        return this;
    }

    @ApiModelProperty(value="Readonly. A reference to the enclosing cluster. This might be null if the host is not yet assigned to a cluster. Available since API v11.")
    public ApiClusterRef getClusterRef() {
        return this.clusterRef;
    }

    public void setClusterRef(ApiClusterRef clusterRef) {
        this.clusterRef = clusterRef;
    }

    public ApiHost distribution(ApiOsDistribution distribution) {
        this.distribution = distribution;
        return this;
    }

    @ApiModelProperty(value="Readonly. OS distribution available on the host. Available since API v40.")
    public ApiOsDistribution getDistribution() {
        return this.distribution;
    }

    public void setDistribution(ApiOsDistribution distribution) {
        this.distribution = distribution;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiHost apiHost = (ApiHost)o;
        return Objects.equals(this.hostId, apiHost.hostId) && Objects.equals(this.ipAddress, apiHost.ipAddress) && Objects.equals(this.hostname, apiHost.hostname) && Objects.equals(this.rackId, apiHost.rackId) && Objects.equals(this.lastHeartbeat, apiHost.lastHeartbeat) && Objects.equals(this.roleRefs, apiHost.roleRefs) && Objects.equals((Object)this.healthSummary, (Object)apiHost.healthSummary) && Objects.equals(this.healthChecks, apiHost.healthChecks) && Objects.equals(this.hostUrl, apiHost.hostUrl) && Objects.equals(this.maintenanceMode, apiHost.maintenanceMode) && Objects.equals((Object)this.commissionState, (Object)apiHost.commissionState) && Objects.equals(this.maintenanceOwners, apiHost.maintenanceOwners) && Objects.equals(this.config, apiHost.config) && Objects.equals(this.numCores, apiHost.numCores) && Objects.equals(this.numPhysicalCores, apiHost.numPhysicalCores) && Objects.equals(this.totalPhysMemBytes, apiHost.totalPhysMemBytes) && Objects.equals((Object)this.entityStatus, (Object)apiHost.entityStatus) && Objects.equals(this.clusterRef, apiHost.clusterRef) && Objects.equals(this.distribution, apiHost.distribution);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.hostId, this.ipAddress, this.hostname, this.rackId, this.lastHeartbeat, this.roleRefs, this.healthSummary, this.healthChecks, this.hostUrl, this.maintenanceMode, this.commissionState, this.maintenanceOwners, this.config, this.numCores, this.numPhysicalCores, this.totalPhysMemBytes, this.entityStatus, this.clusterRef, this.distribution});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiHost {\n");
        sb.append("    hostId: ").append(this.toIndentedString(this.hostId)).append("\n");
        sb.append("    ipAddress: ").append(this.toIndentedString(this.ipAddress)).append("\n");
        sb.append("    hostname: ").append(this.toIndentedString(this.hostname)).append("\n");
        sb.append("    rackId: ").append(this.toIndentedString(this.rackId)).append("\n");
        sb.append("    lastHeartbeat: ").append(this.toIndentedString(this.lastHeartbeat)).append("\n");
        sb.append("    roleRefs: ").append(this.toIndentedString(this.roleRefs)).append("\n");
        sb.append("    healthSummary: ").append(this.toIndentedString((Object)this.healthSummary)).append("\n");
        sb.append("    healthChecks: ").append(this.toIndentedString(this.healthChecks)).append("\n");
        sb.append("    hostUrl: ").append(this.toIndentedString(this.hostUrl)).append("\n");
        sb.append("    maintenanceMode: ").append(this.toIndentedString(this.maintenanceMode)).append("\n");
        sb.append("    commissionState: ").append(this.toIndentedString((Object)this.commissionState)).append("\n");
        sb.append("    maintenanceOwners: ").append(this.toIndentedString(this.maintenanceOwners)).append("\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    numCores: ").append(this.toIndentedString(this.numCores)).append("\n");
        sb.append("    numPhysicalCores: ").append(this.toIndentedString(this.numPhysicalCores)).append("\n");
        sb.append("    totalPhysMemBytes: ").append(this.toIndentedString(this.totalPhysMemBytes)).append("\n");
        sb.append("    entityStatus: ").append(this.toIndentedString((Object)this.entityStatus)).append("\n");
        sb.append("    clusterRef: ").append(this.toIndentedString(this.clusterRef)).append("\n");
        sb.append("    distribution: ").append(this.toIndentedString(this.distribution)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

