/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.action.impl;

import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.context.ProfileRequestContext;

public abstract class AbstractMessageChannelSecurity
extends AbstractProfileAction {
    @Nonnull
    private Function<ProfileRequestContext, BaseContext> parentContextLookupStrategy = new Function<ProfileRequestContext, BaseContext>(){

        @Nullable
        public BaseContext apply(@Nullable ProfileRequestContext input) {
            return input;
        }
    };
    @Nullable
    private BaseContext parentContext;

    public void setParentContextLookupStrategy(@Nonnull Function<ProfileRequestContext, BaseContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.parentContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Parent context lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.parentContext = (BaseContext)this.parentContextLookupStrategy.apply((Object)profileRequestContext);
        if (this.parentContext != null) {
            return super.doPreExecute(profileRequestContext);
        }
        return false;
    }

    protected BaseContext getParentContext() {
        return this.parentContext;
    }
}

