/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger;

import com.cloudera.api.swagger.client.ApiCallback;
import com.cloudera.api.swagger.client.ApiClient;
import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.client.ApiResponse;
import com.cloudera.api.swagger.client.Configuration;
import com.cloudera.api.swagger.client.Pair;
import com.cloudera.api.swagger.client.ProgressRequestBody;
import com.cloudera.api.swagger.client.ProgressResponseBody;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRoleConfigGroup;
import com.cloudera.api.swagger.model.ApiRoleConfigGroupList;
import com.cloudera.api.swagger.model.ApiRoleList;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class MgmtRoleConfigGroupsResourceApi {
    private ApiClient apiClient;

    public MgmtRoleConfigGroupsResourceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MgmtRoleConfigGroupsResourceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call readConfigCall(String roleConfigGroupName, String view, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/cm/service/roleConfigGroups/{roleConfigGroupName}/config".replaceAll("\\{roleConfigGroupName\\}", this.apiClient.escapeString(roleConfigGroupName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (view != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "view", view));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call readConfigValidateBeforeCall(String roleConfigGroupName, String view, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (roleConfigGroupName == null) {
            throw new ApiException("Missing the required parameter 'roleConfigGroupName' when calling readConfig(Async)");
        }
        Call call = this.readConfigCall(roleConfigGroupName, view, progressListener, progressRequestListener);
        return call;
    }

    public ApiConfigList readConfig(String roleConfigGroupName, String view) throws ApiException {
        ApiResponse<ApiConfigList> resp = this.readConfigWithHttpInfo(roleConfigGroupName, view);
        return resp.getData();
    }

    public ApiResponse<ApiConfigList> readConfigWithHttpInfo(String roleConfigGroupName, String view) throws ApiException {
        Call call = this.readConfigValidateBeforeCall(roleConfigGroupName, view, null, null);
        Type localVarReturnType = new TypeToken<ApiConfigList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call readConfigAsync(String roleConfigGroupName, String view, final ApiCallback<ApiConfigList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.readConfigValidateBeforeCall(roleConfigGroupName, view, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiConfigList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call readRoleConfigGroupCall(String roleConfigGroupName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/cm/service/roleConfigGroups/{roleConfigGroupName}".replaceAll("\\{roleConfigGroupName\\}", this.apiClient.escapeString(roleConfigGroupName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call readRoleConfigGroupValidateBeforeCall(String roleConfigGroupName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (roleConfigGroupName == null) {
            throw new ApiException("Missing the required parameter 'roleConfigGroupName' when calling readRoleConfigGroup(Async)");
        }
        Call call = this.readRoleConfigGroupCall(roleConfigGroupName, progressListener, progressRequestListener);
        return call;
    }

    public ApiRoleConfigGroup readRoleConfigGroup(String roleConfigGroupName) throws ApiException {
        ApiResponse<ApiRoleConfigGroup> resp = this.readRoleConfigGroupWithHttpInfo(roleConfigGroupName);
        return resp.getData();
    }

    public ApiResponse<ApiRoleConfigGroup> readRoleConfigGroupWithHttpInfo(String roleConfigGroupName) throws ApiException {
        Call call = this.readRoleConfigGroupValidateBeforeCall(roleConfigGroupName, null, null);
        Type localVarReturnType = new TypeToken<ApiRoleConfigGroup>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call readRoleConfigGroupAsync(String roleConfigGroupName, final ApiCallback<ApiRoleConfigGroup> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.readRoleConfigGroupValidateBeforeCall(roleConfigGroupName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiRoleConfigGroup>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call readRoleConfigGroupsCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/cm/service/roleConfigGroups";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call readRoleConfigGroupsValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.readRoleConfigGroupsCall(progressListener, progressRequestListener);
        return call;
    }

    public ApiRoleConfigGroupList readRoleConfigGroups() throws ApiException {
        ApiResponse<ApiRoleConfigGroupList> resp = this.readRoleConfigGroupsWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<ApiRoleConfigGroupList> readRoleConfigGroupsWithHttpInfo() throws ApiException {
        Call call = this.readRoleConfigGroupsValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<ApiRoleConfigGroupList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call readRoleConfigGroupsAsync(final ApiCallback<ApiRoleConfigGroupList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.readRoleConfigGroupsValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiRoleConfigGroupList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call readRolesCall(String roleConfigGroupName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/cm/service/roleConfigGroups/{roleConfigGroupName}/roles".replaceAll("\\{roleConfigGroupName\\}", this.apiClient.escapeString(roleConfigGroupName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call readRolesValidateBeforeCall(String roleConfigGroupName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (roleConfigGroupName == null) {
            throw new ApiException("Missing the required parameter 'roleConfigGroupName' when calling readRoles(Async)");
        }
        Call call = this.readRolesCall(roleConfigGroupName, progressListener, progressRequestListener);
        return call;
    }

    public ApiRoleList readRoles(String roleConfigGroupName) throws ApiException {
        ApiResponse<ApiRoleList> resp = this.readRolesWithHttpInfo(roleConfigGroupName);
        return resp.getData();
    }

    public ApiResponse<ApiRoleList> readRolesWithHttpInfo(String roleConfigGroupName) throws ApiException {
        Call call = this.readRolesValidateBeforeCall(roleConfigGroupName, null, null);
        Type localVarReturnType = new TypeToken<ApiRoleList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call readRolesAsync(String roleConfigGroupName, final ApiCallback<ApiRoleList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.readRolesValidateBeforeCall(roleConfigGroupName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiRoleList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateConfigCall(String roleConfigGroupName, String message, ApiConfigList body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiConfigList localVarPostBody = body;
        String localVarPath = "/cm/service/roleConfigGroups/{roleConfigGroupName}/config".replaceAll("\\{roleConfigGroupName\\}", this.apiClient.escapeString(roleConfigGroupName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (message != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "message", message));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateConfigValidateBeforeCall(String roleConfigGroupName, String message, ApiConfigList body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (roleConfigGroupName == null) {
            throw new ApiException("Missing the required parameter 'roleConfigGroupName' when calling updateConfig(Async)");
        }
        Call call = this.updateConfigCall(roleConfigGroupName, message, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiConfigList updateConfig(String roleConfigGroupName, String message, ApiConfigList body) throws ApiException {
        ApiResponse<ApiConfigList> resp = this.updateConfigWithHttpInfo(roleConfigGroupName, message, body);
        return resp.getData();
    }

    public ApiResponse<ApiConfigList> updateConfigWithHttpInfo(String roleConfigGroupName, String message, ApiConfigList body) throws ApiException {
        Call call = this.updateConfigValidateBeforeCall(roleConfigGroupName, message, body, null, null);
        Type localVarReturnType = new TypeToken<ApiConfigList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateConfigAsync(String roleConfigGroupName, String message, ApiConfigList body, final ApiCallback<ApiConfigList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateConfigValidateBeforeCall(roleConfigGroupName, message, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiConfigList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateRoleConfigGroupCall(String roleConfigGroupName, String message, ApiRoleConfigGroup body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiRoleConfigGroup localVarPostBody = body;
        String localVarPath = "/cm/service/roleConfigGroups/{roleConfigGroupName}".replaceAll("\\{roleConfigGroupName\\}", this.apiClient.escapeString(roleConfigGroupName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (message != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "message", message));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateRoleConfigGroupValidateBeforeCall(String roleConfigGroupName, String message, ApiRoleConfigGroup body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (roleConfigGroupName == null) {
            throw new ApiException("Missing the required parameter 'roleConfigGroupName' when calling updateRoleConfigGroup(Async)");
        }
        Call call = this.updateRoleConfigGroupCall(roleConfigGroupName, message, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiRoleConfigGroup updateRoleConfigGroup(String roleConfigGroupName, String message, ApiRoleConfigGroup body) throws ApiException {
        ApiResponse<ApiRoleConfigGroup> resp = this.updateRoleConfigGroupWithHttpInfo(roleConfigGroupName, message, body);
        return resp.getData();
    }

    public ApiResponse<ApiRoleConfigGroup> updateRoleConfigGroupWithHttpInfo(String roleConfigGroupName, String message, ApiRoleConfigGroup body) throws ApiException {
        Call call = this.updateRoleConfigGroupValidateBeforeCall(roleConfigGroupName, message, body, null, null);
        Type localVarReturnType = new TypeToken<ApiRoleConfigGroup>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateRoleConfigGroupAsync(String roleConfigGroupName, String message, ApiRoleConfigGroup body, final ApiCallback<ApiRoleConfigGroup> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateRoleConfigGroupValidateBeforeCall(roleConfigGroupName, message, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiRoleConfigGroup>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

