/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.decorators.SingleReplyRequestDecorator;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.util.Strings;

public class ExtendedRequestDecorator<Q extends ExtendedRequest>
extends SingleReplyRequestDecorator<Q>
implements ExtendedRequest {
    private int extendedRequestLength;
    private byte[] requestNameBytes;
    protected byte[] requestValue;

    public ExtendedRequestDecorator(LdapApiService codec, Q decoratedMessage) {
        super(codec, decoratedMessage);
    }

    public String getRequestName() {
        return ((ExtendedRequest)this.getDecorated()).getRequestName();
    }

    public ExtendedRequest setRequestName(String oid) {
        ((ExtendedRequest)this.getDecorated()).setRequestName(oid);
        return this;
    }

    public byte[] getRequestValue() {
        return this.requestValue;
    }

    public void setRequestValue(byte[] requestValue) {
        this.requestValue = requestValue;
    }

    public ExtendedRequest setMessageId(int messageId) {
        super.setMessageId(messageId);
        return this;
    }

    public ExtendedRequest addControl(Control control) {
        return (ExtendedRequest)super.addControl(control);
    }

    public ExtendedRequest addAllControls(Control[] controls) {
        return (ExtendedRequest)super.addAllControls(controls);
    }

    public ExtendedRequest removeControl(Control control) {
        return (ExtendedRequest)super.removeControl(control);
    }

    public int computeLength() {
        this.requestNameBytes = Strings.getBytesUtf8((String)this.getRequestName());
        this.extendedRequestLength = 1 + TLV.getNbBytes((int)this.requestNameBytes.length) + this.requestNameBytes.length;
        if (this.getRequestValue() != null) {
            this.extendedRequestLength += 1 + TLV.getNbBytes((int)this.getRequestValue().length) + this.getRequestValue().length;
        }
        return 1 + TLV.getNbBytes((int)this.extendedRequestLength) + this.extendedRequestLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)119);
            buffer.put(TLV.getBytes((int)this.extendedRequestLength));
            if (this.requestNameBytes == null) {
                throw new EncoderException(I18n.err((I18n)I18n.ERR_05000_NULL_REQUEST_NAME, (Object[])new Object[0]));
            }
            buffer.put((byte)-128);
            buffer.put(TLV.getBytes((int)this.requestNameBytes.length));
            if (this.requestNameBytes.length != 0) {
                buffer.put(this.requestNameBytes);
            }
            if (this.getRequestValue() != null) {
                buffer.put((byte)-127);
                buffer.put(TLV.getBytes((int)this.getRequestValue().length));
                if (this.getRequestValue().length != 0) {
                    buffer.put(this.getRequestValue());
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_08212_PDU_BUFFER_TOO_SMALL, (Object[])new Object[0]), (Exception)boe);
        }
        return buffer;
    }
}

