/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.controls.sort;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.Asn1Object;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ControlDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.controls.sort.SortResponseContainer;
import org.apache.directory.api.ldap.model.message.controls.SortResponse;
import org.apache.directory.api.ldap.model.message.controls.SortResponseControlImpl;
import org.apache.directory.api.ldap.model.message.controls.SortResultCode;
import org.apache.directory.api.util.Strings;

public class SortResponseDecorator
extends ControlDecorator<SortResponse>
implements SortResponse {
    private static final Asn1Decoder DECODER = new Asn1Decoder();
    private int sortRespLen = 0;

    public SortResponseDecorator(LdapApiService codec) {
        super(codec, new SortResponseControlImpl());
    }

    public SortResponseDecorator(LdapApiService codec, SortResponse control) {
        super(codec, control);
    }

    public int computeLength() {
        this.sortRespLen = 0;
        this.valueLength = 0;
        this.sortRespLen += 3;
        if (this.getAttributeName() != null) {
            byte[] data = Strings.getBytesUtf8((String)this.getAttributeName());
            this.sortRespLen += 1 + TLV.getNbBytes((int)data.length) + data.length;
        }
        this.valueLength = 1 + TLV.getNbBytes((int)this.sortRespLen) + this.sortRespLen;
        return this.valueLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_08000_CANNOT_PUT_A_PDU_IN_NULL_BUFFER, (Object[])new Object[0]));
        }
        buffer.put(UniversalTag.SEQUENCE.getValue());
        buffer.put(TLV.getBytes((int)this.sortRespLen));
        BerValue.encodeEnumerated((ByteBuffer)buffer, (int)this.getSortResult().getVal());
        if (this.getAttributeName() != null) {
            BerValue.encode((ByteBuffer)buffer, (String)this.getAttributeName());
        }
        return buffer;
    }

    @Override
    public Asn1Object decode(byte[] controlBytes) throws DecoderException {
        ByteBuffer buffer = ByteBuffer.wrap(controlBytes);
        SortResponseContainer container = new SortResponseContainer(this.getCodecService(), this);
        DECODER.decode(buffer, (Asn1Container)container);
        return this;
    }

    @Override
    public byte[] getValue() {
        if (this.value == null) {
            try {
                this.computeLength();
                ByteBuffer buffer = ByteBuffer.allocate(this.valueLength);
                this.value = this.encode(buffer).array();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.value;
    }

    public void setSortResult(SortResultCode result) {
        ((SortResponse)this.getDecorated()).setSortResult(result);
    }

    public SortResultCode getSortResult() {
        return ((SortResponse)this.getDecorated()).getSortResult();
    }

    public void setAttributeName(String attributeName) {
        ((SortResponse)this.getDecorated()).setAttributeName(attributeName);
    }

    public String getAttributeName() {
        return ((SortResponse)this.getDecorated()).getAttributeName();
    }
}

