/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.atomic.AtomicInteger;
import jdbm.recman.BlockView;
import org.apache.directory.server.i18n.I18n;

public final class BlockIo
implements Externalizable {
    public static final long serialVersionUID = 2L;
    private long blockId;
    private byte[] data;
    private BlockView view = null;
    private boolean dirty = false;
    private AtomicInteger transactionCount = new AtomicInteger(0);

    public BlockIo() {
    }

    BlockIo(long blockId, byte[] data) {
        if (blockId < 0L) {
            throw new Error(I18n.err((I18n)I18n.ERR_539_BAD_BLOCK_ID, (Object[])new Object[]{blockId}));
        }
        this.blockId = blockId;
        this.data = data;
    }

    byte[] getData() {
        return this.data;
    }

    void setBlockId(long blockId) {
        if (this.isInTransaction()) {
            throw new Error(I18n.err((I18n)I18n.ERR_540, (Object[])new Object[0]));
        }
        if (blockId < 0L) {
            throw new Error(I18n.err((I18n)I18n.ERR_539_BAD_BLOCK_ID, (Object[])new Object[]{blockId}));
        }
        this.blockId = blockId;
    }

    long getBlockId() {
        return this.blockId;
    }

    public BlockView getView() {
        return this.view;
    }

    public void setView(BlockView view) {
        this.view = view;
    }

    void setDirty() {
        this.dirty = true;
    }

    void setClean() {
        this.dirty = false;
    }

    boolean isDirty() {
        return this.dirty;
    }

    boolean isInTransaction() {
        return this.transactionCount.get() != 0;
    }

    void incrementTransactionCount() {
        this.transactionCount.getAndIncrement();
    }

    void decrementTransactionCount() {
        if (this.transactionCount.decrementAndGet() < 0) {
            throw new Error(I18n.err((I18n)I18n.ERR_541, (Object[])new Object[]{this.getBlockId()}));
        }
    }

    public byte readByte(int pos) {
        return this.data[pos];
    }

    public void writeByte(int pos, byte value) {
        this.data[pos] = value;
        this.dirty = true;
    }

    public short readShort(int pos) {
        return (short)((this.data[pos + 0] & 0xFF) << 8 | (this.data[pos + 1] & 0xFF) << 0);
    }

    public void writeShort(int pos, short value) {
        this.data[pos + 0] = (byte)(0xFF & value >> 8);
        this.data[pos + 1] = (byte)(0xFF & value >> 0);
        this.dirty = true;
    }

    public int readInt(int pos) {
        return this.data[pos + 0] << 24 | (this.data[pos + 1] & 0xFF) << 16 | (this.data[pos + 2] & 0xFF) << 8 | (this.data[pos + 3] & 0xFF) << 0;
    }

    public void writeInt(int pos, int value) {
        this.data[pos + 0] = (byte)(0xFF & value >> 24);
        this.data[pos + 1] = (byte)(0xFF & value >> 16);
        this.data[pos + 2] = (byte)(0xFF & value >> 8);
        this.data[pos + 3] = (byte)(0xFF & value >> 0);
        this.dirty = true;
    }

    public long readLong(int pos) {
        return (long)this.data[pos + 0] << 56 | (long)(this.data[pos + 1] & 0xFF) << 48 | (long)(this.data[pos + 2] & 0xFF) << 40 | (long)(this.data[pos + 3] & 0xFF) << 32 | (long)(this.data[pos + 4] & 0xFF) << 24 | (long)(this.data[pos + 5] & 0xFF) << 16 | (long)(this.data[pos + 6] & 0xFF) << 8 | (long)(this.data[pos + 7] & 0xFF);
    }

    public void writeLong(int pos, long value) {
        this.data[pos + 0] = (byte)(0xFFL & value >> 56);
        this.data[pos + 1] = (byte)(0xFFL & value >> 48);
        this.data[pos + 2] = (byte)(0xFFL & value >> 40);
        this.data[pos + 3] = (byte)(0xFFL & value >> 32);
        this.data[pos + 4] = (byte)(0xFFL & value >> 24);
        this.data[pos + 5] = (byte)(0xFFL & value >> 16);
        this.data[pos + 6] = (byte)(0xFFL & value >> 8);
        this.data[pos + 7] = (byte)(0xFFL & value >> 0);
        this.dirty = true;
    }

    public String toString() {
        if (this.view != null) {
            return this.view.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("BlockIO ( ");
        sb.append(this.blockId).append(", ");
        if (this.dirty) {
            sb.append("dirty, ");
        } else {
            sb.append("clean, ");
        }
        if (this.view != null) {
            sb.append(this.view.getClass().getSimpleName()).append(", ");
        } else {
            sb.append("no view, ");
        }
        sb.append("tx: ").append(this.transactionCount.get());
        sb.append(" )");
        return sb.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.blockId = in.readLong();
        int length = in.readInt();
        this.data = new byte[length];
        in.readFully(this.data);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.blockId);
        out.writeInt(this.data.length);
        out.write(this.data);
    }
}

