/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.oozie;

import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.AbstractServiceModelGenerator;

public class OozieServiceModelGenerator
extends AbstractServiceModelGenerator {
    private static final String SERVICE = "OOZIE";
    private static final String SERVICE_TYPE = "OOZIE";
    private static final String ROLE_TYPE = "OOZIE_SERVER";

    @Override
    public boolean handles(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) {
        return "OOZIE".equals(service.getType()) && ROLE_TYPE.equals(role.getType());
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) {
        String port;
        String scheme;
        String hostname = role.getHostRef().getHostname();
        boolean sslEnabled = Boolean.parseBoolean(this.getServiceConfigValue(serviceConfig, "oozie_use_ssl"));
        if (sslEnabled) {
            scheme = "https";
            port = this.getRoleConfigValue(roleConfig, "oozie_https_port");
        } else {
            scheme = "http";
            port = this.getRoleConfigValue(roleConfig, "oozie_http_port");
        }
        return new ServiceModel(ServiceModel.Type.API, "OOZIE", String.format(Locale.getDefault(), "%s://%s:%s/oozie/", scheme, hostname, port));
    }
}

