/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.hdfs;

import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.hdfs.NameNodeServiceModelGenerator;

public class HdfsUIServiceModelGenerator
extends NameNodeServiceModelGenerator {
    private static final String SERVICE = "HDFSUI";

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) throws ApiException {
        String port;
        String scheme;
        String hostname = role.getHostRef().getHostname();
        boolean sslEnabled = Boolean.parseBoolean(this.getServiceConfigValue(serviceConfig, "hdfs_hadoop_ssl_enabled"));
        if (sslEnabled) {
            scheme = "https";
            port = this.getRoleConfigValue(roleConfig, "dfs_https_port");
        } else {
            scheme = "http";
            port = this.getRoleConfigValue(roleConfig, "dfs_http_port");
        }
        String namenodeUrl = String.format(Locale.getDefault(), "%s://%s:%s", scheme, hostname, port);
        return new ServiceModel(ServiceModel.Type.UI, SERVICE, namenodeUrl);
    }
}

