/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.auth;

import java.io.File;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.topology.discovery.cm.ClouderaManagerServiceDiscoveryMessages;
import org.apache.knox.gateway.topology.discovery.cm.auth.JAASClientConfig;

public class AuthUtils {
    private static final String JGSS_LOGIN_MODULE = "com.sun.security.jgss.initiate";
    private static ClouderaManagerServiceDiscoveryMessages log = (ClouderaManagerServiceDiscoveryMessages)MessagesFactory.get(ClouderaManagerServiceDiscoveryMessages.class);

    public static String getKerberosLoginConfiguration() {
        return System.getProperty("java.security.auth.login.config");
    }

    public static Configuration createKerberosJAASConfiguration() throws Exception {
        return AuthUtils.createKerberosJAASConfiguration(AuthUtils.getKerberosLoginConfiguration());
    }

    public static Configuration createKerberosJAASConfiguration(String kerberosLoginConfig) throws Exception {
        if (kerberosLoginConfig == null) {
            throw new IllegalArgumentException("Invalid login configuration.");
        }
        return new JAASClientConfig(new File(kerberosLoginConfig).toURI().toURL());
    }

    public static Subject getKerberosSubject() {
        Subject subject = null;
        String kerberosLoginConfig = AuthUtils.getKerberosLoginConfiguration();
        if (kerberosLoginConfig != null) {
            log.attemptingKerberosLogin(kerberosLoginConfig);
            try {
                JAASClientConfig jaasConf = new JAASClientConfig(new File(kerberosLoginConfig).toURI().toURL());
                LoginContext lc = new LoginContext(JGSS_LOGIN_MODULE, null, null, jaasConf);
                lc.login();
                subject = lc.getSubject();
            }
            catch (Exception e) {
                log.failedKerberosLogin(kerberosLoginConfig, JGSS_LOGIN_MODULE, e);
            }
        }
        return subject;
    }
}

