/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.internal;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Context;
import org.glassfish.hk2.api.PerThread;
import org.glassfish.hk2.api.ServiceHandle;

@Singleton
public class PerThreadContext
implements Context<PerThread> {
    private ThreadLocal<HashMap<ActiveDescriptor<?>, Object>> threadMap = new ThreadLocal<HashMap<ActiveDescriptor<?>, Object>>(){

        @Override
        public HashMap<ActiveDescriptor<?>, Object> initialValue() {
            return new HashMap();
        }
    };

    @Override
    public Class<? extends Annotation> getScope() {
        return PerThread.class;
    }

    @Override
    public <U> U findOrCreate(ActiveDescriptor<U> activeDescriptor, ServiceHandle<?> root) {
        HashMap<ActiveDescriptor<?>, Object> database = this.threadMap.get();
        Object retVal = database.get(activeDescriptor);
        if (retVal == null) {
            retVal = activeDescriptor.create(root);
            database.put(activeDescriptor, retVal);
        }
        return (U)retVal;
    }

    @Override
    public boolean containsKey(ActiveDescriptor<?> descriptor) {
        HashMap<ActiveDescriptor<?>, Object> database = this.threadMap.get();
        return database.containsKey(descriptor);
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public boolean supportsNullCreation() {
        return false;
    }

    @Override
    public void shutdown() {
        this.threadMap = null;
    }

    @Override
    public void destroyOne(ActiveDescriptor<?> descriptor) {
    }
}

