/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wscompile;

import com.oracle.webservices.api.databinding.WSDLResolver;
import com.sun.tools.ws.ToolVersion;
import com.sun.tools.ws.processor.modeler.annotation.WebServiceAp;
import com.sun.tools.ws.processor.modeler.wsdl.ConsoleErrorReporter;
import com.sun.tools.ws.resources.WscompileMessages;
import com.sun.tools.ws.wscompile.AbortException;
import com.sun.tools.ws.wscompile.BadCommandLineException;
import com.sun.tools.ws.wscompile.ErrorReceiverFilter;
import com.sun.tools.ws.wscompile.Options;
import com.sun.tools.ws.wscompile.WsgenOptions;
import com.sun.tools.ws.wscompile.WsimportListener;
import com.sun.tools.xjc.util.NullStream;
import com.sun.xml.txw2.TXW;
import com.sun.xml.txw2.TypedXmlWriter;
import com.sun.xml.txw2.annotation.XmlAttribute;
import com.sun.xml.txw2.annotation.XmlElement;
import com.sun.xml.txw2.output.StreamSerializer;
import com.sun.xml.txw2.output.XmlSerializer;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.databinding.DatabindingConfig;
import com.sun.xml.ws.api.databinding.DatabindingFactory;
import com.sun.xml.ws.api.databinding.MetadataReader;
import com.sun.xml.ws.api.databinding.WSDLGenInfo;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.wsdl.writer.WSDLGeneratorExtension;
import com.sun.xml.ws.binding.WebServiceFeatureList;
import com.sun.xml.ws.db.DatabindingImpl;
import com.sun.xml.ws.model.AbstractSEIModelImpl;
import com.sun.xml.ws.model.ExternalMetadataReader;
import com.sun.xml.ws.util.ServiceFinder;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.Holder;
import org.xml.sax.SAXParseException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class WsgenTool {
    private final PrintStream out;
    private final WsgenOptions options = new WsgenOptions();
    private final Container container;

    public WsgenTool(OutputStream outputStream, Container container) {
        this.out = outputStream instanceof PrintStream ? (PrintStream)outputStream : new PrintStream(outputStream);
        this.container = container;
    }

    public WsgenTool(OutputStream outputStream) {
        this(outputStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(String[] stringArray) {
        Listener listener = new Listener();
        for (String string : stringArray) {
            if (string.equals("-version")) {
                listener.message(WscompileMessages.WSGEN_VERSION(ToolVersion.VERSION.MAJOR_VERSION));
                return true;
            }
            if (!string.equals("-fullversion")) continue;
            listener.message(WscompileMessages.WSGEN_FULLVERSION(ToolVersion.VERSION.toString()));
            return true;
        }
        try {
            this.options.parseArguments(stringArray);
            this.options.validate();
            if (!this.buildModel(this.options.endpoint.getName(), listener)) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Options.WeAreDone weAreDone) {
            this.usage(weAreDone.getOptions());
        }
        catch (BadCommandLineException badCommandLineException) {
            if (badCommandLineException.getMessage() != null) {
                System.out.println(badCommandLineException.getMessage());
                System.out.println();
            }
            this.usage(badCommandLineException.getOptions());
            int n = 0;
            return n != 0;
        }
        catch (AbortException abortException) {
        }
        finally {
            if (!this.options.keep) {
                this.options.removeGeneratedFiles();
            }
        }
        return true;
    }

    public boolean buildModel(String string, Listener listener) throws BadCommandLineException {
        Object object;
        final ErrorReceiverFilter errorReceiverFilter = new ErrorReceiverFilter(listener);
        ArrayList<String> arrayList = new ArrayList<String>(6 + (this.options.nocompile ? 1 : 0) + (this.options.encoding != null ? 2 : 0));
        arrayList.add("-d");
        arrayList.add(this.options.destDir.getAbsolutePath());
        arrayList.add("-classpath");
        arrayList.add(this.options.classpath);
        arrayList.add("-s");
        arrayList.add(this.options.sourceDir.getAbsolutePath());
        if (this.options.nocompile) {
            arrayList.add("-proc:only");
        }
        if (this.options.encoding != null) {
            arrayList.add("-encoding");
            arrayList.add(this.options.encoding);
        }
        if (this.options.javacOptions != null) {
            object = this.options.getJavacOptions(arrayList, listener);
            arrayList.addAll((Collection<String>)object);
        }
        if ((object = ToolProvider.getSystemJavaCompiler()) == null) {
            this.out.println(WscompileMessages.WSCOMPILE_CANT_GET_COMPILER(this.property("java.home"), this.property("java.version"), this.property("java.vendor")));
            return false;
        }
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        StandardJavaFileManager standardJavaFileManager = object.getStandardFileManager(diagnosticCollector, null, null);
        JavaCompiler.CompilationTask compilationTask = object.getTask(null, standardJavaFileManager, diagnosticCollector, arrayList, Collections.singleton(string.replaceAll("\\$", ".")), null);
        compilationTask.setProcessors(Collections.singleton(new WebServiceAp(this.options, this.out)));
        boolean bl = compilationTask.call();
        if (!bl) {
            this.out.println(WscompileMessages.WSCOMPILE_ERROR(WscompileMessages.WSCOMPILE_COMPILATION_FAILED()));
            return false;
        }
        if (this.options.genWsdl) {
            Class<?> clazz;
            DatabindingConfig databindingConfig = new DatabindingConfig();
            List<String> list = this.options.externalMetadataFiles;
            boolean bl2 = this.options.disableXmlSecurity;
            if (list != null && list.size() > 0) {
                databindingConfig.setMetadataReader((MetadataReader)new ExternalMetadataReader(this.getExternalFiles(list), null, null, true, bl2));
            }
            String string2 = this.options.destDir.getAbsolutePath() + File.pathSeparator + this.options.classpath;
            URLClassLoader uRLClassLoader = new URLClassLoader(Options.pathToURLs(string2), this.getClass().getClassLoader());
            try {
                clazz = uRLClassLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new BadCommandLineException(WscompileMessages.WSGEN_CLASS_NOT_FOUND(string));
            }
            BindingID bindingID = this.options.getBindingID(this.options.protocol);
            if (!this.options.protocolSet) {
                bindingID = BindingID.parse(clazz);
            }
            WebServiceFeatureList webServiceFeatureList = new WebServiceFeatureList(clazz);
            if (this.options.portName != null) {
                databindingConfig.getMappingInfo().setPortName(this.options.portName);
            }
            DatabindingFactory databindingFactory = DatabindingFactory.newInstance();
            databindingConfig.setEndpointClass(clazz);
            databindingConfig.getMappingInfo().setServiceName(this.options.serviceName);
            databindingConfig.setFeatures(webServiceFeatureList.toArray());
            databindingConfig.setClassLoader((ClassLoader)uRLClassLoader);
            databindingConfig.getMappingInfo().setBindingID(bindingID);
            DatabindingImpl databindingImpl = (DatabindingImpl)databindingFactory.createRuntime(databindingConfig);
            final File[] fileArray = new File[1];
            final HashMap<String, File> hashMap = new HashMap<String, File>();
            WSDLGenInfo wSDLGenInfo = new WSDLGenInfo();
            wSDLGenInfo.setSecureXmlProcessingDisabled(bl2);
            wSDLGenInfo.setWsdlResolver(new WSDLResolver(){

                private File toFile(String string) {
                    return new File(((WsgenTool)WsgenTool.this).options.nonclassDestDir, string);
                }

                private Result toResult(File file) {
                    StreamResult streamResult;
                    try {
                        streamResult = new StreamResult(new FileOutputStream(file));
                        streamResult.setSystemId(file.getPath().replace('\\', '/'));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        errorReceiverFilter.error(fileNotFoundException);
                        return null;
                    }
                    return streamResult;
                }

                public Result getWSDL(String string) {
                    File file;
                    fileArray[0] = file = this.toFile(string);
                    return this.toResult(file);
                }

                public Result getSchemaOutput(String string, String string2) {
                    if (string == null) {
                        return null;
                    }
                    File file = this.toFile(string2);
                    hashMap.put(string, file);
                    return this.toResult(file);
                }

                public Result getAbstractWSDL(Holder<String> holder) {
                    return this.toResult(this.toFile((String)holder.value));
                }

                public Result getSchemaOutput(String string, Holder<String> holder) {
                    return this.getSchemaOutput(string, (String)holder.value);
                }
            });
            wSDLGenInfo.setContainer(this.container);
            wSDLGenInfo.setExtensions((WSDLGeneratorExtension[])ServiceFinder.find(WSDLGeneratorExtension.class).toArray());
            wSDLGenInfo.setInlineSchemas(this.options.inlineSchemas);
            databindingImpl.generateWSDL(wSDLGenInfo);
            if (this.options.wsgenReport != null) {
                this.generateWsgenReport(clazz, (AbstractSEIModelImpl)databindingImpl.getModel(), fileArray[0], hashMap);
            }
        }
        return true;
    }

    private String property(String string) {
        try {
            String string2 = System.getProperty(string);
            return string2 != null ? string2 : "UNKNOWN";
        }
        catch (SecurityException securityException) {
            return "UNKNOWN";
        }
    }

    private List<File> getExternalFiles(List<String> list) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string : list) {
            File file = new File(string);
            if (!file.exists()) {
                file = new File(this.options.sourceDir.getAbsolutePath() + File.separator + string);
            }
            arrayList.add(file);
        }
        return arrayList;
    }

    private void generateWsgenReport(Class<?> clazz, AbstractSEIModelImpl abstractSEIModelImpl, File file, Map<String, File> map) {
        try {
            ReportOutput.Report report = (ReportOutput.Report)TXW.create(ReportOutput.Report.class, (XmlSerializer)new StreamSerializer((OutputStream)new BufferedOutputStream(new FileOutputStream(this.options.wsgenReport))));
            report.wsdl(file.getAbsolutePath());
            ReportOutput.writeQName(abstractSEIModelImpl.getServiceQName(), report.service());
            ReportOutput.writeQName(abstractSEIModelImpl.getPortName(), report.port());
            ReportOutput.writeQName(abstractSEIModelImpl.getPortTypeName(), report.portType());
            report.implClass(clazz.getName());
            for (Map.Entry<String, File> entry : map.entrySet()) {
                ReportOutput.Schema schema = report.schema();
                schema.ns(entry.getKey());
                schema.location(entry.getValue().getAbsolutePath());
            }
            report.commit();
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
    }

    private float getVersion(String string) {
        return Float.parseFloat(string);
    }

    protected void usage(Options options) {
        if (options == null) {
            options = this.options;
        }
        if (options instanceof WsgenOptions) {
            System.out.println(WscompileMessages.WSGEN_HELP("WSGEN", ((WsgenOptions)options).protocols, ((WsgenOptions)options).nonstdProtocols.keySet()));
            System.out.println(WscompileMessages.WSGEN_USAGE_EXTENSIONS());
            System.out.println(WscompileMessages.WSGEN_USAGE_EXAMPLES());
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    class Listener
    extends WsimportListener {
        ConsoleErrorReporter cer;

        Listener() {
            this.cer = new ConsoleErrorReporter(WsgenTool.this.out == null ? new PrintStream((OutputStream)new NullStream()) : WsgenTool.this.out);
        }

        @Override
        public void generatedFile(String string) {
            this.message(string);
        }

        @Override
        public void message(String string) {
            WsgenTool.this.out.println(string);
        }

        @Override
        public void error(SAXParseException sAXParseException) {
            this.cer.error(sAXParseException);
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) {
            this.cer.fatalError(sAXParseException);
        }

        @Override
        public void warning(SAXParseException sAXParseException) {
            this.cer.warning(sAXParseException);
        }

        @Override
        public void info(SAXParseException sAXParseException) {
            this.cer.info(sAXParseException);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class ReportOutput {
        ReportOutput() {
        }

        private static void writeQName(QName qName, QualifiedName qualifiedName) {
            qualifiedName.uri(qName.getNamespaceURI());
            qualifiedName.localName(qName.getLocalPart());
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        static interface Schema
        extends TypedXmlWriter {
            @XmlAttribute
            public void ns(String var1);

            @XmlAttribute
            public void location(String var1);
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        static interface QualifiedName
        extends TypedXmlWriter {
            @XmlAttribute
            public void uri(String var1);

            @XmlAttribute
            public void localName(String var1);
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        @XmlElement(value="report")
        static interface Report
        extends TypedXmlWriter {
            @XmlElement
            public void wsdl(String var1);

            @XmlElement
            public QualifiedName portType();

            @XmlElement
            public QualifiedName service();

            @XmlElement
            public QualifiedName port();

            @XmlElement
            public void implClass(String var1);

            @XmlElement
            public Schema schema();
        }
    }
}

