/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.registry.impl;

import java.io.File;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.service.definition.Route;
import org.apache.knox.gateway.service.definition.ServiceDefinition;
import org.apache.knox.gateway.services.Service;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.registry.ServiceDefEntry;
import org.apache.knox.gateway.services.registry.ServiceDefinitionRegistry;
import org.apache.knox.gateway.services.registry.impl.DefaultServiceDefEntry;
import org.apache.knox.gateway.util.ServiceDefinitionsLoader;
import org.apache.knox.gateway.util.urltemplate.Matcher;
import org.apache.knox.gateway.util.urltemplate.Parser;
import org.apache.knox.gateway.util.urltemplate.Template;

public class DefaultServiceDefinitionRegistry
implements ServiceDefinitionRegistry,
Service {
    private static GatewayMessages LOG = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private Matcher<ServiceDefEntry> entries = new Matcher();

    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        String stacks = config.getGatewayServicesDir();
        File stacksDir = new File(stacks);
        Set<ServiceDefinition> serviceDefinitions = ServiceDefinitionsLoader.getServiceDefinitions(stacksDir);
        for (ServiceDefinition serviceDefinition : serviceDefinitions) {
            List routes = serviceDefinition.getRoutes();
            for (Route route : routes) {
                try {
                    Template template = Parser.parseTemplate((String)route.getPath());
                    this.addServiceDefEntry(template, serviceDefinition);
                }
                catch (URISyntaxException e) {
                    LOG.failedToParsePath(route.getPath(), e);
                }
            }
        }
    }

    private void addServiceDefEntry(Template template, ServiceDefinition serviceDefinition) {
        ServiceDefEntry entry = (ServiceDefEntry)this.entries.get(template);
        if (entry == null) {
            this.entries.add(template, (Object)new DefaultServiceDefEntry(serviceDefinition.getRole(), serviceDefinition.getName(), template.getPattern()));
        }
    }

    public void start() throws ServiceLifecycleException {
    }

    public void stop() throws ServiceLifecycleException {
    }

    public ServiceDefEntry getMatchingService(String urlPattern) {
        Matcher.Match match = null;
        try {
            match = this.entries.match(Parser.parseLiteral((String)urlPattern));
        }
        catch (URISyntaxException e) {
            LOG.failedToParsePath(urlPattern, e);
        }
        if (match != null) {
            return (ServiceDefEntry)match.getValue();
        }
        return null;
    }
}

