/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.authorization.authorizer;

import java.util.List;
import org.pac4j.core.authorization.authorizer.Authorizer;
import org.pac4j.core.context.ContextHelper;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.CommonProfile;

public class StrictTransportSecurityHeader
implements Authorizer<CommonProfile> {
    private static final int DEFAULT_MAX_AGE = 15768000;
    private int maxAge = 15768000;

    public StrictTransportSecurityHeader() {
    }

    public StrictTransportSecurityHeader(int maxAge) {
        this.maxAge = maxAge;
    }

    @Override
    public boolean isAuthorized(WebContext context, List<CommonProfile> profiles) {
        if (ContextHelper.isHttpsOrSecure(context)) {
            context.setResponseHeader("Strict-Transport-Security", "max-age=" + this.maxAge + " ; includeSubDomains");
        }
        return true;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }
}

