/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.j2e.util;

import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pac4j.core.config.Config;
import org.pac4j.core.config.ConfigSingleton;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.ProfileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@RequestScoped
public class Pac4jProducer {
    private static final Logger logger = LoggerFactory.getLogger(Pac4jProducer.class);

    @Produces
    J2EContext getWebContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        logger.trace("Producing a pac4j web context...");
        Config config = ConfigSingleton.getConfig();
        if (config == null) {
            throw new TechnicalException("The Config of the ConfigSingleton is null. You must define at least one pac4j filter!");
        }
        J2EContext j2EContext = new J2EContext(httpServletRequest, httpServletResponse, config.getSessionStore());
        logger.trace("Returning a pac4j web context.");
        return j2EContext;
    }

    @Produces
    ProfileManager getProfileManager(WebContext webContext) {
        logger.trace("Producing a pac4j profile manager...");
        ProfileManager profileManager = new ProfileManager(webContext);
        logger.trace("Returning a pac4j profile manager.");
        return profileManager;
    }
}

