/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientRequestQuotaManager$;
import kafka.server.QuotaType$Request$;
import kafka.utils.QuotaUtils$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.config.ClientQuotaManagerConfig;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005uu!B\u0011#\u0011\u00039c!B\u0015#\u0011\u0003Q\u0003\"B\u0019\u0002\t\u0003\u0011\u0004bB\u001a\u0002\u0005\u0004%\t\u0001\u000e\u0005\u0007q\u0005\u0001\u000b\u0011B\u001b\t\u000fe\n!\u0019!C\u0005u!1a(\u0001Q\u0001\nmBqaP\u0001C\u0002\u0013%\u0001\t\u0003\u0004J\u0003\u0001\u0006I!\u0011\u0004\u0005S\t\u0002!\n\u0003\u0005O\u0013\t\u0015\r\u0011\"\u0003P\u0011!Y\u0016B!A!\u0002\u0013\u0001\u0006\u0002\u0003/\n\u0005\u000b\u0007I\u0011B/\t\u0011\u0015L!\u0011!Q\u0001\nyC\u0001BZ\u0005\u0003\u0006\u0004%Ia\u001a\u0005\t]&\u0011\t\u0011)A\u0005Q\"Aq.\u0003BC\u0002\u0013%\u0001\u000f\u0003\u0005|\u0013\t\u0005\t\u0015!\u0003r\u0011!a\u0018B!b\u0001\n\u0013i\b\"CA\b\u0013\t\u0005\t\u0015!\u0003\u007f\u0011\u0019\t\u0014\u0002\"\u0001\u0002\u0012!A\u0011qD\u0005C\u0002\u0013%!\bC\u0004\u0002\"%\u0001\u000b\u0011B\u001e\t\u0013\u0005\r\u0012B1A\u0005\n\u0005\u0015\u0002\u0002CA\u0018\u0013\u0001\u0006I!a\n\t\u0013\u0005E\u0012B1A\u0005\u0002\u0005M\u0002\u0002CA\u001e\u0013\u0001\u0006I!!\u000e\t\u000f\u0005u\u0012\u0002\"\u0003\u0002@!9\u00111J\u0005\u0005\u0002\u00055\u0003bBA9\u0013\u0011\u0005\u00111\u000f\u0005\b\u0003oJA\u0011KA=\u0011\u001d\t9)\u0003C)\u0003\u0013Cq!!&\n\t\u0013\t9*A\rDY&,g\u000e\u001e*fcV,7\u000f^)v_R\fW*\u00198bO\u0016\u0014(BA\u0012%\u0003\u0019\u0019XM\u001d<fe*\tQ%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005!\nQ\"\u0001\u0012\u00033\rc\u0017.\u001a8u%\u0016\fX/Z:u#V|G/Y'b]\u0006<WM]\n\u0003\u0003-\u0002\"\u0001L\u0018\u000e\u00035R\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001(\u0003iq\u0015M\\8t)>\u0004VM]2f]R\fw-\u001a)feN+7m\u001c8e+\u0005)\u0004C\u0001\u00177\u0013\t9TF\u0001\u0004E_V\u0014G.Z\u0001\u001c\u001d\u0006twn\u001d+p!\u0016\u00148-\u001a8uC\u001e,\u0007+\u001a:TK\u000e|g\u000e\u001a\u0011\u0002a\u0011+g-Y;mi&s\u0017m\u0019;jm\u0016,\u00050Z7qiN+gn]8s\u000bb\u0004\u0018N]1uS>tG+[7f'\u0016\u001cwN\u001c3t+\u0005Y\u0004C\u0001\u0017=\u0013\tiTF\u0001\u0003M_:<\u0017!\r#fM\u0006,H\u000e^%oC\u000e$\u0018N^3Fq\u0016l\u0007\u000f^*f]N|'/\u0012=qSJ\fG/[8o)&lWmU3d_:$7\u000fI\u0001\u0011\u000bb,W\u000e\u001d;TK:\u001cxN\u001d(b[\u0016,\u0012!\u0011\t\u0003\u0005\u001ek\u0011a\u0011\u0006\u0003\t\u0016\u000bA\u0001\\1oO*\ta)\u0001\u0003kCZ\f\u0017B\u0001%D\u0005\u0019\u0019FO]5oO\u0006\tR\t_3naR\u001cVM\\:pe:\u000bW.\u001a\u0011\u0014\u0005%Y\u0005C\u0001\u0015M\u0013\ti%E\u0001\nDY&,g\u000e^)v_R\fW*\u00198bO\u0016\u0014\u0018AB2p]\u001aLw-F\u0001Q!\t\t\u0016,D\u0001S\u0015\tq5K\u0003\u0002$)*\u0011Q%\u0016\u0006\u0003-^\u000ba!\u00199bG\",'\"\u0001-\u0002\u0007=\u0014x-\u0003\u0002[%\nA2\t\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0007>tg-[4\u0002\u000f\r|gNZ5hA\u00059Q.\u001a;sS\u000e\u001cX#\u00010\u0011\u0005}\u001bW\"\u00011\u000b\u0005q\u000b'B\u00012U\u0003\u0019\u0019w.\\7p]&\u0011A\r\u0019\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013\u0001\u0002;j[\u0016,\u0012\u0001\u001b\t\u0003S2l\u0011A\u001b\u0006\u0003W\u0006\fQ!\u001e;jYNL!!\u001c6\u0003\tQKW.Z\u0001\u0006i&lW\rI\u0001\u0011i\"\u0014X-\u00193OC6,\u0007K]3gSb,\u0012!\u001d\t\u0003eft!a]<\u0011\u0005QlS\"A;\u000b\u0005Y4\u0013A\u0002\u001fs_>$h(\u0003\u0002y[\u00051\u0001K]3eK\u001aL!\u0001\u0013>\u000b\u0005al\u0013!\u0005;ie\u0016\fGMT1nKB\u0013XMZ5yA\u0005i\u0011/^8uC\u000e\u000bG\u000e\u001c2bG.,\u0012A \t\u0005Y}\f\u0019!C\u0002\u0002\u00025\u0012aa\u00149uS>t\u0007\u0003BA\u0003\u0003\u0017i!!a\u0002\u000b\u0007\u0005%1+A\u0003rk>$\u0018-\u0003\u0003\u0002\u000e\u0005\u001d!aE\"mS\u0016tG/U;pi\u0006\u001c\u0015\r\u001c7cC\u000e\\\u0017AD9v_R\f7)\u00197mE\u0006\u001c7\u000e\t\u000b\r\u0003'\t)\"a\u0006\u0002\u001a\u0005m\u0011Q\u0004\t\u0003Q%AQA\u0014\u000bA\u0002ACQ\u0001\u0018\u000bA\u0002yCQA\u001a\u000bA\u0002!DQa\u001c\u000bA\u0002EDQ\u0001 \u000bA\u0002y\f\u0011#\\1y)\"\u0014x\u000e\u001e;mKRKW.Z't\u0003Ii\u0017\r\u001f+ie>$H\u000f\\3US6,Wj\u001d\u0011\u0002!\u0015DX-\u001c9u\u001b\u0016$(/[2OC6,WCAA\u0014!\u0011\tI#a\u000b\u000e\u0003\u0005L1!!\fb\u0005)iU\r\u001e:jG:\u000bW.Z\u0001\u0012Kb,W\u000e\u001d;NKR\u0014\u0018n\u0019(b[\u0016\u0004\u0013\u0001D3yK6\u0004HoU3og>\u0014XCAA\u001b!\ry\u0016qG\u0005\u0004\u0003s\u0001'AB*f]N|'/A\u0007fq\u0016l\u0007\u000f^*f]N|'\u000fI\u0001\re\u0016\u001cwN\u001d3Fq\u0016l\u0007\u000f\u001e\u000b\u0005\u0003\u0003\n9\u0005E\u0002-\u0003\u0007J1!!\u0012.\u0005\u0011)f.\u001b;\t\r\u0005%3\u00041\u00016\u0003\u00151\u0018\r\\;f\u0003}i\u0017-\u001f2f%\u0016\u001cwN\u001d3B]\u0012<U\r\u001e+ie>$H\u000f\\3US6,Wj\u001d\u000b\u0007\u0003\u001f\n)&!\u001c\u0011\u00071\n\t&C\u0002\u0002T5\u00121!\u00138u\u0011\u001d\t9\u0006\ba\u0001\u00033\nqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0002\\\u0005\u001dd\u0002BA/\u0003Gj!!a\u0018\u000b\u0007\u0005\u0005D%A\u0004oKR<xN]6\n\t\u0005\u0015\u0014qL\u0001\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0013\u0011\tI'a\u001b\u0003\u000fI+\u0017/^3ti*!\u0011QMA0\u0011\u0019\ty\u0007\ba\u0001w\u00051A/[7f\u001bN\f\u0011#\\1zE\u0016\u0014VmY8sI\u0016CX-\u001c9u)\u0011\t\t%!\u001e\t\u000f\u0005]S\u00041\u0001\u0002Z\u0005aA\u000f\u001b:piRdW\rV5nKR)1(a\u001f\u0002\u0006\"9\u0011Q\u0010\u0010A\u0002\u0005}\u0014!A3\u0011\u0007}\u000b\t)C\u0002\u0002\u0004\u0002\u0014q#U;pi\u00064\u0016n\u001c7bi&|g.\u0012=dKB$\u0018n\u001c8\t\r\u0005=d\u00041\u0001<\u0003U\u0019G.[3oiF+x\u000e^1NKR\u0014\u0018n\u0019(b[\u0016$B!a\n\u0002\f\"9\u0011QR\u0010A\u0002\u0005=\u0015aD9v_R\fW*\u001a;sS\u000e$\u0016mZ:\u0011\u000bI\f\t*]9\n\u0007\u0005M%PA\u0002NCB\f\u0011C\\1o_N$v\u000eU3sG\u0016tG/Y4f)\r)\u0014\u0011\u0014\u0005\u0007\u00037\u0003\u0003\u0019A\u001e\u0002\u000b9\fgn\\:")
public class ClientRequestQuotaManager
extends ClientQuotaManager {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final Time time;
    private final String threadNamePrefix;
    private final Option<ClientQuotaCallback> quotaCallback;
    private final long maxThrottleTimeMs;
    private final MetricName exemptMetricName;
    private final Sensor exemptSensor;

    public static double NanosToPercentagePerSecond() {
        return ClientRequestQuotaManager$.MODULE$.NanosToPercentagePerSecond();
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private Time time() {
        return this.time;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private Option<ClientQuotaCallback> quotaCallback() {
        return this.quotaCallback;
    }

    private long maxThrottleTimeMs() {
        return this.maxThrottleTimeMs;
    }

    private MetricName exemptMetricName() {
        return this.exemptMetricName;
    }

    public Sensor exemptSensor() {
        return this.exemptSensor;
    }

    private void recordExempt(double value) {
        this.exemptSensor().record(value);
    }

    public int maybeRecordAndGetThrottleTimeMs(RequestChannel.Request request, long timeMs) {
        if (this.quotasEnabled()) {
            request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable)timeNanos -> this.recordNoThrottle(request.session(), request.header().clientId(), (double)timeNanos * ClientRequestQuotaManager$.MODULE$.NanosToPercentagePerSecond())));
            return this.recordAndGetThrottleTimeMs(request.session(), request.header().clientId(), (double)request.requestThreadTimeNanos() * ClientRequestQuotaManager$.MODULE$.NanosToPercentagePerSecond(), timeMs);
        }
        return 0;
    }

    public void maybeRecordExempt(RequestChannel.Request request) {
        if (this.quotasEnabled()) {
            request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable)timeNanos -> this.recordExempt((double)timeNanos * ClientRequestQuotaManager$.MODULE$.NanosToPercentagePerSecond())));
            this.recordExempt((double)request.requestThreadTimeNanos() * ClientRequestQuotaManager$.MODULE$.NanosToPercentagePerSecond());
            return;
        }
    }

    @Override
    public long throttleTime(QuotaViolationException e, long timeMs) {
        return QuotaUtils$.MODULE$.boundedThrottleTime(e, this.maxThrottleTimeMs(), timeMs);
    }

    @Override
    public MetricName clientQuotaMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("request-time", "Request", "Tracking request-time per user/client-id", CollectionConverters$.MODULE$.MapHasAsJava(quotaMetricTags).asJava());
    }

    private double nanosToPercentage(long nanos) {
        return (double)nanos * ClientRequestQuotaManager$.MODULE$.NanosToPercentagePerSecond();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$exemptSensor$1(ClientRequestQuotaManager $this, Sensor sensor) {
        void add_stat;
        void add_metricName;
        Rate rate = new Rate();
        MetricName metricName = $this.exemptMetricName();
        if (sensor == null) {
            throw null;
        }
        sensor.add((MetricName)add_metricName, (MeasurableStat)add_stat, null);
    }

    public ClientRequestQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, Time time, String threadNamePrefix, Option<ClientQuotaCallback> quotaCallback) {
        this.config = config;
        this.metrics = metrics;
        this.time = time;
        this.threadNamePrefix = threadNamePrefix;
        this.quotaCallback = quotaCallback;
        super(config, metrics, QuotaType$Request$.MODULE$, time, threadNamePrefix, quotaCallback);
        this.maxThrottleTimeMs = TimeUnit.SECONDS.toMillis(config.quotaWindowSizeSeconds);
        this.exemptMetricName = metrics.metricName("exempt-request-time", "Request", "Tracking exempt-request-time utilization percentage");
        this.exemptSensor = this.getOrCreateSensor(ClientRequestQuotaManager$.MODULE$.kafka$server$ClientRequestQuotaManager$$ExemptSensorName(), ClientRequestQuotaManager$.MODULE$.kafka$server$ClientRequestQuotaManager$$DefaultInactiveExemptSensorExpirationTimeSeconds(), (Function1<Sensor, BoxedUnit>)(Function1 & Serializable)sensor -> {
            ClientRequestQuotaManager.$anonfun$exemptSensor$1(this, sensor);
            return BoxedUnit.UNIT;
        });
    }
}

