/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.test.TestRecord;

public class TestInputTopic<K, V> {
    private final TopologyTestDriver driver;
    private final String topic;
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;
    private Instant currentTime;
    private final Duration advanceDuration;

    TestInputTopic(TopologyTestDriver driver, String topicName, Serializer<K> keySerializer, Serializer<V> valueSerializer, Instant startTimestamp, Duration autoAdvance) {
        Objects.requireNonNull(driver, "TopologyTestDriver cannot be null");
        Objects.requireNonNull(topicName, "topicName cannot be null");
        Objects.requireNonNull(keySerializer, "keySerializer cannot be null");
        Objects.requireNonNull(valueSerializer, "valueSerializer cannot be null");
        Objects.requireNonNull(startTimestamp, "startTimestamp cannot be null");
        Objects.requireNonNull(autoAdvance, "autoAdvance cannot be null");
        this.driver = driver;
        this.topic = topicName;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.currentTime = startTimestamp;
        if (autoAdvance.isNegative()) {
            throw new IllegalArgumentException("autoAdvance must be positive");
        }
        this.advanceDuration = autoAdvance;
    }

    public void advanceTime(Duration advance) {
        if (advance.isNegative()) {
            throw new IllegalArgumentException("advance must be positive");
        }
        this.currentTime = this.currentTime.plus(advance);
    }

    private Instant getTimestampAndAdvance() {
        Instant timestamp = this.currentTime;
        this.currentTime = this.currentTime.plus(this.advanceDuration);
        return timestamp;
    }

    public void pipeInput(TestRecord<K, V> record) {
        Instant timestamp = record.getRecordTime() == null ? this.getTimestampAndAdvance() : record.getRecordTime();
        this.driver.pipeRecord(this.topic, record, this.keySerializer, this.valueSerializer, timestamp);
    }

    public void pipeInput(V value) {
        this.pipeInput((V)new TestRecord(value));
    }

    public void pipeInput(K key, V value) {
        this.pipeInput((V)new TestRecord<K, V>(key, value));
    }

    public void pipeInput(V value, Instant timestamp) {
        this.pipeInput((V)new TestRecord<Object, V>(null, value, timestamp));
    }

    public void pipeInput(K key, V value, long timestampMs) {
        this.pipeInput((V)new TestRecord<K, V>(key, value, null, timestampMs));
    }

    public void pipeInput(K key, V value, Instant timestamp) {
        this.pipeInput((V)new TestRecord<K, V>(key, value, timestamp));
    }

    public void pipeRecordList(List<? extends TestRecord<K, V>> records) {
        for (TestRecord<K, V> record : records) {
            this.pipeInput((V)record);
        }
    }

    public void pipeKeyValueList(List<KeyValue<K, V>> keyValues) {
        for (KeyValue<K, V> keyValue : keyValues) {
            this.pipeInput(keyValue.key, keyValue.value);
        }
    }

    public void pipeValueList(List<V> values) {
        for (V value : values) {
            this.pipeInput(value);
        }
    }

    public void pipeKeyValueList(List<KeyValue<K, V>> keyValues, Instant startTimestamp, Duration advance) {
        Instant recordTime = startTimestamp;
        for (KeyValue<K, V> keyValue : keyValues) {
            this.pipeInput(keyValue.key, keyValue.value, recordTime);
            recordTime = recordTime.plus(advance);
        }
    }

    public void pipeValueList(List<V> values, Instant startTimestamp, Duration advance) {
        Instant recordTime = startTimestamp;
        for (V value : values) {
            this.pipeInput(value, recordTime);
            recordTime = recordTime.plus(advance);
        }
    }

    public String toString() {
        return new StringJoiner(", ", TestInputTopic.class.getSimpleName() + "[", "]").add("topic='" + this.topic + "'").add("keySerializer=" + this.keySerializer.getClass().getSimpleName()).add("valueSerializer=" + this.valueSerializer.getClass().getSimpleName()).toString();
    }
}

