/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.EmitStrategy;
import org.apache.kafka.streams.kstream.JoinWindows;
import org.apache.kafka.streams.kstream.internals.AbstractConfigurableStoreFactory;
import org.apache.kafka.streams.kstream.internals.StreamJoinedInternal;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.StoreFactory;
import org.apache.kafka.streams.state.DslWindowParams;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.WindowStore;

public class StreamJoinedStoreFactory<K, V1, V2>
extends AbstractConfigurableStoreFactory {
    private final String name;
    private final JoinWindows windows;
    private final Serde<?> valueSerde;
    private final WindowBytesStoreSupplier storeSupplier;
    private final StreamJoinedInternal<K, V1, V2> joinedInternal;
    private boolean loggingEnabled;
    private final Map<String, String> logConfig;

    public StreamJoinedStoreFactory(String name, JoinWindows windows, StreamJoinedInternal<K, V1, V2> joinedInternal, Type type) {
        super(joinedInternal.dslStoreSuppliers());
        this.name = name + "-store";
        this.joinedInternal = joinedInternal;
        this.windows = windows;
        this.loggingEnabled = joinedInternal.loggingEnabled();
        this.logConfig = new HashMap<String, String>(joinedInternal.logConfig());
        this.logConfig.put("cleanup.policy", "delete");
        switch (type) {
            case THIS: {
                this.valueSerde = joinedInternal.valueSerde();
                this.storeSupplier = joinedInternal.thisStoreSupplier();
                break;
            }
            case OTHER: {
                this.valueSerde = joinedInternal.otherValueSerde();
                this.storeSupplier = joinedInternal.otherStoreSupplier();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)type));
            }
        }
    }

    @Override
    public StateStore build() {
        WindowBytesStoreSupplier supplier = this.storeSupplier == null ? this.dslStoreSuppliers().windowStore(new DslWindowParams(this.name, Duration.ofMillis(this.retentionPeriod()), Duration.ofMillis(this.windows.size()), true, EmitStrategy.onWindowUpdate(), false, false)) : this.storeSupplier;
        StoreBuilder<WindowStore<K, ?>> builder = Stores.windowStoreBuilder(supplier, this.joinedInternal.keySerde(), this.valueSerde);
        if (this.joinedInternal.loggingEnabled()) {
            builder.withLoggingEnabled(this.logConfig);
        } else {
            builder.withLoggingDisabled();
        }
        return builder.build();
    }

    @Override
    public long retentionPeriod() {
        return this.windows.size() + this.windows.gracePeriodMs();
    }

    @Override
    public long historyRetention() {
        throw new IllegalStateException("historyRetention is not supported when not a versioned store");
    }

    @Override
    public boolean loggingEnabled() {
        return this.loggingEnabled;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean isWindowStore() {
        return true;
    }

    @Override
    public boolean isVersionedStore() {
        return false;
    }

    @Override
    public Map<String, String> logConfig() {
        return this.logConfig;
    }

    @Override
    public StoreFactory withCachingDisabled() {
        return this;
    }

    @Override
    public StoreFactory withLoggingDisabled() {
        this.loggingEnabled = false;
        return this;
    }

    @Override
    public boolean isCompatibleWith(StoreFactory storeFactory) {
        return storeFactory instanceof StreamJoinedStoreFactory && ((StreamJoinedStoreFactory)storeFactory).joinedInternal.equals(this.joinedInternal);
    }

    public static enum Type {
        THIS,
        OTHER;

    }
}

