/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.SnapshotFooterRecord;
import org.apache.kafka.common.message.SnapshotHeaderRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.internals.BatchAccumulator;
import org.apache.kafka.raft.internals.BatchMemoryPool;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;

public class BatchFileWriter
implements AutoCloseable {
    private final FileChannel channel;
    private final BatchAccumulator<ApiMessageAndVersion> batchAccumulator;
    private final Time time;

    private BatchFileWriter(FileChannel channel, BatchAccumulator<ApiMessageAndVersion> batchAccumulator, Time time) {
        this.channel = channel;
        this.batchAccumulator = batchAccumulator;
        this.time = time;
    }

    public void append(ApiMessageAndVersion apiMessageAndVersion) {
        this.batchAccumulator.append(0, Collections.singletonList(apiMessageAndVersion), false);
    }

    public void append(List<ApiMessageAndVersion> messageBatch) {
        this.batchAccumulator.append(0, messageBatch, false);
    }

    @Override
    public void close() throws IOException {
        this.batchAccumulator.appendSnapshotFooterRecord(new SnapshotFooterRecord().setVersion((short)0), this.time.milliseconds());
        this.batchAccumulator.forceDrain();
        try {
            for (BatchAccumulator.CompletedBatch batch : this.batchAccumulator.drain()) {
                Utils.writeFully((FileChannel)this.channel, (ByteBuffer)batch.data.buffer());
            }
        }
        finally {
            this.batchAccumulator.close();
            this.channel.close();
        }
    }

    public static BatchFileWriter open(Path snapshotPath) throws IOException {
        Time time = Time.SYSTEM;
        BatchAccumulator batchAccumulator = new BatchAccumulator(0, 0L, Integer.MAX_VALUE, 0x800000, Integer.MAX_VALUE, (MemoryPool)new BatchMemoryPool(5, 0x800000), time, (Compression)Compression.NONE, (RecordSerde)new MetadataRecordSerde());
        batchAccumulator.appendSnapshotHeaderRecord(new SnapshotHeaderRecord().setVersion((short)0).setLastContainedLogTimestamp(0L), time.milliseconds());
        batchAccumulator.forceDrain();
        FileChannel channel = FileChannel.open(snapshotPath, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        return new BatchFileWriter(channel, (BatchAccumulator<ApiMessageAndVersion>)batchAccumulator, time);
    }
}

