/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.coordinator;

import com.fasterxml.jackson.core.type.TypeReference;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.UriBuilder;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.trogdor.common.JsonUtil;
import org.apache.kafka.trogdor.common.StringFormatter;
import org.apache.kafka.trogdor.rest.CoordinatorStatusResponse;
import org.apache.kafka.trogdor.rest.CreateTaskRequest;
import org.apache.kafka.trogdor.rest.DestroyTaskRequest;
import org.apache.kafka.trogdor.rest.Empty;
import org.apache.kafka.trogdor.rest.JsonRestServer;
import org.apache.kafka.trogdor.rest.RequestConflictException;
import org.apache.kafka.trogdor.rest.StopTaskRequest;
import org.apache.kafka.trogdor.rest.TaskDone;
import org.apache.kafka.trogdor.rest.TaskPending;
import org.apache.kafka.trogdor.rest.TaskRequest;
import org.apache.kafka.trogdor.rest.TaskRunning;
import org.apache.kafka.trogdor.rest.TaskState;
import org.apache.kafka.trogdor.rest.TaskStateType;
import org.apache.kafka.trogdor.rest.TaskStopping;
import org.apache.kafka.trogdor.rest.TasksRequest;
import org.apache.kafka.trogdor.rest.TasksResponse;
import org.apache.kafka.trogdor.rest.UptimeResponse;
import org.apache.kafka.trogdor.task.TaskSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatorClient {
    private final Logger log;
    private final int maxTries;
    private final String target;

    private CoordinatorClient(Logger log, int maxTries, String target) {
        this.log = log;
        this.maxTries = maxTries;
        this.target = target;
    }

    public int maxTries() {
        return this.maxTries;
    }

    private String url(String suffix) {
        return String.format("http://%s%s", this.target, suffix);
    }

    public CoordinatorStatusResponse status() throws Exception {
        JsonRestServer.HttpResponse<CoordinatorStatusResponse> resp = JsonRestServer.httpRequest(this.url("/coordinator/status"), "GET", null, new TypeReference<CoordinatorStatusResponse>(){}, this.maxTries);
        return resp.body();
    }

    public UptimeResponse uptime() throws Exception {
        JsonRestServer.HttpResponse<UptimeResponse> resp = JsonRestServer.httpRequest(this.url("/coordinator/uptime"), "GET", null, new TypeReference<UptimeResponse>(){}, this.maxTries);
        return resp.body();
    }

    public void createTask(CreateTaskRequest request) throws Exception {
        JsonRestServer.HttpResponse<Empty> resp = JsonRestServer.httpRequest(this.log, this.url("/coordinator/task/create"), "POST", request, new TypeReference<Empty>(){}, this.maxTries);
        resp.body();
    }

    public void stopTask(StopTaskRequest request) throws Exception {
        JsonRestServer.HttpResponse<Empty> resp = JsonRestServer.httpRequest(this.log, this.url("/coordinator/task/stop"), "PUT", request, new TypeReference<Empty>(){}, this.maxTries);
        resp.body();
    }

    public void destroyTask(DestroyTaskRequest request) throws Exception {
        UriBuilder uriBuilder = UriBuilder.fromPath((String)this.url("/coordinator/tasks"));
        uriBuilder.queryParam("taskId", new Object[]{request.id()});
        JsonRestServer.HttpResponse<Empty> resp = JsonRestServer.httpRequest(this.log, uriBuilder.build(new Object[0]).toString(), "DELETE", null, new TypeReference<Empty>(){}, this.maxTries);
        resp.body();
    }

    public TasksResponse tasks(TasksRequest request) throws Exception {
        UriBuilder uriBuilder = UriBuilder.fromPath((String)this.url("/coordinator/tasks"));
        uriBuilder.queryParam("taskId", request.taskIds().toArray(new Object[0]));
        uriBuilder.queryParam("firstStartMs", new Object[]{request.firstStartMs()});
        uriBuilder.queryParam("lastStartMs", new Object[]{request.lastStartMs()});
        uriBuilder.queryParam("firstEndMs", new Object[]{request.firstEndMs()});
        uriBuilder.queryParam("lastEndMs", new Object[]{request.lastEndMs()});
        if (request.state().isPresent()) {
            uriBuilder.queryParam("state", new Object[]{request.state().get().toString()});
        }
        JsonRestServer.HttpResponse<TasksResponse> resp = JsonRestServer.httpRequest(this.log, uriBuilder.build(new Object[0]).toString(), "GET", null, new TypeReference<TasksResponse>(){}, this.maxTries);
        return resp.body();
    }

    public TaskState task(TaskRequest request) throws Exception {
        String uri = UriBuilder.fromPath((String)this.url("/coordinator/tasks/{taskId}")).build(new Object[]{request.taskId()}).toString();
        JsonRestServer.HttpResponse<TaskState> resp = JsonRestServer.httpRequest(this.log, uri, "GET", null, new TypeReference<TaskState>(){}, this.maxTries);
        return resp.body();
    }

    public void shutdown() throws Exception {
        JsonRestServer.HttpResponse<Empty> resp = JsonRestServer.httpRequest(this.log, this.url("/coordinator/shutdown"), "PUT", null, new TypeReference<Empty>(){}, this.maxTries);
        resp.body();
    }

    private static void addTargetArgument(ArgumentParser parser) {
        parser.addArgument(new String[]{"--target", "-t"}).action((ArgumentAction)Arguments.store()).required(true).type(String.class).dest("target").metavar(new String[]{"TARGET"}).help("A colon-separated host and port pair.  For example, example.com:8889");
    }

    private static void addJsonArgument(ArgumentParser parser) {
        parser.addArgument(new String[]{"--json"}).action((ArgumentAction)Arguments.storeTrue()).dest("json").metavar(new String[]{"JSON"}).help("Show the full response as JSON.");
    }

    public static void main(String[] args) throws Exception {
        ArgumentParser rootParser = ArgumentParsers.newArgumentParser((String)"trogdor-coordinator-client").description("The Trogdor coordinator client.");
        Subparsers subParsers = rootParser.addSubparsers().dest("command");
        Subparser uptimeParser = subParsers.addParser("uptime").help("Get the coordinator uptime.");
        CoordinatorClient.addTargetArgument((ArgumentParser)uptimeParser);
        CoordinatorClient.addJsonArgument((ArgumentParser)uptimeParser);
        Subparser statusParser = subParsers.addParser("status").help("Get the coordinator status.");
        CoordinatorClient.addTargetArgument((ArgumentParser)statusParser);
        CoordinatorClient.addJsonArgument((ArgumentParser)statusParser);
        Subparser showTaskParser = subParsers.addParser("showTask").help("Show a coordinator task.");
        CoordinatorClient.addTargetArgument((ArgumentParser)showTaskParser);
        CoordinatorClient.addJsonArgument((ArgumentParser)showTaskParser);
        showTaskParser.addArgument(new String[]{"--id", "-i"}).action((ArgumentAction)Arguments.store()).required(true).type(String.class).dest("taskId").metavar(new String[]{"TASK_ID"}).help("The task ID to show.");
        showTaskParser.addArgument(new String[]{"--verbose", "-v"}).action((ArgumentAction)Arguments.storeTrue()).dest("verbose").metavar(new String[]{"VERBOSE"}).help("Print out everything.");
        showTaskParser.addArgument(new String[]{"--show-status", "-S"}).action((ArgumentAction)Arguments.storeTrue()).dest("showStatus").metavar(new String[]{"SHOW_STATUS"}).help("Show the task status.");
        Subparser showTasksParser = subParsers.addParser("showTasks").help("Show many coordinator tasks.  By default, all tasks are shown, but command-line options can be specified as filters.");
        CoordinatorClient.addTargetArgument((ArgumentParser)showTasksParser);
        CoordinatorClient.addJsonArgument((ArgumentParser)showTasksParser);
        MutuallyExclusiveGroup idGroup = showTasksParser.addMutuallyExclusiveGroup();
        idGroup.addArgument(new String[]{"--id", "-i"}).action((ArgumentAction)Arguments.append()).type(String.class).dest("taskIds").metavar(new String[]{"TASK_IDS"}).help("Show only this task ID.  This option may be specified multiple times.");
        idGroup.addArgument(new String[]{"--id-pattern"}).action((ArgumentAction)Arguments.store()).type(String.class).dest("taskIdPattern").metavar(new String[]{"TASK_ID_PATTERN"}).help("Only display tasks which match the given ID pattern.");
        showTasksParser.addArgument(new String[]{"--state", "-s"}).type(TaskStateType.class).dest("taskStateType").metavar(new String[]{"TASK_STATE_TYPE"}).help("Show only tasks in this state.");
        Subparser createTaskParser = subParsers.addParser("createTask").help("Create a new task.");
        CoordinatorClient.addTargetArgument((ArgumentParser)createTaskParser);
        createTaskParser.addArgument(new String[]{"--id", "-i"}).action((ArgumentAction)Arguments.store()).required(true).type(String.class).dest("taskId").metavar(new String[]{"TASK_ID"}).help("The task ID to create.");
        createTaskParser.addArgument(new String[]{"--spec", "-s"}).action((ArgumentAction)Arguments.store()).required(true).type(String.class).dest("taskSpec").metavar(new String[]{"TASK_SPEC"}).help("The task spec to create, or a path to a file containing the task spec.");
        Subparser stopTaskParser = subParsers.addParser("stopTask").help("Stop a task.");
        CoordinatorClient.addTargetArgument((ArgumentParser)stopTaskParser);
        stopTaskParser.addArgument(new String[]{"--id", "-i"}).action((ArgumentAction)Arguments.store()).required(true).type(String.class).dest("taskId").metavar(new String[]{"TASK_ID"}).help("The task ID to create.");
        Subparser destroyTaskParser = subParsers.addParser("destroyTask").help("Destroy a task.");
        CoordinatorClient.addTargetArgument((ArgumentParser)destroyTaskParser);
        destroyTaskParser.addArgument(new String[]{"--id", "-i"}).action((ArgumentAction)Arguments.store()).required(true).type(String.class).dest("taskId").metavar(new String[]{"TASK_ID"}).help("The task ID to destroy.");
        Subparser shutdownParser = subParsers.addParser("shutdown").help("Shut down the coordinator.");
        CoordinatorClient.addTargetArgument((ArgumentParser)shutdownParser);
        Namespace res = rootParser.parseArgsOrFail(args);
        String target = res.getString("target");
        CoordinatorClient client = new Builder().maxTries(3).target(target).build();
        ZoneOffset localOffset = OffsetDateTime.now().getOffset();
        switch (res.getString("command")) {
            case "uptime": {
                UptimeResponse uptime = client.uptime();
                if (res.getBoolean("json").booleanValue()) {
                    System.out.println(JsonUtil.toJsonString(uptime));
                    break;
                }
                System.out.printf("Coordinator is running at %s.%n", target);
                System.out.printf("\tStart time: %s%n", StringFormatter.dateString(uptime.serverStartMs(), localOffset));
                System.out.printf("\tCurrent server time: %s%n", StringFormatter.dateString(uptime.nowMs(), localOffset));
                System.out.printf("\tUptime: %s%n", StringFormatter.durationString(uptime.nowMs() - uptime.serverStartMs()));
                break;
            }
            case "status": {
                CoordinatorStatusResponse response = client.status();
                if (res.getBoolean("json").booleanValue()) {
                    System.out.println(JsonUtil.toJsonString(response));
                    break;
                }
                System.out.printf("Coordinator is running at %s.%n", target);
                System.out.printf("\tStart time: %s%n", StringFormatter.dateString(response.serverStartMs(), localOffset));
                break;
            }
            case "showTask": {
                TaskDone taskDone;
                String taskId = res.getString("taskId");
                TaskRequest req = new TaskRequest(taskId);
                TaskState taskState = null;
                try {
                    taskState = client.task(req);
                }
                catch (NotFoundException e) {
                    System.out.printf("Task %s was not found.%n", taskId);
                    Exit.exit((int)1);
                }
                if (res.getBoolean("json").booleanValue()) {
                    System.out.println(JsonUtil.toJsonString(taskState));
                    break;
                }
                System.out.printf("Task %s of type %s is %s. %s%n", new Object[]{taskId, taskState.spec().getClass().getCanonicalName(), taskState.stateType(), CoordinatorClient.prettyPrintTaskInfo(taskState, localOffset)});
                if (taskState instanceof TaskDone && (taskDone = (TaskDone)taskState).error() != null && !taskDone.error().isEmpty()) {
                    System.out.printf("Error: %s%n", taskDone.error());
                }
                if (res.getBoolean("verbose").booleanValue()) {
                    System.out.printf("Spec: %s%n%n", JsonUtil.toPrettyJsonString(taskState.spec()));
                }
                if (!res.getBoolean("verbose").booleanValue() && !res.getBoolean("showStatus").booleanValue()) break;
                System.out.printf("Status: %s%n%n", JsonUtil.toPrettyJsonString(taskState.status()));
                break;
            }
            case "showTasks": {
                TaskStateType taskStateType = (TaskStateType)((Object)res.get("taskStateType"));
                ArrayList<String> taskIds = new ArrayList<String>();
                Pattern taskIdPattern = null;
                if (res.getList("taskIds") != null) {
                    for (Object taskId : res.getList("taskIds")) {
                        taskIds.add((String)taskId);
                    }
                } else if (res.getString("taskIdPattern") != null) {
                    try {
                        taskIdPattern = Pattern.compile(res.getString("taskIdPattern"));
                    }
                    catch (PatternSyntaxException e) {
                        System.out.println("Invalid task ID regular expression " + res.getString("taskIdPattern"));
                        e.printStackTrace();
                        Exit.exit((int)1);
                    }
                }
                TasksRequest req = new TasksRequest(taskIds, 0L, 0L, 0L, 0L, Optional.ofNullable(taskStateType));
                TasksResponse response = client.tasks(req);
                if (taskIdPattern != null) {
                    TreeMap<String, TaskState> filteredTasks = new TreeMap<String, TaskState>();
                    for (Map.Entry<String, TaskState> entry : response.tasks().entrySet()) {
                        if (!taskIdPattern.matcher(entry.getKey()).matches()) continue;
                        filteredTasks.put(entry.getKey(), entry.getValue());
                    }
                    response = new TasksResponse(filteredTasks);
                }
                if (res.getBoolean("json").booleanValue()) {
                    System.out.println(JsonUtil.toJsonString(response));
                } else {
                    System.out.println(CoordinatorClient.prettyPrintTasksResponse(response, localOffset));
                }
                if (!response.tasks().isEmpty()) break;
                Exit.exit((int)1);
                break;
            }
            case "createTask": {
                String taskId = res.getString("taskId");
                TaskSpec taskSpec = JsonUtil.objectFromCommandLineArgument(res.getString("taskSpec"), TaskSpec.class);
                CreateTaskRequest req = new CreateTaskRequest(taskId, taskSpec);
                try {
                    client.createTask(req);
                    System.out.printf("Sent CreateTaskRequest for task %s.%n", req.id());
                }
                catch (RequestConflictException rce) {
                    System.out.printf("CreateTaskRequest for task %s got a 409 status code - a task with the same ID but a different specification already exists.%nException: %s%n", req.id(), rce.getMessage());
                    Exit.exit((int)1);
                }
                break;
            }
            case "stopTask": {
                String taskId = res.getString("taskId");
                StopTaskRequest req = new StopTaskRequest(taskId);
                client.stopTask(req);
                System.out.printf("Sent StopTaskRequest for task %s.%n", taskId);
                break;
            }
            case "destroyTask": {
                String taskId = res.getString("taskId");
                DestroyTaskRequest req = new DestroyTaskRequest(taskId);
                client.destroyTask(req);
                System.out.printf("Sent DestroyTaskRequest for task %s.%n", taskId);
                break;
            }
            case "shutdown": {
                client.shutdown();
                System.out.println("Sent ShutdownRequest.");
                break;
            }
            default: {
                System.out.println("You must choose an action. Type --help for help.");
                Exit.exit((int)1);
            }
        }
    }

    static String prettyPrintTasksResponse(TasksResponse response, ZoneOffset zoneOffset) {
        if (response.tasks().isEmpty()) {
            return "No matching tasks found.";
        }
        ArrayList<List<String>> lines = new ArrayList<List<String>>();
        ArrayList<String> header = new ArrayList<String>(Arrays.asList("ID", "TYPE", "STATE", "INFO"));
        lines.add(header);
        for (Map.Entry<String, TaskState> entry : response.tasks().entrySet()) {
            String taskId = entry.getKey();
            TaskState taskState = entry.getValue();
            ArrayList<String> cols = new ArrayList<String>();
            cols.add(taskId);
            cols.add(taskState.spec().getClass().getCanonicalName());
            cols.add(taskState.stateType().toString());
            cols.add(CoordinatorClient.prettyPrintTaskInfo(taskState, zoneOffset));
            lines.add(cols);
        }
        return StringFormatter.prettyPrintGrid(lines);
    }

    static String prettyPrintTaskInfo(TaskState taskState, ZoneOffset zoneOffset) {
        if (taskState instanceof TaskPending) {
            return "Will start at " + StringFormatter.dateString(taskState.spec().startMs(), zoneOffset);
        }
        if (taskState instanceof TaskRunning) {
            TaskRunning runState = (TaskRunning)taskState;
            return "Started " + StringFormatter.dateString(runState.startedMs(), zoneOffset) + "; will stop after " + StringFormatter.durationString(taskState.spec().durationMs());
        }
        if (taskState instanceof TaskStopping) {
            TaskStopping stoppingState = (TaskStopping)taskState;
            return "Started " + StringFormatter.dateString(stoppingState.startedMs(), zoneOffset);
        }
        if (taskState instanceof TaskDone) {
            TaskDone doneState = (TaskDone)taskState;
            String status = doneState.error() == null || doneState.error().isEmpty() ? (doneState.cancelled() ? "CANCELLED" : "FINISHED") : "FAILED";
            return String.format("%s at %s after %s", status, StringFormatter.dateString(doneState.doneMs(), zoneOffset), StringFormatter.durationString(doneState.doneMs() - doneState.startedMs()));
        }
        throw new RuntimeException("Unknown task state type " + (Object)((Object)taskState.stateType()));
    }

    public static class Builder {
        private Logger log = LoggerFactory.getLogger(CoordinatorClient.class);
        private int maxTries = 1;
        private String target = null;

        public Builder log(Logger log) {
            this.log = log;
            return this;
        }

        public Builder maxTries(int maxTries) {
            this.maxTries = maxTries;
            return this;
        }

        public Builder target(String target) {
            this.target = target;
            return this;
        }

        public Builder target(String host, int port) {
            this.target = String.format("%s:%d", host, port);
            return this;
        }

        public CoordinatorClient build() {
            if (this.target == null) {
                throw new RuntimeException("You must specify a target.");
            }
            return new CoordinatorClient(this.log, this.maxTries, this.target);
        }
    }
}

