/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.Uuid;

public final class ReplicaKey
implements Comparable<ReplicaKey> {
    public static final Uuid NO_DIRECTORY_ID = Uuid.ZERO_UUID;
    private final int id;
    private final Optional<Uuid> directoryId;

    private ReplicaKey(int id, Optional<Uuid> directoryId) {
        this.id = id;
        this.directoryId = directoryId;
    }

    public int id() {
        return this.id;
    }

    public Optional<Uuid> directoryId() {
        return this.directoryId;
    }

    @Override
    public int compareTo(ReplicaKey that) {
        int idComparison = Integer.compare(this.id, that.id);
        if (idComparison == 0) {
            return this.directoryId.orElse(NO_DIRECTORY_ID).compareTo(that.directoryId.orElse(NO_DIRECTORY_ID));
        }
        return idComparison;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicaKey that = (ReplicaKey)o;
        if (this.id != that.id) {
            return false;
        }
        return Objects.equals(this.directoryId, that.directoryId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.directoryId);
    }

    public String toString() {
        return String.format("ReplicaKey(id=%d, directoryId=%s)", this.id, this.directoryId);
    }

    public static ReplicaKey of(int id, Uuid directoryId) {
        return new ReplicaKey(id, directoryId.equals((Object)NO_DIRECTORY_ID) ? Optional.empty() : Optional.of(directoryId));
    }
}

