/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import kafka.log.LogLoader$;
import kafka.log.SplitSegmentResult;
import kafka.log.UnifiedLog$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidOffsetException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.snapshot.Snapshots;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.CorruptIndexException;
import org.apache.kafka.storage.internals.log.LoadedLogOffsets;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogSegmentOffsetOverflowException;
import org.apache.kafka.storage.internals.log.LogSegments;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005]h\u0001B\u000f\u001f\u0001\rB\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\ts\u0001\u0011\t\u0011)A\u0005u!AQ\t\u0001B\u0001B\u0003%a\t\u0003\u0005P\u0001\t\u0005\t\u0015!\u0003Q\u0011!A\u0006A!A!\u0002\u0013I\u0006\u0002\u00030\u0001\u0005\u0003\u0005\u000b\u0011B0\t\u0011\t\u0004!\u0011!Q\u0001\n\rD\u0001B\u001a\u0001\u0003\u0002\u0003\u0006Ia\u001a\u0005\tU\u0002\u0011\t\u0011)A\u0005W\"Aa\u000e\u0001B\u0001B\u0003%1\u000e\u0003\u0005p\u0001\t\u0005\t\u0015!\u0003q\u0011!Y\bA!A!\u0002\u0013a\b\"C@\u0001\u0005\u0003\u0005\u000b\u0011BA\u0001\u0011%\tI\u0003\u0001B\u0001B\u0003%1\rC\u0004\u0002,\u0001!\t!!\f\t\u000f\u0005=\u0003\u0001\"\u0001\u0002R!9\u0011\u0011\f\u0001\u0005\n\u0005m\u0003bBA5\u0001\u0011%\u00111\u000e\u0005\b\u0003\u001f\u0003A\u0011BAI\u0011\u001d\tI\n\u0001C\u0005\u00037C\u0001\"a*\u0001\t\u0003q\u0012\u0011\u0016\u0005\b\u0003c\u0003A\u0011BAZ\u0011\u001d\tY\r\u0001C\u0005\u0003\u001b<\u0011\"!5\u001f\u0003\u0003E\t!a5\u0007\u0011uq\u0012\u0011!E\u0001\u0003+Dq!a\u000b\u001a\t\u0003\t9\u000eC\u0005\u0002Zf\t\n\u0011\"\u0001\u0002\\\"I\u0011\u0011_\r\u0012\u0002\u0013\u0005\u00111\u001f\u0002\n\u0019><Gj\\1eKJT!a\b\u0011\u0002\u00071|wMC\u0001\"\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0013+!\t)\u0003&D\u0001'\u0015\u00059\u0013!B:dC2\f\u0017BA\u0015'\u0005\u0019\te.\u001f*fMB\u00111FL\u0007\u0002Y)\u0011Q\u0006I\u0001\u0006kRLGn]\u0005\u0003_1\u0012q\u0001T8hO&tw-A\u0002eSJ\u0004\"AM\u001c\u000e\u0003MR!\u0001N\u001b\u0002\u0005%|'\"\u0001\u001c\u0002\t)\fg/Y\u0005\u0003qM\u0012AAR5mK\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007CA\u001eD\u001b\u0005a$BA\u001f?\u0003\u0019\u0019w.\\7p]*\u0011\u0011e\u0010\u0006\u0003\u0001\u0006\u000ba!\u00199bG\",'\"\u0001\"\u0002\u0007=\u0014x-\u0003\u0002Ey\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017AB2p]\u001aLw\r\u0005\u0002H\u001b6\t\u0001J\u0003\u0002 \u0013*\u0011!jS\u0001\nS:$XM\u001d8bYNT!\u0001\u0014 \u0002\u000fM$xN]1hK&\u0011a\n\u0013\u0002\n\u0019><7i\u001c8gS\u001e\f\u0011b]2iK\u0012,H.\u001a:\u0011\u0005E3V\"\u0001*\u000b\u0005M#\u0016\u0001B;uS2T!!\u0016 \u0002\rM,'O^3s\u0013\t9&KA\u0005TG\",G-\u001e7fe\u0006!A/[7f!\tQF,D\u0001\\\u0015\tiC(\u0003\u0002^7\n!A+[7f\u0003Qawn\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fYB\u0011q\tY\u0005\u0003C\"\u0013A\u0003T8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0017\u0001\u00055bI\u000ecW-\u00198TQV$Hm\\<o!\t)C-\u0003\u0002fM\t9!i\\8mK\u0006t\u0017\u0001C:fO6,g\u000e^:\u0011\u0005\u001dC\u0017BA5I\u0005-aunZ*fO6,g\u000e^:\u000211|wm\u0015;beR|eMZ:fi\u000eCWmY6q_&tG\u000f\u0005\u0002&Y&\u0011QN\n\u0002\u0005\u0019>tw-A\fsK\u000e|g/\u001a:z!>Lg\u000e^\"iK\u000e\\\u0007o\\5oi\u0006\u0001B.Z1eKJ,\u0005o\\2i\u0007\u0006\u001c\u0007.\u001a\t\u0004cN,X\"\u0001:\u000b\u0005M+\u0014B\u0001;s\u0005!y\u0005\u000f^5p]\u0006d\u0007C\u0001<z\u001b\u00059(B\u0001=J\u0003\u0015)\u0007o\\2i\u0013\tQxO\u0001\u000bMK\u0006$WM]#q_\u000eDg)\u001b7f\u0007\u0006\u001c\u0007.Z\u0001\u0015aJ|G-^2feN#\u0018\r^3NC:\fw-\u001a:\u0011\u0005\u001dk\u0018B\u0001@I\u0005Q\u0001&o\u001c3vG\u0016\u00148\u000b^1uK6\u000bg.Y4fe\u0006!b.^7SK6\f\u0017N\\5oON+w-\\3oiN\u0004\u0002\"a\u0001\u0002\n\u00055\u00111E\u0007\u0003\u0003\u000bQ1!a\u0002s\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003\u0017\t)AA\u0007D_:\u001cWO\u001d:f]Rl\u0015\r\u001d\t\u0005\u0003\u001f\tiB\u0004\u0003\u0002\u0012\u0005e\u0001cAA\nM5\u0011\u0011Q\u0003\u0006\u0004\u0003/\u0011\u0013A\u0002\u001fs_>$h(C\u0002\u0002\u001c\u0019\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0010\u0003C\u0011aa\u0015;sS:<'bAA\u000eMA\u0019Q%!\n\n\u0007\u0005\u001dbEA\u0002J]R\f!#[:SK6|G/\u001a'pO\u0016s\u0017M\u00197fI\u00061A(\u001b8jiz\"b$a\f\u00024\u0005U\u0012qGA\u001d\u0003w\ti$a\u0010\u0002B\u0005\r\u0013QIA$\u0003\u0013\nY%!\u0014\u0011\u0007\u0005E\u0002!D\u0001\u001f\u0011\u0015\u0001t\u00021\u00012\u0011\u0015It\u00021\u0001;\u0011\u0015)u\u00021\u0001G\u0011\u0015yu\u00021\u0001Q\u0011\u0015Av\u00021\u0001Z\u0011\u0015qv\u00021\u0001`\u0011\u0015\u0011w\u00021\u0001d\u0011\u00151w\u00021\u0001h\u0011\u0015Qw\u00021\u0001l\u0011\u0015qw\u00021\u0001l\u0011\u0015yw\u00021\u0001q\u0011\u0015Yx\u00021\u0001}\u0011!yx\u0002%AA\u0002\u0005\u0005\u0001\u0002CA\u0015\u001fA\u0005\t\u0019A2\u0002\t1|\u0017\r\u001a\u000b\u0003\u0003'\u00022aRA+\u0013\r\t9\u0006\u0013\u0002\u0011\u0019>\fG-\u001a3M_\u001e|eMZ:fiN\f!E]3n_Z,G+Z7q\r&dWm]!oI\u000e{G\u000e\\3diN;\u0018\r\u001d$jY\u0016\u001cHCAA/!\u0015\ty&!\u001a2\u001b\t\t\tGC\u0002\u0002d\u0019\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9'!\u0019\u0003\u0007M+G/A\u000bsKR\u0014\u0018p\u00148PM\u001a\u001cX\r^(wKJ4Gn\\<\u0016\t\u00055\u00141\u000f\u000b\u0005\u0003_\n)\t\u0005\u0003\u0002r\u0005MD\u0002\u0001\u0003\b\u0003k\u0012\"\u0019AA<\u0005\u0005!\u0016\u0003BA=\u0003\u007f\u00022!JA>\u0013\r\tiH\n\u0002\b\u001d>$\b.\u001b8h!\r)\u0013\u0011Q\u0005\u0004\u0003\u00073#aA!os\"9\u0011q\u0011\nA\u0002\u0005%\u0015A\u00014o!\u0015)\u00131RA8\u0013\r\tiI\n\u0002\n\rVt7\r^5p]B\n\u0001\u0003\\8bIN+w-\\3oi\u001aKG.Z:\u0015\u0005\u0005M\u0005cA\u0013\u0002\u0016&\u0019\u0011q\u0013\u0014\u0003\tUs\u0017\u000e^\u0001\u000fe\u0016\u001cwN^3s'\u0016<W.\u001a8u)\u0011\t\u0019#!(\t\u000f\u0005}E\u00031\u0001\u0002\"\u000691/Z4nK:$\bcA$\u0002$&\u0019\u0011Q\u0015%\u0003\u00151{wmU3h[\u0016tG/\u0001\u0006sK\u000e|g/\u001a:M_\u001e$\"!a+\u0011\u000b\u0015\nik[6\n\u0007\u0005=fE\u0001\u0004UkBdWMM\u0001\u001de\u0016lwN^3B]\u0012$U\r\\3uKN+w-\\3oiN\f5/\u001f8d)\u0011\t\u0019*!.\t\u000f\u0005]f\u00031\u0001\u0002:\u0006\u00012/Z4nK:$8\u000fV8EK2,G/\u001a\t\u0007\u0003w\u000b)-!)\u000f\t\u0005u\u0016\u0011\u0019\b\u0005\u0003'\ty,C\u0001(\u0013\r\t\u0019MJ\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9-!3\u0003\u0011%#XM]1cY\u0016T1!a1'\u0003q!W\r\\3uKB\u0013x\u000eZ;dKJ\u001cf.\u00199tQ>$8/Q:z]\u000e$B!a%\u0002P\"1am\u0006a\u0001\u0003s\u000b\u0011\u0002T8h\u0019>\fG-\u001a:\u0011\u0007\u0005E\u0012d\u0005\u0002\u001aIQ\u0011\u00111[\u0001\u001dI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u00194+\t\tiN\u000b\u0003\u0002\u0002\u0005}7FAAq!\u0011\t\u0019/!<\u000e\u0005\u0005\u0015(\u0002BAt\u0003S\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-h%\u0001\u0006b]:|G/\u0019;j_:LA!a<\u0002f\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00029\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132iU\u0011\u0011Q\u001f\u0016\u0004G\u0006}\u0007")
public class LogLoader
implements Logging {
    private final File dir;
    private final TopicPartition topicPartition;
    private final LogConfig config;
    private final Scheduler scheduler;
    private final Time time;
    private final LogDirFailureChannel logDirFailureChannel;
    private final boolean hadCleanShutdown;
    private final LogSegments segments;
    private final long logStartOffsetCheckpoint;
    private final long recoveryPointCheckpoint;
    private final Optional<LeaderEpochFileCache> leaderEpochCache;
    private final ProducerStateManager producerStateManager;
    private final ConcurrentMap<String, Object> numRemainingSegments;
    private final boolean isRemoteLogEnabled;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$14() {
        return LogLoader$.MODULE$.$lessinit$greater$default$14();
    }

    public static ConcurrentMap<String, Object> $lessinit$greater$default$13() {
        return LogLoader$.MODULE$.$lessinit$greater$default$13();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public LoadedLogOffsets load() {
        long l;
        long l2;
        Set<File> swapFiles = this.removeTempFilesAndCollectSwapFiles();
        LongRef minSwapFileOffset = LongRef.create((long)Long.MAX_VALUE);
        LongRef maxSwapFileOffset = LongRef.create((long)Long.MIN_VALUE);
        ((IterableLike)swapFiles.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)UnifiedLog$.MODULE$.isLogFile(new File(Utils.replaceSuffix((String)f.getPath(), (String)UnifiedLog$.MODULE$.SwapFileSuffix(), (String)"")))))).foreach((Function1 & Serializable & scala.Serializable)f -> {
            LogLoader.$anonfun$load$2(this, minSwapFileOffset, maxSwapFileOffset, f);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dir.listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable & scala.Serializable)file -> {
            Object object;
            block6: {
                try {
                    if (!file.getName().endsWith(UnifiedLog$.MODULE$.SwapFileSuffix())) {
                        long offset = UnifiedLog$.MODULE$.offsetFromFile((File)file);
                        if (offset >= minSwapFileOffset$1.elem && offset < maxSwapFileOffset$1.elem) {
                            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Deleting segment files ").append(file.getName()).append(" that is compacted but has not been deleted yet.").toString());
                            object = BoxesRunTime.boxToBoolean((boolean)file.delete());
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                        break block6;
                    }
                    return BoxedUnit.UNIT;
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    return BoxedUnit.UNIT;
                }
                catch (NumberFormatException numberFormatException) {
                    object = BoxedUnit.UNIT;
                }
            }
            return object;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dir.listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable & scala.Serializable)file -> {
            if (file.getName().endsWith(UnifiedLog$.MODULE$.SwapFileSuffix())) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Recovering file ").append(file.getName()).append(" by renaming from ").append(UnifiedLog$.MODULE$.SwapFileSuffix()).append(" files.").toString());
                return BoxesRunTime.boxToBoolean((boolean)file.renameTo(new File(Utils.replaceSuffix((String)file.getPath(), (String)UnifiedLog$.MODULE$.SwapFileSuffix(), (String)""))));
            }
            return BoxedUnit.UNIT;
        });
        while (true) {
            try {
                LogLoader.$anonfun$load$10(this);
            }
            catch (LogSegmentOffsetOverflowException retryOnOffsetOverflow_e) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Caught segment overflow error: ").append(retryOnOffsetOverflow_e.getMessage()).append(". Split segment and retry.").toString());
                SplitSegmentResult retryOnOffsetOverflow_result = UnifiedLog$.MODULE$.splitOverflowedSegment(retryOnOffsetOverflow_e.segment, this.segments, this.dir, this.topicPartition, this.config, this.scheduler, this.logDirFailureChannel, this.logIdent());
                this.deleteProducerSnapshotsAsync(retryOnOffsetOverflow_result.deletedSegments());
                continue;
            }
            break;
        }
        if (!this.dir.getAbsolutePath().endsWith(UnifiedLog$.MODULE$.DeleteDirSuffix())) {
            void var7_10;
            void var5_9;
            Tuple2 tuple2;
            while (true) {
                try {
                    tuple2 = this.recoverLog();
                }
                catch (LogSegmentOffsetOverflowException retryOnOffsetOverflow_e) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Caught segment overflow error: ").append(retryOnOffsetOverflow_e.getMessage()).append(". Split segment and retry.").toString());
                    SplitSegmentResult retryOnOffsetOverflow_result = UnifiedLog$.MODULE$.splitOverflowedSegment(retryOnOffsetOverflow_e.segment, this.segments, this.dir, this.topicPartition, this.config, this.scheduler, this.logDirFailureChannel, this.logIdent());
                    this.deleteProducerSnapshotsAsync(retryOnOffsetOverflow_result.deletedSegments());
                    continue;
                }
                break;
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError(null);
            }
            long newRecoveryPoint = tuple22._1$mcJ$sp();
            long nextOffset = tuple22._2$mcJ$sp();
            ((LogSegment)this.segments.lastSegment().get()).resizeIndexes(this.config.maxIndexSize);
            l2 = var5_9;
            l = var7_10;
        } else {
            if (this.segments.isEmpty()) {
                this.segments.add(LogSegment.open((File)this.dir, (long)0L, (LogConfig)this.config, (Time)this.time, (int)this.config.initFileSize(), (boolean)false));
            }
            l2 = 0L;
            l = 0L;
        }
        long l3 = l;
        long l4 = l2;
        this.leaderEpochCache.ifPresent(x$3 -> x$3.truncateFromEndAsyncFlush(l3));
        long newLogStartOffset = this.isRemoteLogEnabled ? this.logStartOffsetCheckpoint : package$.MODULE$.max(this.logStartOffsetCheckpoint, ((LogSegment)this.segments.firstSegment().get()).baseOffset());
        this.leaderEpochCache.ifPresent(x$4 -> x$4.truncateFromStartAsyncFlush($this.logStartOffsetCheckpoint));
        if (!this.producerStateManager.isEmpty()) {
            throw new IllegalStateException("Producer state must be empty during log initialization");
        }
        this.producerStateManager.removeStraySnapshots(this.segments.baseOffsets());
        UnifiedLog$.MODULE$.rebuildProducerState(this.producerStateManager, this.segments, newLogStartOffset, l3, this.config.recordVersion(), this.time, this.hadCleanShutdown, this.logIdent());
        LogSegment activeSegment = (LogSegment)this.segments.lastSegment().get();
        return new LoadedLogOffsets(newLogStartOffset, l4, new LogOffsetMetadata(l3, activeSegment.baseOffset(), activeSegment.size()));
    }

    /*
     * WARNING - void declaration
     */
    private Set<File> removeTempFilesAndCollectSwapFiles() {
        void var6_6;
        void var5_5;
        scala.collection.mutable.Set swapFiles = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Set cleanedFiles = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        LongRef minCleanedFileOffset = LongRef.create((long)Long.MAX_VALUE);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dir.listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable & scala.Serializable)file -> {
            if (!file.canRead()) {
                throw new IOException(new StringBuilder(20).append("Could not read file ").append(file).toString());
            }
            String filename = file.getName();
            if (filename.endsWith(".deleted") && !filename.endsWith(Snapshots.DELETE_SUFFIX)) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Deleting stray temporary file ").append(file.getAbsolutePath()).toString());
                return BoxesRunTime.boxToBoolean((boolean)Files.deleteIfExists(file.toPath()));
            }
            if (filename.endsWith(UnifiedLog$.MODULE$.CleanedFileSuffix())) {
                minCleanedFileOffset$1.elem = Math.min(UnifiedLog$.MODULE$.offsetFromFile((File)file), minCleanedFileOffset$1.elem);
                return cleanedFiles.$plus$eq(file);
            }
            if (filename.endsWith(UnifiedLog$.MODULE$.SwapFileSuffix())) {
                return swapFiles.$plus$eq(file);
            }
            return BoxedUnit.UNIT;
        });
        Tuple2 tuple2 = swapFiles.partition((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoader.$anonfun$removeTempFilesAndCollectSwapFiles$4(minCleanedFileOffset, file)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.mutable.Set invalidSwapFiles = (scala.collection.mutable.Set)tuple2._1();
        scala.collection.mutable.Set validSwapFiles = (scala.collection.mutable.Set)tuple2._2();
        void invalidSwapFiles2 = var5_5;
        void validSwapFiles2 = var6_6;
        invalidSwapFiles2.foreach((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoader.$anonfun$removeTempFilesAndCollectSwapFiles$5(this, minCleanedFileOffset, file)));
        cleanedFiles.foreach((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoader.$anonfun$removeTempFilesAndCollectSwapFiles$7(this, file)));
        return validSwapFiles2;
    }

    private <T> T retryOnOffsetOverflow(Function0<T> fn) {
        while (true) {
            try {
                return (T)fn.apply();
            }
            catch (LogSegmentOffsetOverflowException e) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Caught segment overflow error: ").append(retryOnOffsetOverflow_e.getMessage()).append(". Split segment and retry.").toString());
                SplitSegmentResult result = UnifiedLog$.MODULE$.splitOverflowedSegment(e.segment, this.segments, this.dir, this.topicPartition, this.config, this.scheduler, this.logDirFailureChannel, this.logIdent());
                this.deleteProducerSnapshotsAsync(result.deletedSegments());
                continue;
            }
            break;
        }
    }

    private void loadSegmentFiles() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dir.listFiles())).sortBy((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getName(), (Ordering)Ordering.String$.MODULE$))).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable & scala.Serializable)file -> {
            if (UnifiedLog$.MODULE$.isIndexFile((File)file)) {
                long offset = UnifiedLog$.MODULE$.offsetFromFile((File)file);
                if (!LogFileUtils.logFile((File)$this.dir, (long)offset).exists()) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Found an orphaned index file ").append(file.getAbsolutePath()).append(", with no corresponding log file.").toString());
                    return BoxesRunTime.boxToBoolean((boolean)Files.deleteIfExists(file.toPath()));
                }
                return BoxedUnit.UNIT;
            }
            if (UnifiedLog$.MODULE$.isLogFile((File)file)) {
                long baseOffset = UnifiedLog$.MODULE$.offsetFromFile((File)file);
                boolean timeIndexFileNewlyCreated = !LogFileUtils.timeIndexFile((File)$this.dir, (long)baseOffset).exists();
                LogSegment segment = LogSegment.open((File)$this.dir, (long)baseOffset, (LogConfig)$this.config, (Time)$this.time, (boolean)true, (int)0, (boolean)false, (String)"");
                try {
                    segment.sanityCheck(timeIndexFileNewlyCreated);
                }
                catch (NoSuchFileException noSuchFileException) {
                    if ($this.hadCleanShutdown || segment.baseOffset() < $this.recoveryPointCheckpoint) {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(109).append("Could not find offset index file corresponding to log file").append(" ").append(segment.log().file().getAbsolutePath()).append(", recovering segment and rebuilding index files...").toString());
                    }
                    this.recoverSegment(segment);
                }
                catch (CorruptIndexException e) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("Found a corrupted index file corresponding to log file").append(" ").append(segment.log().file().getAbsolutePath()).append(" due to ").append(e.getMessage()).append("}, recovering segment and").append(" rebuilding index files...").toString());
                    this.recoverSegment(segment);
                }
                return $this.segments.add(segment);
            }
            return BoxedUnit.UNIT;
        });
    }

    private int recoverSegment(LogSegment segment) {
        ProducerStateManager producerStateManager = new ProducerStateManager(this.topicPartition, this.dir, this.producerStateManager.maxTransactionTimeoutMs(), this.producerStateManager.producerStateManagerConfig(), this.time);
        UnifiedLog$.MODULE$.rebuildProducerState(producerStateManager, this.segments, this.logStartOffsetCheckpoint, segment.baseOffset(), this.config.recordVersion(), this.time, false, this.logIdent());
        int bytesTruncated = segment.recover(producerStateManager, this.leaderEpochCache);
        producerStateManager.takeSnapshot();
        return bytesTruncated;
    }

    public Tuple2<Object, Object> recoverLog() {
        boolean bl;
        if (!this.hadCleanShutdown) {
            Collection unflushed = this.segments.values(this.recoveryPointCheckpoint, Long.MAX_VALUE);
            int numUnflushed = unflushed.size();
            Iterator<LogSegment> unflushedIter = unflushed.iterator();
            boolean truncated = false;
            IntRef numFlushed = IntRef.create((int)0);
            String threadName = Thread.currentThread().getName();
            this.numRemainingSegments.put(threadName, BoxesRunTime.boxToInteger((int)numUnflushed));
            while (unflushedIter.hasNext() && !truncated) {
                int n;
                LogSegment segment = (LogSegment)unflushedIter.next();
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Recovering unflushed segment ").append(segment.baseOffset()).append(". ").append(numFlushed$1.elem).append("/").append(numUnflushed).append(" recovered for ").append($this.topicPartition).append(".").toString());
                try {
                    n = this.recoverSegment(segment);
                }
                catch (InvalidOffsetException invalidOffsetException) {
                    long startOffset = segment.baseOffset();
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("Found invalid offset during recovery. Deleting the").append(" corrupt segment and creating an empty one with starting offset ").append(startOffset).toString());
                    n = segment.truncateTo(startOffset);
                }
                if (n > 0) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Corruption found in segment ").append(segment.baseOffset()).append(",").append(" truncating to offset ").append(segment.readNextOffset()).toString());
                    ArrayBuffer unflushedRemaining = new ArrayBuffer();
                    unflushedIter.forEachRemaining(s -> unflushedRemaining.$plus$eq(s));
                    this.removeAndDeleteSegmentsAsync((Iterable<LogSegment>)unflushedRemaining);
                    truncated = true;
                    this.numRemainingSegments.put(threadName, BoxesRunTime.boxToInteger((int)0));
                    continue;
                }
                ++numFlushed.elem;
                this.numRemainingSegments.put(threadName, BoxesRunTime.boxToInteger((int)(numUnflushed - numFlushed.elem)));
            }
        }
        Option logEndOffsetOption = this.deleteSegmentsIfLogStartGreaterThanLogEnd$1();
        if (this.segments.isEmpty()) {
            this.segments.add(LogSegment.open((File)this.dir, (long)this.logStartOffsetCheckpoint, (LogConfig)this.config, (Time)this.time, (int)this.config.initFileSize(), (boolean)this.config.preallocate));
        }
        if ((bl = this.hadCleanShutdown) && logEndOffsetOption instanceof Some) {
            long logEndOffset = BoxesRunTime.unboxToLong((Object)((Some)logEndOffsetOption).value());
            return new Tuple2.mcJJ.sp(logEndOffset, logEndOffset);
        }
        long logEndOffset = BoxesRunTime.unboxToLong((Object)logEndOffsetOption.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> ((LogSegment)$this.segments.lastSegment().get()).readNextOffset()));
        return new Tuple2.mcJJ.sp(Math.min(this.recoveryPointCheckpoint, logEndOffset), logEndOffset);
    }

    private void removeAndDeleteSegmentsAsync(Iterable<LogSegment> segmentsToDelete) {
        if (segmentsToDelete.nonEmpty()) {
            List toDelete = segmentsToDelete.toList();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Deleting segments as part of log recovery: ").append(toDelete.mkString(",")).toString());
            toDelete.foreach((Function1 & Serializable & scala.Serializable)segment -> {
                this.segments.remove(segment.baseOffset());
                return BoxedUnit.UNIT;
            });
            UnifiedLog$.MODULE$.deleteSegmentFiles((scala.collection.immutable.Iterable<LogSegment>)toDelete, true, this.dir, this.topicPartition, this.config, this.scheduler, this.logDirFailureChannel, this.logIdent());
            this.deleteProducerSnapshotsAsync(segmentsToDelete);
            return;
        }
    }

    private void deleteProducerSnapshotsAsync(Iterable<LogSegment> segments) {
        UnifiedLog$.MODULE$.deleteProducerSnapshots(segments, this.producerStateManager, true, this.scheduler, this.config, this.logDirFailureChannel, this.dir.getParent(), this.topicPartition);
    }

    public static final /* synthetic */ void $anonfun$load$2(LogLoader $this, LongRef minSwapFileOffset$1, LongRef maxSwapFileOffset$1, File f) {
        long baseOffset = UnifiedLog$.MODULE$.offsetFromFile(f);
        LogSegment segment = LogSegment.open((File)f.getParentFile(), (long)baseOffset, (LogConfig)$this.config, (Time)$this.time, (boolean)false, (int)0, (boolean)false, (String)UnifiedLog$.MODULE$.SwapFileSuffix());
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(94).append("Found log file ").append(f.getPath()).append(" from interrupted swap operation, which is recoverable from ").append(UnifiedLog$.MODULE$.SwapFileSuffix()).append(" files by renaming.").toString());
        minSwapFileOffset$1.elem = Math.min(segment.baseOffset(), minSwapFileOffset$1.elem);
        maxSwapFileOffset$1.elem = Math.max(segment.readNextOffset(), maxSwapFileOffset$1.elem);
    }

    public static final /* synthetic */ void $anonfun$load$10(LogLoader $this) {
        $this.segments.close();
        $this.segments.clear();
        $this.loadSegmentFiles();
    }

    public static final /* synthetic */ boolean $anonfun$removeTempFilesAndCollectSwapFiles$4(LongRef minCleanedFileOffset$1, File file) {
        return UnifiedLog$.MODULE$.offsetFromFile(file) >= minCleanedFileOffset$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$removeTempFilesAndCollectSwapFiles$5(LogLoader $this, LongRef minCleanedFileOffset$1, File file) {
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Deleting invalid swap file ").append(file.getAbsoluteFile()).append(" minCleanedFileOffset: ").append(minCleanedFileOffset$1.elem).toString());
        return Files.deleteIfExists(file.toPath());
    }

    public static final /* synthetic */ boolean $anonfun$removeTempFilesAndCollectSwapFiles$7(LogLoader $this, File file) {
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Deleting stray .clean file ").append(file.getAbsolutePath()).toString());
        return Files.deleteIfExists(file.toPath());
    }

    private final Option deleteSegmentsIfLogStartGreaterThanLogEnd$1() {
        if (this.segments.nonEmpty()) {
            long logEndOffset = ((LogSegment)this.segments.lastSegment().get()).readNextOffset();
            if (logEndOffset >= this.logStartOffsetCheckpoint) {
                return new Some((Object)BoxesRunTime.boxToLong((long)logEndOffset));
            }
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(148).append("Deleting all segments because logEndOffset (").append(logEndOffset).append(") ").append("is smaller than logStartOffset ").append($this.logStartOffsetCheckpoint).append(". ").append("This could happen if segment files were deleted from the file system.").toString());
            this.removeAndDeleteSegmentsAsync((Iterable<LogSegment>)((Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.segments.values()).asScala()));
            this.leaderEpochCache.ifPresent(x$7 -> x$7.clearAndFlush());
            this.producerStateManager.truncateFullyAndStartAt(this.logStartOffsetCheckpoint);
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public LogLoader(File dir, TopicPartition topicPartition, LogConfig config, Scheduler scheduler, Time time, LogDirFailureChannel logDirFailureChannel, boolean hadCleanShutdown, LogSegments segments, long logStartOffsetCheckpoint, long recoveryPointCheckpoint, Optional<LeaderEpochFileCache> leaderEpochCache, ProducerStateManager producerStateManager, ConcurrentMap<String, Object> numRemainingSegments, boolean isRemoteLogEnabled) {
        this.dir = dir;
        this.topicPartition = topicPartition;
        this.config = config;
        this.scheduler = scheduler;
        this.time = time;
        this.logDirFailureChannel = logDirFailureChannel;
        this.hadCleanShutdown = hadCleanShutdown;
        this.segments = segments;
        this.logStartOffsetCheckpoint = logStartOffsetCheckpoint;
        this.recoveryPointCheckpoint = recoveryPointCheckpoint;
        this.leaderEpochCache = leaderEpochCache;
        this.producerStateManager = producerStateManager;
        this.numRemainingSegments = numRemainingSegments;
        this.isRemoteLogEnabled = isRemoteLogEnabled;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(29).append("[LogLoader partition=").append(topicPartition).append(", dir=").append(dir.getParent()).append("] ").toString());
    }
}

